/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je;

import com.sleepycat.je.CacheMode;
import com.sleepycat.je.CursorConfig;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.LockConflictException;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.Transaction;
import com.sleepycat.je.dbi.CursorImpl;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.GetMode;
import com.sleepycat.je.dbi.PutMode;
import com.sleepycat.je.dbi.RangeRestartException;
import com.sleepycat.je.latch.LatchSupport;
import com.sleepycat.je.log.ReplicationContext;
import com.sleepycat.je.tree.BIN;
import com.sleepycat.je.tree.DBIN;
import com.sleepycat.je.tree.Key;
import com.sleepycat.je.tree.LN;
import com.sleepycat.je.tree.Node;
import com.sleepycat.je.txn.BuddyLocker;
import com.sleepycat.je.txn.LockType;
import com.sleepycat.je.txn.Locker;
import com.sleepycat.je.txn.LockerFactory;
import com.sleepycat.je.utilint.DatabaseUtil;
import com.sleepycat.je.utilint.LoggerUtils;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Cursor {
    CursorImpl cursorImpl;
    CursorConfig config;
    private boolean updateOperationsProhibited;
    private Database dbHandle;
    private DatabaseImpl dbImpl;
    private boolean readUncommittedDefault;
    private boolean serializableIsolationDefault;
    private Logger logger;
    private boolean nonCloning = false;
    private CacheMode cacheMode;
    private boolean cacheModeOverridden;

    Cursor(Database dbHandle, Transaction txn, CursorConfig cursorConfig) {
        if (cursorConfig == null) {
            cursorConfig = CursorConfig.DEFAULT;
        }
        if (dbHandle != null) {
            dbHandle.checkOpen("Can't access Database:");
        }
        Locker locker = LockerFactory.getReadableLocker(dbHandle.getEnvironment(), txn, dbHandle.isTransactional(), false, cursorConfig.getReadCommitted());
        this.init(dbHandle, dbHandle.getDatabaseImpl(), locker, cursorConfig, false);
    }

    Cursor(Database dbHandle, Locker locker, CursorConfig cursorConfig) {
        if (cursorConfig == null) {
            cursorConfig = CursorConfig.DEFAULT;
        }
        if (dbHandle != null) {
            dbHandle.checkOpen("Can't access Database:");
        }
        locker = LockerFactory.getReadableLocker(dbHandle.getEnvironment(), dbHandle, locker, cursorConfig.getReadCommitted());
        this.init(dbHandle, dbHandle.getDatabaseImpl(), locker, cursorConfig, false);
    }

    Cursor(Database dbHandle, Locker locker, CursorConfig cursorConfig, boolean retainNonTxnLocks) {
        if (cursorConfig == null) {
            cursorConfig = CursorConfig.DEFAULT;
        }
        if (dbHandle != null) {
            dbHandle.checkOpen("Can't access Database:");
        }
        this.init(dbHandle, dbHandle.getDatabaseImpl(), locker, cursorConfig, retainNonTxnLocks);
    }

    Cursor(DatabaseImpl databaseImpl, Locker locker, CursorConfig cursorConfig, boolean retainNonTxnLocks) {
        if (cursorConfig == null) {
            cursorConfig = CursorConfig.DEFAULT;
        }
        if (this.dbHandle != null) {
            this.dbHandle.checkOpen("Can't access Database:");
        }
        this.init(null, databaseImpl, locker, cursorConfig, retainNonTxnLocks);
    }

    private void init(Database dbHandle, DatabaseImpl databaseImpl, Locker locker, CursorConfig cursorConfig, boolean retainNonTxnLocks) {
        assert (locker != null);
        try {
            locker.openCursorHook();
        }
        catch (RuntimeException e) {
            locker.operationEnd();
            throw e;
        }
        this.cursorImpl = new CursorImpl(databaseImpl, locker, retainNonTxnLocks);
        this.cacheMode = databaseImpl.getDefaultCacheMode();
        this.cursorImpl.setAllowEviction(true);
        this.readUncommittedDefault = cursorConfig.getReadUncommitted() || locker.isReadUncommittedDefault();
        this.serializableIsolationDefault = this.cursorImpl.getLocker().isSerializableIsolation();
        this.updateOperationsProhibited = databaseImpl.isTransactional() && !locker.isTransactional() || dbHandle != null && !dbHandle.isWritable();
        this.dbImpl = databaseImpl;
        if (dbHandle != null) {
            this.dbHandle = dbHandle;
            dbHandle.addCursor(this);
        }
        this.config = cursorConfig;
        this.logger = databaseImpl.getDbEnvironment().getLogger();
    }

    Cursor(Cursor cursor, boolean samePosition) {
        this.readUncommittedDefault = cursor.readUncommittedDefault;
        this.serializableIsolationDefault = cursor.serializableIsolationDefault;
        this.updateOperationsProhibited = cursor.updateOperationsProhibited;
        this.cursorImpl = cursor.cursorImpl.dup(samePosition);
        this.dbImpl = cursor.dbImpl;
        this.dbHandle = cursor.dbHandle;
        if (this.dbHandle != null) {
            this.dbHandle.addCursor(this);
        }
        this.config = cursor.config;
        this.logger = this.dbImpl.getDbEnvironment().getLogger();
        this.cacheMode = cursor.cacheMode;
        this.cacheModeOverridden = cursor.cacheModeOverridden;
    }

    void setNonCloning(boolean nonCloning) {
        this.nonCloning = nonCloning;
    }

    CursorImpl getCursorImpl() {
        return this.cursorImpl;
    }

    public Database getDatabase() {
        return this.dbHandle;
    }

    DatabaseImpl getDatabaseImpl() {
        return this.dbImpl;
    }

    public CursorConfig getConfig() {
        try {
            return this.config.clone();
        }
        catch (Error E) {
            this.dbImpl.getDbEnvironment().invalidate(E);
            throw E;
        }
    }

    public CacheMode getCacheMode() {
        return this.cacheMode;
    }

    public void setCacheMode(CacheMode cacheMode) {
        this.cacheModeOverridden = cacheMode != null;
        this.cacheMode = cacheMode != null ? cacheMode : this.dbImpl.getDefaultCacheMode();
    }

    public void close() throws DatabaseException {
        try {
            if (this.cursorImpl.isClosed()) {
                return;
            }
            this.checkEnv();
            this.cursorImpl.close();
            if (this.dbHandle != null) {
                this.dbHandle.removeCursor(this);
                this.dbHandle = null;
            }
        }
        catch (Error E) {
            this.dbImpl.getDbEnvironment().invalidate(E);
            throw E;
        }
    }

    public int count() throws DatabaseException {
        this.checkState(true);
        this.trace(Level.FINEST, "Cursor.count: ", null);
        return this.countInternal(null);
    }

    public Cursor dup(boolean samePosition) throws DatabaseException {
        try {
            this.checkState(false);
            return new Cursor(this, samePosition);
        }
        catch (Error E) {
            this.dbImpl.getDbEnvironment().invalidate(E);
            throw E;
        }
    }

    public OperationStatus delete() throws LockConflictException, DatabaseException, UnsupportedOperationException {
        this.checkState(true);
        this.checkUpdatesAllowed("delete");
        this.trace(Level.FINEST, "Cursor.delete: ", null);
        return this.deleteInternal(this.dbImpl.getRepContext());
    }

    public OperationStatus put(DatabaseEntry key, DatabaseEntry data) throws DatabaseException, UnsupportedOperationException {
        this.checkState(false);
        DatabaseUtil.checkForNullDbt(key, "key", true);
        DatabaseUtil.checkForNullDbt(data, "data", true);
        DatabaseUtil.checkForPartialKey(key);
        this.checkUpdatesAllowed("put");
        this.trace(Level.FINEST, "Cursor.put: ", key, data, null);
        return this.putInternal(key, data, PutMode.OVERWRITE);
    }

    public OperationStatus putNoOverwrite(DatabaseEntry key, DatabaseEntry data) throws DatabaseException, UnsupportedOperationException {
        this.checkState(false);
        DatabaseUtil.checkForNullDbt(key, "key", true);
        DatabaseUtil.checkForNullDbt(data, "data", true);
        DatabaseUtil.checkForPartialKey(key);
        this.checkUpdatesAllowed("putNoOverwrite");
        this.trace(Level.FINEST, "Cursor.putNoOverwrite: ", key, data, null);
        return this.putInternal(key, data, PutMode.NO_OVERWRITE);
    }

    public OperationStatus putNoDupData(DatabaseEntry key, DatabaseEntry data) throws DatabaseException, UnsupportedOperationException {
        this.checkState(false);
        DatabaseUtil.checkForNullDbt(key, "key", true);
        DatabaseUtil.checkForNullDbt(data, "data", true);
        DatabaseUtil.checkForPartialKey(key);
        this.checkUpdatesAllowed("putNoDupData");
        if (!this.dbImpl.getSortedDuplicates()) {
            throw new UnsupportedOperationException("Database is not configured for duplicate data.");
        }
        this.trace(Level.FINEST, "Cursor.putNoDupData: ", key, data, null);
        return this.putInternal(key, data, PutMode.NO_DUP_DATA);
    }

    public OperationStatus putCurrent(DatabaseEntry data) throws DatabaseException, UnsupportedOperationException {
        this.checkState(true);
        DatabaseUtil.checkForNullDbt(data, "data", true);
        this.checkUpdatesAllowed("putCurrent");
        this.trace(Level.FINEST, "Cursor.putCurrent: ", null, data, null);
        return this.putInternal(null, data, PutMode.CURRENT);
    }

    public OperationStatus getCurrent(DatabaseEntry key, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        try {
            this.checkState(true);
            this.checkArgsNoValRequired(key, data);
            this.trace(Level.FINEST, "Cursor.getCurrent: ", lockMode);
            return this.getCurrentInternal(key, data, lockMode);
        }
        catch (Error E) {
            this.dbImpl.getDbEnvironment().invalidate(E);
            throw E;
        }
    }

    public OperationStatus getFirst(DatabaseEntry key, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        this.checkState(false);
        this.checkArgsNoValRequired(key, data);
        this.trace(Level.FINEST, "Cursor.getFirst: ", lockMode);
        return this.position(key, data, lockMode, true);
    }

    public OperationStatus getLast(DatabaseEntry key, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        this.checkState(false);
        this.checkArgsNoValRequired(key, data);
        this.trace(Level.FINEST, "Cursor.getLast: ", lockMode);
        return this.position(key, data, lockMode, false);
    }

    public OperationStatus getNext(DatabaseEntry key, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        this.checkState(false);
        this.checkArgsNoValRequired(key, data);
        this.trace(Level.FINEST, "Cursor.getNext: ", lockMode);
        if (this.cursorImpl.isNotInitialized()) {
            return this.position(key, data, lockMode, true);
        }
        return this.retrieveNext(key, data, lockMode, GetMode.NEXT);
    }

    public OperationStatus getNextDup(DatabaseEntry key, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        this.checkState(true);
        this.checkArgsNoValRequired(key, data);
        this.trace(Level.FINEST, "Cursor.getNextDup: ", lockMode);
        return this.retrieveNext(key, data, lockMode, GetMode.NEXT_DUP);
    }

    public OperationStatus getNextNoDup(DatabaseEntry key, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        this.checkState(false);
        this.checkArgsNoValRequired(key, data);
        this.trace(Level.FINEST, "Cursor.getNextNoDup: ", lockMode);
        if (this.cursorImpl.isNotInitialized()) {
            return this.position(key, data, lockMode, true);
        }
        return this.retrieveNext(key, data, lockMode, GetMode.NEXT_NODUP);
    }

    public OperationStatus getPrev(DatabaseEntry key, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        this.checkState(false);
        this.checkArgsNoValRequired(key, data);
        this.trace(Level.FINEST, "Cursor.getPrev: ", lockMode);
        if (this.cursorImpl.isNotInitialized()) {
            return this.position(key, data, lockMode, false);
        }
        return this.retrieveNext(key, data, lockMode, GetMode.PREV);
    }

    public OperationStatus getPrevDup(DatabaseEntry key, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        this.checkState(true);
        this.checkArgsNoValRequired(key, data);
        this.trace(Level.FINEST, "Cursor.getPrevDup: ", lockMode);
        return this.retrieveNext(key, data, lockMode, GetMode.PREV_DUP);
    }

    public OperationStatus getPrevNoDup(DatabaseEntry key, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        this.checkState(false);
        this.checkArgsNoValRequired(key, data);
        this.trace(Level.FINEST, "Cursor.getPrevNoDup: ", lockMode);
        if (this.cursorImpl.isNotInitialized()) {
            return this.position(key, data, lockMode, false);
        }
        return this.retrieveNext(key, data, lockMode, GetMode.PREV_NODUP);
    }

    public OperationStatus getSearchKey(DatabaseEntry key, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        this.checkState(false);
        DatabaseUtil.checkForNullDbt(key, "key", true);
        DatabaseUtil.checkForNullDbt(data, "data", false);
        this.trace(Level.FINEST, "Cursor.getSearchKey: ", key, null, lockMode);
        return this.search(key, data, lockMode, CursorImpl.SearchMode.SET);
    }

    public OperationStatus getSearchKeyRange(DatabaseEntry key, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        this.checkState(false);
        DatabaseUtil.checkForNullDbt(key, "key", true);
        DatabaseUtil.checkForNullDbt(data, "data", false);
        this.trace(Level.FINEST, "Cursor.getSearchKeyRange: ", key, null, lockMode);
        return this.search(key, data, lockMode, CursorImpl.SearchMode.SET_RANGE);
    }

    public OperationStatus getSearchBoth(DatabaseEntry key, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        this.checkState(false);
        this.checkArgsValRequired(key, data);
        this.trace(Level.FINEST, "Cursor.getSearchBoth: ", key, data, lockMode);
        return this.search(key, data, lockMode, CursorImpl.SearchMode.BOTH);
    }

    public OperationStatus getSearchBothRange(DatabaseEntry key, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        this.checkState(false);
        this.checkArgsValRequired(key, data);
        this.trace(Level.FINEST, "Cursor.getSearchBothRange: ", key, data, lockMode);
        return this.search(key, data, lockMode, CursorImpl.SearchMode.BOTH_RANGE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int countInternal(LockMode lockMode) {
        int n;
        CursorImpl dup = this.cursorImpl.cloneCursor(true, this.cacheMode);
        try {
            n = dup.count(this.getLockType(lockMode, false));
        }
        catch (Throwable throwable) {
            try {
                dup.close(this.cursorImpl);
                throw throwable;
            }
            catch (Error E) {
                this.dbImpl.getDbEnvironment().invalidate(E);
                throw E;
            }
        }
        dup.close(this.cursorImpl);
        return n;
    }

    OperationStatus deleteInternal(ReplicationContext repContext) {
        try {
            OperationStatus status;
            boolean doNotifyTriggers;
            DatabaseEntry oldKey = null;
            DatabaseEntry oldData = null;
            boolean bl = doNotifyTriggers = this.dbHandle != null && this.dbHandle.hasTriggers();
            if (doNotifyTriggers && (status = this.getCurrentInternal(oldKey = new DatabaseEntry(), oldData = new DatabaseEntry(), LockMode.RMW)) != OperationStatus.SUCCESS) {
                return OperationStatus.KEYEMPTY;
            }
            if (doNotifyTriggers) {
                this.dbHandle.notifyTriggers(this.cursorImpl.getLocker(), oldKey, oldData, null);
            }
            return this.deleteNoNotify(repContext);
        }
        catch (Error E) {
            this.dbImpl.getDbEnvironment().invalidate(E);
            throw E;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    OperationStatus deleteNoNotify(ReplicationContext repContext) {
        try {
            this.beginUseExistingCursor();
            this.cursorImpl.latchBINs();
            OperationStatus status = this.cursorImpl.delete(repContext);
            this.endUseExistingCursor();
            OperationStatus operationStatus = status;
            return operationStatus;
        }
        finally {
            this.cursorImpl.releaseBINs();
        }
    }

    OperationStatus putInternal(DatabaseEntry key, DatabaseEntry data, PutMode putMode) {
        LN ln = putMode == PutMode.CURRENT ? null : new LN(data, this.dbImpl.getDbEnvironment(), this.dbImpl.isReplicated());
        return this.putNotify(key, data, ln, putMode, this.dbImpl.getRepContext());
    }

    OperationStatus putLN(byte[] key, LN ln, PutMode putMode, ReplicationContext repContext) {
        assert (putMode != PutMode.CURRENT);
        return this.putNotify(new DatabaseEntry(key), new DatabaseEntry(ln.getData()), ln, putMode, repContext);
    }

    private OperationStatus putNotify(DatabaseEntry key, DatabaseEntry data, LN ln, PutMode putMode, ReplicationContext repContext) {
        try {
            OperationStatus commitStatus;
            boolean doNotifyTriggers;
            DatabaseEntry oldData = null;
            DatabaseEntry newData = null;
            DatabaseEntry returnNewData = null;
            boolean bl = doNotifyTriggers = this.dbHandle != null && this.dbHandle.hasTriggers();
            if (doNotifyTriggers) {
                newData = data.getPartial() ? (returnNewData = new DatabaseEntry()) : data;
                oldData = new DatabaseEntry();
            }
            if (putMode == PutMode.CURRENT) {
                assert (ln == null);
                if (doNotifyTriggers && key == null) {
                    key = new DatabaseEntry();
                }
                commitStatus = this.putCurrentNoNotify(data, key, oldData, returnNewData, repContext);
            } else {
                assert (ln != null);
                commitStatus = this.putNoNotify(key, data, ln, putMode, oldData, returnNewData, repContext);
            }
            if (doNotifyTriggers && commitStatus == OperationStatus.SUCCESS) {
                if (oldData != null && oldData.getData() == null) {
                    oldData = null;
                }
                if (newData != null && newData.getData() == null) {
                    newData = null;
                }
                this.dbHandle.notifyTriggers(this.cursorImpl.getLocker(), key, oldData, newData);
            }
            return commitStatus;
        }
        catch (Error E) {
            this.dbImpl.getDbEnvironment().invalidate(E);
            throw E;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OperationStatus putNoNotify(DatabaseEntry key, DatabaseEntry data, LN ln, PutMode putMode, DatabaseEntry returnOldData, DatabaseEntry returnNewData, ReplicationContext repContext) {
        assert (key != null);
        assert (ln != null);
        assert (putMode != null);
        assert (putMode != PutMode.CURRENT);
        Locker nextKeyLocker = null;
        CursorImpl nextKeyCursor = null;
        try {
            Locker cursorLocker = this.cursorImpl.getLocker();
            if (this.dbImpl.getDbEnvironment().getTxnManager().areOtherSerializableTransactionsActive(cursorLocker)) {
                nextKeyLocker = BuddyLocker.createBuddyLocker(this.dbImpl.getDbEnvironment(), cursorLocker);
                nextKeyCursor = new CursorImpl(this.dbImpl, nextKeyLocker);
                nextKeyCursor.setAllowEviction(true);
                nextKeyCursor.lockNextKeyForInsert(key, data);
            }
            OperationStatus operationStatus = this.putAllowPhantoms(key, data, ln, putMode, returnOldData, returnNewData, nextKeyCursor, repContext);
            return operationStatus;
        }
        finally {
            if (nextKeyCursor != null) {
                nextKeyCursor.close();
            }
            if (nextKeyLocker != null) {
                nextKeyLocker.operationEnd();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OperationStatus putAllowPhantoms(DatabaseEntry key, DatabaseEntry data, LN ln, PutMode putMode, DatabaseEntry returnOldData, DatabaseEntry returnNewData, CursorImpl nextKeyCursor, ReplicationContext repContext) {
        OperationStatus status = OperationStatus.NOTFOUND;
        CursorImpl dup = this.beginMoveCursor(false, nextKeyCursor);
        try {
            OperationStatus operationStatus = status = dup.put(key, data, ln, putMode, returnOldData, returnNewData, repContext);
            this.endMoveCursor(dup, status == OperationStatus.SUCCESS);
            return operationStatus;
        }
        catch (Throwable throwable) {
            this.endMoveCursor(dup, status == OperationStatus.SUCCESS);
            throw throwable;
        }
    }

    private OperationStatus putCurrentNoNotify(DatabaseEntry data, DatabaseEntry returnKey, DatabaseEntry returnOldData, DatabaseEntry returnNewData, ReplicationContext repContext) {
        assert (data != null);
        this.beginUseExistingCursor();
        OperationStatus status = this.cursorImpl.putCurrent(data, returnKey, returnOldData, returnNewData, -1L, repContext);
        this.endUseExistingCursor();
        return status;
    }

    OperationStatus position(DatabaseEntry key, DatabaseEntry data, LockMode lockMode, boolean first) {
        try {
            if (!this.isSerializableIsolation(lockMode)) {
                return this.positionAllowPhantoms(key, data, this.getLockType(lockMode, false), first);
            }
            while (true) {
                try {
                    if (!first) {
                        this.cursorImpl.lockEofNode(LockType.RANGE_READ);
                    }
                    LockType lockType = this.getLockType(lockMode, first);
                    OperationStatus status = this.positionAllowPhantoms(key, data, lockType, first);
                    if (first && status != OperationStatus.SUCCESS) {
                        this.cursorImpl.lockEofNode(LockType.RANGE_READ);
                    }
                    return status;
                }
                catch (RangeRestartException e) {
                    continue;
                }
                break;
            }
        }
        catch (Error E) {
            this.dbImpl.getDbEnvironment().invalidate(E);
            throw E;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OperationStatus positionAllowPhantoms(DatabaseEntry key, DatabaseEntry data, LockType lockType, boolean first) {
        assert (key != null && data != null);
        OperationStatus status = OperationStatus.NOTFOUND;
        CursorImpl dup = this.beginMoveCursor(false);
        try {
            if (!dup.positionFirstOrLast(first, null)) {
                status = OperationStatus.NOTFOUND;
                assert (LatchSupport.countLatchesHeld() == 0) : LatchSupport.latchesHeldToString();
            } else {
                assert (LatchSupport.countLatchesHeld() == 1) : LatchSupport.latchesHeldToString();
                status = dup.getCurrentAlreadyLatched(key, data, lockType, first);
                if (status != OperationStatus.SUCCESS) {
                    status = dup.getNext(key, data, lockType, first, false);
                }
            }
            this.cursorImpl.releaseBINs();
            this.endMoveCursor(dup, status == OperationStatus.SUCCESS);
        }
        catch (Throwable throwable) {
            this.cursorImpl.releaseBINs();
            this.endMoveCursor(dup, status == OperationStatus.SUCCESS);
            throw throwable;
        }
        return status;
    }

    OperationStatus search(DatabaseEntry key, DatabaseEntry data, LockMode lockMode, CursorImpl.SearchMode searchMode) {
        try {
            if (!this.isSerializableIsolation(lockMode)) {
                LockType lockType = this.getLockType(lockMode, false);
                CursorImpl.KeyChangeStatus result = this.searchAllowPhantoms(key, data, lockType, lockType, searchMode);
                return result.status;
            }
            while (true) {
                try {
                    CursorImpl.KeyChangeStatus result;
                    LockType searchLockType = this.getLockType(lockMode, false);
                    LockType advanceLockType = this.getLockType(lockMode, true);
                    DatabaseEntry tryKey = new DatabaseEntry(key.getData(), key.getOffset(), key.getSize());
                    DatabaseEntry tryData = new DatabaseEntry(data.getData(), data.getOffset(), data.getSize());
                    if (searchMode.isExactSearch()) {
                        result = this.searchExactAndRangeLock(tryKey, tryData, searchLockType, advanceLockType, searchMode);
                    } else {
                        result = this.searchAllowPhantoms(tryKey, tryData, searchLockType, advanceLockType, searchMode);
                        if (result.status != OperationStatus.SUCCESS) {
                            this.cursorImpl.lockEofNode(LockType.RANGE_READ);
                        }
                    }
                    if (result.status == OperationStatus.SUCCESS) {
                        key.setData(tryKey.getData(), 0, tryKey.getSize());
                        data.setData(tryData.getData(), 0, tryData.getSize());
                    }
                    return result.status;
                }
                catch (RangeRestartException e) {
                    continue;
                }
                break;
            }
        }
        catch (Error E) {
            this.dbImpl.getDbEnvironment().invalidate(E);
            throw E;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CursorImpl.KeyChangeStatus searchExactAndRangeLock(DatabaseEntry key, DatabaseEntry data, LockType searchLockType, LockType advanceLockType, CursorImpl.SearchMode searchMode) {
        searchMode = searchMode == CursorImpl.SearchMode.SET ? CursorImpl.SearchMode.SET_RANGE : CursorImpl.SearchMode.BOTH_RANGE;
        CursorImpl.KeyChangeStatus result = null;
        CursorImpl dup = this.beginMoveCursor(false);
        try {
            result = this.searchInternal(dup, key, data, searchLockType, advanceLockType, searchMode, true);
            if (result.keyChange && result.status == OperationStatus.SUCCESS) {
                result.status = OperationStatus.NOTFOUND;
            }
            this.endMoveCursor(dup, result != null && result.status == OperationStatus.SUCCESS);
        }
        catch (Throwable throwable) {
            this.endMoveCursor(dup, result != null && result.status == OperationStatus.SUCCESS);
            throw throwable;
        }
        if (result.status != OperationStatus.SUCCESS && !result.keyChange) {
            this.cursorImpl.lockEofNode(LockType.RANGE_READ);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CursorImpl.KeyChangeStatus searchAllowPhantoms(DatabaseEntry key, DatabaseEntry data, LockType searchLockType, LockType advanceLockType, CursorImpl.SearchMode searchMode) {
        OperationStatus status = OperationStatus.NOTFOUND;
        CursorImpl dup = this.beginMoveCursor(false);
        try {
            CursorImpl.KeyChangeStatus result = this.searchInternal(dup, key, data, searchLockType, advanceLockType, searchMode, false);
            status = result.status;
            CursorImpl.KeyChangeStatus keyChangeStatus = result;
            this.endMoveCursor(dup, status == OperationStatus.SUCCESS);
            return keyChangeStatus;
        }
        catch (Throwable throwable) {
            this.endMoveCursor(dup, status == OperationStatus.SUCCESS);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CursorImpl.KeyChangeStatus searchInternal(CursorImpl dup, DatabaseEntry key, DatabaseEntry data, LockType searchLockType, LockType advanceLockType, CursorImpl.SearchMode searchMode, boolean advanceAfterRangeSearch) {
        assert (key != null && data != null);
        OperationStatus status = OperationStatus.NOTFOUND;
        boolean keyChange = false;
        try {
            int searchResult = dup.searchAndPosition(key, data, searchMode, searchLockType);
            if ((searchResult & 1) != 0) {
                DatabaseEntry useKey;
                boolean exactKeyMatch = (searchResult & 2) != 0;
                boolean exactDataMatch = (searchResult & 4) != 0;
                boolean foundLast = (searchResult & 8) != 0;
                boolean rangeMatch = false;
                if (searchMode == CursorImpl.SearchMode.SET_RANGE && !exactKeyMatch) {
                    rangeMatch = true;
                }
                if (!(searchMode != CursorImpl.SearchMode.BOTH_RANGE || exactKeyMatch && exactDataMatch)) {
                    rangeMatch = true;
                }
                DatabaseEntry databaseEntry = useKey = searchMode == CursorImpl.SearchMode.SET ? null : key;
                if (rangeMatch || (status = dup.getCurrentAlreadyLatched(useKey, data, searchLockType, true)) == OperationStatus.KEYEMPTY) {
                    if (foundLast) {
                        status = OperationStatus.NOTFOUND;
                    } else if (searchMode == CursorImpl.SearchMode.SET) {
                        status = dup.getNextDuplicate(key, data, advanceLockType, true, rangeMatch);
                    } else if (searchMode == CursorImpl.SearchMode.BOTH) {
                        if (status == OperationStatus.KEYEMPTY) {
                            status = OperationStatus.NOTFOUND;
                        }
                    } else {
                        assert (!searchMode.isExactSearch());
                        byte[] searchKey = null;
                        if (searchMode.isDataSearch()) {
                            searchKey = Key.makeKey(key);
                        }
                        if (exactKeyMatch) {
                            CursorImpl.KeyChangeStatus result = dup.getNextWithKeyChangeStatus(key, data, advanceLockType, true, rangeMatch);
                            status = result.status;
                            keyChange = searchMode.isDataSearch() ? status == OperationStatus.SUCCESS : result.keyChange;
                        } else if (searchMode.isDataSearch() && !advanceAfterRangeSearch) {
                            status = OperationStatus.NOTFOUND;
                        } else {
                            status = dup.getNextNoDup(key, data, advanceLockType, true, rangeMatch);
                            boolean bl = keyChange = status == OperationStatus.SUCCESS;
                        }
                        if (status == OperationStatus.SUCCESS && searchMode.isDataSearch() && Key.compareKeys(key.getData(), searchKey, this.dbImpl.getBtreeComparator()) != 0) {
                            status = OperationStatus.NOTFOUND;
                        }
                    }
                }
            }
        }
        finally {
            this.cursorImpl.releaseBINs();
            if (status != OperationStatus.SUCCESS && dup != this.cursorImpl) {
                dup.releaseBINs();
            }
        }
        return new CursorImpl.KeyChangeStatus(status, keyChange);
    }

    OperationStatus retrieveNext(DatabaseEntry key, DatabaseEntry data, LockMode lockMode, GetMode getMode) {
        try {
            if (!this.isSerializableIsolation(lockMode)) {
                return this.retrieveNextAllowPhantoms(key, data, this.getLockType(lockMode, false), getMode);
            }
            while (true) {
                try {
                    OperationStatus status;
                    if (getMode == GetMode.NEXT_DUP) {
                        status = this.getNextDupAndRangeLock(key, data, lockMode);
                    } else {
                        if (!getMode.isForward()) {
                            this.rangeLockCurrentPosition(getMode);
                        }
                        LockType lockType = this.getLockType(lockMode, getMode.isForward());
                        status = this.retrieveNextAllowPhantoms(key, data, lockType, getMode);
                        if (getMode.isForward() && status != OperationStatus.SUCCESS) {
                            this.cursorImpl.lockEofNode(LockType.RANGE_READ);
                        }
                    }
                    return status;
                }
                catch (RangeRestartException e) {
                    continue;
                }
                break;
            }
        }
        catch (Error E) {
            this.dbImpl.getDbEnvironment().invalidate(E);
            throw E;
        }
    }

    private OperationStatus getNextDupAndRangeLock(DatabaseEntry key, DatabaseEntry data, LockMode lockMode) {
        boolean noNextKeyFound;
        OperationStatus status;
        CursorImpl dup;
        DatabaseEntry tryKey = new DatabaseEntry();
        DatabaseEntry tryData = new DatabaseEntry();
        LockType lockType = this.getLockType(lockMode, true);
        while (true) {
            assert (LatchSupport.countLatchesHeld() == 0);
            dup = this.beginMoveCursor(true);
            try {
                CursorImpl.KeyChangeStatus result = dup.getNextWithKeyChangeStatus(tryKey, tryData, lockType, true, false);
                status = result.status;
                boolean bl = noNextKeyFound = status != OperationStatus.SUCCESS;
                if (result.keyChange && status == OperationStatus.SUCCESS) {
                    status = OperationStatus.NOTFOUND;
                }
            }
            catch (DatabaseException DBE) {
                this.endMoveCursor(dup, false);
                throw DBE;
            }
            if (!this.checkForInsertion(GetMode.NEXT, this.cursorImpl, dup)) break;
            this.endMoveCursor(dup, false);
        }
        this.endMoveCursor(dup, status == OperationStatus.SUCCESS);
        assert (LatchSupport.countLatchesHeld() == 0);
        if (noNextKeyFound) {
            this.cursorImpl.lockEofNode(LockType.RANGE_READ);
        }
        if (status == OperationStatus.SUCCESS) {
            key.setData(tryKey.getData(), 0, tryKey.getSize());
            data.setData(tryData.getData(), 0, tryData.getSize());
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rangeLockCurrentPosition(GetMode getMode) {
        OperationStatus status;
        DatabaseEntry tempKey = new DatabaseEntry();
        DatabaseEntry tempData = new DatabaseEntry();
        tempKey.setPartial(0, 0, true);
        tempData.setPartial(0, 0, true);
        CursorImpl dup = this.cursorImpl.cloneCursor(true, this.cacheMode);
        try {
            status = getMode == GetMode.PREV_NODUP ? dup.getFirstDuplicate(tempKey, tempData, LockType.RANGE_READ) : dup.getCurrent(tempKey, tempData, LockType.RANGE_READ);
            if (status != OperationStatus.SUCCESS) {
                while (true) {
                    assert (LatchSupport.countLatchesHeld() == 0);
                    status = dup.getNext(tempKey, tempData, LockType.RANGE_READ, true, false);
                    if (!this.checkForInsertion(GetMode.NEXT, this.cursorImpl, dup)) break;
                    dup.close(this.cursorImpl);
                    dup = this.cursorImpl.cloneCursor(true, this.cacheMode);
                }
                assert (LatchSupport.countLatchesHeld() == 0);
            }
        }
        finally {
            dup.close(this.cursorImpl);
        }
        if (status != OperationStatus.SUCCESS) {
            this.cursorImpl.lockEofNode(LockType.RANGE_READ);
        }
    }

    private OperationStatus retrieveNextAllowPhantoms(DatabaseEntry key, DatabaseEntry data, LockType lockType, GetMode getMode) {
        OperationStatus status;
        CursorImpl dup;
        assert (key != null && data != null);
        while (true) {
            block12: {
                assert (LatchSupport.countLatchesHeld() == 0);
                dup = this.beginMoveCursor(true);
                try {
                    if (getMode == GetMode.NEXT) {
                        status = dup.getNext(key, data, lockType, true, false);
                        break block12;
                    }
                    if (getMode == GetMode.PREV) {
                        status = dup.getNext(key, data, lockType, false, false);
                        break block12;
                    }
                    if (getMode == GetMode.NEXT_DUP) {
                        status = dup.getNextDuplicate(key, data, lockType, true, false);
                        break block12;
                    }
                    if (getMode == GetMode.PREV_DUP) {
                        status = dup.getNextDuplicate(key, data, lockType, false, false);
                        break block12;
                    }
                    if (getMode == GetMode.NEXT_NODUP) {
                        status = dup.getNextNoDup(key, data, lockType, true, false);
                        break block12;
                    }
                    if (getMode == GetMode.PREV_NODUP) {
                        status = dup.getNextNoDup(key, data, lockType, false, false);
                        break block12;
                    }
                    throw EnvironmentFailureException.unexpectedState("unknown GetMode: " + getMode);
                }
                catch (DatabaseException DBE) {
                    this.endMoveCursor(dup, false);
                    throw DBE;
                }
            }
            if (!this.checkForInsertion(getMode, this.cursorImpl, dup)) break;
            this.endMoveCursor(dup, false);
        }
        this.endMoveCursor(dup, status == OperationStatus.SUCCESS);
        assert (LatchSupport.countLatchesHeld() == 0);
        return status;
    }

    OperationStatus getCurrentInternal(DatabaseEntry key, DatabaseEntry data, LockMode lockMode) {
        LockType lockType = this.getLockType(lockMode, false);
        this.beginUseExistingCursor();
        OperationStatus status = this.cursorImpl.getCurrent(key, data, lockType);
        this.endUseExistingCursor();
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkForInsertion(GetMode getMode, CursorImpl origCursor, CursorImpl dupCursor) {
        boolean forward = true;
        if (getMode == GetMode.PREV || getMode == GetMode.PREV_DUP || getMode == GetMode.PREV_NODUP) {
            forward = false;
        }
        boolean ret = false;
        if (origCursor.getBIN() != dupCursor.getBIN()) {
            block15: {
                origCursor.latchBINs();
                BIN origBIN = origCursor.getBIN();
                DBIN origDBIN = origCursor.getDupBIN();
                try {
                    if (origDBIN != null) break block15;
                    if (forward) {
                        if (origBIN.getNEntries() - 1 <= origCursor.getIndex()) break block15;
                        for (int i = origCursor.getIndex() + 1; i < origBIN.getNEntries(); ++i) {
                            LN ln;
                            Node n;
                            if (origBIN.isEntryKnownDeleted(i) || (n = origBIN.fetchTarget(i)) == null || n.containsDuplicates() || (ln = (LN)n).isDeleted()) continue;
                            ret = true;
                            break block15;
                        }
                        break block15;
                    }
                    if (origCursor.getIndex() <= 0) break block15;
                    for (int i = 0; i < origCursor.getIndex(); ++i) {
                        LN ln;
                        Node n;
                        if (origBIN.isEntryKnownDeleted(i) || (n = origBIN.fetchTarget(i)) == null || n.containsDuplicates() || (ln = (LN)n).isDeleted()) continue;
                        ret = true;
                        break;
                    }
                }
                finally {
                    origCursor.releaseBINs();
                }
            }
            return ret;
        }
        if (origCursor.getDupBIN() != dupCursor.getDupBIN() && origCursor.getIndex() == dupCursor.getIndex() && getMode != GetMode.NEXT_NODUP && getMode != GetMode.PREV_NODUP) {
            block16: {
                origCursor.latchBINs();
                DBIN origDBIN = origCursor.getDupBIN();
                try {
                    if (forward) {
                        if (origDBIN.getNEntries() - 1 <= origCursor.getDupIndex()) break block16;
                        for (int i = origCursor.getDupIndex() + 1; i < origDBIN.getNEntries(); ++i) {
                            if (origDBIN.isEntryKnownDeleted(i)) continue;
                            Node n = origDBIN.fetchTarget(i);
                            LN ln = (LN)n;
                            if (n == null || ln.isDeleted()) continue;
                            ret = true;
                            break block16;
                        }
                        break block16;
                    }
                    if (origCursor.getDupIndex() <= 0) break block16;
                    for (int i = 0; i < origCursor.getDupIndex(); ++i) {
                        if (origDBIN.isEntryKnownDeleted(i)) continue;
                        Node n = origDBIN.fetchTarget(i);
                        LN ln = (LN)n;
                        if (n == null || ln.isDeleted()) continue;
                        ret = true;
                        break;
                    }
                }
                finally {
                    origCursor.releaseBINs();
                }
            }
            return ret;
        }
        return false;
    }

    private CursorImpl beginMoveCursor(boolean addCursor, CursorImpl usePosition) {
        if (this.cursorImpl.isNotInitialized()) {
            this.cursorImpl.setCacheMode(this.cacheMode);
            this.cursorImpl.criticalEviction();
            return this.cursorImpl;
        }
        if (this.nonCloning) {
            this.cursorImpl.setCacheMode(this.cacheMode);
            if (addCursor) {
                this.cursorImpl.criticalEviction();
            } else {
                this.cursorImpl.reset();
            }
            return this.cursorImpl;
        }
        CursorImpl dup = this.cursorImpl.cloneCursor(addCursor, this.cacheMode, usePosition);
        dup.setClosingLocker(this.cursorImpl);
        return dup;
    }

    private CursorImpl beginMoveCursor(boolean addCursor) {
        return this.beginMoveCursor(addCursor, null);
    }

    private void endMoveCursor(CursorImpl dup, boolean success) {
        dup.clearClosingLocker();
        if (dup == this.cursorImpl) {
            if (success) {
                this.cursorImpl.criticalEviction();
            } else {
                this.cursorImpl.reset();
            }
        } else {
            if (success) {
                this.cursorImpl.close(dup);
                this.cursorImpl = dup;
            } else {
                dup.close(this.cursorImpl);
            }
            if (!this.cacheModeOverridden) {
                this.cacheMode = this.dbImpl.getDefaultCacheMode();
            }
        }
    }

    private void beginUseExistingCursor() {
        this.cursorImpl.setCacheMode(this.cacheMode);
        this.cursorImpl.criticalEviction();
    }

    private void endUseExistingCursor() {
        this.cursorImpl.criticalEviction();
    }

    boolean advanceCursor(DatabaseEntry key, DatabaseEntry data) {
        return this.cursorImpl.advanceCursor(key, data);
    }

    private LockType getLockType(LockMode lockMode, boolean rangeLock) {
        if (this.isReadUncommittedMode(lockMode)) {
            return LockType.NONE;
        }
        if (lockMode == null || lockMode == LockMode.DEFAULT) {
            return rangeLock ? LockType.RANGE_READ : LockType.READ;
        }
        if (lockMode == LockMode.RMW) {
            return rangeLock ? LockType.RANGE_WRITE : LockType.WRITE;
        }
        if (lockMode == LockMode.READ_COMMITTED) {
            throw new IllegalArgumentException(lockMode.toString() + " not allowed with Cursor methods, " + "use CursorConfig.setReadCommitted instead.");
        }
        assert (false) : lockMode;
        return LockType.NONE;
    }

    boolean isReadUncommittedMode(LockMode lockMode) {
        return lockMode == LockMode.READ_UNCOMMITTED || this.readUncommittedDefault && (lockMode == null || lockMode == LockMode.DEFAULT);
    }

    private boolean isSerializableIsolation(LockMode lockMode) {
        return this.serializableIsolationDefault && !this.isReadUncommittedMode(lockMode);
    }

    protected void checkUpdatesAllowed(String operation) {
        if (this.updateOperationsProhibited) {
            throw new UnsupportedOperationException("A transaction was not supplied when opening this cursor: " + operation);
        }
    }

    private void checkArgsNoValRequired(DatabaseEntry key, DatabaseEntry data) {
        DatabaseUtil.checkForNullDbt(key, "key", false);
        DatabaseUtil.checkForNullDbt(data, "data", false);
    }

    private void checkArgsValRequired(DatabaseEntry key, DatabaseEntry data) {
        DatabaseUtil.checkForNullDbt(key, "key", true);
        DatabaseUtil.checkForNullDbt(data, "data", true);
    }

    void checkState(boolean mustBeInitialized) {
        this.checkEnv();
        if (this.dbHandle != null) {
            this.dbHandle.checkOpen("Can't call Cursor method:");
        }
        this.cursorImpl.checkCursorState(mustBeInitialized);
    }

    void checkEnv() {
        this.cursorImpl.checkEnv();
    }

    void trace(Level level, String methodName, DatabaseEntry key, DatabaseEntry data, LockMode lockMode) {
        if (this.logger.isLoggable(level)) {
            StringBuffer sb = new StringBuffer();
            sb.append(methodName);
            this.traceCursorImpl(sb);
            if (key != null) {
                sb.append(" key=").append(key.dumpData());
            }
            if (data != null) {
                sb.append(" data=").append(data.dumpData());
            }
            if (lockMode != null) {
                sb.append(" lockMode=").append((Object)lockMode);
            }
            LoggerUtils.logMsg(this.logger, this.dbImpl.getDbEnvironment(), level, sb.toString());
        }
    }

    void trace(Level level, String methodName, LockMode lockMode) {
        if (this.logger.isLoggable(level)) {
            StringBuffer sb = new StringBuffer();
            sb.append(methodName);
            this.traceCursorImpl(sb);
            if (lockMode != null) {
                sb.append(" lockMode=").append((Object)lockMode);
            }
            LoggerUtils.logMsg(this.logger, this.dbImpl.getDbEnvironment(), level, sb.toString());
        }
    }

    private void traceCursorImpl(StringBuffer sb) {
        sb.append(" locker=").append(this.cursorImpl.getLocker().getId());
        if (this.cursorImpl.getBIN() != null) {
            sb.append(" bin=").append(this.cursorImpl.getBIN().getNodeId());
        }
        sb.append(" idx=").append(this.cursorImpl.getIndex());
        if (this.cursorImpl.getDupBIN() != null) {
            sb.append(" Dbin=").append(this.cursorImpl.getDupBIN().getNodeId());
        }
        sb.append(" dupIdx=").append(this.cursorImpl.getDupIndex());
    }
}

