/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep.stream;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.dbi.DatabaseId;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.log.LogEntryHeader;
import com.sleepycat.je.log.LogEntryType;
import com.sleepycat.je.log.LogItem;
import com.sleepycat.je.log.LogUtils;
import com.sleepycat.je.log.entry.LNLogEntry;
import com.sleepycat.je.log.entry.LogEntry;
import com.sleepycat.je.log.entry.ReplicableLogEntry;
import com.sleepycat.je.log.entry.SingleItemEntry;
import com.sleepycat.je.rep.stream.InputWireRecord;
import com.sleepycat.je.rep.stream.WireRecord;
import com.sleepycat.je.tree.NameLN;
import com.sleepycat.je.txn.TxnCommit;
import com.sleepycat.je.txn.TxnEnd;
import com.sleepycat.je.utilint.VLSN;
import java.nio.ByteBuffer;

public class OutputWireRecord
extends WireRecord {
    protected final ByteBuffer entryBuffer;
    protected final EnvironmentImpl envImpl;
    private final LogItem logItem;
    private ReplicableLogEntry sharedEntry = null;
    private ReplicableLogEntry logEntry = null;
    private Boolean reserialize = null;
    private int reSerializedSize = -1;
    private Boolean oldFormatRequired = null;

    OutputWireRecord(EnvironmentImpl envImpl, LogEntryHeader header, ByteBuffer readerBuffer) {
        super(header);
        this.envImpl = envImpl;
        this.logItem = null;
        this.entryBuffer = readerBuffer.slice();
        this.entryBuffer.limit(header.getItemSize());
    }

    OutputWireRecord(EnvironmentImpl envImpl, LogItem logItem) {
        super(logItem.header);
        this.envImpl = envImpl;
        this.logItem = logItem;
        ByteBuffer buffer = logItem.buffer;
        buffer.position(this.header.getSize());
        this.entryBuffer = buffer.slice();
        assert (this.entryBuffer.limit() == this.header.getItemSize()) : "Limit:" + this.entryBuffer.limit() + " size:" + this.header.getItemSize();
    }

    OutputWireRecord(EnvironmentImpl envImpl, InputWireRecord input) {
        super(input.header);
        this.envImpl = envImpl;
        this.logItem = null;
        LogEntry entry = input.getLogEntry();
        this.entryBuffer = ByteBuffer.allocate(entry.getSize());
        entry.writeEntry(this.entryBuffer);
        this.entryBuffer.flip();
    }

    private synchronized ReplicableLogEntry getSharedEntry() throws DatabaseException {
        if (this.sharedEntry == null) {
            LogEntryType entryType = this.getLogEntryType();
            if (!entryType.isReplicationPossible()) {
                throw EnvironmentFailureException.unexpectedState("Log entry type does not support replication: " + entryType);
            }
            this.sharedEntry = (ReplicableLogEntry)entryType.getSharedLogEntry();
        }
        return this.sharedEntry;
    }

    public synchronized ReplicableLogEntry instantiateEntry() throws DatabaseException {
        LogEntry entry;
        if (this.logEntry != null) {
            return this.logEntry;
        }
        if (this.logItem != null) {
            this.logEntry = this.logItem.cachedEntry;
            if (this.logEntry != null) {
                return this.logEntry;
            }
        }
        if (!((entry = this.instantiateEntry(this.envImpl, this.entryBuffer)) instanceof ReplicableLogEntry)) {
            throw EnvironmentFailureException.unexpectedState("Log entry type does not support replication: " + entry.getClass().getName());
        }
        this.logEntry = (ReplicableLogEntry)entry;
        if (this.logItem != null) {
            this.logItem.cachedEntry = this.logEntry;
        }
        return this.logEntry;
    }

    public byte getEntryType() {
        return this.header.getType();
    }

    public boolean match(InputWireRecord input) throws DatabaseException {
        if (!this.header.logicalEqualsIgnoreVersion(input.header)) {
            return false;
        }
        ReplicableLogEntry entry = this.instantiateEntry();
        return entry.logicalEquals(input.getLogEntry());
    }

    public boolean match(OutputWireRecord otherRecord) throws DatabaseException {
        if (!this.header.logicalEqualsIgnoreVersion(otherRecord.header)) {
            return false;
        }
        ReplicableLogEntry entry = this.instantiateEntry();
        LogEntry otherEntry = otherRecord.instantiateEntry(this.envImpl, otherRecord.entryBuffer);
        return entry.logicalEquals(otherEntry);
    }

    long getLogItemLSN() {
        return this.logItem != null ? this.logItem.lsn : -1L;
    }

    public VLSN getVLSN() {
        return this.header.getVLSN();
    }

    public String dump() throws DatabaseException {
        StringBuilder sb = new StringBuilder();
        this.header.dumpRep(sb);
        ReplicableLogEntry entry = this.instantiateEntry();
        entry.dumpRep(sb);
        return sb.toString();
    }

    public String toString() {
        try {
            return this.dump();
        }
        catch (DatabaseException e) {
            e.printStackTrace();
            return "";
        }
    }

    int getWireSize(int logVersion) {
        return 17 + this.getEntrySize(logVersion);
    }

    private int getEntrySize(int logVersion) {
        return this.willReSerialize(logVersion) ? this.reSerializedSize : this.header.getItemSize();
    }

    private boolean willReSerialize(int logVersion) {
        if (this.reserialize != null) {
            return this.reserialize;
        }
        int newSize = -1;
        if (this.header.getVersion() < 8) {
            this.reserialize = false;
        } else if (this.isOldFormatRequired(logVersion)) {
            this.reserialize = true;
        } else if (this.logEntry != null) {
            if (this.logEntry.hasReplicationFormat()) {
                newSize = this.logEntry.getSize(logVersion, true);
                this.reserialize = this.header.getItemSize() > newSize;
            } else {
                this.reserialize = false;
            }
        } else {
            this.reserialize = this.getSharedEntry().isReplicationFormatWorthwhile(this.entryBuffer, this.header.getVersion(), logVersion);
        }
        if (this.reserialize.booleanValue()) {
            if (newSize == -1) {
                newSize = this.instantiateEntry().getSize(logVersion, true);
            }
            this.reSerializedSize = newSize;
        }
        assert (this.reserialize != null);
        return this.reserialize;
    }

    private boolean isOldFormatRequired(int logVersion) {
        if (this.oldFormatRequired != null) {
            return this.oldFormatRequired;
        }
        this.oldFormatRequired = logVersion < 15 && logVersion < this.header.getVersion() && logVersion < this.getSharedEntry().getLastFormatChange();
        return this.oldFormatRequired;
    }

    boolean writeToWire(ByteBuffer messageBuffer, int logVersion) {
        messageBuffer.put(this.header.getType());
        if (this.willReSerialize(logVersion)) {
            ReplicableLogEntry entry = this.instantiateEntry();
            LogUtils.writeInt(messageBuffer, logVersion);
            LogUtils.writeInt(messageBuffer, this.reSerializedSize);
            LogUtils.writeLong(messageBuffer, this.header.getVLSN().getSequence());
            this.entryBuffer.mark();
            entry.writeEntry(messageBuffer, logVersion, true);
        } else {
            LogUtils.writeInt(messageBuffer, this.header.getVersion());
            LogUtils.writeInt(messageBuffer, this.header.getItemSize());
            LogUtils.writeLong(messageBuffer, this.header.getVLSN().getSequence());
            this.entryBuffer.mark();
            messageBuffer.put(this.entryBuffer);
        }
        this.entryBuffer.reset();
        return this.isOldFormatRequired(logVersion);
    }

    public long getCommitTxnId() throws DatabaseException {
        if (!LogEntryType.LOG_TXN_COMMIT.equalsType(this.header.getType())) {
            return 0L;
        }
        ReplicableLogEntry commitEntry = this.instantiateEntry();
        return commitEntry.getTransactionId();
    }

    public long getCommitTimeStamp() throws DatabaseException {
        if (!LogEntryType.LOG_TXN_COMMIT.equalsType(this.header.getType())) {
            return 0L;
        }
        TxnCommit txnCommit = (TxnCommit)this.instantiateEntry().getMainItem();
        return txnCommit.getTime().getTime();
    }

    public long getTimeStamp() throws DatabaseException {
        Class logClass;
        LogEntry sharedLogEntry = this.getLogEntryType().getSharedLogEntry();
        if (sharedLogEntry instanceof SingleItemEntry && TxnEnd.class.isAssignableFrom(logClass = ((SingleItemEntry)sharedLogEntry).getLogClass())) {
            TxnEnd txnEnd = (TxnEnd)this.instantiateEntry().getMainItem();
            return txnEnd.getTime().getTime();
        }
        return 0L;
    }

    public DatabaseId getReplicableDBId() throws DatabaseException {
        LogEntryType logEntryType = this.getLogEntryType();
        if (!logEntryType.isReplicationPossible()) {
            return null;
        }
        if (!logEntryType.isLNType()) {
            return null;
        }
        return this.instantiateEntry().getDbId();
    }

    public boolean verifyNegativeSequences(String debugTag) {
        ReplicableLogEntry entry = null;
        try {
            entry = this.instantiateEntry();
        }
        catch (DatabaseException e) {
            throw EnvironmentFailureException.unexpectedException(e);
        }
        if (entry.getTransactionId() >= 0L) {
            throw EnvironmentFailureException.unexpectedState(debugTag + " txn id should be negative: " + entry);
        }
        if (entry instanceof LNLogEntry) {
            if (LogEntryType.LOG_NAMELN_TRANSACTIONAL.equalsType(this.getEntryType())) {
                LNLogEntry lnEntry = (LNLogEntry)entry;
                lnEntry.postFetchInit(false);
                NameLN nameLN = (NameLN)lnEntry.getLN();
                if (nameLN.getId().getId() >= 0L) {
                    throw EnvironmentFailureException.unexpectedState(debugTag + " db id should be negative: " + entry);
                }
            } else if (entry.getDbId().getId() >= 0L) {
                throw EnvironmentFailureException.unexpectedState(debugTag + " db id should be negative: " + entry);
            }
        }
        return true;
    }
}

