/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.dbi;

import com.sleepycat.je.CacheMode;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.ThreadInterruptedException;
import com.sleepycat.je.cleaner.DbFileSummary;
import com.sleepycat.je.cleaner.FileProtector;
import com.sleepycat.je.dbi.DatabaseId;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.DupKeyData;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.dbi.LSNAccumulator;
import com.sleepycat.je.dbi.MemoryBudget;
import com.sleepycat.je.evictor.Evictor;
import com.sleepycat.je.evictor.OffHeapCache;
import com.sleepycat.je.log.LogEntryType;
import com.sleepycat.je.log.LogManager;
import com.sleepycat.je.log.Loggable;
import com.sleepycat.je.log.entry.LNLogEntry;
import com.sleepycat.je.log.entry.LogEntry;
import com.sleepycat.je.tree.BIN;
import com.sleepycat.je.tree.IN;
import com.sleepycat.je.tree.Key;
import com.sleepycat.je.tree.LN;
import com.sleepycat.je.tree.OldBINDelta;
import com.sleepycat.je.tree.SearchResult;
import com.sleepycat.je.tree.Tree;
import com.sleepycat.je.utilint.DbLsn;
import com.sleepycat.je.utilint.TestHook;
import com.sleepycat.je.utilint.TestHookExecute;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;

public class DiskOrderedScanner {
    private static final LogEntryType[] LN_ONLY = new LogEntryType[]{LogEntryType.LOG_INS_LN};
    private static final LogEntryType[] BIN_ONLY = new LogEntryType[]{LogEntryType.LOG_BIN};
    private static final LogEntryType[] BIN_OR_DELTA = new LogEntryType[]{LogEntryType.LOG_BIN, LogEntryType.LOG_BIN_DELTA, LogEntryType.LOG_OLD_BIN_DELTA};
    private static final int SIZEOF_JAVA_REF = MemoryBudget.OBJECT_ARRAY_ITEM_OVERHEAD;
    private static final int SIZEOF_WeakBinRef = MemoryBudget.DOS_WEAK_BINREF_OVERHEAD;
    private static final int SIZEOF_OffHeapBinRef = MemoryBudget.DOS_OFFHEAP_BINREF_OVERHEAD;
    private static final int SIZEOF_DeferredDeltaRef = MemoryBudget.DOS_DEFERRED_DELTAREF_OVERHEAD;
    private static final int SIZEOF_DeferredLsnsBatch = MemoryBudget.DOS_DEFERRED_LSN_BATCH_OVERHEAD;
    private static final int ACCUMULATED_MEM_LIMIT = 100000;
    private static final int SUSPENSION_INTERVAL = 50;
    private final boolean scanSerial;
    private final boolean countOnly;
    private final boolean keysOnly;
    private final boolean binsOnly;
    private final long lsnBatchSize;
    private final long memoryLimit;
    private final EnvironmentImpl env;
    private final RecordProcessor processor;
    private final int numDBs;
    private final DBContext[] dbs;
    private final Map<DatabaseId, Integer> dbid2dbidxMap;
    private final boolean dupDBs;
    private final ArrayList<Object> binDeltas;
    private final LSNAccumulator lsnAcc;
    private final LinkedList<DeferredLsnsBatch> deferredLsns;
    private long localMemoryUsage = 0L;
    private long globalMemoryUsage = 0L;
    private long accumulatedMemDelta = 0L;
    private long numLsns = 0L;
    private volatile int nIterations;
    private TestHook testHook1;
    private TestHook evictionHook;
    private final boolean debug;

    DiskOrderedScanner(DatabaseImpl[] dbImpls, RecordProcessor processor, boolean scanSerial, boolean binsOnly, boolean keysOnly, boolean countOnly, long lsnBatchSize, long memoryLimit, boolean dbg) {
        this.processor = processor;
        this.env = dbImpls[0].getEnv();
        this.dupDBs = dbImpls[0].getSortedDuplicates();
        this.scanSerial = scanSerial;
        this.countOnly = countOnly;
        this.keysOnly = keysOnly || countOnly;
        this.binsOnly = binsOnly || this.dupDBs || keysOnly || countOnly;
        this.lsnBatchSize = lsnBatchSize;
        this.memoryLimit = memoryLimit;
        this.debug = dbg;
        this.numDBs = dbImpls.length;
        this.dbs = new DBContext[this.numDBs];
        this.dbid2dbidxMap = new HashMap<DatabaseId, Integer>(this.numDBs);
        for (int i = 0; i < this.numDBs; ++i) {
            this.dbid2dbidxMap.put(dbImpls[i].getId(), i);
            this.dbs[i] = new DBContext(i, dbImpls[i]);
        }
        this.lsnAcc = new LSNAccumulator(){

            @Override
            void noteMemUsage(long increment) {
                DiskOrderedScanner.this.addLocalMemory(increment);
                DiskOrderedScanner.this.addGlobalMemory(increment);
            }
        };
        if (this.binsOnly) {
            this.binDeltas = new ArrayList();
            this.deferredLsns = new LinkedList();
        } else {
            this.binDeltas = null;
            this.deferredLsns = null;
        }
    }

    int getNIterations() {
        return this.nIterations;
    }

    long getNumLsns() {
        return this.numLsns;
    }

    private void addLocalMemory(long delta) {
        this.localMemoryUsage += delta;
        assert (this.localMemoryUsage >= 0L);
    }

    private void addGlobalMemory(long delta) {
        this.globalMemoryUsage += delta;
        assert (this.globalMemoryUsage >= 0L);
        this.accumulatedMemDelta += delta;
        if (this.accumulatedMemDelta > 100000L || this.accumulatedMemDelta < -100000L) {
            this.env.getMemoryBudget().updateDOSMemoryUsage(this.accumulatedMemDelta);
            this.accumulatedMemDelta = 0L;
        }
    }

    private boolean accLimitExceeded() {
        return this.accLimitExceeded(this.localMemoryUsage, this.numLsns);
    }

    private boolean accLimitExceeded(long mem, long nLsns) {
        return mem >= this.memoryLimit || nLsns > this.lsnBatchSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void scan(String protectedFilesNamePrefix, long protectedFilesId) {
        FileProtector.ProtectedActiveFileSet protectedFileSet = this.env.getFileProtector().protectActiveFiles(protectedFilesNamePrefix + "-" + protectedFilesId);
        try {
            if (this.scanSerial) {
                this.scanSerial();
            } else {
                this.scanInterleaved();
            }
            assert (this.globalMemoryUsage == (long)MemoryBudget.TREEMAP_OVERHEAD) : "MemoryUsage is wrong at DOS end: " + this.globalMemoryUsage;
        }
        finally {
            this.env.getFileProtector().removeFileProtection(protectedFileSet);
            long budgeted = this.globalMemoryUsage - this.accumulatedMemDelta;
            this.env.getMemoryBudget().updateDOSMemoryUsage(-budgeted);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scanSerial() {
        int dbidx = 0;
        DBContext ctx = null;
        while (true) {
            try {
                boolean overBudget = this.accLimitExceeded();
                block4: while (dbidx < this.numDBs && !overBudget) {
                    ctx = this.dbs[dbidx];
                    if (ctx.parent == null) {
                        this.getFirstIN(ctx, ctx.prevEndingKey);
                    }
                    if (ctx.done) {
                        ++dbidx;
                        assert (ctx.parent == null);
                        continue;
                    }
                    while (ctx.parent != null) {
                        if (this.binsOnly) {
                            this.accumulateBINs(ctx);
                        } else {
                            this.accumulateLNs(ctx);
                        }
                        if (this.accLimitExceeded()) {
                            overBudget = true;
                            continue block4;
                        }
                        this.processor.checkShutdown();
                        this.getNextIN(ctx);
                        if (!ctx.done) continue;
                        ++dbidx;
                        assert (ctx.parent == null);
                    }
                }
            }
            finally {
                if (ctx.parent != null && ctx.parentIsLatched) {
                    ctx.parent.releaseLatchIfOwner();
                }
            }
            if (this.binsOnly) {
                this.fetchAndProcessBINs();
            } else {
                this.fetchAndProcessLNs();
            }
            if (dbidx >= this.numDBs && (!this.binsOnly || this.deferredLsns.isEmpty())) break;
            this.initNextIteration();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scanInterleaved() {
        while (true) {
            int dbidx;
            boolean overBudget;
            boolean done;
            try {
                block3: do {
                    done = true;
                    overBudget = false;
                    if (this.accLimitExceeded()) {
                        overBudget = true;
                        break;
                    }
                    for (dbidx = 0; dbidx < this.numDBs; ++dbidx) {
                        DBContext ctx = this.dbs[dbidx];
                        if (ctx.done) continue;
                        if (ctx.parent == null) {
                            this.getFirstIN(ctx, ctx.prevEndingKey);
                        } else if (this.numDBs > 1) {
                            this.resumeParent(ctx);
                        }
                        if (ctx.done) continue;
                        done = false;
                        if (this.binsOnly) {
                            this.accumulateBINs(ctx);
                        } else {
                            this.accumulateLNs(ctx);
                        }
                        if (this.accLimitExceeded()) {
                            overBudget = true;
                            continue block3;
                        }
                        this.processor.checkShutdown();
                        if (ctx.pidx >= ctx.parent.getNEntries()) {
                            this.getNextIN(ctx);
                            if (ctx.done) continue;
                        }
                        if (this.numDBs <= 1) continue;
                        this.releaseParent(ctx);
                    }
                } while (!done && !overBudget);
            }
            catch (Throwable throwable) {
                for (int dbidx2 = 0; dbidx2 < this.numDBs; ++dbidx2) {
                    if (this.dbs[dbidx2].parent == null || !this.dbs[dbidx2].parentIsLatched) continue;
                    this.dbs[dbidx2].parent.releaseLatchIfOwner();
                }
                throw throwable;
            }
            for (dbidx = 0; dbidx < this.numDBs; ++dbidx) {
                if (this.dbs[dbidx].parent == null || !this.dbs[dbidx].parentIsLatched) continue;
                this.dbs[dbidx].parent.releaseLatchIfOwner();
            }
            if (this.debug) {
                if (overBudget) {
                    System.out.println("Finished Phase 1." + this.nIterations + " because DOS budget exceeded. localMemoryUsage = " + this.localMemoryUsage + " globalMemoryUsage = " + this.globalMemoryUsage);
                } else {
                    System.out.println("Finished Phase 1." + this.nIterations + " because no more records to scan. localMemoryUsage = " + this.localMemoryUsage + " globalMemoryUsage = " + this.globalMemoryUsage);
                }
            }
            TestHookExecute.doHookIfSet(this.evictionHook);
            if (this.binsOnly) {
                this.fetchAndProcessBINs();
            } else {
                this.fetchAndProcessLNs();
            }
            if (this.debug) {
                System.out.println("Finished Phase 2." + this.nIterations + " localMemoryUsage = " + this.localMemoryUsage + " globalMemoryUsage = " + this.globalMemoryUsage);
            }
            if (done && (!this.binsOnly || this.deferredLsns.isEmpty())) break;
            this.initNextIteration();
        }
        if (this.debug) {
            System.out.println("Producer done in " + this.nIterations + " iterations");
        }
    }

    private void initNextIteration() {
        for (int i = 0; i < this.numDBs; ++i) {
            DBContext ctx = this.dbs[i];
            ctx.parent = null;
            ctx.parentIsLatched = false;
            ctx.checkLevel2Keys = true;
            ctx.prevEndingKey = ctx.newEndingKey;
            ctx.safeToUseCachedDelta = false;
            if (this.binsOnly && ctx.lastBinLsn != -1L) {
                for (DeferredLsnsBatch batch : this.deferredLsns) {
                    if (!batch.containsLsn(ctx.lastBinLsn)) continue;
                    BIN bin = (BIN)this.fetchItem(ctx.lastBinLsn, BIN_OR_DELTA);
                    int memSize = 0;
                    if (bin.isBINDelta(false)) {
                        bin = bin.reconstituteBIN(ctx.dbImpl);
                        memSize = DiskOrderedScanner.getDeltaMemSize(ctx, ctx.lastBinLsn);
                    }
                    this.processBINInternal(ctx, bin, false);
                    batch.undoLsn(this, ctx.lastBinLsn, memSize);
                    assert (Key.compareKeys(ctx.newEndingKey, ctx.prevEndingKey, ctx.dbImpl.getKeyComparator()) >= 0);
                    ctx.prevEndingKey = ctx.newEndingKey;
                    if (!this.debug) break;
                    System.out.println("LSN " + ctx.lastBinLsn + " for bin " + bin.getNodeId() + " was the last bin lsn seen during Phase 1." + this.nIterations + " and it got deferred during Phase 2." + this.nIterations + ". Moved prevEndingKey forward");
                    break;
                }
            }
            ctx.lastBinLsn = -1L;
        }
        this.localMemoryUsage = this.lsnAcc.getMemoryUsage();
        this.numLsns = 0L;
        if (this.binsOnly && !this.deferredLsns.isEmpty()) {
            DeferredLsnsBatch batch = this.deferredLsns.getFirst();
            this.numLsns = batch.lsns.size();
            this.addLocalMemory(batch.memoryUsage);
        }
        ++this.nIterations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void accumulateBINs(DBContext ctx) {
        OffHeapCache ohCache = this.env.getOffHeapCache();
        while (ctx.pidx < ctx.parent.getNEntries()) {
            if (this.skipParentSlot(ctx)) {
                ++ctx.pidx;
                continue;
            }
            if (ctx.prevEndingKey == null || !ctx.safeToUseCachedDelta && ctx.pidx > 0 && Key.compareKeys(ctx.prevEndingKey, ctx.parent.getKey(ctx.pidx), ctx.dbImpl.getKeyComparator()) < 0) {
                ctx.safeToUseCachedDelta = true;
            }
            boolean waitForConsumer = false;
            int binNEntries = 0;
            long binLsn = ctx.parent.getLsn(ctx.pidx);
            int ohBinId = ctx.parent.getOffHeapBINId(ctx.pidx);
            boolean ohBinPri2 = ctx.parent.isOffHeapBINPri2(ctx.pidx);
            ctx.lastBinLsn = binLsn;
            BIN bin = (BIN)ctx.parent.getTarget(ctx.pidx);
            if (bin != null) {
                bin.latch(CacheMode.UNCHANGED);
            }
            try {
                if (bin != null || ohBinId >= 0) {
                    int cmp;
                    boolean isBinDelta;
                    OffHeapCache.BINInfo ohInfo = null;
                    if (bin != null) {
                        isBinDelta = bin.isBINDelta();
                    } else {
                        ohInfo = ohCache.getBINInfo(this.env, ohBinId);
                        isBinDelta = ohInfo.isBINDelta;
                    }
                    if (isBinDelta) {
                        if (bin != null) {
                            if (bin.getDirty() || !ctx.safeToUseCachedDelta) {
                                this.addDirtyDeltaRef(bin.cloneBINDelta());
                            } else {
                                this.addCleanDeltaRef(ctx, binLsn, bin);
                            }
                        } else if (ctx.parent.isOffHeapBINDirty(ctx.pidx) || !ctx.safeToUseCachedDelta) {
                            this.addDirtyDeltaRef(ohCache.loadBIN(this.env, ohBinId));
                        } else {
                            this.addCleanDeltaOffHeapRef(ctx, binLsn, ohInfo.fullBINLsn, ohBinId, ohBinPri2);
                        }
                        ++ctx.pidx;
                        if (this.scanSerial) continue;
                        return;
                    }
                    if (bin == null) {
                        bin = ohCache.loadBIN(this.env, ohBinId);
                        bin.latchNoUpdateLRU(ctx.dbImpl);
                    }
                    if ((binNEntries = bin.getNEntries()) == 0) {
                        ++ctx.pidx;
                        continue;
                    }
                    if (ctx.prevEndingKey != null && (cmp = Key.compareKeys(bin.getKey(binNEntries - 1), ctx.prevEndingKey, ctx.dbImpl.getKeyComparator())) <= 0) {
                        ++ctx.pidx;
                        continue;
                    }
                }
                if (bin == null || this.processor.getCapacity() < binNEntries) {
                    this.lsnAcc.add(binLsn);
                    ++this.numLsns;
                    this.addLocalMemory(8 + DiskOrderedScanner.getDeltaMemSize(ctx, binLsn));
                    if (this.debug) {
                        System.out.println("Phase 1." + this.nIterations + ": accumulated bin lsn: " + binLsn);
                    }
                } else if (this.processor.canProcessWithoutBlocking(binNEntries)) {
                    if (this.debug) {
                        System.out.println("Phase 1." + this.nIterations + ": Processing bin: " + bin.getNodeId());
                    }
                    this.processBINInternal(ctx, bin, false);
                } else {
                    if (this.debug) {
                        System.out.println("Phase 1." + this.nIterations + ": Producer must wait before it can process bin " + bin.getNodeId());
                    }
                    waitForConsumer = true;
                    ctx.binKey = bin.getKey(0);
                }
            }
            finally {
                if (bin == null) continue;
                bin.releaseLatch();
                continue;
            }
            if (waitForConsumer) {
                this.waitForConsumer(ctx, binNEntries);
                continue;
            }
            ++ctx.pidx;
            if (this.scanSerial) continue;
            return;
        }
    }

    void addCleanDeltaRef(DBContext ctx, long binLsn, BIN bin) {
        this.binDeltas.add(new WeakBinRef(this, ctx, binLsn, bin));
        bin.updateLRU(CacheMode.DEFAULT);
        this.addLocalMemory(SIZEOF_WeakBinRef + 2 * SIZEOF_JAVA_REF + DeferredLsnsBatch.LSN_MEM_OVERHEAD);
        this.addGlobalMemory(SIZEOF_WeakBinRef + SIZEOF_JAVA_REF);
        if (this.debug) {
            System.out.println("Phase 1." + this.nIterations + ": added weak bin ref for bin delta " + bin.getNodeId() + " at LSN = " + binLsn);
        }
    }

    void addCleanDeltaOffHeapRef(DBContext ctx, long binLsn, long fullBINLsn, int ohBinId, boolean ohBinPri2) {
        this.binDeltas.add(new OffHeapBinRef(this, ctx, binLsn, fullBINLsn, ohBinId));
        this.env.getOffHeapCache().moveBack(ohBinId, ohBinPri2);
        this.addLocalMemory(SIZEOF_OffHeapBinRef + 2 * SIZEOF_JAVA_REF + DeferredLsnsBatch.LSN_MEM_OVERHEAD);
        this.addGlobalMemory(SIZEOF_OffHeapBinRef + SIZEOF_JAVA_REF);
        if (this.debug) {
            System.out.println("Phase 1." + this.nIterations + ": added off-heap bin ref for bin delta ID " + ohBinId + " at LSN = " + binLsn);
        }
    }

    void addDirtyDeltaRef(BIN delta) {
        this.binDeltas.add(delta);
        this.addLocalMemory(delta.getInMemorySize() + (long)(2 * SIZEOF_JAVA_REF));
        this.addGlobalMemory(delta.getInMemorySize() + (long)SIZEOF_JAVA_REF);
        if (this.debug) {
            System.out.println("Phase 1." + this.nIterations + ": copied dirty or unsafe bin delta " + delta.getNodeId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void accumulateLNs(DBContext ctx) {
        OffHeapCache ohCache = this.env.getOffHeapCache();
        DatabaseImpl dbImpl = ctx.dbImpl;
        IN parent = ctx.parent;
        assert (parent != null);
        IN bin = null;
        ctx.reuseBin = false;
        boolean waitForConsumer = false;
        while (ctx.pidx < parent.getNEntries()) {
            if (this.skipParentSlot(ctx)) {
                ++ctx.pidx;
                continue;
            }
            long plsn = parent.getLsn(ctx.pidx);
            if (!ctx.reuseBin) {
                bin = (BIN)parent.getTarget(ctx.pidx);
            }
            if (bin == null) {
                int ohBinId = parent.getOffHeapBINId(ctx.pidx);
                Object item = ohBinId >= 0 ? ohCache.loadBIN(this.env, ohBinId) : this.fetchItem(plsn, BIN_OR_DELTA);
                if (item instanceof BIN) {
                    bin = (BIN)item;
                    if (bin.isBINDelta(false)) {
                        bin = ((BIN)bin).reconstituteBIN(dbImpl);
                    } else {
                        bin.setDatabase(dbImpl);
                    }
                } else {
                    OldBINDelta delta = (OldBINDelta)item;
                    bin = (BIN)this.fetchItem(delta.getLastFullLsn(), BIN_ONLY);
                    delta.reconstituteBIN(dbImpl, (BIN)bin);
                }
                bin.latchNoUpdateLRU(dbImpl);
            } else {
                bin.latchNoUpdateLRU();
                if (bin.isBINDelta()) {
                    BIN fullBIN;
                    try {
                        fullBIN = ((BIN)bin).reconstituteBIN(dbImpl);
                    }
                    finally {
                        bin.releaseLatch();
                    }
                    bin = fullBIN;
                    bin.latchNoUpdateLRU(dbImpl);
                }
            }
            try {
                int bidx = 0;
                if (waitForConsumer) {
                    boolean exact;
                    waitForConsumer = false;
                    ctx.reuseBin = false;
                    bidx = bin.findEntry(ctx.binKey, true, false);
                    boolean bl = exact = bidx >= 0 && (bidx & 0x10000) != 0;
                    bidx = exact ? (bidx &= 0xFFFEFFFF) : ++bidx;
                }
                boolean checkBinKeys = this.isBinProcessedBefore(ctx, (BIN)bin);
                while (bidx < bin.getNEntries()) {
                    ctx.binKey = bin.getKey(bidx);
                    if (!this.skipSlot(ctx, (BIN)bin, bidx, checkBinKeys)) {
                        LN ln = (LN)bin.getTarget(bidx);
                        if (ln == null && !bin.isEmbeddedLN(bidx) && (ln = ohCache.loadLN((BIN)bin, bidx, CacheMode.UNCHANGED)) == null) {
                            if (!DbLsn.isTransientOrNull(bin.getLsn(bidx))) {
                                this.lsnAcc.add(bin.getLsn(bidx));
                                ++this.numLsns;
                                this.addLocalMemory(8L);
                            }
                        } else {
                            if (!this.processor.canProcessWithoutBlocking(1)) {
                                waitForConsumer = true;
                                break;
                            }
                            byte[] data = ln != null ? ln.getData() : bin.getData(bidx);
                            this.processRecord(ctx, ctx.binKey, data, ((BIN)bin).getExpiration(bidx), bin.isExpirationInHours());
                        }
                    }
                    ++bidx;
                }
            }
            finally {
                bin.releaseLatch();
            }
            if (waitForConsumer) {
                this.waitForConsumer(ctx, 0);
                parent = ctx.parent;
                continue;
            }
            ++ctx.pidx;
            if (this.scanSerial) continue;
            return;
        }
    }

    boolean skipParentSlot(DBContext ctx) {
        if (ctx.checkLevel2Keys && ctx.prevEndingKey != null && ctx.pidx + 1 < ctx.parent.getNEntries() && Key.compareKeys(ctx.prevEndingKey, ctx.parent.getKey(ctx.pidx + 1), ctx.dbImpl.getKeyComparator()) >= 0) {
            return true;
        }
        ctx.checkLevel2Keys = false;
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void waitForConsumer(DBContext ctx, int binNEntries) {
        this.releaseParent(ctx);
        try {
            int minFree = this.binsOnly ? binNEntries : 1;
            int free = Math.max(minFree, this.processor.getCapacity() / 5);
            while (!this.processor.canProcessWithoutBlocking(free)) {
                RecordProcessor recordProcessor = this.processor;
                synchronized (recordProcessor) {
                    this.processor.wait(50L);
                    this.processor.checkShutdown();
                }
            }
        }
        catch (InterruptedException IE) {
            ctx.parent.unpin();
            throw new ThreadInterruptedException(ctx.dbImpl.getEnv(), (Throwable)IE);
        }
        catch (Error E) {
            ctx.parent.unpin();
            throw E;
        }
        this.resumeParent(ctx);
    }

    void releaseParent(DBContext ctx) {
        ctx.plsn = ctx.parent.getLsn(ctx.pidx);
        ctx.pkey = ctx.parent.getKey(ctx.pidx);
        ctx.parent.pin();
        ctx.parent.releaseLatch();
        ctx.parentIsLatched = false;
    }

    void resumeParent(DBContext ctx) {
        ctx.parent.latchShared();
        ctx.parentIsLatched = true;
        ctx.parent.unpin();
        if (ctx.pidx >= ctx.parent.getNEntries() || ctx.plsn != ctx.parent.getLsn(ctx.pidx) || ctx.dbImpl.isDeferredWriteMode() && ctx.parent.getTarget(ctx.pidx) != null) {
            TestHookExecute.doHookIfSet(this.testHook1);
            ctx.pidx = ctx.parent.findEntry(ctx.pkey, false, true);
            if (ctx.pidx <= 0) {
                ctx.parent.releaseLatch();
                ctx.parentIsLatched = false;
                TestHookExecute.doHookIfSet(this.testHook1);
                this.getFirstIN(ctx, ctx.binKey);
                ctx.pidx = ctx.parent.findEntry(ctx.binKey, false, false);
            }
        } else if (ctx.plsn == ctx.parent.getLsn(ctx.pidx)) {
            ctx.reuseBin = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fetchAndProcessBINs() {
        int nAccLsns = this.lsnAcc.getNTotalEntries();
        int nDeferredLsns = 0;
        DeferredLsnsBatch deferredBatch = null;
        DeferredLsnsBatch nextDeferredBatch = null;
        if (!this.deferredLsns.isEmpty()) {
            deferredBatch = this.deferredLsns.removeFirst();
            nDeferredLsns = deferredBatch.lsns.size();
        }
        long[] lsns = new long[nAccLsns + nDeferredLsns];
        this.addGlobalMemory(lsns.length * 8);
        this.lsnAcc.getLSNs(lsns, 0);
        int nLsns = nAccLsns;
        if (deferredBatch != null) {
            for (Long lsn : deferredBatch.lsns) {
                if (this.debug) {
                    System.out.println("Phase 2." + this.nIterations + " Found deferred LSN: " + lsn);
                }
                lsns[nLsns] = lsn;
                ++nLsns;
            }
        }
        if (this.debug) {
            System.out.println("Phase 2." + this.nIterations + " Num LSNs to read during phase 2a: " + lsns.length);
        }
        Arrays.sort(lsns);
        int nDeltas = this.binDeltas.size();
        Object[] deltaArray = new Object[nDeltas + lsns.length];
        this.addGlobalMemory(deltaArray.length * SIZEOF_JAVA_REF);
        for (int i = 0; i < nDeltas; ++i) {
            deltaArray[i] = this.binDeltas.get(i);
        }
        this.binDeltas.clear();
        this.binDeltas.trimToSize();
        this.addGlobalMemory(-(nDeltas * SIZEOF_JAVA_REF));
        for (long lsn : lsns) {
            boolean isDeferred;
            LogEntry logEntry = this.fetchEntry(lsn, BIN_OR_DELTA);
            Object item = logEntry.getMainItem();
            DatabaseId dbId = logEntry.getDbId();
            DBContext ctx = this.getDbCtx(dbId);
            if (item instanceof OldBINDelta) {
                OldBINDelta o = (OldBINDelta)item;
                deltaArray[nDeltas] = item;
                ++nDeltas;
                this.addGlobalMemory(o.getMemorySize());
                continue;
            }
            BIN bin = (BIN)item;
            bin.setDatabase(ctx.dbImpl);
            if (bin.isBINDelta(false)) {
                this.addGlobalMemory(bin.getInMemorySize());
                int memSize = DiskOrderedScanner.getDeltaMemSize(ctx, lsn);
                boolean bl = isDeferred = deferredBatch != null && deferredBatch.removeLsn(this, lsn, memSize);
                if (this.debug) {
                    System.out.println("Phase 2a." + this.nIterations + " Saving bin delta " + bin.getNodeId() + " fetched via LSN " + lsn);
                }
                deltaArray[nDeltas] = isDeferred ? new DeferredDeltaRef(this, bin) : bin;
                ++nDeltas;
                continue;
            }
            boolean bl = isDeferred = deferredBatch != null && deferredBatch.removeLsn(this, lsn, 0);
            if (this.debug) {
                System.out.println("Phase 2a." + this.nIterations + " Processing full bin " + bin.getNodeId() + " fetched via LSN " + lsn);
            }
            this.processBIN(ctx, bin, isDeferred);
        }
        this.addGlobalMemory(-(lsns.length * 8));
        lsns = null;
        if (deferredBatch != null) {
            deferredBatch.free(this);
            deferredBatch = null;
        }
        if (this.debug) {
            System.out.println("Finished Phase 2a." + this.nIterations + " localMemoryUsage = " + this.localMemoryUsage + " globalMemoryUsage = " + this.globalMemoryUsage);
        }
        if (nDeltas == 0) {
            this.addGlobalMemory(-(deltaArray.length * SIZEOF_JAVA_REF));
            return;
        }
        Arrays.sort(deltaArray, 0, nDeltas, new Comparator<Object>(){

            @Override
            public int compare(Object a, Object b) {
                return DbLsn.compareTo(this.getLsn(a), this.getLsn(b));
            }

            private long getLsn(Object o) {
                if (o instanceof OldBINDelta) {
                    return ((OldBINDelta)o).getLastFullLsn();
                }
                if (o instanceof BIN) {
                    return ((BIN)o).getLastFullLsn();
                }
                if (o instanceof DeferredDeltaRef) {
                    return ((DeferredDeltaRef)o).delta.getLastFullLsn();
                }
                if (o instanceof OffHeapBinRef) {
                    return ((OffHeapBinRef)o).fullBinLsn;
                }
                return ((WeakBinRef)o).fullBinLsn;
            }
        });
        for (int i = 0; i < nDeltas; ++i) {
            BIN fullBin;
            DBContext ctx;
            BIN bin;
            Object ref;
            Loggable delta;
            Object o = deltaArray[i];
            deltaArray[i] = null;
            if (o instanceof OldBINDelta) {
                delta = (OldBINDelta)o;
                DBContext ctx2 = this.getDbCtx(((OldBINDelta)delta).getDbId());
                BIN bin2 = (BIN)this.fetchItem(((OldBINDelta)delta).getLastFullLsn(), BIN_ONLY);
                ((OldBINDelta)delta).reconstituteBIN(ctx2.dbImpl, bin2);
                this.processBINInternal(ctx2, bin2, false);
                this.addGlobalMemory(-((OldBINDelta)delta).getMemorySize());
                continue;
            }
            if (o instanceof BIN || o instanceof DeferredDeltaRef) {
                boolean isDeferred;
                if (o instanceof DeferredDeltaRef) {
                    delta = ((DeferredDeltaRef)o).delta;
                    isDeferred = true;
                    ((DeferredDeltaRef)o).free(this);
                } else {
                    delta = (BIN)o;
                    isDeferred = false;
                }
                assert (((IN)delta).isBINDelta(false));
                DBContext ctx3 = this.getDbCtx(((IN)delta).getDatabaseId());
                BIN fullBin2 = ((BIN)delta).reconstituteBIN(ctx3.dbImpl);
                this.processBINInternal(ctx3, fullBin2, isDeferred);
                this.addGlobalMemory(-((IN)delta).getInMemorySize());
                continue;
            }
            if (o instanceof OffHeapBinRef) {
                ref = (OffHeapBinRef)o;
                bin = this.env.getOffHeapCache().loadBINIfLsnMatches(this.env, ((OffHeapBinRef)ref).ohBinId, ((OffHeapBinRef)ref).binLsn);
                if (bin == null) {
                    nextDeferredBatch = this.addDeferredLsn(nextDeferredBatch, ((OffHeapBinRef)ref).binLsn, ((OffHeapBinRef)ref).memSize);
                    if (this.debug) {
                        System.out.println("Phase 2." + this.nIterations + ": Found stale OffHeapBinRef - Deferring LSN: " + ((OffHeapBinRef)ref).binLsn + " delta mem: " + (DeferredLsnsBatch.LSN_MEM_OVERHEAD + ((OffHeapBinRef)ref).memSize));
                    }
                } else {
                    try {
                        ctx = this.getDbCtx(bin.getDatabaseId());
                        fullBin = bin.isBINDelta() ? bin.reconstituteBIN(ctx.dbImpl) : bin;
                        this.processBINInternal(ctx, fullBin, false);
                    }
                    finally {
                        bin.releaseLatch();
                    }
                }
                this.addGlobalMemory(-SIZEOF_OffHeapBinRef);
                continue;
            }
            assert (o instanceof WeakBinRef);
            ref = (WeakBinRef)o;
            bin = (BIN)((Reference)ref).get();
            if (bin == null) {
                nextDeferredBatch = this.addDeferredLsn(nextDeferredBatch, ((WeakBinRef)ref).binLsn, ((WeakBinRef)ref).memSize);
                if (this.debug) {
                    System.out.println("Phase 2." + this.nIterations + ": Found cleared WeakBinRef - Deferring LSN: " + ((WeakBinRef)ref).binLsn + " delta mem: " + (DeferredLsnsBatch.LSN_MEM_OVERHEAD + ((WeakBinRef)ref).memSize));
                }
            } else {
                ctx = this.getDbCtx(bin.getDatabaseId());
                bin.latch(CacheMode.UNCHANGED);
                try {
                    if (bin.getLastFullLsn() != ((WeakBinRef)ref).fullBinLsn) {
                        nextDeferredBatch = this.addDeferredLsn(nextDeferredBatch, ((WeakBinRef)ref).binLsn, ((WeakBinRef)ref).memSize);
                        if (this.debug) {
                            System.out.println("Phase 2." + this.nIterations + ": Found stale WeakBinRef - Deferring LSN: " + ((WeakBinRef)ref).binLsn);
                        }
                    } else {
                        fullBin = bin.isBINDelta() ? bin.reconstituteBIN(ctx.dbImpl) : bin;
                        this.processBINInternal(ctx, fullBin, false);
                    }
                }
                finally {
                    bin.releaseLatch();
                }
            }
            this.addGlobalMemory(-SIZEOF_WeakBinRef);
        }
        this.addGlobalMemory(-(deltaArray.length * SIZEOF_JAVA_REF));
    }

    private DeferredLsnsBatch addDeferredLsn(DeferredLsnsBatch batch, long lsn, int memSize) {
        if (batch == null) {
            batch = new DeferredLsnsBatch(this);
            this.deferredLsns.addLast(batch);
        }
        if (batch.addLsn(this, lsn, memSize)) {
            batch = new DeferredLsnsBatch(this);
            this.deferredLsns.addLast(batch);
        }
        return batch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processBIN(DBContext ctx, BIN bin, boolean isDeferred) {
        bin.latch(CacheMode.UNCHANGED);
        try {
            this.processBINInternal(ctx, bin, isDeferred);
        }
        finally {
            bin.releaseLatch();
        }
    }

    private void processBINInternal(DBContext ctx, BIN bin, boolean isDeferred) {
        boolean checkBinKeys = !isDeferred && this.isBinProcessedBefore(ctx, bin);
        for (int i = 0; i < bin.getNEntries(); ++i) {
            ctx.binKey = bin.getKey(i);
            if (this.skipSlot(ctx, bin, i, checkBinKeys)) continue;
            byte[] key = ctx.binKey;
            byte[] data = this.keysOnly ? null : bin.getData(i);
            this.processRecord(ctx, key, data, bin.getExpiration(i), bin.isExpirationInHours());
        }
    }

    private void fetchAndProcessLNs() {
        long[] lsns = this.lsnAcc.getAndSortPendingLSNs();
        this.addGlobalMemory(lsns.length * 8);
        for (long lsn : lsns) {
            LNLogEntry entry = (LNLogEntry)this.fetchEntry(lsn, LN_ONLY);
            DBContext ctx = this.getDbCtx(entry.getDbId());
            entry.postFetchInit(ctx.dbImpl);
            LN ln = entry.getMainItem();
            if (ln.isDeleted()) continue;
            this.processRecord(ctx, entry.getKey(), ln.getData(), entry.getExpiration(), entry.isExpirationInHours());
        }
        this.addGlobalMemory(-(lsns.length * 8));
    }

    private DBContext getDbCtx(DatabaseId dbId) {
        int dbIdx = this.dbid2dbidxMap.get(dbId);
        return this.dbs[dbIdx];
    }

    private void processRecord(DBContext ctx, byte[] treeKey, byte[] treeData, int expiration, boolean expirationInHours) {
        byte[] data;
        byte[] key;
        assert (treeKey != null);
        if (this.dupDBs && !this.countOnly) {
            DatabaseEntry keyEntry = new DatabaseEntry();
            DatabaseEntry dataEntry = this.keysOnly ? null : new DatabaseEntry();
            DupKeyData.split(treeKey, treeKey.length, keyEntry, dataEntry);
            key = keyEntry.getData();
            data = this.keysOnly ? null : dataEntry.getData();
        } else {
            key = this.countOnly ? null : treeKey;
            data = this.countOnly || this.keysOnly ? null : treeData;
        }
        this.processor.process(ctx.dbIdx, key, data, expiration, expirationInHours);
        if (ctx.newEndingKey == null || Key.compareKeys(ctx.newEndingKey, treeKey, ctx.dbImpl.getKeyComparator()) < 0) {
            ctx.newEndingKey = treeKey;
        }
    }

    private Object fetchItem(long lsn, LogEntryType[] expectTypes) {
        return this.fetchEntry(lsn, expectTypes).getMainItem();
    }

    private LogEntry fetchEntry(long lsn, LogEntryType[] expectTypes) {
        LogManager logManager = this.env.getLogManager();
        LogEntry entry = logManager.getLogEntryHandleFileNotFound(lsn);
        LogEntryType type = entry.getLogType();
        for (LogEntryType expectType : expectTypes) {
            if (!(expectType.isLNType() ? type.isLNType() : type.equals(expectType))) continue;
            return entry;
        }
        throw EnvironmentFailureException.unexpectedState("Expected: " + Arrays.toString(expectTypes) + " but got: " + type + " LSN=" + DbLsn.getNoFormatString(lsn));
    }

    private static int getDeltaMemSize(DBContext ctx, long lsn) {
        long fileNum = DbLsn.getFileNumber(lsn);
        DbFileSummary summary = ctx.dbFileSummaries.get(fileNum);
        if (summary == null) {
            return 0;
        }
        float avgINSize = (float)summary.totalINSize / (float)summary.totalINCount;
        return (int)(avgINSize * 2.0f);
    }

    private boolean isBinProcessedBefore(DBContext ctx, BIN bin) {
        byte[] firstKey;
        return ctx.prevEndingKey != null && bin.getNEntries() > 0 && Key.compareKeys(firstKey = bin.getKey(0), ctx.prevEndingKey, ctx.dbImpl.getKeyComparator()) <= 0;
    }

    private boolean skipSlot(DBContext ctx, BIN bin, int index, boolean checkBinKeys) {
        if (bin.isDefunct(index)) {
            return true;
        }
        return ctx.prevEndingKey != null && checkBinKeys && Key.compareKeys(ctx.prevEndingKey, ctx.binKey, ctx.dbImpl.getKeyComparator()) >= 0;
    }

    private void getFirstIN(DBContext ctx, byte[] searchKey) {
        Tree tree = ctx.dbImpl.getTree();
        for (int i = 0; i < 25; ++i) {
            BIN bin = searchKey == null ? tree.getFirstNode(CacheMode.UNCHANGED) : tree.search(searchKey, CacheMode.UNCHANGED);
            if (bin == null) {
                ctx.parent = null;
                ctx.done = true;
                return;
            }
            long targetId = bin.getNodeId();
            byte[] targetKey = bin.getIdentifierKey();
            bin.releaseLatch();
            ctx.parentIsLatched = true;
            SearchResult result = tree.getParentINForChildIN(targetId, targetKey, -1, 0, true, true, CacheMode.UNCHANGED, null);
            IN parent = result.parent;
            if (!result.exactParentFound) {
                if (parent != null) {
                    parent.releaseLatch();
                }
            } else {
                ctx.parent = parent;
                ctx.pidx = 0;
                if (ctx.parent == null) {
                    ctx.done = true;
                }
                return;
            }
            ctx.parentIsLatched = false;
        }
        throw EnvironmentFailureException.unexpectedState("Unable to find BIN for key: " + Arrays.toString(searchKey));
    }

    private void getNextIN(DBContext ctx) {
        ctx.parent = ctx.dbImpl.getTree().getNextIN(ctx.parent, true, true, CacheMode.UNCHANGED);
        ctx.pidx = 0;
        if (ctx.parent == null) {
            ctx.done = true;
        }
    }

    public void setTestHook1(TestHook hook) {
        this.testHook1 = hook;
    }

    public void setEvictionHook(TestHook hook) {
        this.evictionHook = hook;
    }

    public void evictBinRefs() {
        if (this.debug) {
            System.out.println("DOS EVICTION HOOK");
        }
        for (Object o : this.binDeltas) {
            if (o instanceof OffHeapBinRef) {
                OffHeapBinRef ohRef = (OffHeapBinRef)o;
                this.env.getOffHeapCache().evictBINIfLsnMatch(this.env, ohRef.ohBinId, ohRef.binLsn);
                continue;
            }
            if (!(o instanceof WeakBinRef)) continue;
            Evictor evictor = this.env.getEvictor();
            WeakBinRef binRef = (WeakBinRef)o;
            BIN bin = (BIN)binRef.get();
            if (bin == null) continue;
            binRef.clear();
            bin.latch();
            if (!bin.getInListResident()) {
                bin.releaseLatch();
                continue;
            }
            long freedBytes = evictor.doTestEvict(bin, Evictor.EvictionSource.MANUAL);
            if (freedBytes != 0L) continue;
            bin.latch();
            evictor.doTestEvict(bin, Evictor.EvictionSource.MANUAL);
        }
    }

    public static class DeferredDeltaRef {
        final BIN delta;

        public DeferredDeltaRef() {
            this.delta = null;
        }

        DeferredDeltaRef(DiskOrderedScanner scanner, BIN delta) {
            this.delta = delta;
            scanner.addGlobalMemory(SIZEOF_DeferredDeltaRef);
        }

        void free(DiskOrderedScanner scanner) {
            scanner.addGlobalMemory(-SIZEOF_DeferredDeltaRef);
        }
    }

    public static class DeferredLsnsBatch {
        static final int LSN_MEM_OVERHEAD = MemoryBudget.HASHSET_ENTRY_OVERHEAD + MemoryBudget.LONG_OVERHEAD;
        final HashSet<Long> lsns = new HashSet();
        long memoryUsage = 0L;

        public DeferredLsnsBatch() {
            this.memoryUsage = 0L;
        }

        DeferredLsnsBatch(DiskOrderedScanner scanner) {
            scanner.addGlobalMemory(SIZEOF_DeferredLsnsBatch);
            this.memoryUsage += (long)SIZEOF_DeferredLsnsBatch;
        }

        void free(DiskOrderedScanner scanner) {
            scanner.addGlobalMemory(-SIZEOF_DeferredLsnsBatch);
            this.memoryUsage -= (long)SIZEOF_DeferredLsnsBatch;
            assert (this.memoryUsage == 0L);
        }

        boolean containsLsn(long lsn) {
            return this.lsns.contains(lsn);
        }

        boolean addLsn(DiskOrderedScanner scanner, long lsn, int memSize) {
            this.lsns.add(lsn);
            int currentMemConsumption = LSN_MEM_OVERHEAD;
            scanner.addGlobalMemory(currentMemConsumption);
            int futureMemConsumption = memSize;
            futureMemConsumption += 8;
            this.memoryUsage += (long)(currentMemConsumption + (futureMemConsumption += SIZEOF_DeferredDeltaRef));
            return scanner.accLimitExceeded(this.memoryUsage, this.lsns.size());
        }

        boolean removeLsn(DiskOrderedScanner scanner, long lsn, int memSize) {
            boolean found = this.lsns.remove(lsn);
            if (found) {
                scanner.addGlobalMemory(-DeferredLsnsBatch.LSN_MEM_OVERHEAD);
                int memDelta = LSN_MEM_OVERHEAD;
                memDelta += memSize;
                memDelta += 8;
                this.memoryUsage -= (long)(memDelta += SIZEOF_DeferredDeltaRef);
            }
            return found;
        }

        void undoLsn(DiskOrderedScanner scanner, long lsn, int memSize) {
            boolean found = this.lsns.remove(lsn);
            assert (found);
            scanner.addGlobalMemory(-DeferredLsnsBatch.LSN_MEM_OVERHEAD);
            int memDelta = LSN_MEM_OVERHEAD;
            memDelta += memSize;
            memDelta += 8;
            this.memoryUsage -= (long)(memDelta += SIZEOF_DeferredDeltaRef);
        }
    }

    public static class OffHeapBinRef {
        final int ohBinId;
        final long binLsn;
        final long fullBinLsn;
        final int memSize;

        public OffHeapBinRef() {
            this.ohBinId = 0;
            this.binLsn = 0L;
            this.fullBinLsn = 0L;
            this.memSize = 0;
        }

        OffHeapBinRef(DiskOrderedScanner scanner, DBContext ctx, long binLsn, long fullBinLsn, int ohBinId) {
            this.ohBinId = ohBinId;
            this.binLsn = binLsn;
            this.fullBinLsn = fullBinLsn;
            this.memSize = DiskOrderedScanner.getDeltaMemSize(ctx, binLsn);
        }
    }

    public static class WeakBinRef
    extends WeakReference<BIN> {
        final long binLsn;
        final long fullBinLsn;
        final int memSize;

        public WeakBinRef() {
            super(null);
            this.binLsn = 0L;
            this.fullBinLsn = 0L;
            this.memSize = 0;
        }

        WeakBinRef(DiskOrderedScanner scanner, DBContext ctx, long lsn, BIN delta) {
            super(delta);
            this.binLsn = lsn;
            this.fullBinLsn = delta.getLastFullLsn();
            assert (lsn != delta.getLastFullLsn());
            this.memSize = lsn != delta.getLastFullLsn() ? DiskOrderedScanner.getDeltaMemSize(ctx, lsn) : 0;
        }
    }

    private static class DBContext {
        final int dbIdx;
        final DatabaseImpl dbImpl;
        final Map<Long, DbFileSummary> dbFileSummaries;
        boolean done = false;
        byte[] prevEndingKey = null;
        byte[] newEndingKey = null;
        long lastBinLsn = -1L;
        boolean safeToUseCachedDelta = false;
        IN parent = null;
        boolean parentIsLatched;
        int pidx = 0;
        long plsn;
        byte[] pkey;
        boolean checkLevel2Keys = true;
        byte[] binKey;
        boolean reuseBin = false;

        DBContext(int dbIdx, DatabaseImpl db) {
            this.dbIdx = dbIdx;
            this.dbImpl = db;
            this.dbFileSummaries = this.dbImpl.cloneDbFileSummaries();
        }
    }

    static interface RecordProcessor {
        public void process(int var1, byte[] var2, byte[] var3, int var4, boolean var5);

        public boolean canProcessWithoutBlocking(int var1);

        public int getCapacity();

        public void checkShutdown();
    }
}

