/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je;

import com.sleepycat.je.CacheMode;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.SecondaryAssociation;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.trigger.ReplicatedDatabaseTrigger;
import com.sleepycat.je.trigger.Trigger;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;

public class DatabaseConfig
implements Cloneable {
    public static final DatabaseConfig DEFAULT = new DatabaseConfig();
    private boolean allowCreate = false;
    private boolean exclusiveCreate = false;
    private boolean transactional = false;
    private boolean readOnly = false;
    private boolean sortedDuplicates = false;
    private boolean deferredWrite = false;
    private boolean temporary = false;
    private boolean keyPrefixing = false;
    private boolean replicated = true;
    private int nodeMaxEntries;
    private Comparator<byte[]> btreeComparator = null;
    private Comparator<byte[]> duplicateComparator = null;
    private boolean btreeComparatorByClassName = false;
    private boolean duplicateComparatorByClassName = false;
    private boolean overrideBtreeComparator = false;
    private boolean overrideDuplicateComparator = false;
    private boolean useExistingConfig = false;
    private CacheMode cacheMode = null;
    private SecondaryAssociation secAssociation = null;
    private List<Trigger> triggers = new LinkedList<Trigger>();
    private boolean overrideTriggers;

    public DatabaseConfig setAllowCreate(boolean allowCreate) {
        this.setAllowCreateVoid(allowCreate);
        return this;
    }

    public void setAllowCreateVoid(boolean allowCreate) {
        this.allowCreate = allowCreate;
    }

    public boolean getAllowCreate() {
        return this.allowCreate;
    }

    public DatabaseConfig setExclusiveCreate(boolean exclusiveCreate) {
        this.setExclusiveCreateVoid(exclusiveCreate);
        return this;
    }

    public void setExclusiveCreateVoid(boolean exclusiveCreate) {
        this.exclusiveCreate = exclusiveCreate;
    }

    public boolean getExclusiveCreate() {
        return this.exclusiveCreate;
    }

    public DatabaseConfig setSortedDuplicates(boolean sortedDuplicates) {
        this.setSortedDuplicatesVoid(sortedDuplicates);
        return this;
    }

    public void setSortedDuplicatesVoid(boolean sortedDuplicates) {
        this.sortedDuplicates = sortedDuplicates;
        if (sortedDuplicates) {
            this.setKeyPrefixingVoid(true);
        }
    }

    public boolean getSortedDuplicates() {
        return this.sortedDuplicates;
    }

    public boolean getKeyPrefixing() {
        return this.keyPrefixing;
    }

    public DatabaseConfig setKeyPrefixing(boolean keyPrefixing) {
        this.setKeyPrefixingVoid(keyPrefixing);
        return this;
    }

    public void setKeyPrefixingVoid(boolean keyPrefixing) {
        if (!keyPrefixing && this.sortedDuplicates) {
            throw new IllegalStateException("Key prefixing is mandatory for databases with duplicates");
        }
        this.keyPrefixing = keyPrefixing;
    }

    public DatabaseConfig setTransactional(boolean transactional) {
        this.setTransactionalVoid(transactional);
        return this;
    }

    public void setTransactionalVoid(boolean transactional) {
        this.transactional = transactional;
    }

    public boolean getTransactional() {
        return this.transactional;
    }

    public DatabaseConfig setReadOnly(boolean readOnly) {
        this.setReadOnlyVoid(readOnly);
        return this;
    }

    public void setReadOnlyVoid(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public boolean getReadOnly() {
        return this.readOnly;
    }

    public DatabaseConfig setNodeMaxEntries(int nodeMaxEntries) {
        this.setNodeMaxEntriesVoid(nodeMaxEntries);
        return this;
    }

    public void setNodeMaxEntriesVoid(int nodeMaxEntries) {
        this.nodeMaxEntries = nodeMaxEntries;
    }

    public DatabaseConfig setNodeMaxDupTreeEntries(int nodeMaxDupTreeEntries) {
        return this;
    }

    public void setNodeMaxDupTreeEntriesVoid(int nodeMaxDupTreeEntries) {
    }

    public int getNodeMaxEntries() {
        return this.nodeMaxEntries;
    }

    public int getNodeMaxDupTreeEntries() {
        return 0;
    }

    public DatabaseConfig setBtreeComparator(Comparator<byte[]> btreeComparator) {
        this.setBtreeComparatorVoid(btreeComparator);
        return this;
    }

    public void setBtreeComparatorVoid(Comparator<byte[]> btreeComparator) {
        this.btreeComparator = this.validateComparator(btreeComparator, "Btree");
        this.btreeComparatorByClassName = false;
    }

    public DatabaseConfig setBtreeComparator(Class<? extends Comparator<byte[]>> btreeComparatorClass) {
        this.setBtreeComparatorVoid(btreeComparatorClass);
        return this;
    }

    public void setBtreeComparatorVoid(Class<? extends Comparator<byte[]>> btreeComparatorClass) {
        this.btreeComparator = this.validateComparator(btreeComparatorClass, "Btree");
        this.btreeComparatorByClassName = true;
    }

    public Comparator<byte[]> getBtreeComparator() {
        return this.btreeComparator;
    }

    public boolean getBtreeComparatorByClassName() {
        return this.btreeComparatorByClassName;
    }

    public DatabaseConfig setOverrideBtreeComparator(boolean override) {
        this.setOverrideBtreeComparatorVoid(override);
        return this;
    }

    public void setOverrideBtreeComparatorVoid(boolean override) {
        this.overrideBtreeComparator = override;
    }

    public boolean getOverrideBtreeComparator() {
        return this.overrideBtreeComparator;
    }

    public DatabaseConfig setDuplicateComparator(Comparator<byte[]> duplicateComparator) {
        this.setDuplicateComparatorVoid(duplicateComparator);
        return this;
    }

    public void setDuplicateComparatorVoid(Comparator<byte[]> duplicateComparator) {
        this.duplicateComparator = this.validateComparator(duplicateComparator, "Duplicate");
        this.duplicateComparatorByClassName = false;
    }

    public DatabaseConfig setDuplicateComparator(Class<? extends Comparator<byte[]>> duplicateComparatorClass) {
        this.setDuplicateComparatorVoid(duplicateComparatorClass);
        return this;
    }

    public void setDuplicateComparatorVoid(Class<? extends Comparator<byte[]>> duplicateComparatorClass) {
        this.duplicateComparator = this.validateComparator(duplicateComparatorClass, "Duplicate");
        this.duplicateComparatorByClassName = true;
    }

    public Comparator<byte[]> getDuplicateComparator() {
        return this.duplicateComparator;
    }

    public boolean getDuplicateComparatorByClassName() {
        return this.duplicateComparatorByClassName;
    }

    public DatabaseConfig setOverrideDuplicateComparator(boolean override) {
        this.setOverrideDuplicateComparatorVoid(override);
        return this;
    }

    public void setOverrideDuplicateComparatorVoid(boolean override) {
        this.overrideDuplicateComparator = override;
    }

    public boolean getOverrideDuplicateComparator() {
        return this.overrideDuplicateComparator;
    }

    public DatabaseConfig setTriggers(List<Trigger> triggers) {
        this.setTriggersVoid(triggers);
        return this;
    }

    public void setTriggersVoid(List<Trigger> triggers) {
        this.triggers = triggers;
        if (triggers == null || triggers.size() == 0) {
            return;
        }
        this.checkTriggers(triggers);
    }

    public List<Trigger> getTriggers() {
        return this.triggers;
    }

    public DatabaseConfig setOverrideTriggers(boolean override) {
        this.setOverrideTriggersVoid(override);
        return this;
    }

    public void setOverrideTriggersVoid(boolean override) {
        this.overrideTriggers = override;
    }

    public boolean getOverrideTriggers() {
        return this.overrideTriggers;
    }

    public DatabaseConfig setTemporary(boolean temporary) {
        this.setTemporaryVoid(temporary);
        return this;
    }

    public void setTemporaryVoid(boolean temporary) {
        this.temporary = temporary;
    }

    public boolean getTemporary() {
        return this.temporary;
    }

    public DatabaseConfig setDeferredWrite(boolean deferredWrite) {
        this.setDeferredWriteVoid(deferredWrite);
        return this;
    }

    public void setDeferredWriteVoid(boolean deferredWrite) {
        this.deferredWrite = deferredWrite;
    }

    public boolean getDeferredWrite() {
        return this.deferredWrite;
    }

    void setBtreeComparatorInternal(Comparator<byte[]> comparator, boolean byClassName) {
        this.btreeComparator = comparator;
        this.btreeComparatorByClassName = byClassName;
    }

    void setDuplicateComparatorInternal(Comparator<byte[]> comparator, boolean byClassName) {
        this.duplicateComparator = comparator;
        this.duplicateComparatorByClassName = byClassName;
    }

    public DatabaseConfig setUseExistingConfig(boolean useExistingConfig) {
        this.setUseExistingConfigVoid(useExistingConfig);
        return this;
    }

    public void setUseExistingConfigVoid(boolean useExistingConfig) {
        this.useExistingConfig = useExistingConfig;
    }

    public boolean getUseExistingConfig() {
        return this.useExistingConfig;
    }

    public DatabaseConfig setCacheMode(CacheMode cacheMode) {
        this.setCacheModeVoid(cacheMode);
        return this;
    }

    public void setCacheModeVoid(CacheMode cacheMode) {
        this.cacheMode = cacheMode;
    }

    public CacheMode getCacheMode() {
        return this.cacheMode;
    }

    public DatabaseConfig setReplicated(boolean replicated) {
        this.setReplicatedVoid(replicated);
        return this;
    }

    public void setReplicatedVoid(boolean replicated) {
        this.replicated = replicated;
    }

    public boolean getReplicated() {
        return this.replicated;
    }

    public DatabaseConfig setSecondaryAssociation(SecondaryAssociation association) {
        this.setSecondaryAssociationVoid(association);
        return this;
    }

    public void setSecondaryAssociationVoid(SecondaryAssociation association) {
        this.secAssociation = association;
    }

    public SecondaryAssociation getSecondaryAssociation() {
        return this.secAssociation;
    }

    public DatabaseConfig cloneConfig() {
        return this.clone();
    }

    public DatabaseConfig clone() {
        try {
            return (DatabaseConfig)super.clone();
        }
        catch (CloneNotSupportedException willNeverOccur) {
            return null;
        }
    }

    void validate(DatabaseConfig config) throws DatabaseException {
        if (config == null) {
            config = DEFAULT;
        }
        boolean txnMatch = config.transactional == this.transactional;
        boolean roMatch = config.readOnly == this.readOnly;
        boolean sdMatch = config.sortedDuplicates == this.sortedDuplicates;
        boolean dwMatch = config.getDeferredWrite() == this.deferredWrite;
        boolean btCmpMatch = true;
        if (config.overrideBtreeComparator) {
            btCmpMatch = this.btreeComparator == null ? config.btreeComparator == null : (config.btreeComparatorByClassName != this.btreeComparatorByClassName ? false : (this.btreeComparatorByClassName ? this.btreeComparator.getClass() == config.btreeComparator.getClass() : Arrays.equals(DatabaseImpl.objectToBytes(this.btreeComparator, "Btree"), DatabaseImpl.objectToBytes(config.btreeComparator, "Btree"))));
        }
        boolean dtCmpMatch = true;
        if (config.overrideDuplicateComparator) {
            dtCmpMatch = this.duplicateComparator == null ? config.duplicateComparator == null : (config.duplicateComparatorByClassName != this.duplicateComparatorByClassName ? false : (this.duplicateComparatorByClassName ? this.duplicateComparator.getClass() == config.duplicateComparator.getClass() : Arrays.equals(DatabaseImpl.objectToBytes(this.duplicateComparator, "Duplicate"), DatabaseImpl.objectToBytes(config.duplicateComparator, "Duplicate"))));
        }
        if (txnMatch && roMatch && sdMatch && dwMatch && btCmpMatch && dtCmpMatch) {
            return;
        }
        String message = this.genDatabaseConfigMismatchMessage(txnMatch, roMatch, sdMatch, dwMatch, btCmpMatch, dtCmpMatch);
        throw new IllegalArgumentException(message);
    }

    private String genDatabaseConfigMismatchMessage(boolean txnMatch, boolean roMatch, boolean sdMatch, boolean dwMatch, boolean btCmpMatch, boolean dtCmpMatch) {
        StringBuilder ret = new StringBuilder("The following DatabaseConfig parameters for the\ncached Database do not match the parameters for the\nrequested Database:\n");
        if (!txnMatch) {
            ret.append(" Transactional\n");
        }
        if (!roMatch) {
            ret.append(" Read-Only\n");
        }
        if (!sdMatch) {
            ret.append(" Sorted Duplicates\n");
        }
        if (!dwMatch) {
            ret.append(" Deferred Write");
        }
        if (!btCmpMatch) {
            ret.append(" Btree Comparator\n");
        }
        if (!dtCmpMatch) {
            ret.append(" Duplicate Comparator\n");
        }
        return ret.toString();
    }

    private Comparator<byte[]> validateComparator(Comparator<byte[]> comparator, String type) throws IllegalArgumentException {
        if (comparator == null) {
            return null;
        }
        try {
            DatabaseImpl.comparatorToBytes(comparator, false, type);
            return comparator;
        }
        catch (DatabaseException e) {
            throw new IllegalArgumentException(type + " comparator is not valid.", e);
        }
    }

    private Comparator<byte[]> validateComparator(Class<? extends Comparator<byte[]>> comparatorClass, String type) throws IllegalArgumentException {
        if (comparatorClass == null) {
            return null;
        }
        if (!Comparator.class.isAssignableFrom(comparatorClass)) {
            throw new IllegalArgumentException(comparatorClass.getName() + " is is not valid as a " + type + " comparator because it does not  implement java.util.Comparator.");
        }
        try {
            return DatabaseImpl.instantiateComparator(comparatorClass, type);
        }
        catch (DatabaseException e) {
            throw new IllegalArgumentException(type + " comparator is not valid. Perhaps you have not implemented a zero-parameter constructor for the comparator or the comparator class cannot be found.", e);
        }
    }

    void validateForNewDb() throws DatabaseException {
        if (this.readOnly) {
            throw new IllegalArgumentException("DatabaseConfig.setReadOnly() must be set to false when creating a Database");
        }
        if (this.transactional && this.deferredWrite) {
            throw new IllegalArgumentException("deferredWrite mode is not supported for transactional databases");
        }
    }

    boolean persistentEquals(DatabaseConfig other) {
        if (this.sortedDuplicates != other.sortedDuplicates) {
            return false;
        }
        if (this.temporary != other.temporary) {
            return false;
        }
        if (this.replicated != other.replicated) {
            return false;
        }
        if (this.nodeMaxEntries != other.nodeMaxEntries) {
            return false;
        }
        if (this.btreeComparator == null && other.btreeComparator != null || this.btreeComparator != null && other.btreeComparator == null) {
            return false;
        }
        if (this.btreeComparator != null && this.btreeComparator.getClass() != other.btreeComparator.getClass()) {
            return false;
        }
        if (this.duplicateComparator == null && other.duplicateComparator != null || this.duplicateComparator != null && other.duplicateComparator == null) {
            return false;
        }
        return this.duplicateComparator == null || this.duplicateComparator.getClass() == other.duplicateComparator.getClass();
    }

    void validateOnDbOpen(String databaseName, boolean dbIsReplicated) {
        if (this.getDeferredWrite() && this.getTemporary() || this.getDeferredWrite() && this.getTransactional() || this.getTemporary() && this.getTransactional()) {
            throw new IllegalArgumentException("Attempted to open Database " + databaseName + " and two ore more of the following exclusive properties are true: deferredWrite, temporary, transactional");
        }
        if (this.triggers != null && this.triggers.size() > 0) {
            boolean replicatedTriggers = this.checkTriggers(this.triggers);
            if (dbIsReplicated && !replicatedTriggers) {
                throw new IllegalArgumentException("For a replicated Database, triggers must implement " + ReplicatedDatabaseTrigger.class.getName());
            }
        }
    }

    boolean checkTriggers(List<Trigger> triggerList) {
        boolean replicatedTrigger = triggerList.get(0) instanceof ReplicatedDatabaseTrigger;
        HashSet<String> triggerNames = new HashSet<String>();
        for (Trigger trigger : triggerList) {
            if (!triggerNames.add(trigger.getName())) {
                throw new IllegalArgumentException("Duplicate trigger name:" + trigger.getName());
            }
            if (replicatedTrigger == trigger instanceof ReplicatedDatabaseTrigger) continue;
            throw new IllegalArgumentException("Conflicting trigger types in list:" + triggerList);
        }
        return replicatedTrigger;
    }

    static DatabaseConfig combineConfig(DatabaseImpl dbImpl, DatabaseConfig dbHandleConfig) {
        DatabaseConfig showConfig = dbHandleConfig.cloneConfig();
        if (dbImpl != null) {
            showConfig.setBtreeComparatorInternal(dbImpl.getBtreeComparator(), dbImpl.getBtreeComparatorByClass());
            showConfig.setDuplicateComparatorInternal(dbImpl.getDuplicateComparator(), dbImpl.getDuplicateComparatorByClass());
            showConfig.setKeyPrefixing(dbImpl.getKeyPrefixing());
            showConfig.setNodeMaxEntries(dbImpl.getNodeMaxTreeEntries());
            showConfig.setTriggers(dbImpl.getTriggers());
            showConfig.setTransactional(dbImpl.isTransactional());
            showConfig.setDeferredWrite(dbImpl.isDurableDeferredWrite());
            showConfig.setReplicated(dbImpl.isReplicated());
            showConfig.setSortedDuplicates(dbImpl.getSortedDuplicates());
            showConfig.setTemporary(dbImpl.isTemporary());
        }
        return showConfig;
    }

    public String toString() {
        return "allowCreate=" + this.allowCreate + "\nexclusiveCreate=" + this.exclusiveCreate + "\ntransactional=" + this.transactional + "\nreadOnly=" + this.readOnly + "\nsortedDuplicates=" + this.sortedDuplicates + "\ndeferredWrite=" + this.deferredWrite + "\ntemporary=" + this.temporary + "\nkeyPrefixing=" + this.keyPrefixing + "\n";
    }
}

