/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je;

import com.sleepycat.je.CacheMode;
import com.sleepycat.je.CursorConfig;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DbInternal;
import com.sleepycat.je.DiskLimitException;
import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.ForwardCursor;
import com.sleepycat.je.Get;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationResult;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.Put;
import com.sleepycat.je.ReadOptions;
import com.sleepycat.je.SecondaryAssociation;
import com.sleepycat.je.SecondaryDatabase;
import com.sleepycat.je.ThreadInterruptedException;
import com.sleepycat.je.Transaction;
import com.sleepycat.je.WriteOptions;
import com.sleepycat.je.dbi.CursorImpl;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.DupKeyData;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.dbi.ExpirationInfo;
import com.sleepycat.je.dbi.GetMode;
import com.sleepycat.je.dbi.PutMode;
import com.sleepycat.je.dbi.RangeConstraint;
import com.sleepycat.je.dbi.RangeRestartException;
import com.sleepycat.je.dbi.SearchMode;
import com.sleepycat.je.dbi.TTL;
import com.sleepycat.je.dbi.TriggerManager;
import com.sleepycat.je.latch.LatchSupport;
import com.sleepycat.je.log.LogUtils;
import com.sleepycat.je.log.ReplicationContext;
import com.sleepycat.je.tree.BIN;
import com.sleepycat.je.tree.Key;
import com.sleepycat.je.tree.LN;
import com.sleepycat.je.txn.BuddyLocker;
import com.sleepycat.je.txn.LockType;
import com.sleepycat.je.txn.Locker;
import com.sleepycat.je.txn.LockerFactory;
import com.sleepycat.je.utilint.DatabaseUtil;
import com.sleepycat.je.utilint.LoggerUtils;
import java.util.Collection;
import java.util.Comparator;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Cursor
implements ForwardCursor {
    static final ReadOptions DEFAULT_READ_OPTIONS = new ReadOptions();
    static final WriteOptions DEFAULT_WRITE_OPTIONS = new WriteOptions();
    private static final DatabaseEntry EMPTY_DUP_DATA = new DatabaseEntry(new byte[0]);
    static final DatabaseEntry NO_RETURN_DATA = new DatabaseEntry();
    CursorConfig config;
    private Transaction transaction;
    private Database dbHandle;
    private DatabaseImpl dbImpl;
    CursorImpl cursorImpl;
    private boolean updateOperationsProhibited;
    private boolean readUncommittedDefault;
    private boolean serializableIsolationDefault;
    private boolean nonSticky = false;
    private CacheMode defaultCacheMode;
    private RangeConstraint rangeConstraint;
    private Logger logger;

    Cursor(Database dbHandle, Transaction txn, CursorConfig cursorConfig) {
        if (cursorConfig == null) {
            cursorConfig = CursorConfig.DEFAULT;
        }
        DatabaseImpl dbImpl = dbHandle.checkOpen();
        Locker locker = LockerFactory.getReadableLocker(dbHandle, txn, cursorConfig.getReadCommitted());
        this.init(dbHandle, dbImpl, locker, cursorConfig, false);
    }

    Cursor(Database dbHandle, Locker locker, CursorConfig cursorConfig) {
        if (cursorConfig == null) {
            cursorConfig = CursorConfig.DEFAULT;
        }
        DatabaseImpl dbImpl = dbHandle.checkOpen();
        locker = LockerFactory.getReadableLocker(dbHandle, locker, cursorConfig.getReadCommitted());
        this.init(dbHandle, dbImpl, locker, cursorConfig, false);
    }

    Cursor(Database dbHandle, Locker locker, CursorConfig cursorConfig, boolean retainNonTxnLocks) {
        if (cursorConfig == null) {
            cursorConfig = CursorConfig.DEFAULT;
        }
        DatabaseImpl dbImpl = dbHandle.checkOpen();
        this.init(dbHandle, dbImpl, locker, cursorConfig, retainNonTxnLocks);
    }

    Cursor(DatabaseImpl databaseImpl, Locker locker, CursorConfig cursorConfig, boolean retainNonTxnLocks) {
        if (cursorConfig == null) {
            cursorConfig = CursorConfig.DEFAULT;
        }
        if (this.dbHandle != null) {
            this.dbHandle.checkOpen();
        }
        this.init(null, databaseImpl, locker, cursorConfig, retainNonTxnLocks);
    }

    private void init(Database dbHandle, DatabaseImpl databaseImpl, Locker locker, CursorConfig cursorConfig, boolean retainNonTxnLocks) {
        assert (locker != null);
        try {
            locker.openCursorHook(databaseImpl);
        }
        catch (RuntimeException e) {
            locker.operationEnd();
            throw e;
        }
        this.cursorImpl = new CursorImpl(databaseImpl, locker, retainNonTxnLocks, this.isSecondaryCursor());
        this.transaction = locker.getTransaction();
        this.cursorImpl.setAllowEviction(true);
        this.readUncommittedDefault = cursorConfig.getReadUncommitted() || locker.isReadUncommittedDefault();
        this.serializableIsolationDefault = this.cursorImpl.getLocker().isSerializableIsolation();
        this.updateOperationsProhibited = locker.isReadOnly() || dbHandle != null && !dbHandle.isWritable() || databaseImpl.isTransactional() && !locker.isTransactional() || databaseImpl.isReplicated() == locker.isLocalWrite();
        this.dbImpl = databaseImpl;
        if (dbHandle != null) {
            this.dbHandle = dbHandle;
            dbHandle.addCursor(this);
        }
        this.config = cursorConfig;
        this.logger = databaseImpl.getEnv().getLogger();
        this.nonSticky = cursorConfig.getNonSticky();
        this.setCacheMode(null);
    }

    Cursor(Cursor cursor, boolean samePosition) {
        this.readUncommittedDefault = cursor.readUncommittedDefault;
        this.serializableIsolationDefault = cursor.serializableIsolationDefault;
        this.updateOperationsProhibited = cursor.updateOperationsProhibited;
        this.cursorImpl = cursor.cursorImpl.cloneCursor(samePosition);
        this.dbImpl = cursor.dbImpl;
        this.dbHandle = cursor.dbHandle;
        if (this.dbHandle != null) {
            this.dbHandle.addCursor(this);
        }
        this.config = cursor.config;
        this.logger = this.dbImpl.getEnv().getLogger();
        this.defaultCacheMode = cursor.defaultCacheMode;
        this.nonSticky = cursor.nonSticky;
    }

    boolean isSecondaryCursor() {
        return false;
    }

    void setNonSticky(boolean nonSticky) {
        this.nonSticky = nonSticky;
    }

    CursorImpl getCursorImpl() {
        return this.cursorImpl;
    }

    @Override
    public Database getDatabase() {
        return this.dbHandle;
    }

    DatabaseImpl getDatabaseImpl() {
        return this.dbImpl;
    }

    public CursorConfig getConfig() {
        try {
            return this.config.clone();
        }
        catch (Error E) {
            this.dbImpl.getEnv().invalidate(E);
            throw E;
        }
    }

    public CacheMode getCacheMode() {
        return this.defaultCacheMode;
    }

    public void setCacheMode(CacheMode cacheMode) {
        this.defaultCacheMode = cacheMode != null ? cacheMode : this.dbImpl.getDefaultCacheMode();
    }

    public void setRangeConstraint(RangeConstraint rangeConstraint) {
        if (this.dbImpl.getSortedDuplicates()) {
            throw new UnsupportedOperationException("Not allowed with dups");
        }
        this.rangeConstraint = rangeConstraint;
    }

    private void setPrefixConstraint(Cursor c, final byte[] keyBytes2) {
        c.rangeConstraint = new RangeConstraint(){

            @Override
            public boolean inBounds(byte[] checkKey) {
                return DupKeyData.compareMainKey(checkKey, keyBytes2, Cursor.this.dbImpl.getBtreeComparator()) == 0;
            }
        };
    }

    private void setPrefixConstraint(Cursor c, final DatabaseEntry key2) {
        c.rangeConstraint = new RangeConstraint(){

            @Override
            public boolean inBounds(byte[] checkKey) {
                return DupKeyData.compareMainKey(checkKey, key2.getData(), key2.getOffset(), key2.getSize(), Cursor.this.dbImpl.getBtreeComparator()) == 0;
            }
        };
    }

    private boolean checkRangeConstraint(DatabaseEntry key) {
        assert (key.getOffset() == 0);
        assert (key.getData().length == key.getSize());
        if (this.rangeConstraint == null) {
            return true;
        }
        return this.rangeConstraint.inBounds(key.getData());
    }

    @Override
    public void close() {
        try {
            if (this.cursorImpl.isClosed()) {
                return;
            }
            this.checkEnv();
            this.cursorImpl.close();
            if (this.dbHandle != null) {
                this.dbHandle.removeCursor(this);
                this.dbHandle = null;
            }
        }
        catch (Error E) {
            this.dbImpl.getEnv().invalidate(E);
            throw E;
        }
    }

    public Cursor dup(boolean samePosition) {
        try {
            this.checkOpenAndState(false);
            return new Cursor(this, samePosition);
        }
        catch (Error E) {
            this.dbImpl.getEnv().invalidate(E);
            throw E;
        }
    }

    public OperationResult delete(WriteOptions options) {
        this.checkOpenAndState(true);
        this.trace(Level.FINEST, "Cursor.delete: ", null);
        CacheMode cacheMode = options != null ? options.getCacheMode() : null;
        return this.deleteInternal(this.dbImpl.getRepContext(), cacheMode);
    }

    public OperationStatus delete() {
        OperationResult result = this.delete(null);
        return result == null ? OperationStatus.KEYEMPTY : OperationStatus.SUCCESS;
    }

    public OperationResult put(DatabaseEntry key, DatabaseEntry data, Put putType, WriteOptions options) {
        try {
            this.checkOpen();
            this.trace(Level.FINEST, "Cursor.put: ", String.valueOf((Object)putType), key, data, null);
            return this.putInternal(key, data, putType, options);
        }
        catch (Error E) {
            this.dbImpl.getEnv().invalidate(E);
            throw E;
        }
    }

    OperationResult putInternal(DatabaseEntry key, DatabaseEntry data, Put putType, WriteOptions options) {
        DatabaseUtil.checkForNullParam((Object)putType, "putType");
        if (putType == Put.CURRENT) {
            if (key != null) {
                throw new IllegalArgumentException("The key must be null for Put.Current");
            }
        } else {
            DatabaseUtil.checkForNullDbt(key, "key", true);
        }
        if (key != null) {
            DatabaseUtil.checkForPartial(key, "key");
        }
        DatabaseUtil.checkForNullDbt(data, "data", true);
        this.checkState(putType == Put.CURRENT);
        if (options == null) {
            options = DEFAULT_WRITE_OPTIONS;
        }
        return this.putInternal(key, data, options.getCacheMode(), ExpirationInfo.getInfo(options), putType.getPutMode());
    }

    public OperationStatus put(DatabaseEntry key, DatabaseEntry data) {
        OperationResult result = this.put(key, data, Put.OVERWRITE, null);
        EnvironmentFailureException.assertState(result != null);
        return OperationStatus.SUCCESS;
    }

    public OperationStatus putNoOverwrite(DatabaseEntry key, DatabaseEntry data) {
        OperationResult result = this.put(key, data, Put.NO_OVERWRITE, null);
        return result == null ? OperationStatus.KEYEXIST : OperationStatus.SUCCESS;
    }

    public OperationStatus putNoDupData(DatabaseEntry key, DatabaseEntry data) {
        OperationResult result = this.put(key, data, Put.NO_DUP_DATA, null);
        return result == null ? OperationStatus.KEYEXIST : OperationStatus.SUCCESS;
    }

    public OperationStatus putCurrent(DatabaseEntry data) {
        OperationResult result = this.put(null, data, Put.CURRENT, null);
        return result == null ? OperationStatus.KEYEMPTY : OperationStatus.SUCCESS;
    }

    @Override
    public OperationResult get(DatabaseEntry key, DatabaseEntry data, Get getType, ReadOptions options) {
        try {
            this.checkOpen();
            if (options == null) {
                options = DEFAULT_READ_OPTIONS;
            }
            LockMode lockMode = options.getLockMode();
            this.trace(Level.FINEST, "Cursor.get: ", String.valueOf((Object)getType), key, data, lockMode);
            return this.getInternal(key, data, getType, options, lockMode);
        }
        catch (Error E) {
            this.dbImpl.getEnv().invalidate(E);
            throw E;
        }
    }

    OperationResult getInternal(DatabaseEntry key, DatabaseEntry data, Get getType, ReadOptions options, LockMode lockMode) {
        DatabaseUtil.checkForNullParam((Object)getType, "getType");
        CacheMode cacheMode = options.getCacheMode();
        SearchMode searchMode = getType.getSearchMode();
        if (searchMode != null) {
            this.checkState(false);
            DatabaseUtil.checkForNullDbt(key, "key", true);
            DatabaseUtil.checkForPartial(key, "key");
            if (searchMode.isDataSearch()) {
                DatabaseUtil.checkForNullDbt(data, "data", true);
                DatabaseUtil.checkForPartial(data, "data");
            } else if (data == null) {
                data = NO_RETURN_DATA;
            }
            return this.search(key, data, lockMode, cacheMode, searchMode, true);
        }
        if (key == null) {
            key = NO_RETURN_DATA;
        }
        if (data == null) {
            data = NO_RETURN_DATA;
        }
        GetMode getMode = getType.getGetMode();
        if (getType.getAllowNextPrevUninitialized() && this.cursorImpl.isNotInitialized()) {
            assert (getMode != null);
            getType = getMode.isForward() ? Get.FIRST : Get.LAST;
            getMode = null;
        }
        if (getMode != null) {
            this.checkState(true);
            return this.retrieveNext(key, data, lockMode, cacheMode, getMode);
        }
        if (getType == Get.CURRENT) {
            this.checkState(true);
            return this.getCurrentInternal(key, data, lockMode, cacheMode);
        }
        assert (getType == Get.FIRST || getType == Get.LAST);
        this.checkState(false);
        return this.position(key, data, lockMode, cacheMode, getType == Get.FIRST);
    }

    @Override
    public OperationStatus getCurrent(DatabaseEntry key, DatabaseEntry data, LockMode lockMode) {
        OperationResult result = this.get(key, data, Get.CURRENT, DbInternal.getReadOptions(lockMode));
        return result == null ? OperationStatus.KEYEMPTY : OperationStatus.SUCCESS;
    }

    public OperationStatus getFirst(DatabaseEntry key, DatabaseEntry data, LockMode lockMode) {
        OperationResult result = this.get(key, data, Get.FIRST, DbInternal.getReadOptions(lockMode));
        return result == null ? OperationStatus.NOTFOUND : OperationStatus.SUCCESS;
    }

    public OperationStatus getLast(DatabaseEntry key, DatabaseEntry data, LockMode lockMode) {
        OperationResult result = this.get(key, data, Get.LAST, DbInternal.getReadOptions(lockMode));
        return result == null ? OperationStatus.NOTFOUND : OperationStatus.SUCCESS;
    }

    @Override
    public OperationStatus getNext(DatabaseEntry key, DatabaseEntry data, LockMode lockMode) {
        OperationResult result = this.get(key, data, Get.NEXT, DbInternal.getReadOptions(lockMode));
        return result == null ? OperationStatus.NOTFOUND : OperationStatus.SUCCESS;
    }

    public OperationStatus getNextDup(DatabaseEntry key, DatabaseEntry data, LockMode lockMode) {
        OperationResult result = this.get(key, data, Get.NEXT_DUP, DbInternal.getReadOptions(lockMode));
        return result == null ? OperationStatus.NOTFOUND : OperationStatus.SUCCESS;
    }

    public OperationStatus getNextNoDup(DatabaseEntry key, DatabaseEntry data, LockMode lockMode) {
        OperationResult result = this.get(key, data, Get.NEXT_NO_DUP, DbInternal.getReadOptions(lockMode));
        return result == null ? OperationStatus.NOTFOUND : OperationStatus.SUCCESS;
    }

    public OperationStatus getPrev(DatabaseEntry key, DatabaseEntry data, LockMode lockMode) {
        OperationResult result = this.get(key, data, Get.PREV, DbInternal.getReadOptions(lockMode));
        return result == null ? OperationStatus.NOTFOUND : OperationStatus.SUCCESS;
    }

    public OperationStatus getPrevDup(DatabaseEntry key, DatabaseEntry data, LockMode lockMode) {
        OperationResult result = this.get(key, data, Get.PREV_DUP, DbInternal.getReadOptions(lockMode));
        return result == null ? OperationStatus.NOTFOUND : OperationStatus.SUCCESS;
    }

    public OperationStatus getPrevNoDup(DatabaseEntry key, DatabaseEntry data, LockMode lockMode) {
        OperationResult result = this.get(key, data, Get.PREV_NO_DUP, DbInternal.getReadOptions(lockMode));
        return result == null ? OperationStatus.NOTFOUND : OperationStatus.SUCCESS;
    }

    public long skipNext(long maxCount, DatabaseEntry key, DatabaseEntry data, LockMode lockMode) {
        this.checkOpenAndState(true);
        if (maxCount <= 0L) {
            throw new IllegalArgumentException("maxCount must be positive: " + maxCount);
        }
        this.trace(Level.FINEST, "Cursor.skipNext: ", lockMode);
        return this.skipInternal(maxCount, true, key, data, lockMode, null);
    }

    public long skipPrev(long maxCount, DatabaseEntry key, DatabaseEntry data, LockMode lockMode) {
        this.checkOpenAndState(true);
        if (maxCount <= 0L) {
            throw new IllegalArgumentException("maxCount must be positive: " + maxCount);
        }
        this.trace(Level.FINEST, "Cursor.skipPrev: ", lockMode);
        return this.skipInternal(maxCount, false, key, data, lockMode, null);
    }

    public OperationStatus getSearchKey(DatabaseEntry key, DatabaseEntry data, LockMode lockMode) {
        OperationResult result = this.get(key, data, Get.SEARCH, DbInternal.getReadOptions(lockMode));
        return result == null ? OperationStatus.NOTFOUND : OperationStatus.SUCCESS;
    }

    public OperationStatus getSearchKeyRange(DatabaseEntry key, DatabaseEntry data, LockMode lockMode) {
        OperationResult result = this.get(key, data, Get.SEARCH_GTE, DbInternal.getReadOptions(lockMode));
        return result == null ? OperationStatus.NOTFOUND : OperationStatus.SUCCESS;
    }

    public OperationStatus getSearchBoth(DatabaseEntry key, DatabaseEntry data, LockMode lockMode) {
        OperationResult result = this.get(key, data, Get.SEARCH_BOTH, DbInternal.getReadOptions(lockMode));
        return result == null ? OperationStatus.NOTFOUND : OperationStatus.SUCCESS;
    }

    public OperationStatus getSearchBothRange(DatabaseEntry key, DatabaseEntry data, LockMode lockMode) {
        OperationResult result = this.get(key, data, Get.SEARCH_BOTH_GTE, DbInternal.getReadOptions(lockMode));
        return result == null ? OperationStatus.NOTFOUND : OperationStatus.SUCCESS;
    }

    public int count() {
        this.checkOpenAndState(true);
        this.trace(Level.FINEST, "Cursor.count: ", null);
        return this.countInternal();
    }

    public long countEstimate() {
        this.checkOpenAndState(true);
        this.trace(Level.FINEST, "Cursor.countEstimate: ", null);
        return this.countEstimateInternal();
    }

    OperationResult deleteForReplay(ReplicationContext repContext) {
        return this.deleteNotify(repContext, null);
    }

    OperationResult deleteInternal(ReplicationContext repContext, CacheMode cacheMode) {
        this.checkUpdatesAllowed();
        return this.deleteNotify(repContext, cacheMode);
    }

    private OperationResult deleteNotify(ReplicationContext repContext, CacheMode cacheMode) {
        boolean hasAssociations;
        boolean hasUserTriggers = this.dbImpl.getTriggers() != null;
        boolean bl = hasAssociations = this.dbHandle != null && this.dbHandle.hasSecondaryOrForeignKeyAssociations();
        if (hasAssociations) {
            try {
                this.dbImpl.getEnv().getSecondaryAssociationLock().readLock().lockInterruptibly();
            }
            catch (InterruptedException e) {
                throw new ThreadInterruptedException(this.dbImpl.getEnv(), (Throwable)e);
            }
        }
        try {
            OperationResult deleteResult;
            OperationResult readResult;
            DatabaseEntry oldData;
            boolean needOldData;
            Collection<SecondaryDatabase> fkSecondaries;
            Collection<SecondaryDatabase> secondaries;
            DatabaseEntry key;
            if (hasAssociations || hasUserTriggers) {
                key = new DatabaseEntry();
                key.setData(this.cursorImpl.getCurrentKey());
            } else {
                key = null;
            }
            if (hasAssociations) {
                secondaries = this.dbHandle.secAssoc.getSecondaries(key);
                fkSecondaries = this.dbHandle.foreignKeySecondaries;
                needOldData = hasUserTriggers || SecondaryDatabase.needOldDataForDelete(secondaries);
            } else {
                secondaries = null;
                fkSecondaries = null;
                needOldData = hasUserTriggers;
            }
            DatabaseEntry databaseEntry = oldData = needOldData ? new DatabaseEntry() : null;
            if (needOldData || hasAssociations) {
                readResult = this.getCurrentInternal(key, oldData, LockMode.RMW, cacheMode);
                if (readResult == null) {
                    OperationResult operationResult = null;
                    return operationResult;
                }
            } else {
                readResult = null;
            }
            Locker locker = this.cursorImpl.getLocker();
            if (fkSecondaries != null) {
                for (SecondaryDatabase secDb : fkSecondaries) {
                    secDb.onForeignKeyDelete(locker, key, cacheMode);
                }
            }
            if ((deleteResult = this.deleteNoNotify(cacheMode, repContext)) == null) {
                SecondaryDatabase secDb;
                secDb = null;
                return secDb;
            }
            if (secondaries != null) {
                int nWrites = 0;
                for (SecondaryDatabase secDb : secondaries) {
                    nWrites += secDb.updateSecondary(locker, null, key, oldData, null, cacheMode, 0L, false, readResult.getExpirationTime());
                }
                this.cursorImpl.setNSecondaryWrites(nWrites);
            }
            if (hasUserTriggers) {
                TriggerManager.runDeleteTriggers(locker, this.dbImpl, key, oldData);
            }
            OperationResult operationResult = deleteResult;
            return operationResult;
        }
        catch (Error E) {
            this.dbImpl.getEnv().invalidate(E);
            throw E;
        }
        finally {
            if (hasAssociations) {
                this.dbImpl.getEnv().getSecondaryAssociationLock().readLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    OperationResult deleteNoNotify(CacheMode cacheMode, ReplicationContext repContext) {
        Object object = this.getTxnSynchronizer();
        synchronized (object) {
            this.checkTxnState();
            this.beginUseExistingCursor(cacheMode);
            OperationResult result = this.cursorImpl.deleteCurrentRecord(repContext);
            if (result != null) {
                this.dbImpl.getEnv().incDeleteOps(this.dbImpl);
            }
            this.endUseExistingCursor();
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    OperationResult putForReplay(DatabaseEntry key, DatabaseEntry data, LN ln, int expiration, boolean expirationInHours, PutMode putMode, ReplicationContext repContext) {
        assert (putMode != PutMode.CURRENT);
        ExpirationInfo expInfo = new ExpirationInfo(expiration, expirationInHours, true);
        Object object = this.getTxnSynchronizer();
        synchronized (object) {
            this.checkTxnState();
            return this.putNotify(key, data, ln, null, expInfo, putMode, repContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    OperationResult putInternal(DatabaseEntry key, DatabaseEntry data, CacheMode cacheMode, ExpirationInfo expInfo, PutMode putMode) {
        this.checkUpdatesAllowed(expInfo);
        Object object = this.getTxnSynchronizer();
        synchronized (object) {
            this.checkTxnState();
            if (this.dbImpl.getSortedDuplicates()) {
                return this.putHandleDups(key, data, cacheMode, expInfo, putMode);
            }
            if (putMode == PutMode.NO_DUP_DATA) {
                throw new UnsupportedOperationException("Database is not configured for duplicate data.");
            }
            return this.putNoDups(key, data, cacheMode, expInfo, putMode);
        }
    }

    private OperationResult putHandleDups(DatabaseEntry key, DatabaseEntry data, CacheMode cacheMode, ExpirationInfo expInfo, PutMode putMode) {
        switch (putMode) {
            case OVERWRITE: {
                return this.dupsPutOverwrite(key, data, cacheMode, expInfo);
            }
            case NO_OVERWRITE: {
                return this.dupsPutNoOverwrite(key, data, cacheMode, expInfo);
            }
            case NO_DUP_DATA: {
                return this.dupsPutNoDupData(key, data, cacheMode, expInfo);
            }
            case CURRENT: {
                return this.dupsPutCurrent(data, cacheMode, expInfo);
            }
        }
        throw EnvironmentFailureException.unexpectedState(putMode.toString());
    }

    private OperationResult dupsPutOverwrite(DatabaseEntry key, DatabaseEntry data, CacheMode cacheMode, ExpirationInfo expInfo) {
        DatabaseEntry twoPartKey = DupKeyData.combine(key, data);
        return this.putNoDups(twoPartKey, EMPTY_DUP_DATA, cacheMode, expInfo, PutMode.OVERWRITE);
    }

    private OperationResult dupsPutNoOverwrite(DatabaseEntry key, DatabaseEntry data, CacheMode cacheMode, ExpirationInfo expInfo) {
        DatabaseEntry key2 = new DatabaseEntry();
        DatabaseEntry data2 = new DatabaseEntry();
        try (Cursor c = this.dup(false);){
            c.setNonSticky(true);
            Cursor.setEntry(key, key2);
            OperationResult result = c.dupsGetSearchKeyRange(key2, data2, LockMode.RMW, cacheMode);
            if (result != null && key.equals(key2)) {
                OperationResult operationResult = null;
                return operationResult;
            }
            if (result == null) {
                c.cursorImpl.lockEof(LockType.WRITE);
            }
            Cursor.setEntry(key, key2);
            result = c.dupsGetSearchKey(key2, data2, LockMode.RMW, cacheMode);
            if (result != null) {
                OperationResult operationResult = null;
                return operationResult;
            }
            result = c.dupsPutNoDupData(key, data, cacheMode, expInfo);
            if (result == null) {
                OperationResult operationResult = null;
                return operationResult;
            }
            this.swapCursor(c);
            OperationResult operationResult = result;
            return operationResult;
        }
    }

    private OperationResult dupsPutNoDupData(DatabaseEntry key, DatabaseEntry data, CacheMode cacheMode, ExpirationInfo expInfo) {
        DatabaseEntry twoPartKey = DupKeyData.combine(key, data);
        return this.putNoDups(twoPartKey, EMPTY_DUP_DATA, cacheMode, expInfo, PutMode.NO_OVERWRITE);
    }

    private OperationResult dupsPutCurrent(DatabaseEntry newData, CacheMode cacheMode, ExpirationInfo expInfo) {
        DatabaseEntry oldTwoPartKey = new DatabaseEntry(this.cursorImpl.getCurrentKey());
        DatabaseEntry key = new DatabaseEntry();
        DupKeyData.split(oldTwoPartKey, key, null);
        DatabaseEntry newTwoPartKey = DupKeyData.combine(key, newData);
        return this.putNoDups(newTwoPartKey, EMPTY_DUP_DATA, cacheMode, expInfo, PutMode.CURRENT);
    }

    private OperationResult putNoDups(DatabaseEntry key, DatabaseEntry data, CacheMode cacheMode, ExpirationInfo expInfo, PutMode putMode) {
        LN ln = putMode == PutMode.CURRENT ? null : LN.makeLN(this.dbImpl.getEnv(), data);
        return this.putNotify(key, data, ln, cacheMode, expInfo, putMode, this.dbImpl.getRepContext());
    }

    private OperationResult putNotify(DatabaseEntry key, DatabaseEntry data, LN ln, CacheMode cacheMode, ExpirationInfo expInfo, PutMode putMode, ReplicationContext repContext) {
        boolean hasAssociations;
        boolean hasUserTriggers = this.dbImpl.getTriggers() != null;
        boolean bl = hasAssociations = this.dbHandle != null && this.dbHandle.hasSecondaryOrForeignKeyAssociations();
        if (hasAssociations) {
            try {
                this.dbImpl.getEnv().getSecondaryAssociationLock().readLock().lockInterruptibly();
            }
            catch (InterruptedException e) {
                throw new ThreadInterruptedException(this.dbImpl.getEnv(), (Throwable)e);
            }
        }
        try {
            OperationResult result;
            DatabaseEntry replaceKey = null;
            if (putMode == PutMode.CURRENT) {
                if (key == null) {
                    if (hasAssociations || hasUserTriggers) {
                        key = new DatabaseEntry();
                        key.setData(this.cursorImpl.getCurrentKey());
                    }
                } else {
                    replaceKey = key;
                }
            }
            DatabaseEntry oldData = null;
            DatabaseEntry newData = null;
            Collection<SecondaryDatabase> secondaries = null;
            if (hasAssociations || hasUserTriggers) {
                if (data.getPartial()) {
                    newData = new DatabaseEntry();
                }
                if (hasUserTriggers) {
                    oldData = new DatabaseEntry();
                }
                if (hasAssociations) {
                    secondaries = this.dbHandle.secAssoc.getSecondaries(key);
                    if (oldData == null && SecondaryDatabase.needOldDataForUpdate(secondaries)) {
                        oldData = new DatabaseEntry();
                    }
                    if (expInfo == null) {
                        expInfo = new ExpirationInfo(0, false, false);
                    }
                }
            }
            if ((result = putMode == PutMode.CURRENT ? this.putCurrentNoNotify(replaceKey, data, oldData, newData, cacheMode, expInfo, repContext) : this.putNoNotify(key, data, ln, cacheMode, expInfo, putMode, oldData, newData, repContext)) == null) {
                OperationResult operationResult = null;
                return operationResult;
            }
            if (oldData != null && oldData.getData() == null) {
                oldData = null;
            }
            if (newData == null) {
                newData = data;
            }
            Locker locker = this.cursorImpl.getLocker();
            if (secondaries != null) {
                int nWrites = 0;
                for (SecondaryDatabase secDb : secondaries) {
                    if (result.isUpdate() && !secDb.updateMayChangeSecondary()) continue;
                    nWrites += secDb.updateSecondary(locker, null, key, oldData, newData, cacheMode, result.getExpirationTime(), expInfo.getExpirationUpdated(), expInfo.getOldExpirationTime());
                }
                this.cursorImpl.setNSecondaryWrites(nWrites);
            }
            if (hasUserTriggers) {
                TriggerManager.runPutTriggers(locker, this.dbImpl, key, oldData, newData);
            }
            OperationResult operationResult = result;
            return operationResult;
        }
        catch (Error E) {
            this.dbImpl.getEnv().invalidate(E);
            throw E;
        }
        finally {
            if (hasAssociations) {
                this.dbImpl.getEnv().getSecondaryAssociationLock().readLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OperationResult putNoNotify(DatabaseEntry key, DatabaseEntry data, LN ln, CacheMode cacheMode, ExpirationInfo expInfo, PutMode putMode, DatabaseEntry returnOldData, DatabaseEntry returnNewData, ReplicationContext repContext) {
        OperationResult operationResult;
        assert (key != null);
        assert (ln != null);
        assert (putMode != null);
        assert (putMode != PutMode.CURRENT);
        Locker nextKeyLocker = null;
        CursorImpl nextKeyCursor = null;
        CursorImpl dup = null;
        OperationResult result = null;
        boolean success = false;
        try {
            EnvironmentImpl envImpl = this.dbImpl.getEnv();
            Locker cursorLocker = this.cursorImpl.getLocker();
            if (envImpl.getTxnManager().areOtherSerializableTransactionsActive(cursorLocker)) {
                nextKeyLocker = BuddyLocker.createBuddyLocker(envImpl, cursorLocker);
                nextKeyCursor = new CursorImpl(this.dbImpl, nextKeyLocker);
                nextKeyCursor.setAllowEviction(true);
                nextKeyCursor.lockNextKeyForInsert(key);
            }
            if ((result = (dup = this.beginMoveCursor(false, cacheMode)).insertOrUpdateRecord(key, data, ln, expInfo, putMode, returnOldData, returnNewData, repContext)) == null) {
                if (putMode == PutMode.NO_OVERWRITE) {
                    envImpl.incInsertFailOps(this.dbImpl);
                }
            } else if (!result.isUpdate()) {
                envImpl.incInsertOps(this.dbImpl);
            } else {
                envImpl.incUpdateOps(this.dbImpl);
            }
            success = true;
            operationResult = result;
        }
        catch (Throwable throwable) {
            try {
                if (dup != null) {
                    this.endMoveCursor(dup, result != null);
                }
                if (nextKeyCursor != null) {
                    nextKeyCursor.close();
                }
                if (nextKeyLocker != null) {
                    nextKeyLocker.operationEnd();
                }
            }
            catch (Exception e) {
                if (success) {
                    throw e;
                }
                LoggerUtils.traceAndLogException(this.dbImpl.getEnv(), "Cursor", "putNoNotify", "", e);
            }
            throw throwable;
        }
        try {
            if (dup != null) {
                this.endMoveCursor(dup, result != null);
            }
            if (nextKeyCursor != null) {
                nextKeyCursor.close();
            }
            if (nextKeyLocker != null) {
                nextKeyLocker.operationEnd();
            }
        }
        catch (Exception e) {
            if (success) {
                throw e;
            }
            LoggerUtils.traceAndLogException(this.dbImpl.getEnv(), "Cursor", "putNoNotify", "", e);
        }
        return operationResult;
    }

    private OperationResult putCurrentNoNotify(DatabaseEntry key, DatabaseEntry data, DatabaseEntry returnOldData, DatabaseEntry returnNewData, CacheMode cacheMode, ExpirationInfo expInfo, ReplicationContext repContext) {
        assert (data != null);
        this.beginUseExistingCursor(cacheMode);
        OperationResult result = this.cursorImpl.updateCurrentRecord(key, data, expInfo, returnOldData, returnNewData, repContext);
        if (result != null) {
            this.dbImpl.getEnv().incUpdateOps(this.dbImpl);
        }
        this.endUseExistingCursor();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    OperationResult getCurrentInternal(DatabaseEntry key, DatabaseEntry data, LockMode lockMode, CacheMode cacheMode) {
        Object object = this.getTxnSynchronizer();
        synchronized (object) {
            this.checkTxnState();
            if (this.dbImpl.getSortedDuplicates()) {
                return this.getCurrentHandleDups(key, data, lockMode, cacheMode);
            }
            return this.getCurrentNoDups(key, data, lockMode, cacheMode);
        }
    }

    OperationResult checkCurrent(LockMode lockMode, CacheMode cacheMode) {
        return this.getCurrentNoDups(null, null, lockMode, cacheMode);
    }

    private OperationResult getCurrentHandleDups(DatabaseEntry key, DatabaseEntry data, LockMode lockMode, CacheMode cacheMode) {
        DatabaseEntry twoPartKey = new DatabaseEntry();
        OperationResult result = this.getCurrentNoDups(twoPartKey, NO_RETURN_DATA, lockMode, cacheMode);
        if (result == null) {
            return null;
        }
        DupKeyData.split(twoPartKey, key, data);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OperationResult getCurrentNoDups(DatabaseEntry key, DatabaseEntry data, LockMode lockMode, CacheMode cacheMode) {
        boolean success = false;
        this.beginUseExistingCursor(cacheMode);
        LockType lockType = this.getLockType(lockMode, false);
        try {
            OperationResult result = this.cursorImpl.lockAndGetCurrent(key, data, lockType, lockMode == LockMode.READ_UNCOMMITTED_ALL, false, false);
            success = true;
            OperationResult operationResult = result;
            return operationResult;
        }
        finally {
            if (success && !this.dbImpl.isInternalDb() && this.cursorImpl.getBIN() != null && this.cursorImpl.getBIN().isBINDelta()) {
                this.dbImpl.getEnv().incBinDeltaGets();
            }
            this.cursorImpl.releaseBIN();
            this.endUseExistingCursor();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    OperationResult position(DatabaseEntry key, DatabaseEntry data, LockMode lockMode, CacheMode cacheMode, boolean first) {
        Object object = this.getTxnSynchronizer();
        synchronized (object) {
            this.checkTxnState();
            OperationResult result = this.dbImpl.getSortedDuplicates() ? this.positionHandleDups(key, data, lockMode, cacheMode, first) : this.positionNoDups(key, data, lockMode, cacheMode, first);
            if (result != null) {
                this.dbImpl.getEnv().incPositionOps(this.dbImpl);
            }
            return result;
        }
    }

    private OperationResult positionHandleDups(DatabaseEntry key, DatabaseEntry data, LockMode lockMode, CacheMode cacheMode, boolean first) {
        DatabaseEntry twoPartKey = new DatabaseEntry();
        OperationResult result = this.positionNoDups(twoPartKey, NO_RETURN_DATA, lockMode, cacheMode, first);
        if (result == null) {
            return null;
        }
        DupKeyData.split(twoPartKey, key, data);
        return result;
    }

    private OperationResult positionNoDups(DatabaseEntry key, DatabaseEntry data, LockMode lockMode, CacheMode cacheMode, boolean first) {
        try {
            if (!this.isSerializableIsolation(lockMode)) {
                return this.positionAllowPhantoms(key, data, lockMode, cacheMode, false, first);
            }
            while (true) {
                try {
                    if (!first) {
                        this.cursorImpl.lockEof(LockType.RANGE_READ);
                    }
                    OperationResult result = this.positionAllowPhantoms(key, data, lockMode, cacheMode, first, first);
                    if (first && result == null) {
                        this.cursorImpl.lockEof(LockType.RANGE_READ);
                    }
                    return result;
                }
                catch (RangeRestartException result) {
                    continue;
                }
                break;
            }
        }
        catch (Error E) {
            this.dbImpl.getEnv().invalidate(E);
            throw E;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OperationResult positionAllowPhantoms(DatabaseEntry key, DatabaseEntry data, LockMode lockMode, CacheMode cacheMode, boolean rangeLock, boolean first) {
        assert (key != null && data != null);
        OperationResult result = null;
        CursorImpl dup = this.beginMoveCursor(false, cacheMode);
        try {
            if (!dup.positionFirstOrLast(first)) {
                result = null;
                if (LatchSupport.TRACK_LATCHES) {
                    LatchSupport.expectBtreeLatchesHeld(0);
                }
            } else {
                boolean dirtyReadAll;
                LockType lockType;
                if (LatchSupport.TRACK_LATCHES) {
                    LatchSupport.expectBtreeLatchesHeld(1);
                }
                if ((result = dup.lockAndGetCurrent(key, data, lockType = this.getLockType(lockMode, rangeLock), dirtyReadAll = lockMode == LockMode.READ_UNCOMMITTED_ALL, true, false)) == null) {
                    result = dup.getNext(key, data, lockType, dirtyReadAll, first, true, null);
                }
            }
            dup.releaseBIN();
            this.endMoveCursor(dup, result != null);
        }
        catch (Throwable throwable) {
            dup.releaseBIN();
            this.endMoveCursor(dup, result != null);
            throw throwable;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    OperationResult retrieveNext(DatabaseEntry key, DatabaseEntry data, LockMode lockMode, CacheMode cacheMode, GetMode getMode) {
        Object object = this.getTxnSynchronizer();
        synchronized (object) {
            OperationResult result = this.dbImpl.getSortedDuplicates() ? this.retrieveNextHandleDups(key, data, lockMode, cacheMode, getMode) : this.retrieveNextNoDups(key, data, lockMode, cacheMode, getMode);
            if (result != null) {
                this.dbImpl.getEnv().incPositionOps(this.dbImpl);
            }
            return result;
        }
    }

    private OperationResult retrieveNextHandleDups(DatabaseEntry key, DatabaseEntry data, LockMode lockMode, CacheMode cacheMode, GetMode getMode) {
        switch (getMode) {
            case NEXT: 
            case PREV: {
                return this.dupsGetNextOrPrev(key, data, lockMode, cacheMode, getMode);
            }
            case NEXT_DUP: {
                return this.dupsGetNextOrPrevDup(key, data, lockMode, cacheMode, GetMode.NEXT);
            }
            case PREV_DUP: {
                return this.dupsGetNextOrPrevDup(key, data, lockMode, cacheMode, GetMode.PREV);
            }
            case NEXT_NODUP: {
                return this.dupsGetNextNoDup(key, data, lockMode, cacheMode);
            }
            case PREV_NODUP: {
                return this.dupsGetPrevNoDup(key, data, lockMode, cacheMode);
            }
        }
        throw EnvironmentFailureException.unexpectedState(getMode.toString());
    }

    private OperationResult dupsGetNextOrPrev(DatabaseEntry key, DatabaseEntry data, LockMode lockMode, CacheMode cacheMode, GetMode getMode) {
        DatabaseEntry twoPartKey = new DatabaseEntry();
        OperationResult result = this.retrieveNextNoDups(twoPartKey, NO_RETURN_DATA, lockMode, cacheMode, getMode);
        if (result == null) {
            return null;
        }
        DupKeyData.split(twoPartKey, key, data);
        return result;
    }

    private OperationResult dupsGetNextOrPrevDup(DatabaseEntry key, DatabaseEntry data, LockMode lockMode, CacheMode cacheMode, GetMode getMode) {
        byte[] currentKey = this.cursorImpl.getCurrentKey();
        try (Cursor c = this.dup(true);){
            c.setNonSticky(true);
            this.setPrefixConstraint(c, currentKey);
            DatabaseEntry twoPartKey = new DatabaseEntry();
            OperationResult result = c.retrieveNextNoDups(twoPartKey, NO_RETURN_DATA, lockMode, cacheMode, getMode);
            if (result == null) {
                OperationResult operationResult = null;
                return operationResult;
            }
            DupKeyData.split(twoPartKey, key, data);
            this.swapCursor(c);
            OperationResult operationResult = result;
            return operationResult;
        }
    }

    private OperationResult dupsGetNextNoDup(DatabaseEntry key, DatabaseEntry data, LockMode lockMode, CacheMode cacheMode) {
        byte[] currentKey = this.cursorImpl.getCurrentKey();
        DatabaseEntry twoPartKey = DupKeyData.removeData(currentKey);
        try (Cursor c = this.dup(false);){
            c.setNonSticky(true);
            DupKeyData.NextNoDupComparator searchComparator = new DupKeyData.NextNoDupComparator(this.dbImpl.getBtreeComparator());
            OperationResult result = c.searchNoDups(twoPartKey, NO_RETURN_DATA, lockMode, cacheMode, SearchMode.SET_RANGE, searchComparator);
            if (result == null) {
                OperationResult operationResult = null;
                return operationResult;
            }
            DupKeyData.split(twoPartKey, key, data);
            this.swapCursor(c);
            OperationResult operationResult = result;
            return operationResult;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OperationResult dupsGetPrevNoDup(DatabaseEntry key, DatabaseEntry data, LockMode lockMode, CacheMode cacheMode) {
        OperationResult result;
        byte[] currentKey = this.cursorImpl.getCurrentKey();
        DatabaseEntry twoPartKey = DupKeyData.removeData(currentKey);
        try (Cursor c = this.dup(false);){
            c.setNonSticky(true);
            this.setPrefixConstraint(c, currentKey);
            result = c.searchNoDups(twoPartKey, NO_RETURN_DATA, lockMode, cacheMode, SearchMode.SET_RANGE, null);
            if (result != null) {
                c.rangeConstraint = null;
                result = c.retrieveNextNoDups(twoPartKey, NO_RETURN_DATA, lockMode, cacheMode, GetMode.PREV);
                if (result == null) {
                    OperationResult operationResult = null;
                    return operationResult;
                }
                DupKeyData.split(twoPartKey, key, data);
                this.swapCursor(c);
                OperationResult operationResult = result;
                return operationResult;
            }
        }
        c = this.dup(true);
        try {
            c.setNonSticky(true);
            while (true) {
                if ((result = c.retrieveNextNoDups(twoPartKey, NO_RETURN_DATA, lockMode, cacheMode, GetMode.PREV)) == null) {
                    OperationResult operationResult = null;
                    return operationResult;
                }
                if (this.haveSameDupPrefix(twoPartKey, currentKey)) continue;
                DupKeyData.split(twoPartKey, key, data);
                this.swapCursor(c);
                OperationResult operationResult = result;
                return operationResult;
            }
        }
        finally {
            c.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private OperationResult retrieveNextNoDups(DatabaseEntry key, DatabaseEntry data, LockMode lockMode, CacheMode cacheMode, GetMode getModeParam) {
        GetMode getMode;
        switch (getModeParam) {
            case NEXT_DUP: 
            case PREV_DUP: {
                return null;
            }
            case NEXT_NODUP: {
                getMode = GetMode.NEXT;
                break;
            }
            case PREV_NODUP: {
                getMode = GetMode.PREV;
                break;
            }
            default: {
                getMode = getModeParam;
            }
        }
        try {
            if (!this.isSerializableIsolation(lockMode)) {
                assert (getMode == GetMode.NEXT || getMode == GetMode.PREV);
                CursorImpl dup = this.beginMoveCursor(true, cacheMode);
                OperationResult result = null;
                try {
                    OperationResult operationResult = result = dup.getNext(key, data, this.getLockType(lockMode, false), lockMode == LockMode.READ_UNCOMMITTED_ALL, getMode.isForward(), false, this.rangeConstraint);
                    this.endMoveCursor(dup, result != null);
                    return operationResult;
                }
                catch (Throwable throwable) {
                    this.endMoveCursor(dup, result != null);
                    throw throwable;
                }
            }
        }
        catch (Error E) {
            this.dbImpl.getEnv().invalidate(E);
            throw E;
        }
        while (true) {
            try {
                if (!getMode.isForward()) {
                    this.rangeLockCurrentPosition();
                }
                LockType lockType = this.getLockType(lockMode, getMode.isForward());
                DatabaseEntry tryKey = Cursor.cloneEntry(key);
                DatabaseEntry tryData = Cursor.cloneEntry(data);
                OperationResult result = this.retrieveNextCheckForInsertion(tryKey, tryData, lockType, cacheMode, getMode);
                if (getMode.isForward() && result == null) {
                    this.cursorImpl.lockEof(LockType.RANGE_READ);
                }
                if (result != null && !this.checkRangeConstraint(tryKey)) {
                    return null;
                }
                if (result == null) return result;
                Cursor.setEntry(tryKey, key);
                Cursor.setEntry(tryData, data);
                return result;
            }
            catch (RangeRestartException lockType) {
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rangeLockCurrentPosition() {
        OperationResult result;
        DatabaseEntry tempKey = new DatabaseEntry();
        DatabaseEntry tempData = new DatabaseEntry();
        tempKey.setPartial(0, 0, true);
        tempData.setPartial(0, 0, true);
        CursorImpl dup = this.cursorImpl.cloneCursor(true);
        try {
            result = dup.lockAndGetCurrent(tempKey, tempData, LockType.RANGE_READ);
            if (result == null) {
                while (true) {
                    if (LatchSupport.TRACK_LATCHES) {
                        LatchSupport.expectBtreeLatchesHeld(0);
                    }
                    result = dup.getNext(tempKey, tempData, LockType.RANGE_READ, false, true, false, null);
                    if (!this.cursorImpl.checkForInsertion(GetMode.NEXT, dup)) break;
                    dup.close(this.cursorImpl);
                    dup = this.cursorImpl.cloneCursor(true);
                }
                if (LatchSupport.TRACK_LATCHES) {
                    LatchSupport.expectBtreeLatchesHeld(0);
                }
            }
        }
        finally {
            dup.close(this.cursorImpl);
        }
        if (result == null) {
            this.cursorImpl.lockEof(LockType.RANGE_READ);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OperationResult retrieveNextCheckForInsertion(DatabaseEntry key, DatabaseEntry data, LockType lockType, CacheMode cacheMode, GetMode getMode) {
        assert (key != null && data != null);
        assert (getMode == GetMode.NEXT || getMode == GetMode.PREV);
        while (true) {
            if (LatchSupport.TRACK_LATCHES) {
                LatchSupport.expectBtreeLatchesHeld(0);
            }
            CursorImpl dup = this.beginMoveCursor(true, true, cacheMode);
            boolean doEndMoveCursor = true;
            try {
                OperationResult result = dup.getNext(key, data, lockType, false, getMode.isForward(), false, null);
                if (this.cursorImpl.checkForInsertion(getMode, dup)) continue;
                doEndMoveCursor = false;
                this.endMoveCursor(dup, result != null);
                if (LatchSupport.TRACK_LATCHES) {
                    LatchSupport.expectBtreeLatchesHeld(0);
                }
                OperationResult operationResult = result;
                return operationResult;
            }
            finally {
                if (!doEndMoveCursor) continue;
                this.endMoveCursor(dup, false);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private long skipInternal(long maxCount, boolean forward, DatabaseEntry key, DatabaseEntry data, LockMode lockMode, CacheMode cacheMode) {
        LockType lockType = this.getLockType(lockMode, false);
        Object object = this.getTxnSynchronizer();
        synchronized (object) {
            this.checkTxnState();
            while (true) {
                CursorImpl dup = this.beginMoveCursor(true, true, cacheMode);
                boolean success = false;
                try {
                    long count = dup.skip(forward, maxCount, null);
                    if (count <= 0L) {
                        long l = 0L;
                        return l;
                    }
                    OperationResult result = this.getCurrentWithCursorImpl(dup, key, data, lockType);
                    if (result == null) continue;
                    success = true;
                    long l = count;
                    return l;
                }
                finally {
                    this.endMoveCursor(dup, success);
                    continue;
                }
                break;
            }
        }
    }

    private OperationResult getCurrentWithCursorImpl(CursorImpl c, DatabaseEntry key, DatabaseEntry data, LockType lockType) {
        if (!this.dbImpl.getSortedDuplicates()) {
            return c.lockAndGetCurrent(key, data, lockType);
        }
        DatabaseEntry twoPartKey = new DatabaseEntry();
        OperationResult result = c.lockAndGetCurrent(twoPartKey, NO_RETURN_DATA, lockType);
        if (result == null) {
            return null;
        }
        DupKeyData.split(twoPartKey, key, data);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    OperationResult search(DatabaseEntry key, DatabaseEntry data, LockMode lockMode, CacheMode cacheMode, SearchMode searchMode, boolean countOpStat) {
        Object object = this.getTxnSynchronizer();
        synchronized (object) {
            OperationResult result;
            block14: {
                block13: {
                    this.checkTxnState();
                    if (!this.dbImpl.getSortedDuplicates()) break block13;
                    switch (searchMode) {
                        case SET: {
                            result = this.dupsGetSearchKey(key, data, lockMode, cacheMode);
                            break block14;
                        }
                        case SET_RANGE: {
                            result = this.dupsGetSearchKeyRange(key, data, lockMode, cacheMode);
                            break block14;
                        }
                        case BOTH: {
                            result = this.dupsGetSearchBoth(key, data, lockMode, cacheMode);
                            break block14;
                        }
                        case BOTH_RANGE: {
                            result = this.dupsGetSearchBothRange(key, data, lockMode, cacheMode);
                            break block14;
                        }
                        default: {
                            throw EnvironmentFailureException.unexpectedState(searchMode.toString());
                        }
                    }
                }
                if (searchMode == SearchMode.BOTH_RANGE) {
                    searchMode = SearchMode.BOTH;
                }
                result = this.searchNoDups(key, data, lockMode, cacheMode, searchMode, null);
            }
            if (countOpStat) {
                if (result != null) {
                    this.dbImpl.getEnv().incSearchOps(this.dbImpl);
                } else {
                    this.dbImpl.getEnv().incSearchFailOps(this.dbImpl);
                }
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    OperationResult searchForReplay(DatabaseEntry key, DatabaseEntry data, LockMode lockMode, CacheMode cacheMode, SearchMode searchMode) {
        Object object = this.getTxnSynchronizer();
        synchronized (object) {
            this.checkTxnState();
            return this.searchNoDups(key, data, lockMode, cacheMode, searchMode, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OperationResult dupsGetSearchKey(DatabaseEntry key, DatabaseEntry data, LockMode lockMode, CacheMode cacheMode) {
        DatabaseEntry twoPartKey = new DatabaseEntry(DupKeyData.makePrefixKey(key.getData(), key.getOffset(), key.getSize()));
        RangeConstraint savedRangeConstraint = this.rangeConstraint;
        try {
            this.setPrefixConstraint(this, key);
            OperationResult result = this.searchNoDups(twoPartKey, NO_RETURN_DATA, lockMode, cacheMode, SearchMode.SET_RANGE, null);
            if (result == null) {
                OperationResult operationResult = null;
                return operationResult;
            }
            DupKeyData.split(twoPartKey, key, data);
            OperationResult operationResult = result;
            return operationResult;
        }
        finally {
            this.rangeConstraint = savedRangeConstraint;
        }
    }

    private OperationResult dupsGetSearchKeyRange(DatabaseEntry key, DatabaseEntry data, LockMode lockMode, CacheMode cacheMode) {
        DatabaseEntry twoPartKey = new DatabaseEntry(DupKeyData.makePrefixKey(key.getData(), key.getOffset(), key.getSize()));
        OperationResult result = this.searchNoDups(twoPartKey, NO_RETURN_DATA, lockMode, cacheMode, SearchMode.SET_RANGE, null);
        if (result == null) {
            return null;
        }
        DupKeyData.split(twoPartKey, key, data);
        return result;
    }

    private OperationResult dupsGetSearchBoth(DatabaseEntry key, DatabaseEntry data, LockMode lockMode, CacheMode cacheMode) {
        DatabaseEntry twoPartKey = DupKeyData.combine(key, data);
        OperationResult result = this.searchNoDups(twoPartKey, NO_RETURN_DATA, lockMode, cacheMode, SearchMode.BOTH, null);
        if (result == null) {
            return null;
        }
        DupKeyData.split(twoPartKey, key, data);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OperationResult dupsGetSearchBothRange(DatabaseEntry key, DatabaseEntry data, LockMode lockMode, CacheMode cacheMode) {
        DatabaseEntry twoPartKey = DupKeyData.combine(key, data);
        RangeConstraint savedRangeConstraint = this.rangeConstraint;
        try {
            this.setPrefixConstraint(this, key);
            OperationResult result = this.searchNoDups(twoPartKey, NO_RETURN_DATA, lockMode, cacheMode, SearchMode.SET_RANGE, null);
            if (result == null) {
                OperationResult operationResult = null;
                return operationResult;
            }
            DupKeyData.split(twoPartKey, key, data);
            OperationResult operationResult = result;
            return operationResult;
        }
        finally {
            this.rangeConstraint = savedRangeConstraint;
        }
    }

    private OperationResult searchNoDups(DatabaseEntry key, DatabaseEntry data, LockMode lockMode, CacheMode cacheMode, SearchMode searchMode, Comparator<byte[]> comparator) {
        assert (searchMode != SearchMode.BOTH_RANGE);
        try {
            if (!this.isSerializableIsolation(lockMode)) {
                if (searchMode.isExactSearch()) {
                    assert (comparator == null);
                    return this.searchExact(key, data, lockMode, cacheMode, searchMode);
                }
                while (true) {
                    try {
                        return this.searchRange(key, data, lockMode, cacheMode, comparator);
                    }
                    catch (RangeRestartException rangeRestartException) {
                        continue;
                    }
                    break;
                }
            }
            while (true) {
                try {
                    LockType searchLockType = this.getLockType(lockMode, false);
                    LockType advanceLockType = this.getLockType(lockMode, true);
                    DatabaseEntry tryKey = Cursor.cloneEntry(key);
                    DatabaseEntry tryData = Cursor.cloneEntry(data);
                    OperationResult result = this.searchRangeSerializable(tryKey, tryData, searchLockType, advanceLockType, comparator, cacheMode, searchMode);
                    if (result != null) {
                        Cursor.setEntry(tryKey, key);
                        Cursor.setEntry(tryData, data);
                    }
                    return result;
                }
                catch (RangeRestartException rangeRestartException) {
                    continue;
                }
                break;
            }
        }
        catch (Error E) {
            this.dbImpl.getEnv().invalidate(E);
            throw E;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OperationResult searchExact(DatabaseEntry key, DatabaseEntry data, LockMode lockMode, CacheMode cacheMode, SearchMode searchMode) {
        CursorImpl dup;
        OperationResult result;
        boolean success;
        block9: {
            DatabaseEntry origData;
            block8: {
                OperationResult operationResult;
                assert (key != null && data != null);
                assert (searchMode == SearchMode.SET || searchMode == SearchMode.BOTH);
                success = false;
                result = null;
                origData = new DatabaseEntry(data.getData(), data.getOffset(), data.getSize());
                boolean dataRequested = !data.getPartial() || data.getPartialLength() != 0;
                LockType lockType = this.getLockType(lockMode, false);
                boolean dirtyReadAll = lockMode == LockMode.READ_UNCOMMITTED_ALL;
                dup = this.beginMoveCursor(false, cacheMode);
                try {
                    if (dup.searchExact(key, lockType, dirtyReadAll, dataRequested) != null) break block8;
                    success = true;
                    operationResult = null;
                }
                catch (Throwable throwable) {
                    if (success && !this.dbImpl.isInternalDb() && dup.getBIN() != null && dup.getBIN().isBINDelta()) {
                        this.dbImpl.getEnv().incBinDeltaGets();
                    }
                    dup.releaseBIN();
                    this.endMoveCursor(dup, result != null);
                    throw throwable;
                }
                if (success && !this.dbImpl.isInternalDb() && dup.getBIN() != null && dup.getBIN().isBINDelta()) {
                    this.dbImpl.getEnv().incBinDeltaGets();
                }
                dup.releaseBIN();
                this.endMoveCursor(dup, result != null);
                return operationResult;
            }
            result = dup.getCurrent(this.dbImpl.allowsKeyUpdates() ? key : null, data);
            if (result == null || searchMode != SearchMode.BOTH || this.checkDataMatch(origData, data)) break block9;
            result = null;
        }
        if ((success = true) && !this.dbImpl.isInternalDb() && dup.getBIN() != null && dup.getBIN().isBINDelta()) {
            this.dbImpl.getEnv().incBinDeltaGets();
        }
        dup.releaseBIN();
        this.endMoveCursor(dup, result != null);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OperationResult searchRange(DatabaseEntry key, DatabaseEntry data, LockMode lockMode, CacheMode cacheMode, Comparator<byte[]> comparator) throws RangeRestartException {
        CursorImpl dup;
        OperationResult result;
        boolean incStats;
        boolean success;
        block9: {
            boolean foundLast;
            int searchResult;
            boolean dirtyReadAll;
            LockType lockType;
            block8: {
                OperationResult operationResult;
                assert (key != null && data != null);
                success = false;
                incStats = !this.dbImpl.isInternalDb();
                result = null;
                lockType = this.getLockType(lockMode, false);
                dirtyReadAll = lockMode == LockMode.READ_UNCOMMITTED_ALL;
                dup = this.beginMoveCursor(false, cacheMode);
                try {
                    searchResult = dup.searchRange(key, comparator);
                    if ((searchResult & 1) != 0) break block8;
                    success = true;
                    operationResult = null;
                }
                catch (Throwable throwable) {
                    if (success && incStats && dup.getBIN() != null && dup.getBIN().isBINDelta()) {
                        this.dbImpl.getEnv().incBinDeltaGets();
                    }
                    dup.releaseBIN();
                    this.endMoveCursor(dup, result != null);
                    throw throwable;
                }
                if (success && incStats && dup.getBIN() != null && dup.getBIN().isBINDelta()) {
                    this.dbImpl.getEnv().incBinDeltaGets();
                }
                dup.releaseBIN();
                this.endMoveCursor(dup, result != null);
                return operationResult;
            }
            boolean exactKeyMatch = (searchResult & 2) != 0;
            boolean bl = foundLast = (searchResult & 4) != 0;
            if (exactKeyMatch) {
                result = dup.lockAndGetCurrent(key, data, lockType, dirtyReadAll, true, false);
            }
            if (exactKeyMatch && result != null) break block9;
            result = null;
            if (foundLast) break block9;
            result = this.searchRangeAdvanceAndCheckKey(dup, key, data, lockType, dirtyReadAll, comparator, this.rangeConstraint);
            incStats = false;
        }
        if ((success = true) && incStats && dup.getBIN() != null && dup.getBIN().isBINDelta()) {
            this.dbImpl.getEnv().incBinDeltaGets();
        }
        dup.releaseBIN();
        this.endMoveCursor(dup, result != null);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OperationResult searchRangeSerializable(DatabaseEntry key, DatabaseEntry data, LockType searchLockType, LockType advanceLockType, Comparator<byte[]> comparator, CacheMode cacheMode, SearchMode searchMode) throws RangeRestartException {
        assert (key != null && data != null);
        boolean success = false;
        boolean incStats = !this.dbImpl.isInternalDb();
        OperationResult result = null;
        boolean exactSearch = searchMode.isExactSearch();
        boolean keyChange = false;
        boolean mustLockEOF = false;
        DatabaseEntry origData = null;
        if (exactSearch) {
            origData = new DatabaseEntry(data.getData(), data.getOffset(), data.getSize());
        }
        CursorImpl dup = this.beginMoveCursor(false, cacheMode);
        try {
            int searchResult = dup.searchRange(key, comparator);
            if ((searchResult & 1) != 0) {
                boolean foundLast;
                boolean exactKeyMatch = (searchResult & 2) != 0;
                boolean bl = foundLast = (searchResult & 4) != 0;
                if (exactKeyMatch) {
                    result = dup.lockAndGetCurrent(key, data, searchLockType, false, true, false);
                }
                if (!exactKeyMatch || result == null) {
                    result = null;
                    if (!foundLast) {
                        result = this.searchRangeAdvanceAndCheckKey(dup, key, data, advanceLockType, false, comparator, null);
                        keyChange = result != null;
                        incStats = false;
                    }
                    boolean bl2 = mustLockEOF = result == null;
                }
                if (result != null && exactSearch) {
                    if (keyChange) {
                        result = null;
                    } else if (searchMode == SearchMode.BOTH && !this.checkDataMatch(origData, data)) {
                        result = null;
                    }
                }
                if (result != null && !exactSearch && !this.checkRangeConstraint(key)) {
                    result = null;
                }
            } else {
                mustLockEOF = true;
            }
            success = true;
        }
        catch (Throwable throwable) {
            if (success && incStats && dup.getBIN() != null && dup.getBIN().isBINDelta()) {
                this.dbImpl.getEnv().incBinDeltaGets();
            }
            dup.releaseBIN();
            this.endMoveCursor(dup, result != null);
            throw throwable;
        }
        if (success && incStats && dup.getBIN() != null && dup.getBIN().isBINDelta()) {
            this.dbImpl.getEnv().incBinDeltaGets();
        }
        dup.releaseBIN();
        this.endMoveCursor(dup, result != null);
        if (mustLockEOF) {
            this.cursorImpl.lockEof(LockType.RANGE_READ);
        }
        return result;
    }

    private OperationResult searchRangeAdvanceAndCheckKey(CursorImpl dup, DatabaseEntry key, DatabaseEntry data, LockType lockType, boolean dirtyReadAll, Comparator<byte[]> comparator, RangeConstraint rangeConstraint) throws RangeRestartException {
        OperationResult result;
        if (comparator == null) {
            comparator = this.dbImpl.getKeyComparator();
        }
        DatabaseEntry origKey = new DatabaseEntry(key.getData(), key.getOffset(), key.getSize());
        DatabaseEntry nextKey = key;
        if (key.getPartial()) {
            nextKey = new DatabaseEntry(key.getData(), key.getOffset(), key.getSize());
        }
        if ((result = dup.getNext(nextKey, data, lockType, dirtyReadAll, true, true, rangeConstraint)) != null) {
            int c = Key.compareKeys(nextKey, origKey, comparator);
            if (c < 0) {
                key.setData(origKey.getData(), origKey.getOffset(), origKey.getSize());
                throw new RangeRestartException();
            }
            if (key.getPartial()) {
                LN.setEntry(key, nextKey);
            }
        }
        return result;
    }

    private boolean checkDataMatch(DatabaseEntry data1, DatabaseEntry data2) {
        int size2;
        int size1 = data1.getSize();
        if (size1 != (size2 = data2.getSize())) {
            return false;
        }
        return Key.compareUnsignedBytes(data1.getData(), data1.getOffset(), size1, data2.getData(), data2.getOffset(), size2) == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int countInternal() {
        Object object = this.getTxnSynchronizer();
        synchronized (object) {
            this.checkTxnState();
            if (this.dbImpl.getSortedDuplicates()) {
                return this.countHandleDups();
            }
            return this.countNoDups();
        }
    }

    private int countHandleDups() {
        byte[] currentKey = this.cursorImpl.getCurrentKey();
        DatabaseEntry twoPartKey = DupKeyData.removeData(currentKey);
        try (Cursor c = this.dup(false);){
            c.setNonSticky(true);
            this.setPrefixConstraint(c, currentKey);
            OperationResult result = c.searchNoDups(twoPartKey, NO_RETURN_DATA, LockMode.READ_UNCOMMITTED, CacheMode.UNCHANGED, SearchMode.SET_RANGE, null);
            if (result == null) {
                int n = 0;
                return n;
            }
            long count = 1L + c.cursorImpl.skip(true, 0L, c.rangeConstraint);
            if (count > Integer.MAX_VALUE) {
                throw new IllegalStateException("count exceeded integer size: " + count);
            }
            int n = (int)count;
            return n;
        }
    }

    private int countNoDups() {
        try {
            this.beginUseExistingCursor(CacheMode.UNCHANGED);
            OperationResult result = this.cursorImpl.lockAndGetCurrent(null, null, LockType.NONE);
            this.endUseExistingCursor();
            return result != null ? 1 : 0;
        }
        catch (Error E) {
            this.dbImpl.getEnv().invalidate(E);
            throw E;
        }
    }

    long countEstimateInternal() {
        if (this.dbImpl.getSortedDuplicates()) {
            return this.countEstimateHandleDups();
        }
        return this.countNoDups();
    }

    /*
     * Exception decompiling
     */
    private long countEstimateHandleDups() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean readPrimaryAfterGet(Database priDb, DatabaseEntry key, DatabaseEntry pKey, DatabaseEntry data, LockMode lockMode, boolean secDirtyRead, boolean lockPrimaryOnly, boolean verifyPrimary, Locker locker, Database secDb, SecondaryAssociation secAssoc) {
        boolean dataRequested;
        boolean priDirtyRead = this.isReadUncommittedMode(lockMode);
        DatabaseImpl priDbImpl = priDb.getDbImpl();
        if (lockPrimaryOnly ? !$assertionsDisabled && (!secDirtyRead || priDirtyRead) : !$assertionsDisabled && secDirtyRead != priDirtyRead) {
            throw new AssertionError();
        }
        boolean bl = dataRequested = !data.getPartial() || data.getPartialLength() > 0;
        if (!dataRequested && !verifyPrimary) {
            data.setData(LogUtils.ZERO_LENGTH_BYTE_ARRAY);
            return true;
        }
        DatabaseEntry copyToPartialEntry = null;
        if (priDirtyRead && data.getPartial()) {
            copyToPartialEntry = data;
            data = new DatabaseEntry();
        }
        try (CursorImpl priCursor = new CursorImpl(priDbImpl, locker, true, false);){
            LockType priLockType = this.getLockType(lockMode, false);
            boolean dirtyReadAll = lockMode == LockMode.READ_UNCOMMITTED_ALL;
            CursorImpl.LockStanding priLockStanding = priCursor.searchExact(pKey, priLockType, dirtyReadAll, dataRequested);
            try {
                if (priLockStanding != null && priCursor.getCurrent(null, data) == null) {
                    priCursor.revertLock(priLockStanding);
                    priLockStanding = null;
                }
            }
            finally {
                priCursor.releaseBIN();
            }
            if (priLockStanding != null && lockPrimaryOnly && !this.ensureReferenceToPrimary(pKey, priLockType)) {
                priCursor.revertLock(priLockStanding);
                priLockStanding = null;
            }
            if (priLockStanding == null) {
                if (secDirtyRead || this.cursorImpl.isProbablyExpired()) {
                    boolean bl2 = false;
                    return bl2;
                }
                if (secAssoc != null) {
                    boolean stillExist = false;
                    for (SecondaryDatabase db : secAssoc.getSecondaries(pKey)) {
                        if (db != secDb) continue;
                        stillExist = true;
                        break;
                    }
                    if (!stillExist) {
                        boolean bl3 = false;
                        return bl3;
                    }
                }
                throw secDb.secondaryRefersToMissingPrimaryKey(locker, key, pKey, this.cursorImpl.getExpirationTime());
            }
            if (priDirtyRead && this.checkForPrimaryUpdate(key, pKey, data)) {
                boolean bl4 = false;
                return bl4;
            }
            if (copyToPartialEntry != null) {
                LN.setEntry(copyToPartialEntry, data.getData());
            }
            this.cursorImpl.setPriInfo(priCursor);
            priDbImpl.getEnv().incSearchOps(priDbImpl);
            boolean bl5 = true;
            return bl5;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean ensureReferenceToPrimary(DatabaseEntry matchPriKey, LockType lockType) {
        assert (lockType != LockType.NONE);
        this.cursorImpl.latchBIN();
        try {
            long expirationTime;
            BIN bin = this.cursorImpl.getBIN();
            int index = this.cursorImpl.getIndex();
            if (bin.isDeleted(index)) {
                boolean bl = false;
                return bl;
            }
            EnvironmentImpl envImpl = this.dbImpl.getEnv();
            if (envImpl.expiresWithin(expirationTime = TTL.expirationToSystemTime(bin.getExpiration(index), bin.isExpirationInHours()), envImpl.getTtlMaxTxnTime())) {
                this.cursorImpl.lockLN(lockType);
            }
        }
        finally {
            this.cursorImpl.releaseBIN();
        }
        if (!this.cursorImpl.hasDuplicates()) {
            DatabaseEntry secData = new DatabaseEntry();
            if (this.cursorImpl.lockAndGetCurrent(null, secData, LockType.NONE) == null) {
                return false;
            }
            if (!secData.equals(matchPriKey)) {
                return false;
            }
        }
        return true;
    }

    boolean checkForPrimaryUpdate(DatabaseEntry key, DatabaseEntry pKey, DatabaseEntry data) {
        return false;
    }

    private boolean haveSameDupPrefix(DatabaseEntry twoPartKey1, byte[] keyBytes2) {
        assert (twoPartKey1.getOffset() == 0);
        assert (twoPartKey1.getData().length == twoPartKey1.getSize());
        return DupKeyData.compareMainKey(twoPartKey1.getData(), keyBytes2, this.dbImpl.getBtreeComparator()) == 0;
    }

    private CursorImpl beginMoveCursor(boolean samePosition, boolean forceClone, CacheMode cacheMode) {
        assert (!forceClone || samePosition);
        this.cursorImpl.setCacheMode(cacheMode != null ? cacheMode : this.defaultCacheMode);
        if (this.cursorImpl.isNotInitialized()) {
            this.cursorImpl.criticalEviction();
            return this.cursorImpl;
        }
        if (this.nonSticky && !forceClone) {
            if (samePosition) {
                this.cursorImpl.beforeNonStickyOp();
            } else {
                this.cursorImpl.reset();
            }
            return this.cursorImpl;
        }
        CursorImpl dup = this.cursorImpl.cloneCursor(samePosition);
        dup.setClosingLocker(this.cursorImpl);
        return dup;
    }

    private CursorImpl beginMoveCursor(boolean samePosition, CacheMode cacheMode) {
        return this.beginMoveCursor(samePosition, false, cacheMode);
    }

    private void endMoveCursor(CursorImpl dup, boolean success) {
        dup.clearClosingLocker();
        if (dup == this.cursorImpl) {
            if (success) {
                this.cursorImpl.afterNonStickyOp();
            } else {
                this.cursorImpl.reset();
            }
        } else if (success) {
            this.cursorImpl.close(dup);
            this.cursorImpl = dup;
        } else {
            dup.close(this.cursorImpl);
        }
    }

    private void beginUseExistingCursor(CacheMode cacheMode) {
        this.cursorImpl.setCacheMode(cacheMode != null ? cacheMode : this.defaultCacheMode);
        this.cursorImpl.criticalEviction();
    }

    private void endUseExistingCursor() {
        this.cursorImpl.criticalEviction();
    }

    private void swapCursor(Cursor other) {
        CursorImpl otherImpl = other.cursorImpl;
        other.cursorImpl = this.cursorImpl;
        this.cursorImpl = otherImpl;
    }

    boolean advanceCursor(DatabaseEntry key, DatabaseEntry data) {
        return this.cursorImpl.advanceCursor(key, data);
    }

    private LockType getLockType(LockMode lockMode, boolean rangeLock) {
        if (this.isReadUncommittedMode(lockMode)) {
            return LockType.NONE;
        }
        if (lockMode == null || lockMode == LockMode.DEFAULT) {
            return rangeLock ? LockType.RANGE_READ : LockType.READ;
        }
        if (lockMode == LockMode.RMW) {
            return rangeLock ? LockType.RANGE_WRITE : LockType.WRITE;
        }
        if (lockMode == LockMode.READ_COMMITTED) {
            throw new IllegalArgumentException(lockMode.toString() + " not allowed with Cursor methods, use CursorConfig.setReadCommitted instead.");
        }
        assert (false) : lockMode;
        return LockType.NONE;
    }

    boolean isReadUncommittedMode(LockMode lockMode) {
        return lockMode == LockMode.READ_UNCOMMITTED || lockMode == LockMode.READ_UNCOMMITTED_ALL || this.readUncommittedDefault && (lockMode == null || lockMode == LockMode.DEFAULT);
    }

    boolean isSerializableIsolation(LockMode lockMode) {
        return this.serializableIsolationDefault && !this.isReadUncommittedMode(lockMode);
    }

    private void checkUpdatesAllowed(ExpirationInfo expInfo) {
        this.checkUpdatesAllowed();
        if (this.dbImpl.isReplicated() && expInfo != null && expInfo.expiration > 0) {
            this.dbImpl.getEnv().checkTTLAvailable();
        }
    }

    private void checkUpdatesAllowed() {
        String diskLimitViolation;
        if (this.updateOperationsProhibited) {
            throw this.updatesProhibitedException(this.cursorImpl.getLocker());
        }
        if (!this.dbImpl.getDbType().isInternal() && (diskLimitViolation = this.dbImpl.getEnv().getDiskLimitViolation()) != null) {
            throw new DiskLimitException(this.cursorImpl.getLocker(), diskLimitViolation);
        }
    }

    private UnsupportedOperationException updatesProhibitedException(Locker locker) {
        StringBuilder str = new StringBuilder(200);
        str.append("Write operation is not allowed because ");
        if (locker.isReadOnly()) {
            str.append("the Transaction is configured as read-only.");
        } else if (this.dbHandle != null && !this.dbHandle.isWritable()) {
            str.append("the Database is configured as read-only.");
        } else if (this.dbImpl.isTransactional() && !locker.isTransactional()) {
            str.append("a Transaction was not supplied to openCursor ");
            str.append("and the Database is transactional.");
        } else if (this.dbImpl.isReplicated() && locker.isLocalWrite()) {
            str.append("the Database is replicated and Transaction is ");
            str.append("configured as local-write.");
        } else if (!this.dbImpl.isReplicated() && !locker.isLocalWrite()) {
            str.append("the Database is not replicated and the ");
            str.append("Transaction is not configured as local-write.");
        } else assert (false);
        throw new UnsupportedOperationException(str.toString());
    }

    void checkState(boolean mustBeInitialized) {
        this.cursorImpl.checkCursorState(mustBeInitialized, false);
    }

    void checkOpenAndState(boolean mustBeInitialized) {
        this.checkEnv();
        this.checkOpen();
        this.checkState(mustBeInitialized);
    }

    void checkOpen() {
        this.checkEnv();
        if (this.dbHandle != null) {
            this.dbHandle.checkOpen();
        }
    }

    void checkEnv() {
        this.cursorImpl.checkEnv();
    }

    private Object getTxnSynchronizer() {
        return this.transaction != null ? this.transaction : this;
    }

    private void checkTxnState() {
        if (this.transaction == null) {
            return;
        }
        this.transaction.checkOpen();
        this.transaction.getTxn().checkState(false);
    }

    void trace(Level level, String methodName, String getOrPutType, DatabaseEntry key, DatabaseEntry data, LockMode lockMode) {
        if (this.logger.isLoggable(level)) {
            StringBuilder sb = new StringBuilder();
            sb.append(methodName);
            sb.append(getOrPutType);
            this.traceCursorImpl(sb);
            if (key != null) {
                sb.append(" key=").append(key.dumpData());
            }
            if (data != null) {
                sb.append(" data=").append(data.dumpData());
            }
            if (lockMode != null) {
                sb.append(" lockMode=").append((Object)lockMode);
            }
            LoggerUtils.logMsg(this.logger, this.dbImpl.getEnv(), level, sb.toString());
        }
    }

    void trace(Level level, String methodName, DatabaseEntry key, DatabaseEntry data, LockMode lockMode) {
        if (this.logger.isLoggable(level)) {
            StringBuilder sb = new StringBuilder();
            sb.append(methodName);
            this.traceCursorImpl(sb);
            if (key != null) {
                sb.append(" key=").append(key.dumpData());
            }
            if (data != null) {
                sb.append(" data=").append(data.dumpData());
            }
            if (lockMode != null) {
                sb.append(" lockMode=").append((Object)lockMode);
            }
            LoggerUtils.logMsg(this.logger, this.dbImpl.getEnv(), level, sb.toString());
        }
    }

    void trace(Level level, String methodName, LockMode lockMode) {
        if (this.logger.isLoggable(level)) {
            StringBuilder sb = new StringBuilder();
            sb.append(methodName);
            this.traceCursorImpl(sb);
            if (lockMode != null) {
                sb.append(" lockMode=").append((Object)lockMode);
            }
            LoggerUtils.logMsg(this.logger, this.dbImpl.getEnv(), level, sb.toString());
        }
    }

    private void traceCursorImpl(StringBuilder sb) {
        sb.append(" locker=").append(this.cursorImpl.getLocker().getId());
        sb.append(" bin=").append(this.cursorImpl.getCurrentNodeId());
        sb.append(" idx=").append(this.cursorImpl.getIndex());
    }

    private static DatabaseEntry cloneEntry(DatabaseEntry from) {
        DatabaseEntry to = new DatabaseEntry();
        Cursor.setEntry(from, to);
        return to;
    }

    private static void setEntry(DatabaseEntry from, DatabaseEntry to) {
        to.setPartial(from.getPartialOffset(), from.getPartialLength(), from.getPartial());
        to.setData(from.getData(), from.getOffset(), from.getSize());
    }

    static {
        NO_RETURN_DATA.setPartial(0, 0, true);
    }
}

