/**********************************************************************\
 © COPYRIGHT 2018 Corporation for National Research Initiatives (CNRI);
                        All rights reserved.

        The HANDLE.NET software is made available subject to the
      Handle.Net Public License Agreement, which may be obtained at
          http://hdl.handle.net/20.1000/112 or hdl:20.1000/112
\**********************************************************************/

package net.handle.apps.test;

import java.io.*;

import net.cnri.util.StreamTable;

/************************************************************************
 Used to call the client, server, and write tests
 *************************************************************************/
public class Test {
    private static File configDir;
    private static StreamTable configTable = new StreamTable();

    public static void printUsage() {
        System.err.println("USAGE_1: java -classpath <classpath> " + "net.handle.apps.test.Test" + " [server|all] <config.dct directory>");
        System.err.println("USAGE_2: java -classpath <classpath> " + "net.handle.apps.test.Test" + " client [prefix]");
    }

    // gets the location of config.dct
    public static void getConfig(String configDirStr) {
        try {
            configDir = new File(configDirStr);
            configTable.readFromFile(new File(configDir, "config.dct"));
        } catch (Exception e) {
            System.err.println("ERROR READING CONFIGURATION");
            System.exit(-1);
        }
        if (!configDir.exists() || !configDir.isDirectory()) {
            System.err.println("INVALID CONFIGURATION DIRECTORY");
            System.exit(-1);
        }
    }

    @SuppressWarnings("unused")
    public static void main(String argv[]) {
        if (argv == null || argv.length <= 0) {
            printUsage();
            System.exit(-1);
            return;
        }

        String inputStr = null;

        for (int i = 1; i < argv.length; i++)
            if (inputStr == null) inputStr = argv[i];

        String action = argv[0].toUpperCase().trim();

        if (inputStr == null && !action.equals("CLIENT")) {
            printUsage();
            System.exit(-1);
        }

        try {
            if (action.equals("CLIENT")) {
                System.out.println("*****Begin Client Test*****");
                ClientTest clientTester = new ClientTest();
                if (inputStr == null) //test global sites
                    ClientTest.testGlobalSites();
                else //test site corresponding to given prefix
                    ClientTest.testNASites(argv[1].toUpperCase().trim());
            }

            else if (action.equals("SERVER")) {
                getConfig(inputStr);
                System.out.println("*****Begin Server Test*****");
                ServerTest serverTester = new ServerTest(configTable, configDir);
            }

            else if (action.equals("ALL")) {
                getConfig(inputStr);
                System.out.println("\n******Begin Client Test******");
                ClientTest clientTester = new ClientTest();
                ClientTest.testGlobalSites();

                System.out.println("\n******Begin Server Test******");
                ServerTest serverTester = new ServerTest(configTable, configDir);

            } else {
                printUsage();
                System.exit(-1);
            }
        } catch (Exception e) {
            System.exit(-1);
        }
    }
}
