/**********************************************************************\
 © COPYRIGHT 2018 Corporation for National Research Initiatives (CNRI);
                        All rights reserved.

        The HANDLE.NET software is made available subject to the
      Handle.Net Public License Agreement, which may be obtained at
          http://hdl.handle.net/20.1000/112 or hdl:20.1000/112
\**********************************************************************/

package net.handle.apps.test;

import net.cnri.util.StreamTable;
import net.handle.apps.simple.SiteInfoConverter;
import net.handle.hdllib.*;

import java.io.*;

/*******************************************************************
 Tests local handle server
 - Tests each interface (TCP, HTTP, UDP)
 - Prints to screen if interface passed or failed
 *******************************************************************/
public class ServerTest {
    private static final String SITE_INFO_FILE = "siteinfo.bin";
    private static final String SITE_INFO_JSON_FILE = "siteinfo.json";

    private static HandleResolver resolver = new HandleResolver();

    public ServerTest(@SuppressWarnings("unused") StreamTable config, File configDir) {

        try {
            SiteInfo site;
            File siteInfoFile = new File(configDir, SITE_INFO_FILE);
            if (!siteInfoFile.exists() || !siteInfoFile.canRead()) {
                File siteInfoJsonFile = new File(configDir, SITE_INFO_JSON_FILE);
                if (!siteInfoJsonFile.exists() || !siteInfoJsonFile.canRead()) {
                    System.err.println("Missing or inaccessible site info file: " + siteInfoFile.getAbsolutePath() + "/" + siteInfoJsonFile.getName());
                    throw new Exception("Missing or inaccessible site info file: " + siteInfoFile.getAbsolutePath() + "/" + siteInfoJsonFile.getName());
                } else {
                    byte[] siteInfoBytes = Util.getBytesFromFile(siteInfoJsonFile);
                    try {
                        site = SiteInfoConverter.convertToSiteInfo(new String(siteInfoBytes, "UTF-8"));
                    } catch (Throwable t) {
                        System.err.println("Missing or inaccessible site info file: " + siteInfoFile.getAbsolutePath() + "/" + siteInfoJsonFile.getName());
                        throw new Exception("Missing or inaccessible site info file: " + siteInfoFile.getAbsolutePath() + "/" + siteInfoJsonFile.getName(), t);
                    }
                }
            } else {
                site = new SiteInfo();
                byte siteInfoBuf[] = new byte[(int) siteInfoFile.length()];
                InputStream in = new FileInputStream(siteInfoFile);
                try {
                    int r, n = 0;
                    while ((r = in.read(siteInfoBuf, n, siteInfoBuf.length - n)) > 0)
                        n += r;
                } finally {
                    in.close();
                }
                Encoder.decodeSiteInfoRecord(siteInfoBuf, 0, site);
            }

            Interface serverInterface;

            for (int j = 0; j < site.servers.length; j++) {
                System.out.println("SERVER: " + site.servers[j].getAddressString());

                //test each interface (TCP, HTTP, UDP)
                for (int k = 0; k < site.servers[j].interfaces.length; k++) {
                    serverInterface = site.servers[j].interfaces[k];

                    try {
                        GenericRequest req = new GenericRequest(Common.BLANK_HANDLE, AbstractMessage.OC_GET_SITE_INFO, null);
                        resolver.sendRequestToInterface(req, site.servers[j], serverInterface);

                        System.out.print(Interface.protocolName(serverInterface.protocol));
                        System.out.println(":" + serverInterface.port + "            ***PASS***");

                    } catch (HandleException t) {
                        System.err.println("Server: " + site.servers[j].getAddressString());
                        System.err.print(Interface.protocolName(serverInterface.protocol));
                        System.err.print(":" + serverInterface.port + "            ***FAIL***");
                        System.err.println("  " + HandleException.getCodeStr(t.getCode()));
                    }
                }
            }
        } catch (Exception e) {
            System.err.println("Invalid site/server specification");
            System.err.println("Test Failed");
            System.exit(-1);

        }
    }
}
