/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep.util;

import com.sleepycat.je.rep.NodeState;
import com.sleepycat.je.rep.ReplicationNetworkConfig;
import com.sleepycat.je.rep.ReplicationNode;
import com.sleepycat.je.rep.impl.BinaryNodeStateProtocol;
import com.sleepycat.je.rep.impl.node.NameIdPair;
import com.sleepycat.je.rep.net.DataChannel;
import com.sleepycat.je.rep.net.DataChannelFactory;
import com.sleepycat.je.rep.utilint.BinaryProtocol;
import com.sleepycat.je.rep.utilint.ServiceDispatcher;
import com.sleepycat.je.rep.utilint.net.DataChannelFactoryBuilder;
import com.sleepycat.je.utilint.CmdUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.Channel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.StringTokenizer;

public class DbPing {
    private String nodeName;
    private String groupName;
    private InetSocketAddress socketAddress;
    private int socketTimeout = 10000;
    private DataChannelFactory channelFactory;
    private static final String undocumentedUsageString = "  -netProps <optional>    # name of a property file containing\n                             # properties needed for replication\n                             # service access\n";
    private static final String usageString = "Usage: " + CmdUtil.getJavaCommand(DbPing.class) + "\n  -nodeName <node name>      # name of the node whose state is\n                             # requested\n  -groupName <group name>    # name of the group which the node\n                             # joins\n  -nodeHost <host:port>      # the host name and port pair the\n                             # node used to join the group\n  -socketTimeout <optional>  # the timeout value for creating a\n                             # socket connection with the node,\n                             # default is 10 seconds if not set";

    public static void main(String[] args) throws Exception {
        DbPing ping = new DbPing();
        ping.parseArgs(args);
        System.out.println(ping.getNodeState());
    }

    private void printUsage(String msg) {
        if (msg != null) {
            System.err.println(msg);
        }
        System.err.println(usageString);
        System.exit(-1);
    }

    private void parseArgs(String[] argv) {
        int argc = 0;
        int nArgs = argv.length;
        String netPropsName = null;
        if (nArgs == 0) {
            this.printUsage(null);
        }
        while (argc < nArgs) {
            String thisArg;
            if ((thisArg = argv[argc++]).equals("-nodeName")) {
                if (argc < nArgs) {
                    this.nodeName = argv[argc++];
                    continue;
                }
                this.printUsage("-nodeName requires an argument");
                continue;
            }
            if (thisArg.equals("-groupName")) {
                if (argc < nArgs) {
                    this.groupName = argv[argc++];
                    continue;
                }
                this.printUsage("-groupName requires an argument");
                continue;
            }
            if (thisArg.equals("-nodeHost")) {
                if (argc < nArgs) {
                    StringTokenizer st;
                    if ((st = new StringTokenizer(argv[argc++], ":")).countTokens() != 2) {
                        this.printUsage("Argument for -nodeHost is not valid.");
                    }
                    try {
                        this.socketAddress = new InetSocketAddress(st.nextToken(), Integer.parseInt(st.nextToken()));
                    }
                    catch (NumberFormatException e) {
                        this.printUsage("the port of -nodeHost is not valid");
                    }
                    continue;
                }
                this.printUsage("-nodeHost requires an argument");
                continue;
            }
            if (thisArg.equals("-socketTimeout")) {
                if (argc < nArgs) {
                    try {
                        this.socketTimeout = Integer.parseInt(argv[argc++]);
                    }
                    catch (NumberFormatException e) {
                        this.printUsage("Argument for -socketTimeout is not valid");
                    }
                    continue;
                }
                this.printUsage("-socketTimeout requires an argument");
                continue;
            }
            if (thisArg.equals("-netProps")) {
                if (argc < nArgs) {
                    netPropsName = argv[argc++];
                    continue;
                }
                this.printUsage("-netProps requires an argument");
                continue;
            }
            this.printUsage(thisArg + " is not a valid argument");
        }
        if (this.socketTimeout <= 0) {
            this.printUsage("-socketTimeout requires a positive integer number");
        }
        ReplicationNetworkConfig repNetConfig = ReplicationNetworkConfig.createDefault();
        if (netPropsName != null) {
            try {
                repNetConfig = ReplicationNetworkConfig.create(new File(netPropsName));
            }
            catch (FileNotFoundException fnfe) {
                this.printUsage("The net properties file " + netPropsName + " does not exist: " + fnfe.getMessage());
            }
            catch (IllegalArgumentException iae) {
                this.printUsage("The net properties file " + netPropsName + " is not valid: " + iae.getMessage());
            }
        }
        if (this.nodeName == null || this.groupName == null || this.socketAddress == null) {
            this.printUsage("Node name, group name and the node host port are mandatory arguments, please configure.");
        }
        this.channelFactory = DbPing.initializeFactory(repNetConfig, this.nodeName);
    }

    private DbPing() {
    }

    public DbPing(ReplicationNode repNode, String groupName, int socketTimeout) {
        this(repNode, groupName, socketTimeout, (ReplicationNetworkConfig)null);
    }

    public DbPing(ReplicationNode repNode, String groupName, int socketTimeout, File netPropsFile) throws FileNotFoundException, IllegalArgumentException {
        this(repNode, groupName, socketTimeout, DbPing.makeRepNetConfig(netPropsFile));
    }

    public DbPing(ReplicationNode repNode, String groupName, int socketTimeout, ReplicationNetworkConfig netConfig) {
        this(repNode, groupName, socketTimeout, DbPing.initializeFactory(netConfig, repNode.getName()));
    }

    public DbPing(ReplicationNode repNode, String groupName, int socketTimeout, DataChannelFactory channelFactory) {
        this.nodeName = repNode.getName();
        this.groupName = groupName;
        this.socketAddress = repNode.getSocketAddress();
        this.socketTimeout = socketTimeout;
        this.channelFactory = channelFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodeState getNodeState() throws IOException, ServiceDispatcher.ServiceConnectFailedException {
        BinaryNodeStateProtocol protocol = new BinaryNodeStateProtocol(NameIdPair.NOCHECK, null);
        try (Channel channel = null;){
            channel = this.channelFactory.connect(this.socketAddress, new DataChannelFactory.ConnectOptions().setTcpNoDelay(true).setOpenTimeout(this.socketTimeout).setReadTimeout(this.socketTimeout));
            ServiceDispatcher.doServiceHandshake((DataChannel)channel, "BinaryNodeState");
            BinaryNodeStateProtocol binaryNodeStateProtocol = protocol;
            binaryNodeStateProtocol.getClass();
            protocol.write((BinaryProtocol.Message)binaryNodeStateProtocol.new BinaryNodeStateProtocol.BinaryNodeStateRequest(this.nodeName, this.groupName), (WritableByteChannel)channel);
            BinaryNodeStateProtocol.BinaryNodeStateResponse response = protocol.read((ReadableByteChannel)channel, BinaryNodeStateProtocol.BinaryNodeStateResponse.class);
            NodeState nodeState = response.convertToNodeState();
            return nodeState;
        }
    }

    private static ReplicationNetworkConfig makeRepNetConfig(File propFile) throws FileNotFoundException {
        if (propFile == null) {
            return ReplicationNetworkConfig.createDefault();
        }
        return ReplicationNetworkConfig.create(propFile);
    }

    private static DataChannelFactory initializeFactory(ReplicationNetworkConfig repNetConfig, String logContext) {
        if (repNetConfig == null) {
            repNetConfig = ReplicationNetworkConfig.createDefault();
        }
        return DataChannelFactoryBuilder.construct(repNetConfig, logContext);
    }
}

