/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.dbi;

import com.sleepycat.je.CacheMode;
import com.sleepycat.je.CheckpointConfig;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.DbInternal;
import com.sleepycat.je.DiskLimitException;
import com.sleepycat.je.Environment;
import com.sleepycat.je.EnvironmentConfig;
import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.EnvironmentLockedException;
import com.sleepycat.je.EnvironmentMutableConfig;
import com.sleepycat.je.EnvironmentNotFoundException;
import com.sleepycat.je.EnvironmentStats;
import com.sleepycat.je.EnvironmentWedgedException;
import com.sleepycat.je.ExceptionListener;
import com.sleepycat.je.LockStats;
import com.sleepycat.je.OperationFailureException;
import com.sleepycat.je.PreloadConfig;
import com.sleepycat.je.PreloadStats;
import com.sleepycat.je.PreloadStatus;
import com.sleepycat.je.ProgressListener;
import com.sleepycat.je.RecoveryProgress;
import com.sleepycat.je.ReplicaConsistencyPolicy;
import com.sleepycat.je.StatsConfig;
import com.sleepycat.je.Transaction;
import com.sleepycat.je.TransactionConfig;
import com.sleepycat.je.TransactionStats;
import com.sleepycat.je.VerifyConfig;
import com.sleepycat.je.VersionMismatchException;
import com.sleepycat.je.cleaner.Cleaner;
import com.sleepycat.je.cleaner.ExpirationProfile;
import com.sleepycat.je.cleaner.FileProtector;
import com.sleepycat.je.cleaner.UtilizationProfile;
import com.sleepycat.je.cleaner.UtilizationTracker;
import com.sleepycat.je.config.EnvironmentParams;
import com.sleepycat.je.dbi.DatabaseId;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.DbConfigManager;
import com.sleepycat.je.dbi.DbEnvPool;
import com.sleepycat.je.dbi.DbEnvState;
import com.sleepycat.je.dbi.DbTree;
import com.sleepycat.je.dbi.DbiStatDefinition;
import com.sleepycat.je.dbi.EnvConfigObserver;
import com.sleepycat.je.dbi.EnvironmentFailureReason;
import com.sleepycat.je.dbi.INList;
import com.sleepycat.je.dbi.MemoryBudget;
import com.sleepycat.je.dbi.NodeSequence;
import com.sleepycat.je.dbi.RepConfigProxy;
import com.sleepycat.je.dbi.SortedLSNTreeWalker;
import com.sleepycat.je.dbi.StartupTracker;
import com.sleepycat.je.dbi.TTL;
import com.sleepycat.je.evictor.Evictor;
import com.sleepycat.je.evictor.OffHeapCache;
import com.sleepycat.je.incomp.INCompressor;
import com.sleepycat.je.latch.Latch;
import com.sleepycat.je.latch.LatchFactory;
import com.sleepycat.je.latch.LatchSupport;
import com.sleepycat.je.log.FileManager;
import com.sleepycat.je.log.LogEntryHeader;
import com.sleepycat.je.log.LogEntryType;
import com.sleepycat.je.log.LogFlusher;
import com.sleepycat.je.log.LogItem;
import com.sleepycat.je.log.Provisional;
import com.sleepycat.je.log.ReplicationContext;
import com.sleepycat.je.log.Trace;
import com.sleepycat.je.log.entry.LogEntry;
import com.sleepycat.je.log.entry.RestoreRequired;
import com.sleepycat.je.log.entry.SingleItemEntry;
import com.sleepycat.je.log.entry.TraceLogEntry;
import com.sleepycat.je.recovery.Checkpointer;
import com.sleepycat.je.recovery.RecoveryInfo;
import com.sleepycat.je.recovery.RecoveryManager;
import com.sleepycat.je.recovery.VLSNRecoveryProxy;
import com.sleepycat.je.statcap.EnvStatsLogger;
import com.sleepycat.je.statcap.StatCapture;
import com.sleepycat.je.statcap.StatCaptureDefinitions;
import com.sleepycat.je.statcap.StatManager;
import com.sleepycat.je.tree.BIN;
import com.sleepycat.je.tree.BINReference;
import com.sleepycat.je.tree.IN;
import com.sleepycat.je.tree.LN;
import com.sleepycat.je.tree.Node;
import com.sleepycat.je.tree.dupConvert.DupConvert;
import com.sleepycat.je.txn.LockType;
import com.sleepycat.je.txn.LockUpgrade;
import com.sleepycat.je.txn.Locker;
import com.sleepycat.je.txn.ThreadLocker;
import com.sleepycat.je.txn.Txn;
import com.sleepycat.je.txn.TxnManager;
import com.sleepycat.je.util.ConsoleHandler;
import com.sleepycat.je.util.DbBackup;
import com.sleepycat.je.util.FileHandler;
import com.sleepycat.je.util.verify.BtreeVerifier;
import com.sleepycat.je.util.verify.DataVerifier;
import com.sleepycat.je.util.verify.VerifierUtils;
import com.sleepycat.je.utilint.AtomicLongStat;
import com.sleepycat.je.utilint.DbLsn;
import com.sleepycat.je.utilint.LoggerUtils;
import com.sleepycat.je.utilint.LongStat;
import com.sleepycat.je.utilint.StatDefinition;
import com.sleepycat.je.utilint.StatGroup;
import com.sleepycat.je.utilint.TestHook;
import com.sleepycat.je.utilint.TestHookExecute;
import com.sleepycat.je.utilint.TracerFormatter;
import com.sleepycat.je.utilint.VLSN;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.SortedSet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;

public class EnvironmentImpl
implements EnvConfigObserver {
    private static final boolean TEST_NO_LOCKING_MODE = false;
    private volatile DbEnvState envState;
    private volatile boolean closing;
    private final File envHome;
    private final AtomicInteger openCount = new AtomicInteger(0);
    private final AtomicInteger backupCount = new AtomicInteger(0);
    private boolean isTransactional;
    private boolean isNoLocking;
    private boolean isReadOnly;
    private boolean isMemOnly;
    private boolean sharedCache;
    private boolean dbEviction;
    private boolean useOffHeapChecksums;
    private boolean expirationEnabled;
    private boolean exposeUserData;
    private boolean allowBlindOps = false;
    private boolean allowBlindPuts = false;
    private int maxEmbeddedLN = -1;
    private CacheMode cacheMode;
    private boolean initializedSuccessfully = false;
    protected boolean needRepConvert = false;
    private MemoryBudget memoryBudget;
    private static int adler32ChunkSize;
    private long lockTimeout;
    private long txnTimeout;
    private boolean deadlockDetection;
    private long deadlockDetectionDelay;
    protected DbTree dbMapTree;
    private long mapTreeRootLsn = -1L;
    private final Latch mapTreeRootLatch;
    private final INList inMemoryINs;
    protected DbConfigManager configManager;
    private final List<EnvConfigObserver> configObservers;
    protected final Logger envLogger;
    private final com.sleepycat.je.log.LogManager logManager;
    private final LogFlusher logFlusher;
    private final DataVerifier dataVerifier;
    private final FileManager fileManager;
    private final TxnManager txnManager;
    protected final StatManager statManager;
    private final Evictor evictor;
    private final OffHeapCache offHeapCache;
    private final INCompressor inCompressor;
    private final Checkpointer checkpointer;
    private final Cleaner cleaner;
    private final StatCapture statCapture;
    protected final StartupTracker startupTracker;
    private static boolean forcedYield;
    private final ReentrantReadWriteLock secondaryAssociationLock;
    private ExceptionListener exceptionListener = null;
    private ProgressListener<RecoveryProgress> recoveryProgressListener = null;
    private ClassLoader classLoader = null;
    private PreloadConfig dupConvertPreloadConfig = null;
    private volatile int backgroundSleepBacklog;
    private volatile int backgroundReadLimit;
    private volatile int backgroundWriteLimit;
    private long backgroundSleepInterval;
    private int backgroundReadCount;
    private long backgroundWriteBytes;
    private TestHook<?> backgroundSleepHook;
    private final Object backgroundTrackingMutex = new Object();
    private final Object backgroundSleepMutex = new Object();
    private static int threadLocalReferenceCount;
    private boolean didFullThreadDump = false;
    private boolean noComparators = false;
    private final EnvironmentFailureException preallocatedEFE = EnvironmentFailureException.makeJavaErrorWrapper();
    private final AtomicReference<EnvironmentFailureException> invalidatingEFE = new AtomicReference();
    private final AtomicReference<EnvironmentWedgedException> wedgedEFE = new AtomicReference();
    public static final boolean USE_JAVA5_ADLER32;
    private static final String DISABLE_JAVA_ADLER32_NAME = "je.disable.java.adler32";
    private static final String REGISTER_MONITOR = "JEMonitor";
    private volatile boolean isMBeanRegistered = false;
    private static final String INFO_FILES = "je.info";
    private static final int FILEHANDLER_LIMIT = 10000000;
    private static final int FILEHANDLER_COUNT = 10;
    private final java.util.logging.ConsoleHandler consoleHandler;
    private final java.util.logging.FileHandler fileHandler;
    private final Handler configuredHandler;
    private boolean dbLoggingDisabled;
    protected final Formatter formatter;
    protected Environment envInternal;
    private final Object statSynchronizer = new Object();
    protected Integer statKey;
    private long creationTime;
    private final ArrayList<MBeanRegistrar> mBeanRegList = new ArrayList();
    private final NodeSequence nodeSequence;
    private final StatGroup envStats;
    private LongStat relatchesRequired;
    private final StatGroup thrputStats;
    private final AtomicLongStat priSearchOps;
    private final AtomicLongStat priSearchFailOps;
    private final AtomicLongStat secSearchOps;
    private final AtomicLongStat secSearchFailOps;
    private final AtomicLongStat priPositionOps;
    private final AtomicLongStat secPositionOps;
    private final AtomicLongStat priInsertOps;
    private final AtomicLongStat priInsertFailOps;
    private final AtomicLongStat secInsertOps;
    private final AtomicLongStat priUpdateOps;
    private final AtomicLongStat secUpdateOps;
    private final AtomicLongStat priDeleteOps;
    private final AtomicLongStat priDeleteFailOps;
    private final AtomicLongStat secDeleteOps;
    private final AtomicLongStat binDeltaGets;
    private final AtomicLongStat binDeltaInserts;
    private final AtomicLongStat binDeltaUpdates;
    private final AtomicLongStat binDeltaDeletes;
    private EnvStatsLogger envStatLogger = null;
    private final String optionalNodeName;
    private int compactMaxKeyLength;
    private int latchTimeoutMs;
    private int ttlClockTolerance;
    private int ttlMaxTxnTime;
    private int ttlLnPurgeDelay;
    private static final HaltPreloadException TIME_EXCEEDED_PRELOAD_EXCEPTION;
    private static final HaltPreloadException MEMORY_EXCEEDED_PRELOAD_EXCEPTION;
    private static final HaltPreloadException USER_HALT_REQUEST_PRELOAD_EXCEPTION;

    public EnvironmentImpl(File envHome, EnvironmentConfig envConfig, EnvironmentImpl sharedCacheEnv) throws EnvironmentNotFoundException, EnvironmentLockedException {
        this(envHome, envConfig, sharedCacheEnv, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected EnvironmentImpl(File envHome, EnvironmentConfig envConfig, EnvironmentImpl sharedCacheEnv, RepConfigProxy repConfigProxy) throws EnvironmentNotFoundException, EnvironmentLockedException {
        boolean success = false;
        this.startupTracker = new StartupTracker(this);
        this.startupTracker.start(StartupTracker.Phase.TOTAL_ENV_OPEN);
        try {
            this.envHome = envHome;
            this.envState = DbEnvState.INIT;
            this.mapTreeRootLatch = LatchFactory.createExclusiveLatch(this, "MapTreeRoot", false);
            this.envStats = new StatGroup("Environment", "Miscellaneous environment wide statistics.");
            this.relatchesRequired = new LongStat(this.envStats, DbiStatDefinition.ENV_RELATCHES_REQUIRED);
            this.creationTime = System.currentTimeMillis();
            this.binDeltaGets = new AtomicLongStat(this.envStats, DbiStatDefinition.ENV_BIN_DELTA_GETS);
            this.binDeltaInserts = new AtomicLongStat(this.envStats, DbiStatDefinition.ENV_BIN_DELTA_INSERTS);
            this.binDeltaUpdates = new AtomicLongStat(this.envStats, DbiStatDefinition.ENV_BIN_DELTA_UPDATES);
            this.binDeltaDeletes = new AtomicLongStat(this.envStats, DbiStatDefinition.ENV_BIN_DELTA_DELETES);
            this.thrputStats = new StatGroup("Op", "Throughput statistics for JE calls.");
            this.priSearchOps = new AtomicLongStat(this.thrputStats, DbiStatDefinition.THROUGHPUT_PRI_SEARCH);
            this.priSearchFailOps = new AtomicLongStat(this.thrputStats, DbiStatDefinition.THROUGHPUT_PRI_SEARCH_FAIL);
            this.secSearchOps = new AtomicLongStat(this.thrputStats, DbiStatDefinition.THROUGHPUT_SEC_SEARCH);
            this.secSearchFailOps = new AtomicLongStat(this.thrputStats, DbiStatDefinition.THROUGHPUT_SEC_SEARCH_FAIL);
            this.priPositionOps = new AtomicLongStat(this.thrputStats, DbiStatDefinition.THROUGHPUT_PRI_POSITION);
            this.secPositionOps = new AtomicLongStat(this.thrputStats, DbiStatDefinition.THROUGHPUT_SEC_POSITION);
            this.priInsertOps = new AtomicLongStat(this.thrputStats, DbiStatDefinition.THROUGHPUT_PRI_INSERT);
            this.priInsertFailOps = new AtomicLongStat(this.thrputStats, DbiStatDefinition.THROUGHPUT_PRI_INSERT_FAIL);
            this.secInsertOps = new AtomicLongStat(this.thrputStats, DbiStatDefinition.THROUGHPUT_SEC_INSERT);
            this.priUpdateOps = new AtomicLongStat(this.thrputStats, DbiStatDefinition.THROUGHPUT_PRI_UPDATE);
            this.secUpdateOps = new AtomicLongStat(this.thrputStats, DbiStatDefinition.THROUGHPUT_SEC_UPDATE);
            this.priDeleteOps = new AtomicLongStat(this.thrputStats, DbiStatDefinition.THROUGHPUT_PRI_DELETE);
            this.priDeleteFailOps = new AtomicLongStat(this.thrputStats, DbiStatDefinition.THROUGHPUT_PRI_DELETE_FAIL);
            this.secDeleteOps = new AtomicLongStat(this.thrputStats, DbiStatDefinition.THROUGHPUT_SEC_DELETE);
            this.configManager = this.initConfigManager(envConfig, repConfigProxy);
            this.configObservers = new ArrayList<EnvConfigObserver>();
            this.addConfigObserver(this);
            this.initConfigParams(envConfig, repConfigProxy);
            this.formatter = this.initFormatter();
            this.consoleHandler = new ConsoleHandler(this.formatter, this);
            this.fileHandler = this.initFileHandler();
            this.configuredHandler = envConfig.getLoggingHandler();
            this.envLogger = LoggerUtils.getLogger(this.getClass());
            this.memoryBudget = new MemoryBudget(this, sharedCacheEnv, this.configManager);
            this.fileManager = new FileManager(this, envHome, this.isReadOnly);
            if (!(envConfig.getAllowCreate() || this.fileManager.filesExist() || this.configManager.getBoolean(EnvironmentParams.ENV_SETUP_LOGGER))) {
                throw new EnvironmentNotFoundException(this, "Home directory: " + envHome);
            }
            this.optionalNodeName = envConfig.getNodeName();
            this.logManager = new com.sleepycat.je.log.LogManager(this, this.isReadOnly);
            this.inMemoryINs = new INList(this);
            this.txnManager = new TxnManager(this);
            this.statManager = this.createStatManager();
            if (sharedCacheEnv != null) {
                assert (this.sharedCache);
                this.evictor = sharedCacheEnv.evictor;
                this.offHeapCache = sharedCacheEnv.offHeapCache;
            } else {
                this.evictor = new Evictor(this);
                this.offHeapCache = new OffHeapCache(this);
            }
            this.checkpointer = new Checkpointer(this, Checkpointer.getWakeupPeriod(this.configManager), "Checkpointer");
            this.inCompressor = new INCompressor(this, this.configManager.getDuration(EnvironmentParams.COMPRESSOR_WAKEUP_INTERVAL), "INCompressor");
            this.cleaner = new Cleaner(this, "Cleaner");
            this.statCapture = new StatCapture(this, "StatCapture", this.configManager.getDuration(EnvironmentParams.STATS_COLLECT_INTERVAL), envConfig.getCustomStats(), this.getStatCaptureProjections(), this.statManager);
            this.logFlusher = new LogFlusher(this);
            this.dataVerifier = new DataVerifier(this);
            this.nodeSequence = new NodeSequence(this);
            this.dbMapTree = new DbTree(this, this.isReplicated(), this.getPreserveVLSN());
            this.secondaryAssociationLock = new ReentrantReadWriteLock(false);
            this.nodeSequence.initRealNodeId();
            this.statKey = this.statManager.registerStatContext();
            if (!this.isReadOnly() && !this.isMemOnly() && this.configManager.getBoolean(EnvironmentParams.STATS_COLLECT)) {
                this.envStatLogger = new EnvStatsLogger(this);
                this.addConfigObserver(this.envStatLogger);
                this.envStatLogger.log();
            }
            success = true;
        }
        finally {
            if (!success) {
                this.clearFileManager();
                this.closeHandlers();
            }
        }
    }

    protected DbConfigManager initConfigManager(EnvironmentConfig envConfig, RepConfigProxy repParams) {
        return new DbConfigManager(envConfig);
    }

    protected void initConfigParams(EnvironmentConfig envConfig, RepConfigProxy repConfigProxy) {
        forcedYield = this.configManager.getBoolean(EnvironmentParams.ENV_FORCED_YIELD);
        this.isTransactional = this.configManager.getBoolean(EnvironmentParams.ENV_INIT_TXN);
        boolean bl = this.isNoLocking = !this.configManager.getBoolean(EnvironmentParams.ENV_INIT_LOCKING);
        if (this.isTransactional && this.isNoLocking) {
            throw new IllegalArgumentException("Can't set 'je.env.isNoLocking' and 'je.env.isTransactional';");
        }
        this.isReadOnly = this.configManager.getBoolean(EnvironmentParams.ENV_RDONLY);
        this.isMemOnly = this.configManager.getBoolean(EnvironmentParams.LOG_MEMORY_ONLY);
        this.dbEviction = this.configManager.getBoolean(EnvironmentParams.ENV_DB_EVICTION);
        this.useOffHeapChecksums = this.configManager.getBoolean(EnvironmentParams.OFFHEAP_CHECKSUM);
        adler32ChunkSize = this.configManager.getInt(EnvironmentParams.ADLER32_CHUNK_SIZE);
        this.sharedCache = this.configManager.getBoolean(EnvironmentParams.ENV_SHARED_CACHE);
        this.dbLoggingDisabled = !this.configManager.getBoolean(EnvironmentParams.JE_LOGGING_DBLOG);
        this.compactMaxKeyLength = this.configManager.getInt(EnvironmentParams.TREE_COMPACT_MAX_KEY_LENGTH);
        this.latchTimeoutMs = this.configManager.getDuration(EnvironmentParams.ENV_LATCH_TIMEOUT);
        this.ttlClockTolerance = this.configManager.getDuration(EnvironmentParams.ENV_TTL_CLOCK_TOLERANCE);
        this.ttlMaxTxnTime = this.configManager.getDuration(EnvironmentParams.ENV_TTL_MAX_TXN_TIME);
        this.ttlLnPurgeDelay = this.configManager.getDuration(EnvironmentParams.ENV_TTL_LN_PURGE_DELAY);
        this.allowBlindOps = this.configManager.getBoolean(EnvironmentParams.BIN_DELTA_BLIND_OPS);
        this.allowBlindPuts = this.configManager.getBoolean(EnvironmentParams.BIN_DELTA_BLIND_PUTS);
        this.maxEmbeddedLN = this.configManager.getInt(EnvironmentParams.TREE_MAX_EMBEDDED_LN);
        this.deadlockDetection = this.configManager.getBoolean(EnvironmentParams.LOCK_DEADLOCK_DETECT);
        this.deadlockDetectionDelay = this.configManager.getDuration(EnvironmentParams.LOCK_DEADLOCK_DETECT_DELAY);
        this.recoveryProgressListener = envConfig.getRecoveryProgressListener();
        this.classLoader = envConfig.getClassLoader();
        this.dupConvertPreloadConfig = envConfig.getDupConvertPreloadConfig();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean finishInit(EnvironmentConfig envConfig) throws DatabaseException {
        if (this.initializedSuccessfully) {
            return false;
        }
        boolean success = false;
        try {
            boolean doRecovery = this.configManager.getBoolean(EnvironmentParams.ENV_RECOVERY);
            if (doRecovery) {
                boolean recoverySuccess = false;
                try {
                    RecoveryManager recoveryManager = new RecoveryManager(this);
                    recoveryManager.recover(this.isReadOnly);
                    this.postRecoveryConversion();
                    recoverySuccess = true;
                }
                finally {
                    block19: {
                        try {
                            this.logManager.flushSync();
                            this.fileManager.clear();
                        }
                        catch (IOException e) {
                            if (recoverySuccess) {
                                throw new EnvironmentFailureException(this, EnvironmentFailureReason.LOG_INTEGRITY, (Throwable)e);
                            }
                        }
                        catch (Exception e) {
                            if (!recoverySuccess) break block19;
                            throw EnvironmentFailureException.unexpectedException(this, e);
                        }
                    }
                }
            }
            this.isReadOnly = true;
            if (!this.configManager.getBoolean(EnvironmentParams.ENV_COMPARATORS_REQUIRED)) {
                this.noComparators = true;
            }
            this.lockTimeout = this.configManager.getDuration(EnvironmentParams.LOCK_TIMEOUT);
            this.txnTimeout = this.configManager.getDuration(EnvironmentParams.TXN_TIMEOUT);
            this.memoryBudget.initCacheMemoryUsage(this.dbMapTree.getTreeAdminMemory());
            this.envConfigUpdate(this.configManager, envConfig);
            this.initializedSuccessfully = true;
            if (doRecovery) {
                this.convertDupDatabases();
                this.envInternal = this.createInternalEnvironment();
            }
            this.open();
            this.runOrPauseDaemons(this.configManager);
            success = true;
            boolean bl = true;
            return bl;
        }
        finally {
            if (!success) {
                this.clearFileManager();
                this.closeHandlers();
            }
            if (!success && this.sharedCache) {
                this.evictor.removeSharedCacheEnv(this);
            }
            this.startupTracker.stop(StartupTracker.Phase.TOTAL_ENV_OPEN);
            this.startupTracker.setProgress(RecoveryProgress.RECOVERY_FINISHED);
        }
    }

    protected Environment createInternalEnvironment() {
        return new InternalEnvironment(this.getEnvironmentHome(), this.cloneConfig(), this);
    }

    public synchronized void registerMBean(Environment env) throws DatabaseException {
        if (!this.isMBeanRegistered) {
            if (System.getProperty(REGISTER_MONITOR) != null) {
                this.doRegisterMBean(this.getMonitorClassName(), env);
                this.doRegisterMBean(this.getDiagnosticsClassName(), env);
            }
            this.isMBeanRegistered = true;
        }
    }

    protected String getMonitorClassName() {
        return "com.sleepycat.je.jmx.JEMonitor";
    }

    protected String getDiagnosticsClassName() {
        return "com.sleepycat.je.jmx.JEDiagnostics";
    }

    public ReplicaConsistencyPolicy getDefaultConsistencyPolicy() {
        return null;
    }

    public long getEndOfLog() {
        return this.fileManager.getLastUsedLsn();
    }

    public Collection<StatGroup> getRepStatGroups(StatsConfig config, Integer statkey) {
        throw new UnsupportedOperationException("Standalone Environment doesn't support replication statistics.");
    }

    public SortedSet<String> getStatCaptureProjections() {
        return new StatCaptureDefinitions().getStatisticProjections();
    }

    public StatManager createStatManager() {
        return new StatManager(this);
    }

    private void doRegisterMBean(String className, Environment env) throws DatabaseException {
        try {
            Class<?> newClass = Class.forName(className);
            MBeanRegistrar mBeanReg = (MBeanRegistrar)newClass.newInstance();
            mBeanReg.doRegister(env);
            this.mBeanRegList.add(mBeanReg);
        }
        catch (Exception e) {
            throw new EnvironmentFailureException(DbInternal.getNonNullEnvImpl(env), EnvironmentFailureReason.MONITOR_REGISTRATION, (Throwable)e);
        }
    }

    private synchronized void unregisterMBean() throws Exception {
        for (MBeanRegistrar mBeanReg : this.mBeanRegList) {
            mBeanReg.doUnregister();
        }
    }

    private void clearFileManager() throws DatabaseException {
        if (this.fileManager == null) {
            return;
        }
        try {
            this.fileManager.clear();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.fileManager.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void envConfigUpdate(DbConfigManager mgr, EnvironmentMutableConfig newConfig) {
        this.backgroundReadLimit = mgr.getInt(EnvironmentParams.ENV_BACKGROUND_READ_LIMIT);
        this.backgroundWriteLimit = mgr.getInt(EnvironmentParams.ENV_BACKGROUND_WRITE_LIMIT);
        this.backgroundSleepInterval = mgr.getDuration(EnvironmentParams.ENV_BACKGROUND_SLEEP_INTERVAL);
        if (newConfig.isConfigParamSet("com.sleepycat.je.util.ConsoleHandler.level")) {
            Level newConsoleHandlerLevel = Level.parse(mgr.get(EnvironmentParams.JE_CONSOLE_LEVEL));
            this.consoleHandler.setLevel(newConsoleHandlerLevel);
        }
        if (newConfig.isConfigParamSet("com.sleepycat.je.util.FileHandler.level")) {
            Level newFileHandlerLevel = Level.parse(mgr.get(EnvironmentParams.JE_FILE_LEVEL));
            if (this.fileHandler != null) {
                this.fileHandler.setLevel(newFileHandlerLevel);
            }
        }
        this.exceptionListener = newConfig.getExceptionListener();
        this.cacheMode = newConfig.getCacheMode();
        this.expirationEnabled = mgr.getBoolean(EnvironmentParams.ENV_EXPIRATION_ENABLED);
        this.exposeUserData = mgr.getBoolean(EnvironmentParams.ENV_EXPOSE_USER_DATA);
        if (mgr.getBoolean(EnvironmentParams.STATS_COLLECT)) {
            if (this.envStatLogger == null && !this.isReadOnly() && !this.isMemOnly()) {
                this.envStatLogger = new EnvStatsLogger(this);
                this.addConfigObserver(this.envStatLogger);
                this.envStatLogger.log();
            }
        } else {
            if (this.envStatLogger != null) {
                this.removeConfigObserver(this.envStatLogger);
            }
            this.envStatLogger = null;
        }
        if (this.isValid()) {
            this.runOrPauseDaemons(mgr);
        }
    }

    private void runOrPauseDaemons(DbConfigManager mgr) {
        if (this.isReadOnly) {
            return;
        }
        this.inCompressor.runOrPause(mgr.getBoolean(EnvironmentParams.ENV_RUN_INCOMPRESSOR));
        this.cleaner.runOrPause(mgr.getBoolean(EnvironmentParams.ENV_RUN_CLEANER) && !this.isMemOnly);
        this.checkpointer.runOrPause(mgr.getBoolean(EnvironmentParams.ENV_RUN_CHECKPOINTER));
        this.statCapture.runOrPause(mgr.getBoolean(EnvironmentParams.STATS_COLLECT));
        this.logFlusher.configFlushTask(mgr);
        this.dataVerifier.configVerifyTask(mgr);
    }

    public INCompressor getINCompressor() {
        return this.inCompressor;
    }

    public FileProtector getFileProtector() {
        return this.cleaner.getFileProtector();
    }

    public UtilizationTracker getUtilizationTracker() {
        return this.cleaner.getUtilizationTracker();
    }

    public UtilizationProfile getUtilizationProfile() {
        return this.cleaner.getUtilizationProfile();
    }

    public ExpirationProfile getExpirationProfile() {
        return this.cleaner.getExpirationProfile();
    }

    public CacheMode getDefaultCacheMode() {
        if (this.cacheMode != null) {
            return this.cacheMode;
        }
        return CacheMode.DEFAULT;
    }

    public int getCompactMaxKeyLength() {
        return this.compactMaxKeyLength;
    }

    public int getLatchTimeoutMs() {
        return this.latchTimeoutMs;
    }

    public int getTtlClockTolerance() {
        return this.ttlClockTolerance;
    }

    public int getTtlMaxTxnTime() {
        return this.ttlMaxTxnTime;
    }

    public int getTtlLnPurgeDelay() {
        return this.ttlLnPurgeDelay;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateBackgroundReads(int nReads) {
        int limit = this.backgroundReadLimit;
        if (limit > 0) {
            Object object = this.backgroundTrackingMutex;
            synchronized (object) {
                this.backgroundReadCount += nReads;
                if (this.backgroundReadCount >= limit) {
                    ++this.backgroundSleepBacklog;
                    this.backgroundReadCount -= limit;
                    assert (this.backgroundReadCount >= 0);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateBackgroundWrites(int writeSize, int logBufferSize) {
        int limit = this.backgroundWriteLimit;
        if (limit > 0) {
            Object object = this.backgroundTrackingMutex;
            synchronized (object) {
                this.backgroundWriteBytes += (long)writeSize;
                int writeCount = (int)(this.backgroundWriteBytes / (long)logBufferSize);
                if (writeCount >= limit) {
                    ++this.backgroundSleepBacklog;
                    this.backgroundWriteBytes -= (long)(limit * logBufferSize);
                    assert (this.backgroundWriteBytes >= 0L);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sleepAfterBackgroundIO() {
        if (this.backgroundSleepBacklog > 0) {
            Object object = this.backgroundSleepMutex;
            synchronized (object) {
                try {
                    Thread.sleep(this.backgroundSleepInterval);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                assert (TestHookExecute.doHookIfSet(this.backgroundSleepHook));
            }
            object = this.backgroundTrackingMutex;
            synchronized (object) {
                if (this.backgroundSleepBacklog > 0) {
                    --this.backgroundSleepBacklog;
                }
            }
        }
    }

    public void setBackgroundSleepHook(TestHook<?> hook) {
        this.backgroundSleepHook = hook;
    }

    public void logMapTreeRoot() throws DatabaseException {
        this.logMapTreeRoot(-1L);
    }

    public void logMapTreeRoot(long ifBeforeLsn) throws DatabaseException {
        this.mapTreeRootLatch.acquireExclusive();
        try {
            if (ifBeforeLsn == -1L || DbLsn.compareTo(this.mapTreeRootLsn, ifBeforeLsn) < 0) {
                this.mapTreeRootLsn = this.logManager.log(SingleItemEntry.create(LogEntryType.LOG_DBTREE, this.dbMapTree), ReplicationContext.NO_REPLICATE);
            }
        }
        finally {
            this.mapTreeRootLatch.release();
        }
    }

    public void rewriteMapTreeRoot(long cleanerTargetLsn) throws DatabaseException {
        this.mapTreeRootLatch.acquireExclusive();
        try {
            if (DbLsn.compareTo(cleanerTargetLsn, this.mapTreeRootLsn) == 0) {
                this.mapTreeRootLsn = this.logManager.log(SingleItemEntry.create(LogEntryType.LOG_DBTREE, this.dbMapTree), ReplicationContext.NO_REPLICATE);
            }
        }
        finally {
            this.mapTreeRootLatch.release();
        }
    }

    public long getRootLsn() {
        return this.mapTreeRootLsn;
    }

    public void readMapTreeFromLog(long rootLsn) throws DatabaseException {
        if (this.dbMapTree != null) {
            this.dbMapTree.close();
        }
        this.dbMapTree = (DbTree)this.logManager.getEntryHandleFileNotFound(rootLsn);
        if (!this.dbMapTree.isReplicated() && this.getAllowRepConvert()) {
            this.dbMapTree.setIsReplicated();
            this.dbMapTree.setIsRepConverted();
            this.needRepConvert = true;
        }
        this.dbMapTree.initExistingEnvironment(this);
        this.mapTreeRootLatch.acquireExclusive();
        try {
            this.mapTreeRootLsn = rootLsn;
        }
        finally {
            this.mapTreeRootLatch.release();
        }
    }

    public void addToCompressorQueue(BIN bin) {
        this.inCompressor.addBinToQueue(bin);
    }

    public void addToCompressorQueue(Collection<BINReference> binRefs) {
        this.inCompressor.addMultipleBinRefsToQueue(binRefs);
    }

    public void lazyCompress(IN in) {
        BIN bin;
        if (!in.isBIN()) {
            return;
        }
        this.lazyCompress(bin, !(bin = (BIN)in).shouldLogDelta());
    }

    public void lazyCompress(IN in, boolean compressDirtySlots) {
        this.inCompressor.lazyCompress(in, compressDirtySlots);
    }

    public void resetLoggingLevel(String changedLoggerName, Level level) {
        LogManager loggerManager = LogManager.getLogManager();
        Enumeration<String> loggers = loggerManager.getLoggerNames();
        boolean validName = false;
        while (loggers.hasMoreElements()) {
            String loggerName = loggers.nextElement();
            Logger logger = loggerManager.getLogger(loggerName);
            if (!"all".equals(changedLoggerName) && !loggerName.endsWith(changedLoggerName) && !loggerName.endsWith(changedLoggerName + ".noEnv") && !loggerName.endsWith(changedLoggerName + ".fixedPrefix") && !loggerName.startsWith(changedLoggerName)) continue;
            logger.setLevel(level);
            validName = true;
        }
        if (!validName) {
            throw new IllegalArgumentException("The logger name parameter: " + changedLoggerName + " is invalid!");
        }
    }

    protected Formatter initFormatter() {
        return new TracerFormatter(this.getName());
    }

    private java.util.logging.FileHandler initFileHandler() throws DatabaseException {
        boolean setupLoggers = this.configManager.getBoolean(EnvironmentParams.ENV_SETUP_LOGGER);
        if (this.envHome == null || !this.envHome.isDirectory() || this.isReadOnly && !setupLoggers) {
            return null;
        }
        String handlerName = FileHandler.class.getName();
        String logFilePattern = this.envHome + "/" + INFO_FILES;
        int limit = 10000000;
        String logLimit = LoggerUtils.getLoggerProperty(handlerName + ".limit");
        if (logLimit != null) {
            limit = Integer.parseInt(logLimit);
        }
        int count = 10;
        String logCount = LoggerUtils.getLoggerProperty(handlerName + ".count");
        if (logCount != null) {
            count = Integer.parseInt(logCount);
        }
        try {
            return new FileHandler(logFilePattern, limit, count, this.formatter, this);
        }
        catch (IOException e) {
            throw EnvironmentFailureException.unexpectedException("Problem creating output files in: " + logFilePattern, (Exception)e);
        }
    }

    public java.util.logging.ConsoleHandler getConsoleHandler() {
        return this.consoleHandler;
    }

    public java.util.logging.FileHandler getFileHandler() {
        return this.fileHandler;
    }

    public Handler getConfiguredHandler() {
        return this.configuredHandler;
    }

    public void closeHandlers() {
        if (this.consoleHandler != null) {
            this.consoleHandler.close();
        }
        if (this.fileHandler != null) {
            this.fileHandler.close();
        }
    }

    public void open() {
        assert (this.invalidatingEFE.get() == null);
        this.envState = DbEnvState.OPEN;
    }

    public void invalidate(EnvironmentFailureException e) {
        this.invalidatingEFE.compareAndSet(null, e);
        if (e instanceof EnvironmentWedgedException) {
            this.wedgedEFE.compareAndSet(null, (EnvironmentWedgedException)e);
        }
        if (this.envState != DbEnvState.CLOSED) {
            this.envState = DbEnvState.INVALID;
        }
        this.requestShutdownDaemons();
    }

    public EnvironmentFailureException getInvalidatingException() {
        return this.invalidatingEFE.get();
    }

    public AtomicReference<EnvironmentFailureException> getInvalidatingExceptionReference() {
        return this.invalidatingEFE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidate(Error e) {
        EnvironmentFailureException environmentFailureException = this.preallocatedEFE;
        synchronized (environmentFailureException) {
            if (this.preallocatedEFE.getCause() == null) {
                this.preallocatedEFE.initCause(e);
            }
        }
        this.invalidate(this.preallocatedEFE);
    }

    public boolean wasInvalidated() {
        return this.invalidatingEFE.get() != null;
    }

    public boolean isValid() {
        return this.envState == DbEnvState.OPEN;
    }

    public boolean isInInit() {
        return this.envState == DbEnvState.INIT;
    }

    public boolean isClosing() {
        return this.closing;
    }

    public boolean isClosed() {
        return this.envState == DbEnvState.CLOSED;
    }

    public boolean mayNotWrite() {
        return this.envState == DbEnvState.INVALID || this.envState == DbEnvState.CLOSED;
    }

    public void checkIfInvalid() throws EnvironmentFailureException {
        if (this.envState != DbEnvState.INVALID) {
            return;
        }
        EnvironmentFailureException efe = this.invalidatingEFE.get();
        assert (efe != null);
        efe.setAlreadyThrown(true);
        if (efe == this.preallocatedEFE) {
            efe.fillInStackTrace();
            throw efe;
        }
        throw efe.wrapSelf("Environment must be closed, caused by: " + efe);
    }

    public void checkOpen() throws DatabaseException {
        this.checkIfInvalid();
        if (this.envState == DbEnvState.CLOSED) {
            throw new IllegalStateException("Attempt to use a Environment that has been closed.");
        }
    }

    public void close() throws DatabaseException {
        DbEnvPool.getInstance().closeEnvironment(this, true, false);
    }

    public void close(boolean doCheckpoint) throws DatabaseException {
        DbEnvPool.getInstance().closeEnvironment(this, doCheckpoint, false);
    }

    public void abnormalClose() throws DatabaseException {
        this.closeInternalEnvHandle(true);
        int openCount1 = this.getOpenCount();
        if (openCount1 > 1) {
            throw EnvironmentFailureException.unexpectedState(this, "Abnormal close assumes that the open count on this handle is 1, not " + openCount1);
        }
        DbEnvPool.getInstance().closeEnvironment(this, false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void doClose(boolean doCheckpoint, boolean isAbnormalClose) {
        this.closeInternalEnvHandle(isAbnormalClose);
        StringWriter errorStringWriter = new StringWriter();
        PrintWriter errors = new PrintWriter(errorStringWriter);
        DiskLimitException diskLimitEx = null;
        try {
            Trace.traceLazily(this, "Close of environment " + this.envHome + " started");
            LoggerUtils.fine(this.envLogger, this, "Close of environment " + this.envHome + " started");
            this.envState.checkState(DbEnvState.VALID_FOR_CLOSE, DbEnvState.CLOSED);
            try {
                this.setupClose(errors);
            }
            catch (Exception e) {
                this.appendException(errors, e, "releasing resources");
            }
            if (this.getBackupCount() > 0) {
                errors.append("\nThere are backups in progress so the ");
                errors.append("Environment should not have been closed.");
                errors.println();
            }
            this.requestShutdownDaemons();
            try {
                this.unregisterMBean();
            }
            catch (Exception e) {
                this.appendException(errors, e, "unregistering MBean");
            }
            boolean checkpointHappened = false;
            if (doCheckpoint && !this.isReadOnly && this.envState != DbEnvState.INVALID && this.logManager.getLastLsnAtRecovery() != this.fileManager.getLastUsedLsn()) {
                CheckpointConfig ckptConfig = new CheckpointConfig();
                ckptConfig.setForce(true);
                ckptConfig.setMinimizeRecoveryTime(true);
                try {
                    this.invokeCheckpoint(ckptConfig, "close");
                    checkpointHappened = true;
                }
                catch (DiskLimitException e) {
                    diskLimitEx = e;
                }
                catch (Exception e) {
                    this.appendException(errors, e, "performing checkpoint");
                }
            }
            try {
                this.postCheckpointClose(checkpointHappened);
            }
            catch (Exception e) {
                this.appendException(errors, e, "after checkpoint");
            }
            LoggerUtils.fine(this.envLogger, this, "About to shutdown daemons for Env " + this.envHome);
            this.shutdownDaemons();
            if (!isAbnormalClose) {
                try {
                    this.logManager.flushSync();
                }
                catch (Exception e) {
                    this.appendException(errors, e, "flushing log manager");
                }
            }
            try {
                this.fileManager.clear();
            }
            catch (Exception e) {
                this.appendException(errors, e, "clearing file manager");
            }
            try {
                this.fileManager.close();
            }
            catch (Exception e) {
                this.appendException(errors, e, "closing file manager");
            }
            this.dbMapTree.close();
            this.cleaner.close();
            this.inMemoryINs.clear();
            this.closeHandlers();
            if (!isAbnormalClose && this.envState != DbEnvState.INVALID) {
                try {
                    this.checkLeaks();
                }
                catch (Exception e) {
                    this.appendException(errors, e, "performing validity checks");
                }
            }
        }
        finally {
            this.envState = DbEnvState.CLOSED;
            this.clearFileManager();
            this.closeHandlers();
        }
        if (this.wedgedEFE.get() != null) {
            throw this.wedgedEFE.get();
        }
        if (errorStringWriter.getBuffer().length() > 0 && this.invalidatingEFE.get() == null) {
            throw EnvironmentFailureException.unexpectedState(errorStringWriter.toString());
        }
        if (diskLimitEx != null) {
            throw diskLimitEx;
        }
    }

    protected void appendException(PrintWriter pw, Exception e, String doingWhat) {
        pw.append("\nException " + doingWhat + ": ");
        e.printStackTrace(pw);
        pw.println();
    }

    protected synchronized void setupClose(PrintWriter errors) throws DatabaseException {
    }

    protected synchronized void postCheckpointClose(boolean checkpointed) throws DatabaseException {
    }

    protected void postRecoveryConversion() {
    }

    private void convertDupDatabases() {
        if (this.dbMapTree.getDupsConverted()) {
            return;
        }
        DupConvert dupConvert = new DupConvert(this, this.dbMapTree);
        dupConvert.convertDatabases();
        this.dbMapTree.setDupsConverted();
        this.logMapTreeRoot();
        this.logManager.flushSync();
    }

    public void closeAfterInvalid() throws DatabaseException {
        DbEnvPool.getInstance().closeEnvironmentAfterInvalid(this);
    }

    public synchronized void doCloseAfterInvalid() {
        try {
            this.unregisterMBean();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.shutdownDaemons();
        try {
            this.fileManager.clear();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.fileManager.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.closeHandlers();
        this.envState = DbEnvState.CLOSED;
        if (this.wedgedEFE.get() != null) {
            throw this.wedgedEFE.get();
        }
    }

    void incOpenCount() {
        this.openCount.incrementAndGet();
    }

    boolean decOpenCount() {
        return this.openCount.decrementAndGet() <= 0;
    }

    private int getOpenCount() {
        return this.openCount.get();
    }

    protected int getAppOpenCount() {
        return this.openCount.get();
    }

    void incBackupCount() {
        this.backupCount.incrementAndGet();
    }

    void decBackupCount() {
        this.backupCount.decrementAndGet();
    }

    protected int getBackupCount() {
        return this.backupCount.get();
    }

    public static int getThreadLocalReferenceCount() {
        return threadLocalReferenceCount;
    }

    public static synchronized void incThreadLocalReferenceCount() {
        ++threadLocalReferenceCount;
    }

    public static synchronized void decThreadLocalReferenceCount() {
        --threadLocalReferenceCount;
    }

    public boolean getDidFullThreadDump() {
        return this.didFullThreadDump;
    }

    public void setDidFullThreadDump(boolean val) {
        this.didFullThreadDump = val;
    }

    public boolean getNoComparators() {
        return this.noComparators;
    }

    private void checkLeaks() throws DatabaseException {
        long memoryUsage;
        TransactionStats txnStat;
        if (!this.configManager.getBoolean(EnvironmentParams.ENV_CHECK_LEAKS)) {
            return;
        }
        boolean clean = true;
        StatsConfig statsConfig = new StatsConfig();
        statsConfig.setFast(false);
        LockStats lockStat = this.lockStat(statsConfig);
        if (lockStat.getNTotalLocks() != 0) {
            clean = false;
            System.err.println("Problem: " + lockStat.getNTotalLocks() + " locks left");
            this.txnManager.getLockManager().dump();
        }
        if ((txnStat = this.txnStat(statsConfig)).getNActive() != 0) {
            clean = false;
            System.err.println("Problem: " + txnStat.getNActive() + " txns left");
            TransactionStats.Active[] active = txnStat.getActiveTxns();
            if (active != null) {
                for (TransactionStats.Active element : active) {
                    System.err.println(element);
                }
            }
        }
        if (LatchSupport.TRACK_LATCHES && LatchSupport.nBtreeLatchesHeld() > 0) {
            clean = false;
            System.err.println("Some latches held at env close.");
            System.err.println(LatchSupport.btreeLatchesHeldToString());
        }
        if ((memoryUsage = this.memoryBudget.getVariableCacheUsage()) != 0L) {
            clean = false;
            System.err.println("Local Cache Usage = " + memoryUsage);
            System.err.println(this.memoryBudget.loadStats());
        }
        boolean assertionsEnabled = false;
        if (!$assertionsDisabled) {
            assertionsEnabled = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        if (!clean && assertionsEnabled) {
            throw EnvironmentFailureException.unexpectedState("Lock, transaction, latch or memory left behind at environment close");
        }
    }

    public void invokeCheckpoint(CheckpointConfig config, String invokingSource) {
        this.checkpointer.doCheckpoint(config, invokingSource, false);
    }

    public Provisional coordinateWithCheckpoint(DatabaseImpl dbImpl, int targetLevel, IN parent) {
        return this.checkpointer.coordinateEvictionWithCheckpoint(dbImpl, targetLevel, parent);
    }

    public void flushLog(boolean fsync) {
        if (fsync) {
            this.logManager.flushSync();
        } else {
            this.logManager.flushNoSync();
        }
    }

    public long forceLogFileFlip() throws DatabaseException {
        return this.logManager.logForceFlip(new TraceLogEntry(new Trace("File Flip")));
    }

    public void invokeCompressor() {
        this.inCompressor.doCompress();
    }

    public void invokeEvictor() {
        this.evictor.doManualEvict();
        this.offHeapCache.doManualEvict();
    }

    public int invokeCleaner(boolean cleanMultipleFiles) {
        if (this.isReadOnly || this.isMemOnly) {
            throw new UnsupportedOperationException("Log cleaning not allowed in a read-only or memory-only environment");
        }
        return this.cleaner.doClean(cleanMultipleFiles, false);
    }

    public void requestShutdownDaemons() {
        this.closing = true;
        this.inCompressor.requestShutdown();
        if (!this.sharedCache) {
            this.evictor.requestShutdown();
            this.offHeapCache.requestShutdown();
        }
        this.checkpointer.requestShutdown();
        this.cleaner.requestShutdown();
        this.statCapture.requestShutdown();
        this.logFlusher.requestShutdown();
        this.dataVerifier.requestShutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdownDaemons() {
        this.statCapture.shutdown();
        Object object = this.statSynchronizer;
        synchronized (object) {
            this.inCompressor.shutdown();
            this.cleaner.shutdown();
            this.checkpointer.shutdown();
            if (this.sharedCache) {
                this.evictor.removeSharedCacheEnv(this);
                this.offHeapCache.clearCache(this);
            } else {
                this.evictor.shutdown();
                this.offHeapCache.shutdown();
            }
            this.logFlusher.shutdown();
            this.dataVerifier.shutdown();
        }
    }

    public boolean isNoLocking() {
        return this.isNoLocking;
    }

    public boolean isTransactional() {
        return this.isTransactional;
    }

    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    public boolean isMemOnly() {
        return this.isMemOnly;
    }

    public String getOptionalNodeName() {
        return this.optionalNodeName;
    }

    public String makeDaemonThreadName(String daemonName) {
        if (this.optionalNodeName == null) {
            return daemonName;
        }
        return daemonName + " (" + this.optionalNodeName + ")";
    }

    public boolean getDbEviction() {
        return this.dbEviction;
    }

    public static int getAdler32ChunkSize() {
        return adler32ChunkSize;
    }

    public boolean getSharedCache() {
        return this.sharedCache;
    }

    public boolean allowBlindOps() {
        return this.allowBlindOps;
    }

    public boolean allowBlindPuts() {
        return this.allowBlindPuts;
    }

    public int getMaxEmbeddedLN() {
        return this.maxEmbeddedLN;
    }

    public Txn txnBegin(Transaction parent, TransactionConfig txnConfig) throws DatabaseException {
        return this.txnManager.txnBegin(parent, txnConfig);
    }

    public com.sleepycat.je.log.LogManager getLogManager() {
        return this.logManager;
    }

    public LogFlusher getLogFlusher() {
        return this.logFlusher;
    }

    public DataVerifier getDataVerifier() {
        return this.dataVerifier;
    }

    public FileManager getFileManager() {
        return this.fileManager;
    }

    public DbTree getDbTree() {
        return this.dbMapTree;
    }

    public DbConfigManager getConfigManager() {
        return this.configManager;
    }

    public NodeSequence getNodeSequence() {
        return this.nodeSequence;
    }

    public EnvironmentConfig cloneConfig() {
        return this.configManager.getEnvironmentConfig().clone();
    }

    public EnvironmentMutableConfig cloneMutableConfig() {
        return DbInternal.cloneMutableConfig(this.configManager.getEnvironmentConfig());
    }

    public void checkImmutablePropsForEquality(Properties handleConfigProps) throws IllegalArgumentException {
        DbInternal.checkImmutablePropsForEquality(this.configManager.getEnvironmentConfig(), handleConfigProps);
    }

    public void setMutableConfig(EnvironmentMutableConfig config) throws DatabaseException {
        DbEnvPool.getInstance().setMutableConfig(this, config);
    }

    synchronized void doSetMutableConfig(EnvironmentMutableConfig config) throws DatabaseException {
        EnvironmentConfig newConfig = this.configManager.getEnvironmentConfig().clone();
        DbInternal.copyMutablePropsTo(config, newConfig);
        this.configManager = this.resetConfigManager(newConfig);
        for (int i = this.configObservers.size() - 1; i >= 0; --i) {
            EnvConfigObserver o = this.configObservers.get(i);
            o.envConfigUpdate(this.configManager, newConfig);
        }
    }

    protected DbConfigManager resetConfigManager(EnvironmentConfig newConfig) {
        return new DbConfigManager(newConfig);
    }

    public ExceptionListener getExceptionListener() {
        return this.exceptionListener;
    }

    public synchronized void addConfigObserver(EnvConfigObserver o) {
        this.configObservers.add(o);
    }

    public synchronized void removeConfigObserver(EnvConfigObserver o) {
        this.configObservers.remove(o);
    }

    public INList getInMemoryINs() {
        return this.inMemoryINs;
    }

    public TxnManager getTxnManager() {
        return this.txnManager;
    }

    public Checkpointer getCheckpointer() {
        return this.checkpointer;
    }

    public Cleaner getCleaner() {
        return this.cleaner;
    }

    public MemoryBudget getMemoryBudget() {
        return this.memoryBudget;
    }

    public String getDiskLimitViolation() {
        return this.cleaner.getDiskLimitViolation();
    }

    public void checkDiskLimitViolation() throws DiskLimitException {
        String violation = this.cleaner.getDiskLimitViolation();
        if (violation != null) {
            throw new DiskLimitException(null, violation);
        }
    }

    public Logger getLogger() {
        return this.envLogger;
    }

    public boolean isDbLoggingDisabled() {
        return this.dbLoggingDisabled;
    }

    public void verify(VerifyConfig config) throws DatabaseException {
        BtreeVerifier verifier = new BtreeVerifier(this);
        verifier.setBtreeVerifyConfig(config);
        verifier.verifyAll();
    }

    public void verifyCursors() throws DatabaseException {
        this.inCompressor.verifyCursors();
    }

    public boolean getExposeUserData() {
        return this.exposeUserData;
    }

    public EnvironmentStats loadStats(StatsConfig config) throws DatabaseException {
        return this.statManager.loadStats(config, this.statKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EnvironmentStats loadStatsInternal(StatsConfig config) throws DatabaseException {
        EnvironmentStats stats = new EnvironmentStats();
        Object object = this.statSynchronizer;
        synchronized (object) {
            stats.setINCompStats(this.inCompressor.loadStats(config));
            stats.setCkptStats(this.checkpointer.loadStats(config));
            stats.setCleanerStats(this.cleaner.loadStats(config));
            stats.setLogStats(this.logManager.loadStats(config));
            stats.setMBAndEvictorStats(this.memoryBudget.loadStats(), this.evictor.loadStats(config));
            stats.setOffHeapStats(this.offHeapCache.loadStats(config));
            stats.setLockStats(this.txnManager.loadStats(config));
            stats.setEnvStats(this.loadEnvImplStats(config));
            stats.setThroughputStats(this.thrputStats.cloneGroup(config.getClear()));
        }
        return stats;
    }

    private StatGroup loadEnvImplStats(StatsConfig config) {
        StatGroup ret = this.envStats.cloneGroup(config.getClear());
        LongStat ct = new LongStat(ret, DbiStatDefinition.ENV_CREATION_TIME);
        ct.set(this.creationTime);
        return ret;
    }

    public void incSearchOps(DatabaseImpl dbImpl) {
        if (dbImpl.isInternalDb()) {
            return;
        }
        if (dbImpl.isKnownSecondary()) {
            this.secSearchOps.increment();
        } else {
            this.priSearchOps.increment();
        }
    }

    public void incSearchFailOps(DatabaseImpl dbImpl) {
        if (dbImpl.isInternalDb()) {
            return;
        }
        if (dbImpl.isKnownSecondary()) {
            this.secSearchFailOps.increment();
        } else {
            this.priSearchFailOps.increment();
        }
    }

    public void incPositionOps(DatabaseImpl dbImpl) {
        if (dbImpl.isInternalDb()) {
            return;
        }
        if (dbImpl.isKnownSecondary()) {
            this.secPositionOps.increment();
        } else {
            this.priPositionOps.increment();
        }
    }

    public void incInsertOps(DatabaseImpl dbImpl) {
        if (dbImpl.isInternalDb()) {
            return;
        }
        if (dbImpl.isKnownSecondary()) {
            this.secInsertOps.increment();
        } else {
            this.priInsertOps.increment();
        }
    }

    public void incInsertFailOps(DatabaseImpl dbImpl) {
        if (dbImpl.isInternalDb()) {
            return;
        }
        if (!dbImpl.isKnownSecondary()) {
            this.priInsertFailOps.increment();
        }
    }

    public void incUpdateOps(DatabaseImpl dbImpl) {
        if (dbImpl.isInternalDb()) {
            return;
        }
        if (dbImpl.isKnownSecondary()) {
            this.secUpdateOps.increment();
        } else {
            this.priUpdateOps.increment();
        }
    }

    public void incDeleteOps(DatabaseImpl dbImpl) {
        if (dbImpl.isInternalDb()) {
            return;
        }
        if (dbImpl.isKnownSecondary()) {
            this.secDeleteOps.increment();
        } else {
            this.priDeleteOps.increment();
        }
    }

    public void incDeleteFailOps(DatabaseImpl dbImpl) {
        if (dbImpl.isInternalDb()) {
            return;
        }
        this.priDeleteFailOps.increment();
    }

    public void incRelatchesRequired() {
        this.relatchesRequired.increment();
    }

    public void incBinDeltaGets() {
        this.binDeltaGets.increment();
    }

    public void incBinDeltaInserts() {
        this.binDeltaInserts.increment();
    }

    public void incBinDeltaUpdates() {
        this.binDeltaUpdates.increment();
    }

    public void incBinDeltaDeletes() {
        this.binDeltaDeletes.increment();
    }

    public boolean addDbBackup(DbBackup backup) {
        this.incBackupCount();
        return true;
    }

    public void removeDbBackup(DbBackup backup) {
        this.decBackupCount();
    }

    public synchronized LockStats lockStat(StatsConfig config) throws DatabaseException {
        return this.txnManager.lockStat(config);
    }

    public synchronized TransactionStats txnStat(StatsConfig config) {
        return this.txnManager.txnStat(config);
    }

    public int getINCompressorQueueSize() {
        return this.inCompressor.getBinRefQueueSize();
    }

    public StartupTracker getStartupTracker() {
        return this.startupTracker;
    }

    public File getEnvironmentHome() {
        return this.envHome;
    }

    public Environment getInternalEnvHandle() {
        return this.envInternal;
    }

    private synchronized void closeInternalEnvHandle(boolean isAbnormalClose) {
        if (this.envInternal == null) {
            return;
        }
        if (isAbnormalClose) {
            this.envInternal = null;
        } else {
            Environment savedEnvInternal = this.envInternal;
            this.envInternal = null;
            DbInternal.closeInternalHandle(savedEnvInternal);
        }
    }

    public String getName() {
        if (this.optionalNodeName == null) {
            return this.envHome.toString();
        }
        return this.getOptionalNodeName();
    }

    public long getTxnTimeout() {
        return this.txnTimeout;
    }

    public long getLockTimeout() {
        return this.lockTimeout;
    }

    public void setLockTimeout(long timeout) {
        this.lockTimeout = timeout;
    }

    public boolean getDeadlockDetection() {
        return this.deadlockDetection;
    }

    public long getDeadlockDetectionDelay() {
        return this.deadlockDetectionDelay;
    }

    public long getReplayTxnTimeout() {
        if (this.lockTimeout != 0L) {
            return this.lockTimeout;
        }
        return 1L;
    }

    public ReentrantReadWriteLock getSecondaryAssociationLock() {
        return this.secondaryAssociationLock;
    }

    public OffHeapCache getOffHeapCache() {
        return this.offHeapCache;
    }

    public boolean useOffHeapChecksums() {
        return this.useOffHeapChecksums;
    }

    public boolean isExpirationEnabled() {
        return this.expirationEnabled;
    }

    public boolean isExpired(int expiration, boolean hours) {
        return this.expirationEnabled && TTL.isExpired(expiration, hours);
    }

    public boolean isExpired(long expirationTime) {
        return this.expirationEnabled && TTL.isExpired(expirationTime);
    }

    public boolean expiresWithin(int expiration, boolean hours, long withinMs) {
        return this.expirationEnabled && TTL.expiresWithin(expiration, hours, withinMs);
    }

    public boolean expiresWithin(long expirationTime, long withinMs) {
        return this.expirationEnabled && TTL.expiresWithin(expirationTime, withinMs);
    }

    public Evictor getEvictor() {
        return this.evictor;
    }

    void alertEvictor() {
        this.evictor.alert();
    }

    public void criticalEviction(boolean backgroundIO) {
        this.evictor.doCriticalEviction(backgroundIO);
        this.offHeapCache.doCriticalEviction(backgroundIO);
    }

    public void daemonEviction(boolean backgroundIO) {
        this.evictor.doDaemonEviction(backgroundIO);
        this.offHeapCache.doDaemonEviction(backgroundIO);
    }

    public long specialEviction() {
        return this.cleaner.getUtilizationTracker().evictMemory();
    }

    public static boolean maybeForceYield() {
        if (forcedYield) {
            Thread.yield();
        }
        return true;
    }

    public boolean isReplicated() {
        return false;
    }

    public boolean isArbiter() {
        return false;
    }

    public boolean getPreserveVLSN() {
        return false;
    }

    public boolean getCacheVLSN() {
        return false;
    }

    public boolean getAllowRepConvert() {
        return false;
    }

    public boolean isRepConverted() {
        return this.dbMapTree.isRepConverted();
    }

    public boolean needRepConvert() {
        return this.needRepConvert;
    }

    public VLSN assignVLSNs(LogEntry entry) {
        return null;
    }

    public VLSNRecoveryProxy getVLSNProxy() {
        return new NoopVLSNProxy();
    }

    public boolean isMaster() {
        return false;
    }

    public void preRecoveryCheckpointInit(RecoveryInfo recoveryInfo) {
    }

    public void registerVLSN(LogItem logItem) {
    }

    public boolean tryVlsnHeadTruncate(long bytesNeeded) {
        return false;
    }

    public void preCheckpointEndFlush() {
    }

    public Txn createReplayTxn(long txnId) {
        throw EnvironmentFailureException.unexpectedState("Should not be called on a non replicated environment");
    }

    public ThreadLocker createRepThreadLocker() {
        throw EnvironmentFailureException.unexpectedState("Should not be called on a non replicated environment");
    }

    public Txn createRepUserTxn(TransactionConfig config) {
        throw EnvironmentFailureException.unexpectedState("Should not be called on a non replicated environment");
    }

    public Txn createRepTxn(TransactionConfig config, long mandatedId) {
        throw EnvironmentFailureException.unexpectedState("Should not be called on a non replicated environment");
    }

    public OperationFailureException createLockPreemptedException(Locker locker, Throwable cause) {
        throw EnvironmentFailureException.unexpectedState("Should not be called on a non replicated environment");
    }

    public OperationFailureException createDatabasePreemptedException(String msg, String dbName, Database db) {
        throw EnvironmentFailureException.unexpectedState("Should not be called on a non replicated environment");
    }

    public OperationFailureException createLogOverwriteException(String msg) {
        throw EnvironmentFailureException.unexpectedState("Should not be called on a non replicated environment");
    }

    public int getReplayFreeDiskPercent() {
        return 0;
    }

    public void checkRulesForExistingEnv(boolean dbTreeReplicatedBit, boolean dbTreePreserveVLSN) throws UnsupportedOperationException {
        if (dbTreeReplicatedBit && !this.isReadOnly()) {
            throw new UnsupportedOperationException("This environment was previously opened for replication. It cannot be re-opened for in read/write mode for non-replicated operation.");
        }
        if (this.getPreserveVLSN() && !this.isReadOnly()) {
            throw new IllegalArgumentException("je.rep.preserveRecordVersion parameter may not be true in a read-write, non-replicated environment");
        }
    }

    public void awaitVLSNConsistency() {
    }

    public AtomicLongStat getThroughputStat(StatDefinition def) {
        return this.thrputStats.getAtomicLongStat(def);
    }

    public PreloadStats preload(DatabaseImpl[] dbImpls, PreloadConfig config) throws DatabaseException {
        try {
            long maxBytes;
            long maxMillisecs = config.getMaxMillisecs();
            long targetTime = Long.MAX_VALUE;
            if (maxMillisecs > 0L && (targetTime = System.currentTimeMillis() + maxMillisecs) < 0L) {
                targetTime = Long.MAX_VALUE;
            }
            boolean useOffHeapCache = false;
            long cacheBudget = this.memoryBudget.getMaxMemory();
            if (useOffHeapCache) {
                cacheBudget += this.offHeapCache.getMaxMemory();
            }
            if ((maxBytes = config.getMaxBytes()) == 0L) {
                maxBytes = cacheBudget;
            } else if (maxBytes > cacheBudget) {
                throw new IllegalArgumentException("maxBytes parameter to preload() was specified as " + maxBytes + " bytes but the maximum total cache size is only " + cacheBudget + " bytes.");
            }
            Arrays.sort(dbImpls, new Comparator<DatabaseImpl>(){

                @Override
                public int compare(DatabaseImpl o1, DatabaseImpl o2) {
                    DatabaseId id1 = o1.getId();
                    DatabaseId id2 = o2.getId();
                    return id1.compareTo(id2);
                }
            });
            PreloadStats pstats = new PreloadStats();
            PreloadProcessor callback = new PreloadProcessor(this, maxBytes, useOffHeapCache, targetTime, pstats, config);
            int nDbs = dbImpls.length;
            long[] rootLsns = new long[nDbs];
            for (int i = 0; i < nDbs; ++i) {
                rootLsns[i] = dbImpls[i].getTree().getRootLsn();
            }
            PreloadLSNTreeWalker walker = new PreloadLSNTreeWalker(dbImpls, rootLsns, useOffHeapCache, callback, config);
            try {
                ((SortedLSNTreeWalker)walker).walk();
                callback.close();
            }
            catch (HaltPreloadException HPE) {
                pstats.setStatus(HPE.getStatus());
            }
            if (LatchSupport.TRACK_LATCHES) {
                LatchSupport.expectBtreeLatchesHeld(0);
            }
            return pstats;
        }
        catch (Error E) {
            this.invalidate(E);
            throw E;
        }
    }

    public ProgressListener<RecoveryProgress> getRecoveryProgressListener() {
        return this.recoveryProgressListener;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public PreloadConfig getDupConvertPreloadConfig() {
        return this.dupConvertPreloadConfig;
    }

    public void checkTTLAvailable() {
    }

    public void handleRestoreRequired(RestoreRequired restoreRequired) {
        switch (restoreRequired.getFailureType()) {
            case LOG_CHECKSUM: {
                throw new EnvironmentFailureException(this, EnvironmentFailureReason.LOG_CHECKSUM, VerifierUtils.getRestoreRequiredMessage(restoreRequired));
            }
            case BTREE_CORRUPTION: {
                throw new EnvironmentFailureException(this, EnvironmentFailureReason.BTREE_CORRUPTION, VerifierUtils.getRestoreRequiredMessage(restoreRequired));
            }
        }
        throw EnvironmentFailureException.unexpectedState(this, restoreRequired.toString());
    }

    static {
        forcedYield = false;
        threadLocalReferenceCount = 0;
        USE_JAVA5_ADLER32 = System.getProperty(DISABLE_JAVA_ADLER32_NAME) == null;
        LockUpgrade.ILLEGAL.setUpgrade(null);
        LockUpgrade.EXISTING.setUpgrade(null);
        LockUpgrade.WRITE_PROMOTE.setUpgrade(LockType.WRITE);
        LockUpgrade.RANGE_READ_IMMED.setUpgrade(LockType.RANGE_READ);
        LockUpgrade.RANGE_WRITE_IMMED.setUpgrade(LockType.RANGE_WRITE);
        LockUpgrade.RANGE_WRITE_PROMOTE.setUpgrade(LockType.RANGE_WRITE);
        TIME_EXCEEDED_PRELOAD_EXCEPTION = new HaltPreloadException(PreloadStatus.EXCEEDED_TIME);
        MEMORY_EXCEEDED_PRELOAD_EXCEPTION = new HaltPreloadException(PreloadStatus.FILLED_CACHE);
        USER_HALT_REQUEST_PRELOAD_EXCEPTION = new HaltPreloadException(PreloadStatus.USER_HALT_REQUEST);
    }

    private class PreloadLSNTreeWalker
    extends SortedLSNTreeWalker {
        PreloadLSNTreeWalker(DatabaseImpl[] dbs, long[] rootLsns, boolean useOffHeapCache, SortedLSNTreeWalker.TreeNodeProcessor callback, PreloadConfig conf) throws DatabaseException {
            super(dbs, false, rootLsns, callback, null, null);
            this.accumulateLNs = conf.getLoadLNs();
            this.preloadIntoOffHeapCache = useOffHeapCache;
            this.setLSNBatchSize(conf.getLSNBatchSize());
            this.setInternalMemoryLimit(conf.getInternalMemoryLimit());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void walk() throws DatabaseException {
            DatabaseImpl dbImpl;
            int i;
            int nDbs = this.dbImpls.length;
            int nDbsLatched = 0;
            try {
                try {
                    for (i = 0; i < nDbs; ++i) {
                        dbImpl = this.dbImpls[i];
                        dbImpl.getTree().latchRootLatchExclusive();
                        ++nDbsLatched;
                    }
                }
                catch (Exception e) {
                    throw EnvironmentFailureException.unexpectedException(EnvironmentImpl.this, "Couldn't latch all DatabaseImpls during preload", e);
                }
                this.walkInternal();
            }
            finally {
                for (i = nDbsLatched - 1; i >= 0; --i) {
                    dbImpl = this.dbImpls[i];
                    dbImpl.getTree().releaseRootLatch();
                }
            }
        }

        @Override
        IN getRootIN(DatabaseImpl dbImpl, long rootLsn) {
            return dbImpl.getTree().getRootINRootAlreadyLatched(CacheMode.UNCHANGED, false);
        }

        @Override
        protected boolean fetchAndInsertIntoTree() {
            return true;
        }
    }

    private static class PreloadProcessor
    implements SortedLSNTreeWalker.TreeNodeProcessor {
        private final EnvironmentImpl envImpl;
        private final long maxBytes;
        private final boolean useOffHeapCache;
        private final long targetTime;
        private final PreloadStats stats;
        private final boolean countLNs;
        private final ProgressListener<PreloadConfig.Phases> progressListener;
        private long progressCounter = 0L;

        PreloadProcessor(EnvironmentImpl envImpl, long maxBytes, boolean useOffHeapCache, long targetTime, PreloadStats stats, PreloadConfig config) {
            this.envImpl = envImpl;
            this.maxBytes = maxBytes;
            this.useOffHeapCache = useOffHeapCache;
            this.targetTime = targetTime;
            this.stats = stats;
            this.countLNs = config.getLoadLNs();
            this.progressListener = config.getProgressListener();
        }

        @Override
        public void processLSN(long childLsn, LogEntryType childType, Node node, byte[] ignore2, int ignore3) {
            if (System.currentTimeMillis() > this.targetTime) {
                throw TIME_EXCEEDED_PRELOAD_EXCEPTION;
            }
            long usedBytes = this.envImpl.memoryBudget.getCacheMemoryUsage();
            if (this.useOffHeapCache) {
                usedBytes += this.envImpl.offHeapCache.getUsedMemory();
            }
            if (usedBytes > this.maxBytes) {
                throw MEMORY_EXCEEDED_PRELOAD_EXCEPTION;
            }
            if (this.progressListener != null) {
                ++this.progressCounter;
                if (!this.progressListener.progress(PreloadConfig.Phases.PRELOAD, this.progressCounter, -1L)) {
                    throw USER_HALT_REQUEST_PRELOAD_EXCEPTION;
                }
            }
            if (childLsn == -1L) {
                this.stats.incEmbeddedLNs();
            } else if (childType.equals(LogEntryType.LOG_DUPCOUNTLN_TRANSACTIONAL) || childType.equals(LogEntryType.LOG_DUPCOUNTLN)) {
                this.stats.incDupCountLNsLoaded();
            } else if (childType.isLNType()) {
                if (this.countLNs) {
                    this.stats.incLNsLoaded();
                }
            } else if (childType.equals(LogEntryType.LOG_DBIN)) {
                this.stats.incDBINsLoaded();
            } else if (childType.equals(LogEntryType.LOG_BIN)) {
                this.stats.incBINsLoaded();
                if (!this.countLNs) {
                    BIN bin = (BIN)node;
                    for (int i = 0; i < bin.getNEntries(); ++i) {
                        if (!bin.isEmbeddedLN(i)) continue;
                        this.stats.incEmbeddedLNs();
                    }
                }
            } else if (childType.equals(LogEntryType.LOG_DIN)) {
                this.stats.incDINsLoaded();
            } else if (childType.equals(LogEntryType.LOG_IN)) {
                this.stats.incINsLoaded();
            }
        }

        @Override
        public void processDirtyDeletedLN(long childLsn, LN ln, byte[] lnKey) {
        }

        @Override
        public void noteMemoryExceeded() {
            this.stats.incMemoryExceeded();
        }

        public void close() {
            if (this.progressListener != null) {
                this.progressListener.progress(PreloadConfig.Phases.PRELOAD, this.progressCounter, this.progressCounter);
            }
        }
    }

    private static class HaltPreloadException
    extends RuntimeException {
        private final PreloadStatus status;

        HaltPreloadException(PreloadStatus status) {
            super(status.toString());
            this.status = status;
        }

        PreloadStatus getStatus() {
            return this.status;
        }
    }

    private static class InternalEnvironment
    extends Environment {
        public InternalEnvironment(File envHome, EnvironmentConfig configuration, EnvironmentImpl envImpl) throws EnvironmentNotFoundException, EnvironmentLockedException, VersionMismatchException, DatabaseException, IllegalArgumentException {
            super(envHome, configuration, null, envImpl);
        }

        @Override
        protected boolean isInternalHandle() {
            return true;
        }

        @Override
        public synchronized void close() {
            throw EnvironmentFailureException.unexpectedState("close() not permitted on an internal environment handle");
        }
    }

    private class NoopVLSNProxy
    implements VLSNRecoveryProxy {
        private NoopVLSNProxy() {
        }

        @Override
        public void trackMapping(long lsn, LogEntryHeader currentEntryHeader, LogEntry targetLogEntry) {
        }
    }

    public static interface MBeanRegistrar {
        public void doRegister(Environment var1) throws Exception;

        public void doUnregister() throws Exception;
    }
}

