/*
 * Decompiled with CFR 0.152.
 */
package net.handle.server.txnlog;

import net.handle.hdllib.HandleValue;
import net.handle.hdllib.Transaction;
import net.handle.hdllib.TransactionQueueInterface;
import net.handle.hdllib.TransactionQueueListener;
import net.handle.hdllib.TransactionScannerInterface;
import net.handle.server.txnlog.AbstractTransactionQueue;
import net.handle.server.txnlog.FileBasedTransactionQueue;

public class ConcatenatedTransactionQueue
extends AbstractTransactionQueue {
    private volatile TransactionQueueInterface oldQueue;
    private final TransactionQueueInterface currentQueue;
    private final long lastTxnIdOfOldQueue;

    public ConcatenatedTransactionQueue(TransactionQueueInterface oldQueue, TransactionQueueInterface currentQueue) {
        this.oldQueue = oldQueue;
        this.currentQueue = currentQueue;
        TransactionQueueListener subListener = new TransactionQueueListener(){

            @Override
            public void transactionAdded(Transaction txn) {
                ConcatenatedTransactionQueue.this.notifyQueueListeners(txn);
            }

            @Override
            public void shutdown() {
            }
        };
        this.oldQueue.addQueueListener(subListener);
        this.currentQueue.addQueueListener(subListener);
        this.lastTxnIdOfOldQueue = oldQueue.getLastTxnId();
    }

    @Override
    public long getFirstDate() {
        if (this.oldQueue == null) {
            return this.currentQueue.getFirstDate();
        }
        return Math.min(this.oldQueue.getFirstDate(), this.currentQueue.getFirstDate());
    }

    @Override
    public long getLastTxnId() {
        long currentQueueLastTxnId = this.currentQueue.getLastTxnId();
        if (currentQueueLastTxnId < 1L) {
            return this.lastTxnIdOfOldQueue;
        }
        return currentQueueLastTxnId;
    }

    @Override
    public void addTransaction(long txnId, byte[] handle, HandleValue[] values, byte action, long date) throws Exception {
        this.currentQueue.addTransaction(txnId, handle, values, action, date);
    }

    @Override
    public void shutdown() {
        this.shutdownQueueListeners();
        if (this.oldQueue != null) {
            this.oldQueue.shutdown();
        }
        this.currentQueue.shutdown();
    }

    @Override
    public void deleteUntilDate(long date) {
        long firstDateBefore = this.currentQueue.getFirstDate();
        this.currentQueue.deleteUntilDate(date);
        long firstDateAfter = this.currentQueue.getFirstDate();
        if (firstDateAfter > firstDateBefore) {
            TransactionQueueInterface originalQueue = this.oldQueue;
            this.oldQueue = null;
            originalQueue.shutdown();
            if (originalQueue instanceof FileBasedTransactionQueue) {
                ((FileBasedTransactionQueue)originalQueue).deleteAllFiles();
            }
        }
    }

    @Override
    public TransactionScannerInterface getScanner(long lastTimestamp) throws Exception {
        TransactionScannerInterface oldEnumeration = null;
        if (lastTimestamp < this.lastTxnIdOfOldQueue && this.oldQueue != null) {
            oldEnumeration = this.oldQueue.getScanner(lastTimestamp);
        }
        TransactionScannerInterface currentEnumeration = this.currentQueue.getScanner(lastTimestamp);
        return new QueueScanner(oldEnumeration, currentEnumeration);
    }

    public class QueueScanner
    implements TransactionScannerInterface {
        private final TransactionScannerInterface oldEnumeration;
        private final TransactionScannerInterface currentEnumeration;
        private boolean oldEnumerationDone = false;

        protected QueueScanner(TransactionScannerInterface oldEnumeration, TransactionScannerInterface currentEnumeration) throws Exception {
            this.oldEnumeration = oldEnumeration;
            this.currentEnumeration = currentEnumeration;
        }

        @Override
        public Transaction nextTransaction() throws Exception {
            if (this.oldEnumeration != null && !this.oldEnumerationDone) {
                Transaction txn = this.oldEnumeration.nextTransaction();
                if (txn == null) {
                    this.oldEnumerationDone = true;
                } else {
                    return txn;
                }
            }
            return this.currentEnumeration.nextTransaction();
        }

        @Override
        public void close() {
            if (this.oldEnumeration != null) {
                this.oldEnumeration.close();
            }
            if (this.currentEnumeration != null) {
                this.currentEnumeration.close();
            }
        }
    }
}

