/*
 * Decompiled with CFR 0.152.
 */
package net.handle.server.servletcontainer.support;

import java.net.InetAddress;
import net.handle.hdllib.AbstractRequest;
import net.handle.hdllib.AbstractResponse;
import net.handle.hdllib.HandleException;
import net.handle.hdllib.ResponseMessageCallback;
import net.handle.hdllib.Util;
import net.handle.server.servletcontainer.HandleServerInterface;

public class LoggingResponseMessageCallbackWrapper
implements ResponseMessageCallback {
    public static final String ACCESS_TYPE_PREFIX = "HTTP:";
    private final HandleServerInterface handleServer;
    private final boolean logAccesses;
    private final AbstractRequest currentRequest;
    private final InetAddress inetAddress;
    private final ResponseMessageCallback callback;
    private final String accessType;
    private final long recvTime;

    public LoggingResponseMessageCallbackWrapper(ResponseMessageCallback callback, HandleServerInterface handleServer, boolean logAccesses, AbstractRequest currentRequest, InetAddress inetAddress, String accessType) {
        this.callback = callback;
        this.handleServer = handleServer;
        this.logAccesses = logAccesses;
        this.currentRequest = currentRequest;
        this.inetAddress = inetAddress;
        this.accessType = accessType;
        this.recvTime = System.currentTimeMillis();
    }

    @Override
    public void handleResponse(AbstractResponse response) throws HandleException {
        if (this.logAccesses && this.currentRequest != null) {
            long respTime = System.currentTimeMillis() - this.recvTime;
            this.handleServer.logAccess(ACCESS_TYPE_PREFIX + this.accessType, this.inetAddress, this.currentRequest.opCode, response != null ? response.responseCode : 2, Util.getAccessLogString(this.currentRequest), respTime);
        }
        this.callback.handleResponse(response);
    }
}

