/*
 * Decompiled with CFR 0.152.
 */
package net.handle.server.servletcontainer.servlets;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.cnri.util.ServletUtil;
import net.handle.apps.servlet_proxy.HDLProxy;
import net.handle.hdllib.AbstractRequest;
import net.handle.hdllib.AbstractResponse;
import net.handle.hdllib.Encoder;
import net.handle.hdllib.ErrorResponse;
import net.handle.hdllib.HandleException;
import net.handle.hdllib.HandleResolver;
import net.handle.hdllib.Interface;
import net.handle.hdllib.MessageEnvelope;
import net.handle.hdllib.RequestProcessor;
import net.handle.hdllib.ResponseMessageCallback;
import net.handle.hdllib.ServerInfo;
import net.handle.hdllib.SessionInfo;
import net.handle.hdllib.SignedOutputStream;
import net.handle.hdllib.Util;
import net.handle.server.servletcontainer.HandleServerInterface;

public class NativeServlet
extends HttpServlet {
    public static final byte[] MSG_INVALID_MSG_SIZE = Util.encodeString("Invalid message length");
    public static final byte[] MSG_INVALID_REQUEST = Util.encodeString("Invalid request");
    HandleServerInterface handleServer;
    RequestProcessor requestHandler;
    boolean processQueriesHttp;
    boolean processAdminRequestsHttp;
    boolean processQueriesHttps;
    boolean processAdminRequestsHttps;

    public void init() throws ServletException {
        this.handleServer = (HandleServerInterface)this.getServletContext().getAttribute("net.handle.server.HandleServer");
        if (this.handleServer == null) {
            this.requestHandler = (HandleResolver)this.getServletContext().getAttribute(HandleResolver.class.getName());
            if (this.requestHandler == null) {
                this.requestHandler = new HandleResolver();
            }
            this.processQueriesHttp = true;
            this.processAdminRequestsHttp = false;
            this.processQueriesHttps = true;
            this.processAdminRequestsHttps = false;
        } else {
            this.requestHandler = this.handleServer;
            this.setCanProcessInServer();
        }
    }

    private void logError(int level, String logString) {
        if (this.handleServer == null) {
            HDLProxy hdlProxy = (HDLProxy)((Object)this.getServletContext().getAttribute(HDLProxy.class.getName()));
            if (hdlProxy == null) {
                System.err.println(logString);
            } else {
                hdlProxy.logError(level, logString);
            }
        } else {
            this.handleServer.logError(level, logString);
        }
    }

    private void setCanProcessInServer() {
        ServerInfo svrInfo = this.handleServer.getServerInfo();
        for (Interface intf : svrInfo.interfaces) {
            if (intf == null) continue;
            if (intf.protocol == 2) {
                if (intf.type == 3 || intf.type == 1) {
                    this.processAdminRequestsHttp = true;
                    this.processAdminRequestsHttps = true;
                }
                if (intf.type != 3 && intf.type != 2) continue;
                this.processQueriesHttp = true;
                this.processQueriesHttps = true;
                continue;
            }
            if (intf.protocol != 3) continue;
            if (intf.type == 3 || intf.type == 1) {
                this.processAdminRequestsHttps = true;
            }
            if (intf.type != 3 && intf.type != 2) continue;
            this.processQueriesHttps = true;
        }
    }

    String canProcessMsg(HttpServletRequest servletReq, AbstractRequest req) {
        boolean processQueries = servletReq.isSecure() ? this.processQueriesHttps : this.processQueriesHttp;
        boolean processAdminRequests = servletReq.isSecure() ? this.processAdminRequestsHttps : this.processAdminRequestsHttp;
        return Interface.canProcessMsg(req, processQueries, processAdminRequests);
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.setStatus(302);
        resp.setHeader("Location", this.getServletContext().getContextPath() + "/api/handles" + ServletUtil.pathExcluding((String)req.getRequestURI(), (String)this.getServletContext().getContextPath()));
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        new Handler(req, resp).handle();
    }

    private static InetAddress getRemoteInetAddress(HttpServletRequest servletReq) {
        try {
            HDLProxy hdlProxy = (HDLProxy)((Object)servletReq.getServletContext().getAttribute(HDLProxy.class.getName()));
            if (hdlProxy == null) {
                return InetAddress.getByName(servletReq.getRemoteAddr());
            }
            return hdlProxy.getRemoteInetAddress(servletReq);
        }
        catch (UnknownHostException e) {
            return null;
        }
    }

    class Handler
    implements ResponseMessageCallback {
        private final HttpServletRequest servletReq;
        private final HttpServletResponse servletResp;
        private AbstractRequest currentHdlRequest;
        private final long recvTime = System.currentTimeMillis();

        public Handler(HttpServletRequest req, HttpServletResponse resp) {
            this.servletReq = req;
            this.servletResp = resp;
        }

        void handle() throws IOException {
            BufferedInputStream in = new BufferedInputStream((InputStream)this.servletReq.getInputStream());
            int n = 0;
            byte[] envelopeBuf = new byte[20];
            MessageEnvelope envelope = new MessageEnvelope();
            int r = ((InputStream)in).read();
            if (r != 10 && r != 13) {
                envelopeBuf[0] = (byte)r;
                ++n;
            }
            while (n < 20 && (r = ((InputStream)in).read(envelopeBuf, n, 20 - n)) > 0) {
                n += r;
            }
            if (n < 20) {
                this.handleResponse(new ErrorResponse(0, 4, MSG_INVALID_MSG_SIZE));
                return;
            }
            try {
                Encoder.decodeEnvelope(envelopeBuf, envelope);
            }
            catch (HandleException e) {
                this.handleResponse(new ErrorResponse(0, 4, MSG_INVALID_MSG_SIZE));
                return;
            }
            byte[] messageBuf = new byte[envelope.messageLength];
            r = 0;
            for (n = 0; n < envelope.messageLength && (r = ((InputStream)in).read(messageBuf, n, envelope.messageLength - n)) > 0; n += r) {
            }
            if (n < envelope.messageLength) {
                this.handleResponse(new ErrorResponse(0, 4, Util.encodeString("Expecting " + envelope.messageLength + " bytes, only received " + n)));
                return;
            }
            if (envelope.encrypted && (messageBuf = this.decryptMessageReturnNullIfError(envelope, messageBuf)) == null) {
                return;
            }
            if (envelope.messageLength < 24) {
                this.handleResponse(new ErrorResponse(0, 4, MSG_INVALID_MSG_SIZE));
                return;
            }
            try {
                this.currentHdlRequest = (AbstractRequest)Encoder.decodeMessage(messageBuf, 0, envelope);
            }
            catch (Exception e) {
                this.handleResponse(new ErrorResponse(0, 4, Util.encodeString(e.toString())));
                return;
            }
            String errMsg = NativeServlet.this.canProcessMsg(this.servletReq, this.currentHdlRequest);
            if (errMsg != null) {
                NativeServlet.this.logError(75, errMsg);
                this.handleErrorResponse(this.currentHdlRequest, 4, Util.encodeString(errMsg));
                return;
            }
            try {
                NativeServlet.this.requestHandler.processRequest(this.currentHdlRequest, NativeServlet.getRemoteInetAddress(this.servletReq), this);
            }
            catch (HandleException e) {
                this.handleErrorResponse(this.currentHdlRequest, 2, Util.encodeString("Server error processing request, see server logs"));
                NativeServlet.this.logError(75, String.valueOf(this.getClass()) + ": Exception processing request: " + e);
            }
        }

        private byte[] decryptMessageReturnNullIfError(MessageEnvelope envelope, byte[] messageBuf) {
            if (envelope.sessionId <= 0) {
                NativeServlet.this.logError(75, "Invalid session id. Request message not decrypted.");
                this.handleResponse(new ErrorResponse(0, 501, Util.encodeString("Invalid session id. Unable to decrypt request message.")));
                return null;
            }
            SessionInfo sssinfo = NativeServlet.this.handleServer.getSession(envelope.sessionId);
            if (sssinfo == null) {
                NativeServlet.this.logError(75, "Session information not available. Request message not decrypted.");
                this.handleResponse(new ErrorResponse(0, 501, Util.encodeString("Session information not available. Unable to decrypt request message.")));
                return null;
            }
            try {
                messageBuf = sssinfo.decryptBuffer(messageBuf, 0, envelope.messageLength);
                envelope.encrypted = false;
                envelope.messageLength = messageBuf.length;
                return messageBuf;
            }
            catch (Exception e) {
                NativeServlet.this.logError(75, "Exception decrypting request: " + e);
                this.handleResponse(new ErrorResponse(0, 501, Util.encodeString("Exception decrypting request with session key " + e)));
                return null;
            }
        }

        private void handleErrorResponse(AbstractRequest req, int responseCode, byte[] message) {
            ErrorResponse resp;
            try {
                resp = new ErrorResponse(req, responseCode, message);
            }
            catch (HandleException e) {
                resp = new ErrorResponse(req.opCode, responseCode, message);
                resp.requestId = req.requestId;
                resp.sessionId = req.sessionId;
                resp.takeValuesFrom(req);
                resp.setSupportedProtocolVersion();
            }
            if (NativeServlet.this.handleServer != null) {
                try {
                    NativeServlet.this.handleServer.sendResponse(this, resp);
                    return;
                }
                catch (HandleException handleException) {
                    // empty catch block
                }
            }
            this.handleResponse(resp);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleResponse(AbstractResponse response) {
            FilterOutputStream sout = null;
            OutputStream out = null;
            try {
                SessionInfo sssinfo;
                byte[] msg = response.getEncodedMessage();
                boolean encrypted = false;
                if (response.sessionId > 0 && (response.encrypt || !this.servletReq.isSecure() && response.shouldEncrypt()) && (sssinfo = NativeServlet.this.handleServer.getSession(response.sessionId)) != null) {
                    try {
                        msg = sssinfo.encryptBuffer(msg, 0, msg.length);
                        encrypted = true;
                    }
                    catch (Exception e) {
                        NativeServlet.this.logError(50, "Exception encrypting response: " + e);
                        encrypted = false;
                    }
                }
                MessageEnvelope envelope = new MessageEnvelope();
                envelope.encrypted = encrypted;
                envelope.messageLength = msg.length;
                envelope.messageId = 0;
                envelope.requestId = response.requestId;
                envelope.sessionId = response.sessionId;
                envelope.protocolMajorVersion = response.majorProtocolVersion;
                envelope.protocolMinorVersion = response.minorProtocolVersion;
                envelope.suggestMajorProtocolVersion = response.suggestMajorProtocolVersion;
                envelope.suggestMinorProtocolVersion = response.suggestMinorProtocolVersion;
                byte[] envelopeBuf = new byte[20];
                Encoder.encodeEnvelope(envelope, envelopeBuf);
                this.servletResp.setContentType("application/x-hdl-message");
                if (!response.streaming) {
                    this.servletResp.setContentLength(envelopeBuf.length + msg.length);
                }
                out = new BufferedOutputStream((OutputStream)this.servletResp.getOutputStream());
                out.write(envelopeBuf);
                out.write(msg);
                out.flush();
                this.logAccess(response);
                if (response.streaming) {
                    sout = this.servletReq.isSecure() && !"DSA".equals(NativeServlet.this.handleServer.getPublicKey().getAlgorithm()) ? new SignedOutputStream(out) : new SignedOutputStream(NativeServlet.this.handleServer.getPrivateKey(), out);
                    response.streamResponse((SignedOutputStream)sout);
                    out.flush();
                }
            }
            catch (Exception e) {
                NativeServlet.this.logError(50, String.valueOf(this.getClass()) + ": Exception sending response: " + e);
                e.printStackTrace(System.err);
            }
            finally {
                if (sout != null) {
                    try {
                        sout.flush();
                    }
                    catch (Exception exception) {}
                    try {
                        sout.close();
                    }
                    catch (Exception exception) {}
                }
                if (out != null) {
                    try {
                        out.flush();
                    }
                    catch (Exception exception) {}
                    try {
                        out.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }

        private void logAccess(AbstractResponse response) {
            if (this.currentHdlRequest == null) {
                return;
            }
            String accessString = "HTTP:HDL(" + this.currentHdlRequest.suggestMajorProtocolVersion + "." + this.currentHdlRequest.suggestMinorProtocolVersion + ")";
            if (NativeServlet.this.handleServer != null) {
                if (NativeServlet.this.handleServer.logHttpAccesses()) {
                    long respTime = System.currentTimeMillis() - this.recvTime;
                    NativeServlet.this.handleServer.logAccess(accessString, NativeServlet.getRemoteInetAddress(this.servletReq), this.currentHdlRequest.opCode, response != null ? response.responseCode : 2, Util.getAccessLogString(this.currentHdlRequest), respTime);
                }
            } else {
                HDLProxy hdlProxy = (HDLProxy)((Object)this.servletReq.getServletContext().getAttribute(HDLProxy.class.getName()));
                if (hdlProxy == null) {
                    return;
                }
                long responseTime = System.currentTimeMillis() - this.recvTime;
                String referer = this.servletReq.getHeader("Referer");
                if (referer == null) {
                    referer = "";
                }
                String userAgent = this.servletReq.getHeader("user-agent");
                hdlProxy.logAccess(accessString, response.opCode, response.responseCode, Util.decodeString(this.currentHdlRequest.handle), hdlProxy.getRemoteAddr(this.servletReq), referer, userAgent, responseTime, null, null);
            }
        }
    }
}

