/*
 * Decompiled with CFR 0.152.
 */
package net.handle.server.servletcontainer.auth;

import java.security.PublicKey;
import java.security.Signature;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import net.cnri.util.StringUtils;
import net.handle.hdllib.AbstractRequest;
import net.handle.hdllib.AbstractResponse;
import net.handle.hdllib.AbstractResponseAndIndex;
import net.handle.hdllib.AuthenticationInfo;
import net.handle.hdllib.ChallengeAnswerRequest;
import net.handle.hdllib.ChallengeResponse;
import net.handle.hdllib.Common;
import net.handle.hdllib.Encoder;
import net.handle.hdllib.GenericRequest;
import net.handle.hdllib.HandleException;
import net.handle.hdllib.HandleResolver;
import net.handle.hdllib.HandleValue;
import net.handle.hdllib.ResolutionRequest;
import net.handle.hdllib.ResolutionResponse;
import net.handle.hdllib.SecretKeyAuthenticationInfo;
import net.handle.hdllib.Util;
import net.handle.hdllib.ValueReference;
import net.handle.hdllib.VerifyAuthRequest;
import net.handle.hdllib.VerifyAuthResponse;
import net.handle.server.servletcontainer.HandleServerInterface;
import net.handle.server.servletcontainer.auth.AuthenticationInfoWithId;
import net.handle.server.servletcontainer.auth.AuthenticationResponse;
import net.handle.server.servletcontainer.auth.HandleAuthenticationStatus;
import net.handle.server.servletcontainer.auth.HandleAuthorizationHeader;
import net.handle.server.servletcontainer.support.PreAuthenticatedAuthenticationInfo;
import net.handle.util.X509HSTrustManager;
import org.apache.commons.codec.binary.Base64;

public class StandardHandleAuthenticator {
    private final HttpServletRequest request;
    private final HttpSession session;
    private final AuthenticationResponse authResp;
    private final String authHeader;
    private final HandleAuthorizationHeader parsedHandleAuthHeader;

    public StandardHandleAuthenticator(HttpServletRequest request, HttpSession session, AuthenticationResponse authResp) {
        this.request = request;
        this.session = session;
        this.authResp = authResp;
        this.parsedHandleAuthHeader = (HandleAuthorizationHeader)request.getAttribute(HandleAuthorizationHeader.class.getName());
        this.authHeader = request.getHeader("Authorization");
    }

    private HandleAuthenticationStatus getHandleAuthStatus() {
        if (this.session == null) {
            return HandleAuthenticationStatus.fromSession(this.request.getSession(), true);
        }
        return HandleAuthenticationStatus.fromSession(this.session, true);
    }

    public void authenticate() {
        if (this.badSessionInHandleAuthorizationHeader()) {
            this.authResp.setAuthenticating(true);
            this.authResp.setAuthenticated(false);
            return;
        }
        AuthenticationInfoWithId authInfo = null;
        if (this.isAuthenticatingViaHeaderOrHandleAuthHeaderEntity()) {
            this.authResp.setAuthenticating(true);
            authInfo = this.checkSeenBefore();
            if (authInfo == null) {
                authInfo = this.authenticateViaHandleAuthorizationHeader();
            }
            if (authInfo == null) {
                authInfo = this.authenticateViaBasic();
            }
            if (authInfo != null && this.authHeader != null && this.session != null) {
                this.getHandleAuthStatus().setAuthorizationHeader(this.authHeader);
            }
        } else {
            authInfo = this.authenticateViaSession();
            if (authInfo == null) {
                authInfo = this.authenticateViaClientSideCert();
            }
        }
        if (authInfo != null) {
            this.authResp.setAuthenticated(true);
            this.authResp.setId(authInfo.getId());
            if (this.session != null) {
                this.getHandleAuthStatus().setAuthInfoWithId(authInfo);
            }
            this.request.setAttribute(AuthenticationInfo.class.getName(), (Object)authInfo.getAuthInfo());
        }
    }

    private boolean badSessionInHandleAuthorizationHeader() {
        return this.parsedHandleAuthHeader != null && this.parsedHandleAuthHeader.getSessionId() != null && (this.session == null || !this.session.getId().equals(this.parsedHandleAuthHeader.getSessionId()));
    }

    private boolean isAuthenticatingViaHeaderOrHandleAuthHeaderEntity() {
        if (this.authHeader != null && this.authHeader.trim().startsWith("Basic")) {
            return true;
        }
        if (this.parsedHandleAuthHeader != null) {
            return this.parsedHandleAuthHeader.isAuthenticating();
        }
        return this.authHeader != null;
    }

    private AuthenticationInfoWithId authenticateViaHandleAuthorizationHeader() {
        if (this.parsedHandleAuthHeader == null || !this.parsedHandleAuthHeader.isAuthenticating()) {
            return null;
        }
        if (this.session == null) {
            return null;
        }
        AuthenticationInfoWithId authInfo = this.authenticateViaHandleAuthorizationHeaderWhichIsAuthenticatingInSession();
        if (authInfo != null) {
            this.getHandleAuthStatus().setAuthInfoWithId(authInfo);
        }
        return authInfo;
    }

    private AuthenticationInfoWithId authenticateViaHandleAuthorizationHeaderWhichIsAuthenticatingInSession() {
        if (this.parsedHandleAuthHeader.getVersion() != null && !"0".equals(this.parsedHandleAuthHeader.getVersion())) {
            this.authResp.addError("Unknown version in Authorization: Handle");
            return null;
        }
        if (this.parsedHandleAuthHeader.isIncompleteAuthentication()) {
            this.authResp.addError("Missing fields in authentication data");
            return null;
        }
        try {
            byte[] signedResponse;
            byte[] nonce = this.getHandleAuthStatus().getNonce();
            byte[] cnonce = Base64.decodeBase64((String)this.parsedHandleAuthHeader.getCnonce());
            byte[] signature = Base64.decodeBase64((String)this.parsedHandleAuthHeader.getSignature());
            String alg = this.parsedHandleAuthHeader.getAlg();
            ValueReference val = this.extractHandleValueReferenceFromString(this.parsedHandleAuthHeader.getId());
            String authType = this.parsedHandleAuthHeader.getType();
            byte[] algBytes = Util.encodeString(alg);
            if (Util.equalsIgnoreCaseAndPunctuation(algBytes, Common.HASH_ALG_PBKDF2_HMAC_SHA1) || Util.equalsIgnoreCaseAndPunctuation(algBytes, Common.HASH_ALG_PBKDF2_HMAC_SHA1_ALTERNATE)) {
                String salt = this.parsedHandleAuthHeader.getSalt();
                String iterationsString = this.parsedHandleAuthHeader.getIterations();
                String keyLengthString = this.parsedHandleAuthHeader.getLength();
                if (salt != null && iterationsString != null && keyLengthString != null) {
                    signature = Util.constructPbkdf2Encoding(Base64.decodeBase64((String)salt), Integer.parseInt(iterationsString), Integer.parseInt(keyLengthString), signature);
                }
            }
            if ((signedResponse = StandardHandleAuthenticator.constructSignedResponse(authType, alg, signature)) == null) {
                this.authResp.addError("Error parsing Authorization: Handle");
                return null;
            }
            int index = this.verifyIdentityAndGetIndex(val, authType, nonce, cnonce, signedResponse);
            if (index >= 0) {
                return new AuthenticationInfoWithId(this.parsedHandleAuthHeader.getId(), new PreAuthenticatedAuthenticationInfo(val.handle, index));
            }
            return null;
        }
        catch (Exception e) {
            this.authResp.addError("Exception (" + e.getClass().getName() + ") parsing Authorization: Handle");
            return null;
        }
    }

    public static byte[] constructSignedResponse(String authType, String alg, byte[] signature) {
        int algCode;
        byte[] algBytes;
        byte[] algEncoded = Util.encodeString(alg);
        if (alg.equalsIgnoreCase("MD5")) {
            algBytes = Common.HASH_ALG_MD5;
            algCode = 1;
        } else if (alg.equalsIgnoreCase("SHA") || alg.equalsIgnoreCase("SHA1") || alg.equalsIgnoreCase("SHA-1")) {
            algBytes = Common.HASH_ALG_SHA1;
            algCode = 2;
        } else if (alg.equalsIgnoreCase("SHA-256") || alg.equalsIgnoreCase("SHA256") || alg.equalsIgnoreCase("SHA-2") || alg.equalsIgnoreCase("SHA2")) {
            algBytes = Common.HASH_ALG_SHA256;
            algCode = 3;
        } else if (Util.equalsIgnoreCaseAndPunctuation(Common.HASH_ALG_HMAC_SHA1, algEncoded)) {
            algBytes = Common.HASH_ALG_HMAC_SHA1;
            algCode = 18;
        } else if (Util.equalsIgnoreCaseAndPunctuation(Common.HASH_ALG_HMAC_SHA256, algEncoded)) {
            algBytes = Common.HASH_ALG_HMAC_SHA256;
            algCode = 19;
        } else if (Util.equalsIgnoreCaseAndPunctuation(algEncoded, Common.HASH_ALG_PBKDF2_HMAC_SHA1) || Util.equalsIgnoreCaseAndPunctuation(algEncoded, Common.HASH_ALG_PBKDF2_HMAC_SHA1_ALTERNATE)) {
            algBytes = Common.HASH_ALG_PBKDF2_HMAC_SHA1;
            algCode = 34;
        } else {
            return null;
        }
        if ("HS_SECKEY".equals(authType)) {
            byte[] authResponse = new byte[signature.length + 1];
            authResponse[0] = algCode;
            System.arraycopy(signature, 0, authResponse, 1, signature.length);
            return authResponse;
        }
        if ("HS_PUBKEY".equals(authType)) {
            int offset = 0;
            byte[] authResponse = new byte[signature.length + algBytes.length + 8];
            offset += Encoder.writeByteArray(authResponse, offset, algBytes);
            offset += Encoder.writeByteArray(authResponse, offset, signature);
            return authResponse;
        }
        return null;
    }

    private AuthenticationInfoWithId authenticateViaBasic() {
        if (this.authHeader == null) {
            return null;
        }
        String[] parts = this.authHeader.trim().split("\\s++");
        if (parts.length != 2) {
            return null;
        }
        if (!parts[0].equalsIgnoreCase("Basic")) {
            return null;
        }
        byte[] bytes = Base64.decodeBase64((String)parts[1]);
        int colon = Util.indexOf(bytes, (byte)58);
        if (colon < 0) {
            return null;
        }
        byte[] usernameEncoded = Util.substring(bytes, 0, colon);
        byte[] password = Util.substring(bytes, colon + 1);
        ValueReference val = this.extractHandleValueReferenceFromUrlEncodedBytes(usernameEncoded);
        if (this.checkSecretKey(val, password)) {
            return new AuthenticationInfoWithId(new PreAuthenticatedAuthenticationInfo(val.handle, val.index));
        }
        return null;
    }

    private AuthenticationInfoWithId checkSeenBefore() {
        if (this.session == null || this.authHeader == null) {
            return null;
        }
        String oldAuthHeader = this.getHandleAuthStatus().getAuthorizationHeader();
        if (this.authHeader.equals(oldAuthHeader)) {
            return this.getHandleAuthStatus().getAuthInfoWithId();
        }
        return null;
    }

    private boolean checkSecretKey(ValueReference val, byte[] password) {
        SecretKeyAuthenticationInfo authInfo = new SecretKeyAuthenticationInfo(val.handle, val.index, password);
        ServletContext servletContext = this.request.getServletContext();
        HandleServerInterface handleServer = (HandleServerInterface)servletContext.getAttribute("net.handle.server.HandleServer");
        if (handleServer == null) {
            HandleResolver handleResolver = this.getHandleResolver(servletContext);
            return this.checkSecretKeyViaResolver(handleResolver, authInfo);
        }
        return this.checkSecretKeyViaServer(handleServer, authInfo);
    }

    private int verifyIdentityAndGetIndex(ValueReference val, String authType, byte[] nonce, byte[] cnonce, byte[] signature) {
        ServletContext servletContext = this.request.getServletContext();
        HandleServerInterface handleServer = (HandleServerInterface)servletContext.getAttribute("net.handle.server.HandleServer");
        if (handleServer == null) {
            HandleResolver handleResolver = this.getHandleResolver(servletContext);
            return this.verifyIdentityViaResolver(handleResolver, val, authType, nonce, cnonce, signature);
        }
        return this.verifyIdentityViaServer(handleServer, val, authType, nonce, cnonce, signature);
    }

    private HandleResolver getHandleResolverEvenIfInServer(ServletContext servletContext) {
        HandleServerInterface handleServer = (HandleServerInterface)servletContext.getAttribute("net.handle.server.HandleServer");
        if (handleServer != null) {
            return handleServer.getResolver();
        }
        return this.getHandleResolver(servletContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HandleResolver getHandleResolver(ServletContext servletContext) {
        HandleResolver handleResolver = (HandleResolver)servletContext.getAttribute(HandleResolver.class.getName());
        if (handleResolver == null) {
            ServletContext servletContext2 = servletContext;
            synchronized (servletContext2) {
                handleResolver = (HandleResolver)servletContext.getAttribute(HandleResolver.class.getName());
                if (handleResolver == null) {
                    handleResolver = new HandleResolver();
                    servletContext.setAttribute(HandleResolver.class.getName(), (Object)handleResolver);
                }
            }
        }
        return handleResolver;
    }

    private boolean checkSecretKeyViaServer(HandleServerInterface handleServer, SecretKeyAuthenticationInfo authInfo) {
        try {
            String uri = this.request.getRequestURI();
            if (this.request.getQueryString() != null) {
                uri = uri + "?" + this.request.getQueryString();
            }
            GenericRequest origReq = new GenericRequest(Util.encodeString(uri), 2, null);
            ChallengeResponse cRes = new ChallengeResponse((AbstractRequest)origReq, true);
            byte[] signature = authInfo.authenticate(cRes, origReq);
            ChallengeAnswerRequest crReq = new ChallengeAnswerRequest(authInfo.getAuthType(), authInfo.getUserIdHandle(), authInfo.getUserIdIndex(), signature, authInfo);
            AbstractResponse resp = handleServer.verifyIdentity(cRes, crReq, origReq);
            if (resp == null) {
                return true;
            }
            this.authResp.addError("Identity not verified");
            return false;
        }
        catch (HandleException e) {
            this.authResp.addError("Exception (" + e.getClass().getName() + ") verifying identity");
            return false;
        }
    }

    private int verifyIdentityViaServer(HandleServerInterface handleServer, ValueReference val, String authType, byte[] nonce, byte[] cnonce, byte[] signature) {
        try {
            String uri = this.request.getRequestURI();
            if (this.request.getQueryString() != null) {
                uri = uri + "?" + this.request.getQueryString();
            }
            GenericRequest origReq = new GenericRequest(Util.encodeString(uri), 2, null);
            ChallengeResponse cRes = new ChallengeResponse(2, nonce);
            cRes.majorProtocolVersion = (byte)2;
            cRes.minorProtocolVersion = (byte)11;
            cRes.rdHashType = StandardHandleAuthenticator.hashTypeForCnonce(cnonce);
            cRes.requestDigest = cnonce;
            ChallengeAnswerRequest crReq = new ChallengeAnswerRequest(Util.encodeString(authType), val.handle, val.index, signature, null);
            AbstractResponseAndIndex resp = handleServer.verifyIdentityAndGetIndex(cRes, crReq, origReq);
            if (resp.getResponse() instanceof ChallengeResponse) {
                this.authResp.addError("Identity not verified; verifying server may only support older-format SHA-1 MAC");
                return -1;
            }
            if (resp.getResponse() != null) {
                this.authResp.addError("Identity not verified");
                return -1;
            }
            if (resp.getIndex() == 0) {
                return val.index;
            }
            return resp.getIndex();
        }
        catch (HandleException e) {
            this.authResp.addError("Exception (" + e.getClass().getName() + ") verifying identity");
            return -1;
        }
    }

    public static byte hashTypeForCnonce(byte[] cnonce) {
        return 0;
    }

    private boolean checkSecretKeyViaResolver(HandleResolver handleResolver, SecretKeyAuthenticationInfo authInfo) {
        try {
            String uri = this.request.getRequestURI();
            if (this.request.getQueryString() != null) {
                uri = uri + "?" + this.request.getQueryString();
            }
            GenericRequest origReq = new GenericRequest(Util.encodeString(uri), 2, null);
            ChallengeResponse challengeResp = new ChallengeResponse((AbstractRequest)origReq, true);
            byte[] signature = authInfo.authenticate(challengeResp, origReq);
            VerifyAuthRequest verifyAuthReq = new VerifyAuthRequest(authInfo.getUserIdHandle(), challengeResp.nonce, challengeResp.requestDigest, challengeResp.rdHashType, signature, authInfo.getUserIdIndex(), null);
            verifyAuthReq.certify = true;
            AbstractResponse response = handleResolver.processRequest(verifyAuthReq);
            if (response instanceof VerifyAuthResponse) {
                if (((VerifyAuthResponse)response).isValid) {
                    return true;
                }
                this.authResp.addError("Identity not verified");
                return false;
            }
            this.authResp.addError("Identity not verified");
            return false;
        }
        catch (HandleException e) {
            this.authResp.addError("Exception (" + e.getClass().getName() + ") verifying identity");
            return false;
        }
    }

    private int verifyIdentityViaResolver(HandleResolver handleResolver, ValueReference val, String authType, byte[] nonce, byte[] cnonce, byte[] signature) {
        try {
            if ("HS_SECKEY".equals(authType)) {
                if (this.verifySecretKeyIdentityViaResolver(handleResolver, val, nonce, cnonce, signature)) {
                    return -1;
                }
                return val.index;
            }
            if ("HS_PUBKEY".equals(authType)) {
                return this.verifyPublicKeyIdentityViaResolver(handleResolver, val, nonce, cnonce, signature);
            }
            this.authResp.addError("Unknown authType " + authType);
            return -1;
        }
        catch (Exception e) {
            this.authResp.addError("Exception (" + e.getClass().getName() + ") verifying identity");
            return -1;
        }
    }

    private int verifyPublicKeyIdentityViaResolver(HandleResolver handleResolver, ValueReference val, byte[] nonce, byte[] cnonce, byte[] signature) throws Exception {
        int[] nArray;
        byte[] byArray = val.handle;
        byte[][] byArray2 = val.index > 0 ? null : Common.PUBLIC_KEY_TYPES;
        if (val.index > 0) {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = val.index;
        } else {
            nArray = null;
        }
        ResolutionRequest req = new ResolutionRequest(byArray, byArray2, nArray, null);
        req.certify = true;
        AbstractResponse response = handleResolver.processRequest(req);
        if (!(response instanceof ResolutionResponse)) {
            return -1;
        }
        ResolutionResponse rresponse = (ResolutionResponse)response;
        HandleValue[] values = rresponse.getHandleValues();
        if (values == null || values.length < 1) {
            return -1;
        }
        int offset = 0;
        byte[] hashAlgId = Encoder.readByteArray(signature, offset);
        byte[] sigBytes = Encoder.readByteArray(signature, offset += 4 + hashAlgId.length);
        offset += 4 + sigBytes.length;
        Arrays.sort(values, HandleValue.INDEX_COMPARATOR);
        for (HandleValue value : values) {
            try {
                PublicKey pubKey = Util.getPublicKeyFromBytes(value.getData(), 0);
                Signature sig = Signature.getInstance(Util.getSigIdFromHashAlgId(hashAlgId, pubKey.getAlgorithm()));
                sig.initVerify(pubKey);
                sig.update(nonce);
                sig.update(cnonce);
                if (!sig.verify(sigBytes)) continue;
                return value.getIndex();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.authResp.addError("Identity not verified, signature failed");
        return -1;
    }

    private int getIndexMatchingPublicKey(HandleResolver handleResolver, byte[] handle, PublicKey publicKey) {
        try {
            ResolutionRequest req = new ResolutionRequest(handle, Common.PUBLIC_KEY_TYPES, null, null);
            req.certify = true;
            AbstractResponse response = handleResolver.processRequest(req);
            if (!(response instanceof ResolutionResponse)) {
                return 0;
            }
            ResolutionResponse rresponse = (ResolutionResponse)response;
            HandleValue[] values = rresponse.getHandleValues();
            if (values == null || values.length < 1) {
                return 0;
            }
            Arrays.sort(values, HandleValue.INDEX_COMPARATOR);
            for (HandleValue value : values) {
                PublicKey handlePubKey = Util.getPublicKeyFromBytes(value.getData(), 0);
                if (!publicKey.equals(handlePubKey) && !Util.equals(publicKey.getEncoded(), handlePubKey.getEncoded())) continue;
                return value.getIndex();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0;
    }

    private boolean verifySecretKeyIdentityViaResolver(HandleResolver handleResolver, ValueReference val, byte[] nonce, byte[] cnonce, byte[] signature) throws HandleException {
        VerifyAuthRequest verifyAuthReq = new VerifyAuthRequest(val.handle, nonce, cnonce, StandardHandleAuthenticator.hashTypeForCnonce(cnonce), signature, val.index, null);
        verifyAuthReq.certify = true;
        AbstractResponse response = handleResolver.processRequest(verifyAuthReq);
        if (response instanceof VerifyAuthResponse) {
            if (((VerifyAuthResponse)response).isValid) {
                return true;
            }
            this.authResp.addError("Identity not verified");
            return false;
        }
        this.authResp.addError("Identity not verified");
        return false;
    }

    private ValueReference extractHandleValueReferenceFromUrlEncodedBytes(byte[] usernameEncoded) {
        return this.extractHandleValueReferenceFromUrlEncodedString(Util.decodeString(usernameEncoded));
    }

    private ValueReference extractHandleValueReferenceFromUrlEncodedString(String usernameEncoded) {
        String username = StringUtils.decodeURLIgnorePlus((String)usernameEncoded);
        return this.extractHandleValueReferenceFromString(username);
    }

    private ValueReference extractHandleValueReferenceFromString(String username) {
        int colon = username.indexOf(58);
        if (colon < 0) {
            return new ValueReference(Util.encodeString(username), 0);
        }
        String maybeIndex = username.substring(0, colon);
        if (StandardHandleAuthenticator.isDigits(maybeIndex)) {
            String handle = username.substring(colon + 1);
            return new ValueReference(Util.encodeString(handle), Integer.parseInt(maybeIndex));
        }
        return new ValueReference(Util.encodeString(username), 0);
    }

    private AuthenticationInfoWithId authenticateViaClientSideCert() {
        X509Certificate cert = StandardHandleAuthenticator.extractCertificate(this.request);
        if (cert == null) {
            return null;
        }
        ValueReference id = X509HSTrustManager.parseIdentity(cert);
        if (id == null) {
            this.authResp.addError("Unable to parse identity from client-side certificate");
            return null;
        }
        int index = id.index;
        if (index == 0) {
            index = this.getIndexMatchingPublicKey(this.getHandleResolverEvenIfInServer(this.request.getServletContext()), id.handle, cert.getPublicKey());
        }
        return new AuthenticationInfoWithId(new PreAuthenticatedAuthenticationInfo(id.handle, index));
    }

    public static X509Certificate extractCertificate(HttpServletRequest request) {
        X509Certificate[] certs = (X509Certificate[])request.getAttribute("javax.servlet.request.X509Certificate");
        if (null != certs && certs.length > 0) {
            return certs[0];
        }
        return null;
    }

    private AuthenticationInfoWithId authenticateViaSession() {
        if (this.session == null) {
            return null;
        }
        return this.getHandleAuthStatus().getAuthInfoWithId();
    }

    private static boolean isDigits(String s) {
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            if (ch >= '0' && ch <= '9') continue;
            return false;
        }
        return true;
    }
}

