/*
 * Decompiled with CFR 0.152.
 */
package net.handle.server.servletcontainer.auth;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import net.cnri.util.ServletUtil;
import net.cnri.util.StringUtils;
import net.handle.hdllib.Util;
import net.handle.server.servletcontainer.HandleServerInterface;
import net.handle.server.servletcontainer.TlsRenegotiationRequestor;
import net.handle.server.servletcontainer.auth.AuthenticationResponse;
import net.handle.server.servletcontainer.auth.HandleAuthenticationStatus;
import net.handle.server.servletcontainer.auth.HandleAuthorizationHeader;
import net.handle.server.servletcontainer.auth.StandardHandleAuthenticator;
import org.apache.commons.codec.binary.Base64;

public class StandardHandleAuthenticationFilter
implements Filter {
    private static final String WWW_AUTHENTICATE_HEADER = "WWW-Authenticate";
    private static final int MAX_CACHED_ENTITY_FOR_RENEGOTIATION = 200000;
    private HandleServerInterface handleServer;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.handleServer = (HandleServerInterface)filterConfig.getServletContext().getAttribute("net.handle.server.HandleServer");
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (request instanceof HttpServletRequest && response instanceof HttpServletResponse) {
            this.doHttpFilter((HttpServletRequest)request, (HttpServletResponse)response, chain);
        } else {
            chain.doFilter(request, response);
        }
    }

    private void doHttpFilter(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        HandleAuthorizationHeader handleAuthHeader = this.parseHandleAuthorizationHeader(request);
        if (this.isAsyncTlsRenegotiate(handleAuthHeader, request, response)) {
            return;
        }
        AuthenticationResponse authResp = new AuthenticationResponse();
        request.setAttribute(AuthenticationResponse.class.getName(), (Object)authResp);
        HeaderFixingResponseWrapper wrappedResponse = new HeaderFixingResponseWrapper(request, response);
        if (request.isSecure() && !StandardHandleAuthenticationFilter.sessionsApi(request)) {
            this.processAuthenticationResponse(request, handleAuthHeader, authResp);
            new StandardHandleAuthenticator(request, request.getSession(false), authResp).authenticate();
            if (authResp.isAuthenticating() && !authResp.isAuthenticated()) {
                wrappedResponse.setStatus(401);
                return;
            }
            if (authResp.getServerSignature() != null) {
                wrappedResponse.addWwwAuthenticateHandleHeader();
            }
        }
        chain.doFilter((ServletRequest)request, (ServletResponse)wrappedResponse);
    }

    private boolean isAsyncTlsRenegotiate(HandleAuthorizationHeader handleAuthHeader, HttpServletRequest req, HttpServletResponse resp) throws IOException {
        if (handleAuthHeader == null) {
            return false;
        }
        if (!req.isSecure()) {
            return false;
        }
        Boolean wantClientAuth = handleAuthHeader.getClientCertAsBooleanObject();
        if (wantClientAuth == null && !handleAuthHeader.isRequestingForceRenegotiate()) {
            return false;
        }
        TlsRenegotiationRequestor tlsRenegotiationRequestor = (TlsRenegotiationRequestor)req.getAttribute(TlsRenegotiationRequestor.class.getName());
        boolean isWanting = tlsRenegotiationRequestor.isWantingTlsRenegotiation(wantClientAuth, handleAuthHeader.isRequestingForceRenegotiate());
        if (!isWanting) {
            return false;
        }
        if (wantClientAuth != null && !wantClientAuth.booleanValue() && tlsRenegotiationRequestor.isNeedClientAuth()) {
            resp.setStatus(403);
            return true;
        }
        if (req.getContentLength() == 0 || "GET".equals(req.getMethod()) || "HEAD".equals(req.getMethod())) {
            tlsRenegotiationRequestor.requestTlsRenegotiation(null, wantClientAuth);
            return true;
        }
        if (req.getContentLength() > 200000) {
            resp.setStatus(413);
            return true;
        }
        ContentCachingRequestWrapper wrappedReq = new ContentCachingRequestWrapper(req);
        if (wrappedReq.isTooLong()) {
            resp.setStatus(413);
            return true;
        }
        if (wrappedReq.isEmpty()) {
            tlsRenegotiationRequestor.requestTlsRenegotiation(null, wantClientAuth);
            return true;
        }
        tlsRenegotiationRequestor.requestTlsRenegotiation((HttpServletRequest)wrappedReq, wantClientAuth);
        return true;
    }

    private HandleAuthorizationHeader parseHandleAuthorizationHeader(HttpServletRequest request) {
        String authHeader = request.getHeader("Authorization");
        if (authHeader == null) {
            return null;
        }
        return HandleAuthorizationHeader.fromHeader(authHeader);
    }

    private void processAuthenticationResponse(HttpServletRequest request, HandleAuthorizationHeader handleAuthHeader, AuthenticationResponse authResp) {
        if (handleAuthHeader != null) {
            request.setAttribute(HandleAuthorizationHeader.class.getName(), (Object)handleAuthHeader);
            if (handleAuthHeader.requiresSession()) {
                HandleAuthenticationStatus status = HandleAuthenticationStatus.fromSession(request.getSession(), true);
                authResp.setSessionId(status.getSessionId());
                authResp.setNonce(status.getNonce());
                if (handleAuthHeader.isAuthenticating()) {
                    authResp.setAuthenticating(true);
                }
                HandleAuthenticationStatus.processServerSignature(this.handleServer, request.getSession(), handleAuthHeader, authResp);
            }
        }
    }

    private static boolean sessionsApi(HttpServletRequest request) {
        String path = StandardHandleAuthenticationFilter.getPath(request);
        return "/api/sessions".equals(path) || path.startsWith("/api/sessions/");
    }

    private static String getPath(HttpServletRequest servletReq) {
        String path = ServletUtil.pathExcluding((String)servletReq.getRequestURI(), (String)servletReq.getContextPath());
        path = StringUtils.decodeURLIgnorePlus((String)path);
        return path;
    }

    static String quote(String s) throws UnsupportedEncodingException {
        s = new String(Util.encodeString(s), "US-ASCII");
        s = s.replaceAll("\\p{Cntrl}", "");
        return "\"" + s.replace("\\", "\\\\").replace("\"", "\\\"") + "\"";
    }

    private static class HeaderFixingResponseWrapper
    extends HttpServletResponseWrapper {
        private static final String ACCESS_CONTROL_EXPOSE_HEADERS = "Access-Control-Expose-Headers";
        private final HttpServletRequest request;
        private final Set<String> exposedHeaders;

        public HeaderFixingResponseWrapper(HttpServletRequest request, HttpServletResponse response) {
            super(response);
            this.request = request;
            if (request.getHeader("Origin") != null) {
                this.exposedHeaders = new HashSet<String>();
                this.exposedHeaders.add("Content-Length");
                this.fixResponseExposeHeaders();
            } else {
                this.exposedHeaders = null;
            }
        }

        private void fixResponseExposeHeaders() {
            Collection headers = this.getHeaders(ACCESS_CONTROL_EXPOSE_HEADERS);
            if (headers == null) {
                return;
            }
            for (String header : headers) {
                if (header == null || header.isEmpty()) continue;
                for (String field : header.split(",")) {
                    this.exposedHeaders.add(field);
                }
            }
            if (this.exposedHeaders.isEmpty()) {
                super.setHeader(ACCESS_CONTROL_EXPOSE_HEADERS, null);
            } else {
                super.setHeader(ACCESS_CONTROL_EXPOSE_HEADERS, this.commify(this.exposedHeaders));
            }
        }

        public void setStatus(int sc) {
            super.setStatus(sc);
            this.addAuthenticateHeaders(sc);
        }

        @Deprecated
        public void setStatus(int sc, String sm) {
            super.setStatus(sc, sm);
            this.addAuthenticateHeaders(sc);
        }

        public void setDateHeader(String name, long date) {
            this.exposeHeader(name);
            super.setDateHeader(name, date);
        }

        public void addDateHeader(String name, long date) {
            this.exposeHeader(name);
            super.addDateHeader(name, date);
        }

        public void setHeader(String name, String value) {
            this.exposeHeader(name);
            super.setHeader(name, value);
        }

        public void addHeader(String name, String value) {
            this.exposeHeader(name);
            super.addHeader(name, value);
        }

        public void setIntHeader(String name, int value) {
            this.exposeHeader(name);
            super.setIntHeader(name, value);
        }

        public void addIntHeader(String name, int value) {
            this.exposeHeader(name);
            super.addIntHeader(name, value);
        }

        private boolean isSimpleHeader(String name) {
            return name.equalsIgnoreCase("Cache-Control") || name.equalsIgnoreCase("Content-Language") || name.equalsIgnoreCase("Content-Type") || name.equalsIgnoreCase("Expires") || name.equalsIgnoreCase("Last-Modified") || name.equalsIgnoreCase("Pragma");
        }

        private void exposeHeader(String name) {
            if (this.exposedHeaders != null && !name.toLowerCase().startsWith("access-control-") && !this.isSimpleHeader(name)) {
                this.exposedHeaders.add(name);
                super.setHeader(ACCESS_CONTROL_EXPOSE_HEADERS, this.commify(this.exposedHeaders));
            }
        }

        private String commify(Collection<String> ss) {
            StringBuilder sb = new StringBuilder();
            boolean first = true;
            for (String s : ss) {
                if (!first) {
                    sb.append(",");
                }
                first = false;
                sb.append(s);
            }
            return sb.toString();
        }

        private void addAuthenticateHeaders(int sc) {
            if (sc == 401) {
                if (this.request.isSecure()) {
                    if (!this.containsHeader(StandardHandleAuthenticationFilter.WWW_AUTHENTICATE_HEADER)) {
                        if (this.requestMayWantBasicAuth()) {
                            this.addHeader(StandardHandleAuthenticationFilter.WWW_AUTHENTICATE_HEADER, "Basic realm=\"handle\"");
                        }
                        this.addWwwAuthenticateHandleHeader();
                    }
                } else {
                    super.setStatus(403);
                }
            }
        }

        private boolean requestMayWantBasicAuth() {
            String authHeader = this.request.getHeader("Authorization");
            if (authHeader != null) {
                return authHeader.startsWith("Basic");
            }
            return !"XMLHttpRequest".equals(this.request.getHeader("X-Requested-With"));
        }

        public void addWwwAuthenticateHandleHeader() {
            AuthenticationResponse authResp = (AuthenticationResponse)this.request.getAttribute(AuthenticationResponse.class.getName());
            if (authResp.getSessionId() == null) {
                this.addSessionInfo(authResp);
            }
            StringBuilder sb = new StringBuilder();
            sb.append("Handle sessionId=\"").append(authResp.getSessionId()).append("\"");
            sb.append(", nonce=\"").append(Base64.encodeBase64String((byte[])authResp.getNonce())).append("\"");
            if (authResp.getServerSignature() != null) {
                sb.append(", serverAlg=\"").append(authResp.getServerAlg()).append("\"");
                sb.append(", serverSignature=\"").append(Base64.encodeBase64String((byte[])authResp.getServerSignature())).append("\"");
            }
            if (!authResp.getErrors().isEmpty()) {
                sb.append(", error=\"").append(HeaderFixingResponseWrapper.combineErrorsForHeader(authResp.getErrors())).append("\"");
            }
            this.addHeader(StandardHandleAuthenticationFilter.WWW_AUTHENTICATE_HEADER, sb.toString());
        }

        private void addSessionInfo(AuthenticationResponse authResp) {
            HandleAuthenticationStatus status = HandleAuthenticationStatus.fromSession(this.request.getSession(), true);
            authResp.setSessionId(status.getSessionId());
            authResp.setNonce(status.getNonce());
        }

        private static String combineErrorsForHeader(Collection<String> errors) {
            StringBuilder sb = new StringBuilder();
            for (String error : errors) {
                if (sb.length() > 0) {
                    sb.append("; ");
                }
                HeaderFixingResponseWrapper.escapeErrorForHeader(sb, error);
            }
            return sb.toString();
        }

        private static void escapeErrorForHeader(StringBuilder sb, String error) {
            for (byte b : Util.encodeString(error)) {
                if (b == 34) {
                    sb.append("\\\"");
                    continue;
                }
                if (b == 92) {
                    sb.append("\\\\");
                    continue;
                }
                if (b >= 32 && b < 127 && b != 37) {
                    sb.append((char)b);
                    continue;
                }
                sb.append("%");
                sb.append(StringUtils.encodeHexChar((byte)b));
            }
        }
    }

    private static class ContentCachingRequestWrapper
    extends HttpServletRequestWrapper {
        private BufferedReader reader;
        private boolean isTooLong;
        private boolean empty;

        public ContentCachingRequestWrapper(HttpServletRequest request) throws IOException {
            super(request);
            int r;
            BufferedReader origReader;
            request.getParameter("foo");
            try {
                origReader = request.getReader();
            }
            catch (IllegalStateException e) {
                return;
            }
            StringWriter writer = new StringWriter();
            char[] buf = new char[4096];
            int len = 0;
            while ((r = origReader.read(buf)) > 0) {
                writer.write(buf, 0, r);
                if ((len += r) <= 200000) continue;
                writer.close();
                writer = null;
                this.isTooLong = true;
                return;
            }
            if (len == 0) {
                this.empty = true;
                return;
            }
            this.reader = new BufferedReader(new StringReader(writer.toString()));
        }

        public BufferedReader getReader() throws IOException {
            if (this.reader == null) {
                throw new IllegalStateException("Already streamed entity as form parameters");
            }
            return this.reader;
        }

        public boolean isTooLong() {
            return this.isTooLong;
        }

        public boolean isEmpty() {
            return this.empty;
        }
    }
}

