/*
 * Decompiled with CFR 0.152.
 */
package net.handle.server.servletcontainer.auth;

import java.security.PrivateKey;
import java.security.Signature;
import javax.servlet.http.HttpSession;
import net.handle.hdllib.AuthenticationInfo;
import net.handle.hdllib.ChallengeResponse;
import net.handle.hdllib.HandleException;
import net.handle.hdllib.Util;
import net.handle.server.servletcontainer.HandleServerInterface;
import net.handle.server.servletcontainer.auth.AuthenticationInfoWithId;
import net.handle.server.servletcontainer.auth.AuthenticationResponse;
import net.handle.server.servletcontainer.auth.HandleAuthorizationHeader;
import org.apache.commons.codec.binary.Base64;

public class HandleAuthenticationStatus {
    private String sessionId;
    private byte[] nonce;
    private byte[] cnonce;
    private byte[] serverSignature;
    private String authorizationHeader;
    private AuthenticationInfo authInfo;
    private String id;
    private static final Object LOCK = new Object();

    public static byte[] generateNonce() {
        return ChallengeResponse.generateNonce();
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public byte[] getNonce() {
        return this.nonce;
    }

    public void setNonce(byte[] nonce) {
        this.nonce = nonce;
    }

    public byte[] getCnonce() {
        return this.cnonce;
    }

    public void setCnonce(byte[] cnonce) {
        this.cnonce = cnonce;
    }

    public byte[] getServerSignature() {
        return this.serverSignature;
    }

    public void setServerSignature(byte[] serverSignature) {
        this.serverSignature = serverSignature;
    }

    public String getAuthorizationHeader() {
        return this.authorizationHeader;
    }

    public void setAuthorizationHeader(String authorizationHeader) {
        this.authorizationHeader = authorizationHeader;
    }

    public AuthenticationInfo getAuthInfo() {
        return this.authInfo;
    }

    public void setAuthInfo(AuthenticationInfo authInfo) {
        this.authInfo = authInfo;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public AuthenticationInfoWithId getAuthInfoWithId() {
        if (this.authInfo == null) {
            return null;
        }
        return new AuthenticationInfoWithId(this.id, this.authInfo);
    }

    public void setAuthInfoWithId(AuthenticationInfoWithId authInfo) {
        this.id = authInfo.getId();
        this.authInfo = authInfo.getAuthInfo();
    }

    public String getServerAlg(HandleServerInterface handleServer) throws HandleException {
        return Util.decodeString(Util.getHashAlgIdFromSigId(Util.getDefaultSigId(handleServer.getPrivateKey().getAlgorithm())));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getServerSignature(HandleServerInterface handleServer, byte[] cnonceParam) throws HandleException {
        HandleAuthenticationStatus handleAuthenticationStatus = this;
        synchronized (handleAuthenticationStatus) {
            if (this.serverSignature != null && Util.equals(cnonceParam, this.cnonce)) {
                return this.serverSignature;
            }
        }
        PrivateKey privateKey = handleServer.getPrivateKey();
        try {
            Signature signer = Signature.getInstance(Util.getDefaultSigId(privateKey.getAlgorithm()));
            signer.initSign(privateKey);
            signer.update(this.nonce);
            signer.update(cnonceParam);
            byte[] signatureBytes = signer.sign();
            HandleAuthenticationStatus handleAuthenticationStatus2 = this;
            synchronized (handleAuthenticationStatus2) {
                this.cnonce = cnonceParam;
                this.serverSignature = signatureBytes;
            }
            return signatureBytes;
        }
        catch (Exception e) {
            throw new HandleException(1, "Unable to sign challenge", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HandleAuthenticationStatus fromSession(HttpSession session, boolean create) {
        Object sessionLock;
        HandleAuthenticationStatus res = (HandleAuthenticationStatus)session.getAttribute(HandleAuthenticationStatus.class.getName());
        if (res != null) {
            return res;
        }
        if (!create) {
            return null;
        }
        Object object = sessionLock = HandleAuthenticationStatus.getSessionLock(session);
        synchronized (object) {
            res = (HandleAuthenticationStatus)session.getAttribute(HandleAuthenticationStatus.class.getName());
            if (res != null) {
                return res;
            }
            res = new HandleAuthenticationStatus();
            res.setSessionId(session.getId());
            res.setNonce(HandleAuthenticationStatus.generateNonce());
            session.setAttribute(HandleAuthenticationStatus.class.getName(), (Object)res);
            return res;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object getSessionLock(HttpSession session) {
        Object lock = session.getAttribute(HandleAuthenticationStatus.class.getName() + ".lock");
        if (lock != null) {
            return lock;
        }
        Object object = LOCK;
        synchronized (object) {
            lock = session.getAttribute(HandleAuthenticationStatus.class.getName() + ".lock");
            if (lock != null) {
                return lock;
            }
            lock = new Object();
            session.setAttribute(HandleAuthenticationStatus.class.getName() + ".lock", lock);
            return lock;
        }
    }

    public static void processServerSignature(HandleServerInterface handleServer, HttpSession session, HandleAuthorizationHeader handleAuthHeader, AuthenticationResponse authResp) {
        if (handleAuthHeader != null && handleAuthHeader.isRequestingServerSignature() && handleServer != null) {
            HandleAuthenticationStatus status = HandleAuthenticationStatus.fromSession(session, true);
            authResp.setSessionId(status.getSessionId());
            authResp.setNonce(status.getNonce());
            try {
                authResp.setServerSignature(status.getServerSignature(handleServer, Base64.decodeBase64((String)handleAuthHeader.getCnonce())));
                authResp.setServerAlg(status.getServerAlg(handleServer));
            }
            catch (HandleException e) {
                authResp.getErrors().add(e.toString());
            }
        }
    }
}

