/*
 * Decompiled with CFR 0.152.
 */
package net.handle.server.servletcontainer;

import java.lang.ref.WeakReference;
import java.nio.channels.ByteChannel;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import net.handle.server.servletcontainer.PortUnificationSelectChannelConnector;
import net.handle.server.servletcontainer.auth.StandardHandleAuthenticator;
import org.eclipse.jetty.io.nio.ChannelEndPoint;
import org.eclipse.jetty.io.nio.SslConnection;
import org.eclipse.jetty.server.Request;

public class TlsRenegotiationRequestor {
    private static final String PROCESSED_ATTRIBUTE_NAME = TlsRenegotiationRequestor.class.getName() + ".processed";
    private final SslConnection.SslEndPoint sslEndPoint;
    private final Request request;

    TlsRenegotiationRequestor(SslConnection.SslEndPoint sslEndPoint, Request request) {
        this.sslEndPoint = sslEndPoint;
        this.request = request;
    }

    public boolean isWantingTlsRenegotiation(Boolean wantClientAuth, boolean force) {
        if (!force && wantClientAuth == null) {
            return false;
        }
        if (this.request.getAttribute(PROCESSED_ATTRIBUTE_NAME) != null) {
            return false;
        }
        SSLEngine sslEngine = this.sslEndPoint.getSslEngine();
        if (!force) {
            if (wantClientAuth.booleanValue()) {
                if (sslEngine.getNeedClientAuth()) {
                    return false;
                }
                if (sslEngine.getWantClientAuth() && StandardHandleAuthenticator.extractCertificate((HttpServletRequest)this.request) != null) {
                    return false;
                }
            } else {
                if (!sslEngine.getNeedClientAuth() && !sslEngine.getWantClientAuth()) {
                    return false;
                }
                if (sslEngine.getWantClientAuth() && StandardHandleAuthenticator.extractCertificate((HttpServletRequest)this.request) == null) {
                    return false;
                }
            }
        }
        return true;
    }

    public boolean isNeedClientAuth() {
        SSLEngine sslEngine = this.sslEndPoint.getSslEngine();
        return sslEngine.getNeedClientAuth();
    }

    public void requestTlsRenegotiation(HttpServletRequest req, Boolean wantClientAuth) throws SSLException {
        this.request.setAttribute(PROCESSED_ATTRIBUTE_NAME, (Object)Boolean.TRUE);
        if (!(this.sslEndPoint.getEndpoint() instanceof ChannelEndPoint)) {
            throw new AssertionError((Object)"unexpected object structure in requestTlsRenegotiation");
        }
        ByteChannel channel = ((ChannelEndPoint)this.sslEndPoint.getEndpoint()).getChannel();
        if (!(channel instanceof PortUnificationSelectChannelConnector.ReadAheadSocketChannelWrapper)) {
            throw new AssertionError((Object)"unexpected object structure in requestTlsRenegotiation");
        }
        ((PortUnificationSelectChannelConnector.ReadAheadSocketChannelWrapper)channel).request = new WeakReference<Request>(this.request);
        SSLEngine sslEngine = this.sslEndPoint.getSslEngine();
        sslEngine.getSession().invalidate();
        if (wantClientAuth != null && !sslEngine.getNeedClientAuth()) {
            sslEngine.setWantClientAuth(wantClientAuth);
        }
        sslEngine.beginHandshake();
        if (req == null) {
            this.request.startAsync();
        } else {
            this.request.startAsync((ServletRequest)req, this.request.getServletResponse());
        }
    }
}

