/*
 * Decompiled with CFR 0.152.
 */
package net.handle.server.servletcontainer;

import java.io.File;
import java.net.InetAddress;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.handle.hdllib.HandleResolver;
import org.eclipse.jetty.server.Handler;

public class EmbeddedJettyConfig {
    private File baseDir = null;
    private String webAppsPriorityPath = null;
    private String webAppsPath = null;
    private String webAppsStoragePath = null;
    private String webAppsTempPath = null;
    private String jettyXmlPath = null;
    private boolean enableDefaultHttpConfig = true;
    private final ConnectorConfig httpConnectorConfig = new ConnectorConfig();
    private final ConnectorConfig httpsConnectorConfig = new ConnectorConfig();
    private final List<ConnectorConfig> connectors;
    private final List<Handler> defaultHandlers;
    private List<String> systemClasses;
    private List<String> serverClasses;
    private Map<String, Object> contextAttributes;
    private HandleResolver resolver;

    public EmbeddedJettyConfig() {
        this.httpsConnectorConfig.setHttps(true);
        this.connectors = new ArrayList<ConnectorConfig>();
        this.defaultHandlers = new ArrayList<Handler>();
        this.systemClasses = new ArrayList<String>();
        this.serverClasses = new ArrayList<String>();
        this.contextAttributes = new HashMap<String, Object>();
        this.resolver = null;
    }

    private void addConnectorIfMissing(ConnectorConfig connectorConfig) {
        if (!this.connectors.contains(connectorConfig)) {
            this.connectors.add(connectorConfig);
        }
    }

    @Deprecated
    public void setHttpPort(int httpPort) {
        this.httpConnectorConfig.setPort(httpPort);
        this.addConnectorIfMissing(this.httpConnectorConfig);
    }

    @Deprecated
    public void setHttpListenAddress(InetAddress httpListenAddress) {
        this.httpConnectorConfig.setListenAddress(httpListenAddress);
    }

    @Deprecated
    public void setHttpsPort(int httpsPort) {
        this.httpsConnectorConfig.setPort(httpsPort);
        this.httpConnectorConfig.setRedirectPort(httpsPort);
        this.addConnectorIfMissing(this.httpsConnectorConfig);
    }

    @Deprecated
    public void setHttpsListenAddress(InetAddress httpsListenAddress) {
        this.httpsConnectorConfig.setListenAddress(httpsListenAddress);
    }

    @Deprecated
    public void setHttpsKeyPassword(String httpsKeyPassword) {
        this.httpsConnectorConfig.setHttpsKeyPassword(httpsKeyPassword);
    }

    @Deprecated
    public void setHttpsAlias(String httpsAlias) {
        this.httpsConnectorConfig.setHttpsAlias(httpsAlias);
    }

    @Deprecated
    public void setUseSelfSignedCert(boolean useSelfSignedCert) {
        this.httpsConnectorConfig.setHttpsUseSelfSignedCert(useSelfSignedCert);
    }

    @Deprecated
    public void setHttpsKeyStorePassword(String httpsKeyStorePassword) {
        this.httpsConnectorConfig.setHttpsKeyStorePassword(httpsKeyStorePassword);
    }

    @Deprecated
    public void setHttpsKeyStoreFile(String httpsKeyStoreFile) {
        this.httpsConnectorConfig.setHttpsKeyStoreFile(httpsKeyStoreFile);
    }

    @Deprecated
    public void setHttpsClientAuth(String httpsClientAuth) {
        this.httpsConnectorConfig.setHttpsClientAuth(httpsClientAuth);
    }

    @Deprecated
    public void setId(String id) {
        this.httpsConnectorConfig.setHttpsId(id);
    }

    @Deprecated
    public void setPubKey(PublicKey pubKey) {
        this.httpsConnectorConfig.setHttpsPubKey(pubKey);
    }

    @Deprecated
    public void setPrivKey(PrivateKey privKey) {
        this.httpsConnectorConfig.setHttpsPrivKey(privKey);
    }

    public boolean isEnableDefaultHttpConfig() {
        return this.enableDefaultHttpConfig;
    }

    public void setEnableDefaultHttpConfig(boolean enableDefaultHttpConfig) {
        this.enableDefaultHttpConfig = enableDefaultHttpConfig;
    }

    public File getBaseDir() {
        return this.baseDir;
    }

    public void setBaseDir(File baseDir) {
        this.baseDir = baseDir;
    }

    public String getWebAppsPriorityPath() {
        return this.webAppsPriorityPath;
    }

    public void setWebAppsPriorityPath(String webAppsPriorityPath) {
        this.webAppsPriorityPath = webAppsPriorityPath;
    }

    public String getWebAppsPath() {
        return this.webAppsPath;
    }

    public void setWebAppsPath(String webAppsPath) {
        this.webAppsPath = webAppsPath;
    }

    public String getWebAppsStoragePath() {
        return this.webAppsStoragePath;
    }

    public void setWebAppsStoragePath(String webAppsStoragePath) {
        this.webAppsStoragePath = webAppsStoragePath;
    }

    public String getWebAppsTempPath() {
        return this.webAppsTempPath;
    }

    public void setWebAppsTempPath(String webAppsTempPath) {
        this.webAppsTempPath = webAppsTempPath;
    }

    public String getJettyXmlPath() {
        return this.jettyXmlPath;
    }

    public void setJettyXmlPath(String jettyXmlPath) {
        this.jettyXmlPath = jettyXmlPath;
    }

    public List<String> getSystemClasses() {
        return this.systemClasses;
    }

    public void setSystemClasses(List<String> systemClasses) {
        this.systemClasses = systemClasses;
    }

    public void addSystemClass(String systemClass) {
        this.systemClasses.add(systemClass);
    }

    public List<String> getServerClasses() {
        return this.serverClasses;
    }

    public void setServerClasses(List<String> serverClasses) {
        this.serverClasses = serverClasses;
    }

    public void addServerClass(String serverClass) {
        this.serverClasses.add(serverClass);
    }

    public Map<String, Object> getContextAttributes() {
        return this.contextAttributes;
    }

    public void setContextAttributes(Map<String, Object> contextAttributes) {
        this.contextAttributes = contextAttributes;
    }

    public void addContextAttribute(String key, Object value) {
        this.contextAttributes.put(key, value);
    }

    public HandleResolver getResolver() {
        return this.resolver;
    }

    public void setResolver(HandleResolver resolver) {
        this.resolver = resolver;
    }

    public List<Handler> getDefaultHandlers() {
        return this.defaultHandlers;
    }

    public void addDefaultHandler(Handler handler) {
        this.defaultHandlers.add(handler);
    }

    public List<ConnectorConfig> getConnectors() {
        return this.connectors;
    }

    public void addConnector(ConnectorConfig connectorConfig) {
        this.connectors.add(connectorConfig);
    }

    public static class ConnectorConfig {
        private boolean https;
        private boolean httpOnly;
        private int port;
        private InetAddress listenAddress;
        private int redirectPort;
        private boolean httpsUseSelfSignedCert;
        private String httpsKeyStorePassword;
        private String httpsKeyPassword;
        private String httpsKeyStoreFile;
        private String httpsAlias;
        private String httpsId;
        private PublicKey httpsPubKey;
        private PrivateKey httpsPrivKey;
        private X509Certificate[] httpsCertificateChain;
        private String httpsClientAuth;

        public boolean isHttps() {
            return this.https;
        }

        public void setHttps(boolean https) {
            this.https = https;
        }

        public boolean isHttpOnly() {
            return this.httpOnly;
        }

        public void setHttpOnly(boolean httpOnly) {
            this.httpOnly = httpOnly;
        }

        public int getPort() {
            return this.port;
        }

        public void setPort(int port) {
            this.port = port;
        }

        public int getRedirectPort() {
            return this.redirectPort;
        }

        public void setRedirectPort(int port) {
            this.redirectPort = port;
        }

        public InetAddress getListenAddress() {
            return this.listenAddress;
        }

        public void setListenAddress(InetAddress listenAddress) {
            this.listenAddress = listenAddress;
        }

        public boolean isHttpsUseSelfSignedCert() {
            return this.httpsUseSelfSignedCert;
        }

        public void setHttpsUseSelfSignedCert(boolean httpsUseSelfSignedCert) {
            this.httpsUseSelfSignedCert = httpsUseSelfSignedCert;
        }

        public String getHttpsKeyStorePassword() {
            return this.httpsKeyStorePassword;
        }

        public void setHttpsKeyStorePassword(String httpsKeyStorePassword) {
            this.httpsKeyStorePassword = httpsKeyStorePassword;
        }

        public String getHttpsKeyPassword() {
            return this.httpsKeyPassword;
        }

        public void setHttpsKeyPassword(String httpsKeyPassword) {
            this.httpsKeyPassword = httpsKeyPassword;
        }

        public String getHttpsKeyStoreFile() {
            return this.httpsKeyStoreFile;
        }

        public void setHttpsKeyStoreFile(String httpsKeyStoreFile) {
            this.httpsKeyStoreFile = httpsKeyStoreFile;
        }

        public String getHttpsAlias() {
            return this.httpsAlias;
        }

        public void setHttpsAlias(String httpsAlias) {
            this.httpsAlias = httpsAlias;
        }

        public String getHttpsClientAuth() {
            return this.httpsClientAuth;
        }

        public void setHttpsClientAuth(String httpsClientAuth) {
            this.httpsClientAuth = httpsClientAuth;
        }

        public String getHttpsId() {
            return this.httpsId;
        }

        public void setHttpsId(String httpsId) {
            this.httpsId = httpsId;
        }

        public PublicKey getHttpsPubKey() {
            return this.httpsPubKey;
        }

        public void setHttpsPubKey(PublicKey httpsPubKey) {
            this.httpsPubKey = httpsPubKey;
        }

        public PrivateKey getHttpsPrivKey() {
            return this.httpsPrivKey;
        }

        public void setHttpsPrivKey(PrivateKey httpsPrivKey) {
            this.httpsPrivKey = httpsPrivKey;
        }

        public X509Certificate[] getHttpsCertificateChain() {
            return this.httpsCertificateChain;
        }

        public void setHttpsCertificateChain(X509Certificate[] httpsCertificateChain) {
            this.httpsCertificateChain = httpsCertificateChain;
        }
    }
}

