/*
 * Decompiled with CFR 0.152.
 */
package net.handle.server.replication;

import net.handle.hdllib.Encoder;
import net.handle.hdllib.GsonUtility;
import net.handle.hdllib.HandleException;
import net.handle.hdllib.HandleResolver;
import net.handle.hdllib.HandleValue;
import net.handle.hdllib.SiteInfo;
import net.handle.hdllib.Transaction;
import net.handle.hdllib.Util;

public class TransactionValidationErrorMessage {
    public String type = "TransactionValidationErrorMessage";
    public HandleValue[] handleValues;
    public Transaction txn;
    public SiteInfo receivingSiteInfo;
    public int receivingServerNumber;
    public SiteInfo sourceSiteInfo;
    public int sourceServerNumber;

    public TransactionValidationErrorMessage(HandleValue[] handleValues, Transaction txn, SiteInfo receivingSiteInfo, int receivingServerNumber, SiteInfo sourceSiteInfo, int sourceServerNumber) {
        this.handleValues = handleValues;
        this.txn = txn;
        this.receivingSiteInfo = receivingSiteInfo;
        this.receivingServerNumber = receivingServerNumber;
        this.sourceSiteInfo = sourceSiteInfo;
        this.sourceServerNumber = sourceServerNumber;
    }

    public static void main(String[] args) throws HandleException {
        HandleResolver resolver = new HandleResolver();
        HandleValue[] values = resolver.resolveHandle("0.na/cnri.test.ben");
        SiteInfo site1 = null;
        SiteInfo site2 = null;
        for (HandleValue value : values) {
            if (!"HS_SITE".equals(value.getTypeAsString())) continue;
            SiteInfo siteInfo = new SiteInfo();
            Encoder.decodeSiteInfoRecord(value.getData(), 0, siteInfo);
            if (site1 == null) {
                site1 = siteInfo;
                continue;
            }
            site2 = siteInfo;
            break;
        }
        Transaction txn = new Transaction(10L, Util.encodeString("0.na/cnri.test.ben"), values, 3, Long.MAX_VALUE);
        TransactionValidationErrorMessage msg = new TransactionValidationErrorMessage(values, txn, site1, 0, site2, 0);
        String json = GsonUtility.getNewGsonBuilder().setPrettyPrinting().create().toJson((Object)msg);
        System.out.println(json);
    }
}

