/*
 * Decompiled with CFR 0.152.
 */
package net.handle.server.replication;

import com.sleepycat.je.Cursor;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.Durability;
import com.sleepycat.je.Environment;
import com.sleepycat.je.EnvironmentConfig;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.PreloadConfig;
import com.sleepycat.je.Transaction;
import java.io.File;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.TimeUnit;
import net.cnri.util.StreamTable;
import net.handle.hdllib.Encoder;
import net.handle.hdllib.HandleException;
import net.handle.hdllib.Util;
import net.handle.server.HandleServer;
import net.handle.server.bdbje.JeUpgradeTool;

public class ReplicationDb {
    private static final String HANDLE_DB_NAME = "handlesDates";
    private static final String NA_DB_NAME = "nasDates";
    private Environment environment;
    private Database db;
    private Database naDB;
    private final Object CREATE_OR_DELETE_LOCK = new Object();
    private final Object HOME_OR_UNHOME_LOCK = new Object();
    private final HandleServer server;

    public ReplicationDb(File configDir, HandleServer server, StreamTable config) throws HandleException {
        this.server = server;
        File dbDir = new File(configDir, "replicationDb");
        if (!dbDir.exists()) {
            dbDir.mkdirs();
        }
        EnvironmentConfig envConfig = new EnvironmentConfig();
        envConfig.setTransactional(true);
        envConfig.setAllowCreate(true);
        envConfig.setLockTimeout((long)config.getInt("bdbje_timeout", 0), TimeUnit.MICROSECONDS);
        envConfig.setDurability(config.getBoolean("bdbje_no_sync_on_write", false) ? Durability.COMMIT_WRITE_NO_SYNC : Durability.COMMIT_SYNC);
        envConfig.setSharedCache(true);
        envConfig.setConfigParam("je.freeDisk", "0");
        try {
            this.environment = JeUpgradeTool.openEnvironment(dbDir, envConfig);
            this.db = this.openReplicationDb(HANDLE_DB_NAME);
            this.naDB = this.openReplicationDb(NA_DB_NAME);
        }
        catch (Exception e) {
            HandleException he = new HandleException(11, "Unable to open replication database");
            he.initCause(e);
            throw he;
        }
    }

    public void deleteAll() throws Exception {
        if (this.db != null) {
            this.db = this.deleteReplicationDb(this.db, HANDLE_DB_NAME);
        }
        if (this.naDB != null) {
            this.naDB = this.deleteReplicationDb(this.naDB, NA_DB_NAME);
        }
    }

    private Database openReplicationDb(String dbName) throws DatabaseException {
        DatabaseConfig dbConfig = new DatabaseConfig();
        dbConfig.setTransactional(true);
        dbConfig.setAllowCreate(true);
        dbConfig.setSortedDuplicates(false);
        Transaction openTxn = this.environment.beginTransaction(null, null);
        Database db = this.environment.openDatabase(openTxn, dbName, dbConfig);
        openTxn.commit();
        PreloadConfig preloadCfg = new PreloadConfig();
        preloadCfg.setMaxMillisecs(500L);
        db.preload(preloadCfg);
        return db;
    }

    private Database deleteReplicationDb(Database db, String dbName) throws DatabaseException {
        Database tmpDB = db;
        Transaction killTxn = this.environment.beginTransaction(null, null);
        try {
            db = null;
            tmpDB.close();
            tmpDB = null;
            this.environment.truncateDatabase(killTxn, dbName, false);
            killTxn.commit(Durability.COMMIT_SYNC);
        }
        catch (DatabaseException t) {
            try {
                killTxn.abort();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw t;
        }
        finally {
            db = this.openReplicationDb(dbName);
        }
        return db;
    }

    public Iterator<byte[]> iterator(boolean isNA) throws HandleException {
        if (!isNA && this.db != null) {
            return new DBIterator(this.db);
        }
        if (isNA && this.naDB != null) {
            return new DBIterator(this.naDB);
        }
        return Collections.emptyList().iterator();
    }

    public Iterator<byte[]> iteratorFrom(boolean isNA, byte[] startingPoint, boolean inclusive) throws HandleException {
        if (!isNA && this.db != null) {
            return new DBIterator(this.db, startingPoint, inclusive);
        }
        if (isNA && this.naDB != null) {
            return new DBIterator(this.naDB, startingPoint, inclusive);
        }
        return Collections.emptyList().iterator();
    }

    public Object getLock(boolean isNA) {
        return isNA ? this.HOME_OR_UNHOME_LOCK : this.CREATE_OR_DELETE_LOCK;
    }

    public boolean isMoreRecentThanLastDate(byte[] handle, long date, int priority, boolean isNA) throws HandleException {
        Database db;
        Database database = db = isNA ? this.naDB : this.db;
        if (db != null) {
            try {
                DatabaseEntry dbVal = new DatabaseEntry();
                if (db.get(null, new DatabaseEntry(handle), dbVal, null) == OperationStatus.SUCCESS) {
                    byte[] data = dbVal.getData();
                    long lastDate = Encoder.readLong(data, 0);
                    int lastPriority = Encoder.readInt(data, 8);
                    return date > lastDate || date == lastDate && priority >= lastPriority;
                }
            }
            catch (DatabaseException e) {
                this.server.logError(75, "Database error in replication date handling: " + (Object)((Object)e));
                HandleException he = new HandleException(1, "Database error in replication date handling");
                he.initCause(e);
                throw he;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long adjustAndSetLastDate(byte[] handle, long date, int priority, boolean isNA) throws HandleException {
        Database db = isNA ? this.naDB : this.db;
        Object object = this.getLock(isNA);
        synchronized (object) {
            if (db != null) {
                try {
                    DatabaseEntry dbVal = new DatabaseEntry();
                    if (db.get(null, new DatabaseEntry(handle), dbVal, null) == OperationStatus.SUCCESS) {
                        byte[] data = dbVal.getData();
                        long lastDate = Encoder.readLong(data, 0);
                        Encoder.readInt(data, 8);
                        date = date <= lastDate ? lastDate + 1L : date;
                    }
                }
                catch (DatabaseException e) {
                    this.server.logError(75, "Database error in replication date handling: " + (Object)((Object)e));
                    HandleException he = new HandleException(1, "Database error in replication date handling");
                    he.initCause(e);
                    throw he;
                }
            }
            this.setLastDate(handle, date, priority, isNA);
            return date;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLastDate(byte[] handle, long date, int priority, boolean isNA) throws HandleException {
        Database db;
        Database database = db = isNA ? this.naDB : this.db;
        if (db != null) {
            Object object = this.getLock(isNA);
            synchronized (object) {
                byte[] bytes = new byte[12];
                Encoder.writeLong(bytes, 0, date);
                Encoder.writeInt(bytes, 8, priority);
                try {
                    OperationStatus status = db.put(null, new DatabaseEntry(handle), new DatabaseEntry(bytes));
                    if (status != OperationStatus.SUCCESS) {
                        this.server.logError(75, "Unknown status returned from db.put: " + status);
                        throw new HandleException(1, "Database error in replication date handling");
                    }
                }
                catch (DatabaseException e) {
                    this.server.logError(75, "Database error in replication date handling: " + (Object)((Object)e));
                    HandleException he = new HandleException(1, "Database error in replication date handling");
                    he.initCause(e);
                    throw he;
                }
            }
        }
    }

    public void shutdown() {
        try {
            if (this.db != null) {
                this.db.close();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            if (this.naDB != null) {
                this.naDB.close();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            if (this.environment != null) {
                this.environment.close();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private class DBIterator
    implements Iterator<byte[]> {
        private Cursor cursor;
        private OperationStatus status;
        private final DatabaseEntry key = new DatabaseEntry();
        private final DatabaseEntry data = new DatabaseEntry();

        public DBIterator(Database db) throws HandleException {
            try {
                this.cursor = db.openCursor(null, null);
                this.status = this.cursor.getFirst(this.key, this.data, null);
            }
            catch (DatabaseException e) {
                if (this.cursor != null) {
                    try {
                        this.cursor.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                throw new HandleException(15, "Error constructing storage iterator", e);
            }
        }

        public DBIterator(Database db, byte[] startingPoint, boolean inclusive) throws HandleException {
            try {
                this.cursor = db.openCursor(null, null);
                this.key.setData(startingPoint);
                this.status = this.cursor.getSearchKeyRange(this.key, this.data, null);
                if (!inclusive && Util.equals(this.key.getData(), startingPoint)) {
                    if (this.hasNext()) {
                        this.next();
                    } else {
                        this.close();
                    }
                }
            }
            catch (Exception e) {
                if (this.cursor != null) {
                    try {
                        this.cursor.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                throw new HandleException(15, "Error constructing storage iterator", e);
            }
        }

        @Override
        public boolean hasNext() {
            if (this.status == null) {
                return false;
            }
            if (this.status == OperationStatus.SUCCESS) {
                return true;
            }
            this.close();
            this.status = null;
            return false;
        }

        @Override
        public byte[] next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            byte[] handle = this.key.getData();
            byte[] buf = new byte[16 + handle.length];
            Encoder.writeInt(buf, 0, handle.length);
            System.arraycopy(handle, 0, buf, 4, handle.length);
            System.arraycopy(this.data.getData(), 0, buf, 4 + handle.length, 12);
            try {
                this.status = this.cursor.getNext(this.key, this.data, null);
            }
            catch (DatabaseException e) {
                System.err.println("Error in ReplicationDBIterator: " + (Object)((Object)e));
                this.status = null;
                this.close();
            }
            return buf;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        public void close() {
            try {
                if (this.cursor != null) {
                    this.cursor.close();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

