/*
 * Decompiled with CFR 0.152.
 */
package net.handle.server.replication;

import java.util.ArrayList;
import java.util.List;
import net.handle.hdllib.Common;
import net.handle.hdllib.Encoder;
import net.handle.hdllib.HandleException;
import net.handle.hdllib.HandleResolver;
import net.handle.hdllib.HandleValue;
import net.handle.hdllib.ServerInfo;
import net.handle.hdllib.SiteInfo;
import net.handle.hdllib.Util;
import net.handle.server.HandleServer;
import net.handle.server.replication.ReplicationSourceSiteCollection;
import net.handle.server.replication.ReplicationSourceSiteInfo;

public class HandleBasedReplicationSourceSiteCollection
implements ReplicationSourceSiteCollection {
    static final String[] SITE_INFO_TYPES = new String[]{Util.decodeString(Common.SITE_INFO_TYPE), Util.decodeString(Common.SITE_INFO_6_TYPE)};
    final HandleResolver resolver;
    final HandleServer server;
    final ServerInfo serverInfo;
    final int singleSiteIndex;
    final boolean isPullFromSingleSite;
    final String handle;
    String ownName;
    List<ReplicationSourceSiteInfo> replicationSourceSites = new ArrayList<ReplicationSourceSiteInfo>();

    public HandleBasedReplicationSourceSiteCollection(String handle, HandleResolver resolver, ServerInfo serverInfo, HandleServer server) {
        this.isPullFromSingleSite = false;
        this.singleSiteIndex = -1;
        this.handle = handle;
        this.resolver = resolver;
        this.serverInfo = serverInfo;
        this.server = server;
    }

    public HandleBasedReplicationSourceSiteCollection(int singleSiteIndex, String handle, HandleResolver resolver, ServerInfo serverInfo, HandleServer server) {
        this.singleSiteIndex = singleSiteIndex;
        this.isPullFromSingleSite = true;
        this.handle = handle;
        this.resolver = resolver;
        this.serverInfo = serverInfo;
        this.server = server;
    }

    @Override
    public String getOwnName() {
        return this.ownName;
    }

    @Override
    public List<ReplicationSourceSiteInfo> getReplicationSourceSites() {
        return this.replicationSourceSites;
    }

    @Override
    public void refresh() throws HandleException {
        int[] indexes = null;
        String[] types = SITE_INFO_TYPES;
        if (this.isPullFromSingleSite) {
            indexes = new int[]{this.singleSiteIndex};
            types = null;
        }
        HandleValue[] values = this.resolver.resolveHandle(this.handle, types, indexes);
        ArrayList<ReplicationSourceSiteInfo> newReplicationSourceSites = new ArrayList<ReplicationSourceSiteInfo>(this.replicationSourceSites.size());
        for (int i = 0; i < values.length; ++i) {
            if (this.isPullFromSingleSite && values[i].getIndex() != this.singleSiteIndex) continue;
            boolean isNew = true;
            int index = values[i].getIndex();
            String name = index + ":" + this.handle;
            SiteInfo newSite = Encoder.decodeSiteInfoRecord(values[i].getData(), 0);
            if (!newSite.isPrimary && !this.isPullFromSingleSite) continue;
            for (ReplicationSourceSiteInfo replInfo : this.replicationSourceSites) {
                if (!replInfo.getName().equals(name)) continue;
                replInfo.setSite(newSite);
                newReplicationSourceSites.add(replInfo);
                isNew = false;
                break;
            }
            if (!isNew) continue;
            ReplicationSourceSiteInfo replicationSourceSite = new ReplicationSourceSiteInfo(newSite, name);
            boolean match = false;
            block2: for (int server = 0; server < newSite.servers.length; ++server) {
                ServerInfo serverInfo = newSite.servers[server];
                if (!Util.equals(serverInfo.ipAddress, this.serverInfo.ipAddress)) continue;
                for (int a = 0; a < serverInfo.interfaces.length; ++a) {
                    for (int b = 0; b < this.serverInfo.interfaces.length; ++b) {
                        if (serverInfo.interfaces[a].port != this.serverInfo.interfaces[b].port) continue;
                        this.server.setReplicationPriority(index);
                        this.ownName = name;
                        this.server.setReplicationSiteName(this.ownName);
                        match = true;
                        break block2;
                    }
                }
            }
            if (match) continue;
            newReplicationSourceSites.add(replicationSourceSite);
        }
        this.replicationSourceSites = newReplicationSourceSites;
    }
}

