/*
 * Decompiled with CFR 0.152.
 */
package net.handle.server.replication;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import net.cnri.io.AtomicFile;
import net.handle.apps.simple.SiteInfoConverter;
import net.handle.hdllib.Encoder;
import net.handle.hdllib.HandleException;
import net.handle.hdllib.SiteInfo;
import net.handle.hdllib.Util;
import net.handle.server.replication.ReplicationSourceSiteCollection;
import net.handle.server.replication.ReplicationSourceSiteInfo;

public class FileBasedReplicationSourceSiteCollection
implements ReplicationSourceSiteCollection {
    private ReplicationSourceSiteInfo replicationSourceSiteInfo;
    private final File replicationSiteInfoFile;
    private long timestamp;

    public FileBasedReplicationSourceSiteCollection(File replicationSiteInfoFile) {
        this.replicationSiteInfoFile = replicationSiteInfoFile;
    }

    @Override
    public List<ReplicationSourceSiteInfo> getReplicationSourceSites() {
        return Collections.singletonList(this.replicationSourceSiteInfo);
    }

    @Override
    public String getOwnName() {
        return null;
    }

    @Override
    public void refresh() throws IOException, HandleException {
        if (this.replicationSourceSiteInfo == null || this.replicationSiteInfoFile.lastModified() > this.timestamp) {
            this.timestamp = this.replicationSiteInfoFile.lastModified();
            byte[] siteBuf = new AtomicFile(this.replicationSiteInfoFile).readFully();
            SiteInfo newSite = new SiteInfo();
            if (Util.looksLikeBinary(siteBuf)) {
                Encoder.decodeSiteInfoRecord(siteBuf, 0, newSite);
            } else {
                newSite = SiteInfoConverter.convertToSiteInfo(new String(siteBuf, "UTF-8"));
            }
            this.replicationSourceSiteInfo = new ReplicationSourceSiteInfo(newSite, "sources");
        }
    }
}

