/*
 * Decompiled with CFR 0.152.
 */
package net.handle.server.dns;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import net.handle.dnslib.Message;
import net.handle.dnslib.NameServer;
import net.handle.server.Main;
import net.handle.server.dns.DnsConfiguration;

public class DnsUdpRequestHandler
implements Runnable {
    public static final String ACCESS_TYPE = "UDP:DNS";
    private final Main main;
    public final DnsConfiguration dnsConfig;
    private final NameServer nameServer;
    private final boolean logAccesses;
    private final DatagramSocket dsocket;
    private final DatagramPacket packet;
    private final long recvTime;

    public DnsUdpRequestHandler(Main main, DatagramSocket dsock, DnsConfiguration dnsConfig, boolean logAccesses, DatagramPacket packet, long recvTime) {
        this.main = main;
        this.dsocket = dsock;
        this.logAccesses = logAccesses;
        this.dnsConfig = dnsConfig;
        this.nameServer = dnsConfig.getNameServer();
        this.packet = packet;
        this.recvTime = recvTime;
    }

    @Override
    public void run() {
        try {
            this.handleRequest();
        }
        catch (Exception e) {
            this.main.logError(75, String.valueOf(this.getClass()) + ": Exception processing request: " + e);
            e.printStackTrace();
        }
    }

    private void sendResponse(Message dnsMessage, int udpPayloadSize) {
        InetAddress addr = this.packet.getAddress();
        int port = this.packet.getPort();
        try {
            byte[] buf = dnsMessage.getDatagram(udpPayloadSize);
            this.dsocket.send(new DatagramPacket(buf, buf.length, addr, port));
            if (this.logAccesses) {
                long time = System.currentTimeMillis() - this.recvTime;
                String logName = dnsMessage.getQuestionNameAsString();
                this.main.logAccess(ACCESS_TYPE, this.packet.getAddress(), dnsMessage.getOpcode(), dnsMessage.getExtendedResponseCode(), logName, time);
            }
        }
        catch (IOException e) {
            this.main.logError(75, String.valueOf(this.getClass()) + ": unable to send response packet to " + addr + ":" + port);
        }
    }

    private void handleRequest() throws IOException {
        boolean allowed = this.dnsConfig.getAllowQuery(this.packet.getAddress());
        boolean recursionAvailable = this.dnsConfig.getRecursive(this.packet.getAddress());
        byte[] queryBytes = this.packet.getData();
        int[] udpPayloadArr = new int[]{512};
        Message response = !allowed ? this.nameServer.refusalResponse(queryBytes) : this.nameServer.respondToBytes(queryBytes, recursionAvailable, udpPayloadArr);
        if (response == null) {
            return;
        }
        this.sendResponse(response, udpPayloadArr[0]);
    }
}

