/*
 * Decompiled with CFR 0.152.
 */
package net.handle.server.dns;

import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.concurrent.LinkedTransferQueue;
import java.util.concurrent.TimeUnit;
import net.cnri.util.GrowBeforeTransferQueueThreadPoolExecutor;
import net.cnri.util.StreamTable;
import net.handle.hdllib.Util;
import net.handle.server.Main;
import net.handle.server.NetworkInterface;
import net.handle.server.dns.DnsConfiguration;
import net.handle.server.dns.DnsUdpRequestHandler;

public class DnsUdpInterface
extends NetworkInterface {
    private static final int MAX_UDP_PACKET_SIZE = 512;
    private InetAddress bindAddress;
    private int threadLife = 500;
    private int bindPort = 53;
    private int numThreads = 10;
    private int maxHandlers = 200;
    private boolean logAccesses = false;
    private DatagramSocket dsocket = null;
    private boolean keepServing = true;
    public DnsConfiguration dnsConfig;

    public DnsUdpInterface(Main main, StreamTable config, DnsConfiguration dnsConfig) throws UnknownHostException {
        super(main);
        this.dnsConfig = dnsConfig;
        Object bindAddressStr = config.get("bind_address");
        this.bindAddress = bindAddressStr == null ? null : InetAddress.getByName(String.valueOf(bindAddressStr));
        this.bindPort = Integer.parseInt((String)config.get("bind_port"));
        try {
            this.numThreads = Integer.parseInt((String)config.get("num_threads"));
        }
        catch (Exception e) {
            main.logError(50, "unspecified thread count, using default: " + this.numThreads);
        }
        try {
            if (config.containsKey("max_handlers")) {
                this.maxHandlers = Integer.parseInt((String)config.get("max_handlers"));
            }
        }
        catch (Exception e) {
            main.logError(50, "unspecified max_handlers count, using default: " + this.maxHandlers);
        }
        try {
            if (config.containsKey("thread_life")) {
                this.threadLife = Integer.parseInt((String)config.get("thread_life"));
            }
        }
        catch (Exception e) {
            main.logError(50, "Invalid thread life, using default: " + this.threadLife);
        }
        this.logAccesses = config.getBoolean("log_accesses");
    }

    @Override
    public byte getProtocol() {
        return -1;
    }

    @Override
    public int getPort() {
        return this.bindPort;
    }

    @Override
    protected void stopService() {
        this.keepServing = false;
        try {
            this.dsocket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void serveRequests() {
        try {
            this.dsocket = this.bindAddress == null ? new DatagramSocket(this.bindPort) : new DatagramSocket(this.bindPort, this.bindAddress);
        }
        catch (Exception e) {
            this.main.logError(100, String.valueOf(this.getClass()) + ": Error setting up server socket: " + e);
            return;
        }
        System.out.println("DNS Request Listener:");
        System.out.println("   address: " + (this.bindAddress == null ? "ANY" : "" + Util.rfcIpRepr(this.bindAddress)));
        System.out.println("      port: " + this.bindPort);
        this.handlerPool = new GrowBeforeTransferQueueThreadPoolExecutor(this.numThreads, this.maxHandlers, 1L, TimeUnit.MINUTES, new LinkedTransferQueue());
        System.out.println("Starting DNS-UDP request handlers...");
        try {
            System.out.flush();
        }
        catch (Exception e) {
            // empty catch block
        }
        long recvTime = 0L;
        while (this.keepServing) {
            try {
                DatagramPacket dPacket = new DatagramPacket(new byte[512], 512);
                this.dsocket.receive(dPacket);
                recvTime = System.currentTimeMillis();
                this.handlerPool.execute(new DnsUdpRequestHandler(this.main, this.dsocket, this.dnsConfig, this.logAccesses, dPacket, recvTime));
            }
            catch (Exception e) {
                if (!this.keepServing) continue;
                this.main.logError(75, "" + this.getClass() + ": Error handling request: " + e);
                e.printStackTrace(System.err);
            }
        }
        try {
            this.dsocket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

