/*
 * Decompiled with CFR 0.152.
 */
package net.handle.server.dns;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import net.handle.dnslib.Message;
import net.handle.dnslib.NameServer;
import net.handle.server.Main;
import net.handle.server.dns.DnsConfiguration;

public class DnsTcpRequestHandler
implements Runnable {
    public static final String ACCESS_TYPE = "TCP:DNS";
    private Socket socket;
    private InputStream in;
    private OutputStream out;
    private final long recvTime;
    private final Main main;
    public final DnsConfiguration dnsConfig;
    private final boolean logAccesses;
    private final NameServer nameServer;

    public DnsTcpRequestHandler(Main main, DnsConfiguration dnsConfig, boolean logAccesses, Socket socket, long recvTime) {
        this.main = main;
        this.logAccesses = logAccesses;
        this.dnsConfig = dnsConfig;
        this.nameServer = this.dnsConfig.getNameServer();
        this.socket = socket;
        this.recvTime = recvTime;
    }

    @Override
    public void run() {
        try {
            this.in = this.socket.getInputStream();
            this.out = this.socket.getOutputStream();
            this.handleRequest();
        }
        catch (Exception e) {
            this.main.logError(75, String.valueOf(this.getClass()) + ": Exception processing request: " + e);
            e.printStackTrace();
        }
        finally {
            this.close();
        }
    }

    private void sendResponse(Message dnsMessage) {
        try {
            byte[] buf = dnsMessage.getDatagram(65535);
            this.out.write(buf.length >> 8 & 0xFF);
            this.out.write(buf.length & 0xFF);
            this.out.write(buf);
            this.out.flush();
            if (this.logAccesses) {
                long time = System.currentTimeMillis() - this.recvTime;
                String logName = dnsMessage.getQuestionNameAsString();
                this.main.logAccess(ACCESS_TYPE, this.socket.getInetAddress(), dnsMessage.getOpcode(), dnsMessage.getExtendedResponseCode(), logName, time);
            }
        }
        catch (IOException e) {
            InetAddress addr = this.socket.getInetAddress();
            int port = this.socket.getPort();
            this.main.logError(75, String.valueOf(this.getClass()) + ": unable to send response packet to " + addr + ":" + port);
            e.printStackTrace();
        }
    }

    private void close() {
        if (this.in != null) {
            try {
                this.in.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.in = null;
        }
        if (this.out != null) {
            try {
                this.out.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.out = null;
        }
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.socket = null;
        }
    }

    private void handleRequest() throws IOException {
        boolean allowed = this.dnsConfig.getAllowQuery(this.socket.getInetAddress());
        boolean recursionAvailable = this.dnsConfig.getRecursive(this.socket.getInetAddress());
        try {
            while (true) {
                int n;
                int firstByte = this.in.read();
                int secondByte = this.in.read();
                if (firstByte < 0 || secondByte < 0) {
                    return;
                }
                int len = (firstByte & 0xFF) << 8 | secondByte & 0xFF;
                byte[] queryBytes = new byte[len];
                int r = 0;
                for (n = 0; n < len && (r = this.in.read(queryBytes, n, len - n)) > 0; n += r) {
                }
                if (n < len) {
                    return;
                }
                Message response = !allowed ? this.nameServer.refusalResponse(queryBytes) : this.nameServer.respondToBytes(queryBytes, recursionAvailable, null);
                if (response == null) {
                    return;
                }
                this.sendResponse(response);
            }
        }
        catch (Throwable e) {
            this.main.logError(75, String.valueOf(this.getClass()) + ": Error handling request: " + e);
            e.printStackTrace(System.err);
            return;
        }
    }
}

