/*
 * Decompiled with CFR 0.152.
 */
package net.handle.server.dns;

import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.concurrent.LinkedTransferQueue;
import java.util.concurrent.TimeUnit;
import net.cnri.util.GrowBeforeTransferQueueThreadPoolExecutor;
import net.cnri.util.StreamTable;
import net.handle.hdllib.Util;
import net.handle.server.Main;
import net.handle.server.NetworkInterface;
import net.handle.server.dns.DnsConfiguration;
import net.handle.server.dns.DnsTcpRequestHandler;

public class DnsTcpInterface
extends NetworkInterface {
    private InetAddress bindAddress;
    private int threadLife = 500;
    private int bindPort = 53;
    private final int backlog;
    private int numThreads = 10;
    private int maxHandlers = 200;
    private boolean logAccesses = false;
    private ServerSocket socket = null;
    private boolean keepServing = true;
    public DnsConfiguration dnsConfig;

    public DnsTcpInterface(Main main, StreamTable config, DnsConfiguration dnsConfig) throws UnknownHostException {
        super(main);
        this.dnsConfig = dnsConfig;
        Object bindAddressStr = config.get("bind_address");
        this.bindAddress = bindAddressStr == null ? null : InetAddress.getByName(String.valueOf(bindAddressStr));
        this.bindPort = Integer.parseInt((String)config.get("bind_port"));
        this.backlog = Integer.parseInt((String)config.get("backlog", "-1"));
        try {
            this.numThreads = Integer.parseInt((String)config.get("num_threads"));
        }
        catch (Exception e) {
            main.logError(50, "unspecified thread count, using default: " + this.numThreads);
        }
        try {
            if (config.containsKey("max_handlers")) {
                this.maxHandlers = Integer.parseInt((String)config.get("max_handlers"));
            }
        }
        catch (Exception e) {
            main.logError(50, "unspecified max_handlers count, using default: " + this.maxHandlers);
        }
        try {
            if (config.containsKey("thread_life")) {
                this.threadLife = Integer.parseInt((String)config.get("thread_life"));
            }
        }
        catch (Exception e) {
            main.logError(50, "Invalid thread life, using default: " + this.threadLife);
        }
        this.logAccesses = config.getBoolean("log_accesses");
    }

    @Override
    public byte getProtocol() {
        return -1;
    }

    @Override
    public int getPort() {
        return this.bindPort;
    }

    @Override
    protected void stopService() {
        this.keepServing = false;
        try {
            this.socket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void serveRequests() {
        try {
            this.socket = this.bindAddress == null ? new ServerSocket(this.bindPort, this.backlog) : new ServerSocket(this.bindPort, this.backlog, this.bindAddress);
        }
        catch (Exception e) {
            this.main.logError(100, String.valueOf(this.getClass()) + ": Error setting up server socket: " + e);
            return;
        }
        System.out.println("DNS Request Listener:");
        System.out.println("   address: " + (this.bindAddress == null ? "ANY" : "" + Util.rfcIpRepr(this.bindAddress)));
        System.out.println("      port: " + this.bindPort);
        this.handlerPool = new GrowBeforeTransferQueueThreadPoolExecutor(this.numThreads, this.maxHandlers, 1L, TimeUnit.MINUTES, new LinkedTransferQueue());
        System.out.println("Starting DNS-TCP request handlers...");
        try {
            System.out.flush();
        }
        catch (Exception e) {
            // empty catch block
        }
        long recvTime = 0L;
        while (this.keepServing) {
            try {
                Socket newsock = this.socket.accept();
                newsock.setSoTimeout(120000);
                recvTime = System.currentTimeMillis();
                this.handlerPool.execute(new DnsTcpRequestHandler(this.main, this.dnsConfig, this.logAccesses, newsock, recvTime));
            }
            catch (Exception e) {
                if (!this.keepServing) continue;
                this.main.logError(75, "" + this.getClass() + ": Error handling request: " + e);
                e.printStackTrace(System.err);
            }
        }
        try {
            this.socket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

