/*
 * Decompiled with CFR 0.152.
 */
package net.handle.server.dns;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.cnri.util.StreamTable;
import net.handle.dnslib.DomainName;
import net.handle.dnslib.NameResolver;
import net.handle.dnslib.NameServer;
import net.handle.dnslib.ParseException;
import net.handle.dnslib.Storage;
import net.handle.dnslib.StubResolver;
import net.handle.server.AbstractServer;

public class DnsConfiguration {
    private final Map<String, String> dnsHandleMap;
    private List<InetAddress> dns_forward;
    private boolean recursive = false;
    private InetAddressRange[] allow_recursion;
    private InetAddressRange[] allow_query;
    private int dnsCacheSize = 10000;
    private int dnsCachePrefetcherThreads = 10;
    private boolean certify = false;
    private List<Storage> _storageList;
    private NameServer _nameServer;
    private NameResolver _resolver;

    public DnsConfiguration(AbstractServer server, StreamTable config) throws UnknownHostException {
        Map castMap;
        Object dns_forward_raw;
        String prefetcherString;
        if (config == null) {
            config = new StreamTable();
        }
        this.recursive = config.getBoolean("recursion");
        this.certify = config.getBoolean("certify");
        Object allow_recursion_raw = config.get("allow_recursion");
        if (allow_recursion_raw instanceof String) {
            this.allow_recursion = new InetAddressRange[]{new InetAddressRange((String)allow_recursion_raw)};
        } else if (allow_recursion_raw != null) {
            List allow_recursion_list = (List)allow_recursion_raw;
            this.allow_recursion = new InetAddressRange[allow_recursion_list.size()];
            for (int i = 0; i < this.allow_recursion.length; ++i) {
                this.allow_recursion[i] = new InetAddressRange((String)allow_recursion_list.get(i));
            }
        }
        Object allow_query_raw = config.get("allow_query");
        if (allow_query_raw instanceof String) {
            this.allow_query = new InetAddressRange[]{new InetAddressRange((String)allow_query_raw)};
        } else if (allow_query_raw != null) {
            List allow_query_list = (List)allow_query_raw;
            this.allow_query = new InetAddressRange[allow_query_list.size()];
            for (int i = 0; i < this.allow_query.length; ++i) {
                this.allow_query[i] = new InetAddressRange((String)allow_query_list.get(i));
            }
        }
        String cacheString = (String)config.get("dns_cache_size");
        if (cacheString != null) {
            this.dnsCacheSize = Integer.parseInt(cacheString);
        }
        if ((prefetcherString = (String)config.get("dns_cache_prefetcher_threads")) != null) {
            this.dnsCachePrefetcherThreads = Integer.parseInt(prefetcherString);
        }
        if ((dns_forward_raw = config.get("dns_forward")) instanceof String) {
            this.dns_forward = Collections.singletonList(InetAddress.getByName((String)dns_forward_raw));
        } else if (dns_forward_raw != null) {
            List dns_forward_strings = (List)dns_forward_raw;
            this.dns_forward = new ArrayList<InetAddress>();
            for (String string : dns_forward_strings) {
                this.dns_forward.add(InetAddress.getByName(string));
            }
        }
        if (this.dns_forward == null) {
            if (this.recursive || this.allow_recursion != null) {
                System.err.println("Warning: DNS recursion support requested, but no dns_forward server configured");
                this.recursive = false;
                this.allow_recursion = null;
            }
        } else {
            this._resolver = new StubResolver(this.dns_forward, false);
            this._resolver.setCache(this.dnsCachePrefetcherThreads, this.dnsCacheSize);
        }
        this.dnsHandleMap = castMap = (Map)config.get("dns_handle_map");
        if (this.dnsHandleMap != null) {
            this._storageList = new ArrayList<Storage>(this.dnsHandleMap.size());
            for (Map.Entry entry : this.dnsHandleMap.entrySet()) {
                try {
                    this._storageList.add(new Storage(DomainName.ofString((String)entry.getKey()), (String)entry.getValue(), server, this));
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
            }
            this._nameServer = new NameServer(this.storageList(), this._resolver);
            this._nameServer.setCache(this.dnsCachePrefetcherThreads, this.dnsCacheSize);
        }
    }

    public boolean isCertify() {
        return this.certify;
    }

    public boolean getRecursive(InetAddress addr) {
        if (this.allow_recursion == null || addr == null) {
            return this.recursive;
        }
        for (InetAddressRange element : this.allow_recursion) {
            if (!element.matches(addr)) continue;
            return true;
        }
        return false;
    }

    public boolean getAllowQuery(InetAddress addr) {
        if (this.allow_query == null) {
            return true;
        }
        if (addr == null) {
            return false;
        }
        for (InetAddressRange element : this.allow_query) {
            if (!element.matches(addr)) continue;
            return true;
        }
        return false;
    }

    public List<Storage> storageList() {
        return this._storageList;
    }

    public NameServer getNameServer() {
        return this._nameServer;
    }

    public NameResolver getNameResolver() {
        return this._resolver;
    }

    public String getDnsHandlePrefix(String suffix) {
        if (this.dnsHandleMap == null) {
            return null;
        }
        return this.dnsHandleMap.get(suffix.toLowerCase());
    }

    private class InetAddressRange {
        byte[] address;
        int prefix;

        InetAddressRange(String s) throws UnknownHostException {
            int n = s.indexOf(47);
            if (n >= 0) {
                String s1 = s.substring(0, n).trim();
                this.address = InetAddress.getByName(s1).getAddress();
                this.prefix = Integer.parseInt(s.substring(n + 1).trim());
            } else {
                String s1 = s.trim();
                this.address = InetAddress.getByName(s1).getAddress();
                this.prefix = 8 * this.address.length;
            }
        }

        boolean matches(InetAddress addr) {
            byte[] addrBytes = addr.getAddress();
            if (addrBytes.length != this.address.length) {
                return false;
            }
            int prefix = this.prefix;
            for (int i = 0; i < this.address.length; ++i) {
                if (prefix <= 0) {
                    return true;
                }
                int mask = 255;
                if (prefix < 8) {
                    mask <<= 8 - prefix;
                }
                if ((addrBytes[i] & mask) != (this.address[i] & mask)) {
                    return false;
                }
                prefix -= 8;
            }
            return true;
        }
    }
}

