/*
 * Decompiled with CFR 0.152.
 */
package net.handle.server;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import net.cnri.util.StreamTable;
import net.handle.apps.simple.SiteInfoConverter;
import net.handle.hdllib.AbstractResponse;
import net.handle.hdllib.Common;
import net.handle.hdllib.ConfigCommon;
import net.handle.hdllib.Encoder;
import net.handle.hdllib.GenericRequest;
import net.handle.hdllib.GetSiteInfoResponse;
import net.handle.hdllib.HandleResolver;
import net.handle.hdllib.SiteInfo;
import net.handle.hdllib.Util;

public abstract class SimpleSetup {
    private static final String DEFAULT_YES = "y";
    private static final String DEFAULT_NO = "n";
    private static String DEFAULT_INTERVAL = "Monthly";
    private static final int NO_DEFAULT = -1;
    private static final int NO_LIMIT = -1;
    private static BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
    private static PrintStream out = System.out;
    private static PrintStream err = System.err;

    public static void main(String[] argv) {
        try {
            SiteInfo siteInfo;
            File binFile;
            FileOutputStream siteOut;
            String json;
            boolean createBinFile;
            String contactName;
            String contactPhone;
            String contactEmail;
            int siteVersion;
            if (argv.length < 1 || argv[0].length() <= 0) {
                err.println("ERROR:  You must specify a configuration directory.");
                return;
            }
            String configDirName = argv[0];
            File configDir = new File(configDirName);
            if (!configDir.exists()) {
                configDir.mkdirs();
            }
            out.println("\nTo configure your new Handle server, please answer\nthe questions which follow; default answers, shown in \n[square brackets] when available, can be chosen by \npressing Enter.\n");
            int serverType = 0;
            boolean isPrimary = SimpleSetup.getBoolean("Will this be a \"primary\" server (ie, not a mirror of another server)?", DEFAULT_YES);
            boolean isDualStack = SimpleSetup.getBoolean("Will this be a dual-stack server (accessible on both IPv6 and IPv4)?", DEFAULT_NO);
            InetAddress[] externalAddr = new InetAddress[2];
            InetAddress[] bindAddr = new InetAddress[2];
            if (!isDualStack) {
                externalAddr[0] = SimpleSetup.getIPAddress("Through what network-accessible IP address should clients connect to this server?", null, true, 0);
                bindAddr[0] = SimpleSetup.getIPAddress("If different, enter the IP address to which the server should bind.", externalAddr[0], false, 0);
            } else {
                externalAddr[0] = SimpleSetup.getIPAddress("Through what network-accessible IPv6 address should clients connect to this server?", null, true, 6);
                bindAddr[0] = SimpleSetup.getIPAddress("If different, enter the IPv6 address to which the server should bind.", externalAddr[0], false, 6);
                externalAddr[1] = SimpleSetup.getIPAddress("Through what network-accessible IPv4 address should clients connect to this server?", null, true, 4);
                bindAddr[1] = SimpleSetup.getIPAddress("If different, enter the IPv4 address to which the server should bind.", externalAddr[1], false, 4);
            }
            int port = SimpleSetup.getInteger("Enter the (TCP/UDP) port number this server will listen to", 2641, 1, 32000);
            int httpPort = SimpleSetup.getInteger("What port number will the HTTP interface be listening to?", 8000, 1, 32000);
            boolean logAccesses = SimpleSetup.getBoolean("Would you like to log all accesses to this server?", DEFAULT_YES);
            String interval = DEFAULT_INTERVAL;
            if (logAccesses) {
                System.out.println("\nPlease indicate whether log files should be automatically\nrotated, and if so, how often.");
                interval = SimpleSetup.getInterval();
            }
            if (!interval.equals("Never") && interval.equals("Monthly")) {
                System.out.println("\nNOTE: Log rotation will be done on the first of each month.");
            }
            File replPrivKeyFile = new File(configDir, "replpriv.bin");
            File replPubKeyFile = new File(configDir, "replpub.bin");
            File adminPrivKeyFile = new File(configDir, "admpriv.bin");
            File adminPubKeyFile = new File(configDir, "admpub.bin");
            File replicationSiteFile = new File(configDir, "txnsrcsv.bin");
            boolean generateReplKeys = true;
            boolean generateAdminKeys = isPrimary;
            String replicationAdminStr = "";
            String replicationAuthStr = null;
            SiteInfo replicationSite = null;
            String homedPrefix = null;
            if (serverType == 0) {
                if (isPrimary) {
                    replicationAdminStr = "300:0.NA/YOUR_PREFIX";
                    homedPrefix = "0.NA/YOUR_PREFIX";
                } else {
                    if (replPrivKeyFile.exists() && replPubKeyFile.exists()) {
                        generateReplKeys = SimpleSetup.getBoolean("Replication keys already exist, do you want to create new ones? ", DEFAULT_NO);
                    }
                    out.println("\nSince this is a secondary (\"mirror\") server, you need to\nspecify the primary site from which this server will get\nits handles.  You will be asked to specify the IP of a server\nfrom the primary site, and the port it listens to.  This\nprogram will then contact that server and request the site\ndata needed for downloading handles.");
                    boolean needReplicationInfo = true;
                    if (replicationSiteFile.exists()) {
                        out.println("\n\n\nWARNING: You have already configured a primary site from\nwhich this server is to get its handles. CHANGING THIS SETTING\nWILL REQUIRE THAT THIS SERVER RE-DOWNLOAD ALL OF THE HANDLES\nFROM THE PRIMARY SITE.\n\n");
                        needReplicationInfo = SimpleSetup.getBoolean("  Would you like to specify a different primary site?", DEFAULT_NO);
                    }
                    while (needReplicationInfo) {
                        InetAddress replSrcAddr;
                        String line = SimpleSetup.responseToPrompt("Enter the address of a primary server (enter 'manual' to configure manually)");
                        try {
                            if (line.length() <= 0) {
                                throw new Exception("Got empty input");
                            }
                            if ("manual".equalsIgnoreCase(line.trim())) {
                                out.println("\n\n\nWARNING: You have will need to manually create a txnsrcsv.bin\nfile or add a \"replication_sites_handle\" value to the server's\nconfiguration file.\n\n");
                                break;
                            }
                            replSrcAddr = InetAddress.getByName(line);
                        }
                        catch (Exception e) {
                            out.println("Invalid address: \"" + line + "\"; Reason: " + e + ".  Try again.");
                            continue;
                        }
                        int replSrcPort = SimpleSetup.getInteger("Enter the port number of the same primary server (" + line + ")", 2641, 1, 32000);
                        try {
                            GenericRequest req = new GenericRequest(Common.BLANK_HANDLE, 2, null);
                            HandleResolver resolver = new HandleResolver();
                            AbstractResponse resp = resolver.sendHdlTcpRequest(req, replSrcAddr, replSrcPort, null);
                            if (resp.responseCode != 1) {
                                throw new Exception("Unexpected response from primary: " + resp);
                            }
                            replicationSite = ((GetSiteInfoResponse)resp).siteInfo;
                            break;
                        }
                        catch (Exception e) {
                            out.println("Error retrieving replication site info: " + e);
                        }
                    }
                    replicationAuthStr = "300:0.NA/YOUR_PREFIX";
                }
            }
            out.println("\nEach handle site has a version/serial number assigned\nto it.  This is so that a client can tell if a particular\nsite's configuration has changed since the last time it\naccessed a server in the site.  Every time you modify a site\n(by changing an IP address, port, or adding a server, etc), \nyou should increment the version/serial number for that site.");
            while (((siteVersion = SimpleSetup.getInteger("Enter the version/serial number of this site", 1, 1, -1)) & 0xFFFF0000) != 0) {
                out.println("Invalid input: \"" + siteVersion + "\" (value out of 2-byte range).");
            }
            String siteDescription = SimpleSetup.responseToPrompt("Please enter a short description of this server/site");
            String orgName = "";
            while (orgName.length() == 0) {
                orgName = SimpleSetup.responseToPrompt("Please enter the name of your organization");
            }
            if (orgName.equalsIgnoreCase("cnri")) {
                contactEmail = "";
                contactPhone = "";
                contactName = "";
            } else {
                contactName = SimpleSetup.responseToPrompt("Please enter the name of a contact person\nfor " + orgName + " (optional) [(none)]");
                contactPhone = SimpleSetup.getContactPhone(contactName, orgName);
                contactEmail = SimpleSetup.getContactEmail(contactName, orgName);
            }
            out.println("\nThe handle server can communicate via UDP and/or TCP sockets.\nSince UDP messages are blocked by many network firewalls, you may\nwant to disable UDP services if you are behind such a firewall.");
            boolean disableUDP = SimpleSetup.getBoolean("  Do you need to disable UDP services?", DEFAULT_NO);
            boolean generateKeys = true;
            File privKeyFile = new File(configDir, "privkey.bin");
            File pubKeyFile = new File(configDir, "pubkey.bin");
            if (privKeyFile.exists() && pubKeyFile.exists()) {
                generateKeys = SimpleSetup.getBoolean("Server keys already exist, do you want to create new ones? ", DEFAULT_NO);
            }
            if (generateKeys) {
                SimpleSetup.generateKeys(pubKeyFile, privKeyFile, "Server Certification");
            }
            if (serverType == 0) {
                if (!isPrimary && generateReplKeys) {
                    SimpleSetup.generateKeys(replPubKeyFile, replPrivKeyFile, "Replication Authentication");
                }
                if (generateAdminKeys && adminPubKeyFile.exists() && adminPrivKeyFile.exists()) {
                    generateAdminKeys = SimpleSetup.getBoolean("Administrator keys already exist, do you want to create new ones? ", DEFAULT_NO);
                }
                if (generateAdminKeys) {
                    SimpleSetup.generateKeys(adminPubKeyFile, adminPrivKeyFile, "Administration");
                }
            }
            if (!isDualStack) {
                out.println("Generating site info record...");
                SiteInfo siteInfoBuf = new SiteInfo(siteVersion, isPrimary, false, 2, siteDescription, externalAddr[0], port, httpPort, pubKeyFile, disableUDP);
                createBinFile = false;
                try {
                    json = SiteInfoConverter.convertToJson(siteInfoBuf);
                    siteOut = new FileOutputStream(new File(configDir, "siteinfo.json"));
                    siteOut.write(json.getBytes("UTF-8"));
                    siteOut.close();
                }
                catch (Throwable t) {
                    createBinFile = true;
                }
                binFile = new File(configDir, "siteinfo.bin");
                if (createBinFile || binFile.exists()) {
                    siteOut = new FileOutputStream(binFile);
                    siteOut.write(Encoder.encodeSiteInfoRecord(siteInfoBuf));
                    siteOut.close();
                }
                siteInfo = siteInfoBuf;
            } else {
                out.println("Generating site info record...");
                SiteInfo siteInfo4 = new SiteInfo(siteVersion, isPrimary, false, 2, siteDescription, externalAddr[1], externalAddr[0], port, httpPort, pubKeyFile, disableUDP);
                createBinFile = false;
                try {
                    json = SiteInfoConverter.convertToJson(siteInfo4);
                    siteOut = new FileOutputStream(new File(configDir, "siteinfo.json"));
                    siteOut.write(json.getBytes("UTF-8"));
                    siteOut.close();
                }
                catch (Throwable t) {
                    createBinFile = true;
                }
                binFile = new File(configDir, "siteinfo.bin");
                if (createBinFile || binFile.exists()) {
                    siteOut = new FileOutputStream(binFile);
                    siteOut.write(Encoder.encodeSiteInfoRecord(siteInfo4));
                    siteOut.close();
                }
                siteInfo = siteInfo4;
            }
            StreamTable contactData = ConfigCommon.contactDataTable(orgName, contactName, contactPhone, contactEmail);
            File contactDataFile = new File(configDir, "contactdata.dct");
            contactData.writeToFile(contactDataFile);
            if (replicationSite != null) {
                ConfigCommon.writeReplicationSiteFile(configDirName, "txnstat.dct", replicationSiteFile, replicationSite);
            }
            boolean serverAdminFullAccess = true;
            StreamTable config = ConfigCommon.configuration(serverType, disableUDP, port, logAccesses, bindAddr, 15, httpPort, interval, false, 60000, 86400000, 1, isPrimary, "300:0.NA/YOUR_PREFIX", replicationAdminStr, replicationAuthStr, homedPrefix, isDualStack, serverAdminFullAccess);
            config.writeToFile(new File(configDir, "config.dct"));
            File webappsDir = new File(configDir, "webapps");
            boolean copyAdminWar = true;
            if (webappsDir.exists()) {
                out.println("\nYour server already has a webapps directory for Java servlets.\nThis Handle software distribution comes with an admin.war servlet\nwhich provides a browser-based admin tool.  This admin.war can\nbe copied into your server which will replace any existing\nadmin.war.  This is recommended unless you believe your existing\nadmin.war to be newer.");
                copyAdminWar = SimpleSetup.getBoolean("  Would you like to copy this admin.war into your server?", DEFAULT_YES);
            }
            if (copyAdminWar) {
                try {
                    webappsDir.mkdirs();
                    URL url = SimpleSetup.class.getProtectionDomain().getCodeSource().getLocation();
                    File jarFile = new File(url.toURI());
                    File adminWarFile = new File(jarFile.getParentFile().getParentFile(), "admin.war");
                    File adminWarDestFile = new File(webappsDir, "admin.war");
                    SimpleSetup.copyFile(adminWarFile, adminWarDestFile);
                }
                catch (Exception e) {
                    out.println("\n\n\nWARNING: Error adding admin.war to server:\n" + e + "\nYou will have to add admin.war to the webapps subdirectory manually.\n\n");
                }
            }
            String finalMessage = null;
            if (serverType == 0) {
                ConfigCommon.createSiteBundle(configDirName, "sitebndl.zip", isPrimary, replicationAdminStr, adminPubKeyFile, replPubKeyFile, replicationAuthStr, siteInfo, contactDataFile, isDualStack);
                finalMessage = "\nYou have finished configuring your (" + (isPrimary ? "primary" : "mirror") + ") Handle service.\n\nThis service now needs to be registered with your prefix \nadministrator.  Organizations credentialed by DONA to \nregister prefixes are listed at the dona.net website. \n\nIf your prefix administrator is CNRI, go to \nhttp://hdl.handle.net/20.1000/111 to register to \nbecome a resolution service provider and then upload \nyour newly created sitebndl.zip file. Please read the \ninstructions on this page carefully. When the handle \nadministrator receives your file, a prefix will be \ncreated and you will receive notification via email.\n\nPlease send all questions to your prefix administrator, \nif CNRI at hdladmin@cnri.reston.va.us.\n\n";
            } else {
                finalMessage = "You have finished configuring your caching Handle server.\n\nYou can now start your server then test it by pointing\na web browser at http://" + Util.rfcIpRepr(externalAddr[0]) + ":" + httpPort + "/\nand entering a handle.\n";
            }
            out.println("\n-------------------------------------------------------\n" + finalMessage);
        }
        catch (Exception e) {
            err.println("Error setting up the server:\n" + e);
            e.printStackTrace(err);
        }
    }

    private static final void generateKeys(File pubKeyFile, File privKeyFile, String purpose) throws Exception {
        KeyPairGenerator kpg = KeyPairGenerator.getInstance("RSA");
        out.println("\nGenerating keys for: " + purpose);
        kpg.initialize(2048);
        KeyPair keys = kpg.generateKeyPair();
        out.println("\nThe private key that is about to be generated should be stored\nin an encrypted form on your computer. Encryption of the\nprivate key requires that you choose a secret passphrase that\nwill need to be entered whenever the server is started.\nNote: Your private key may be stored unencrypted if you so choose.\nPlease take all precautions to make sure that only authorized\nusers can read your private key.");
        boolean encrypt = SimpleSetup.getBoolean("  Would you like to encrypt your private key?", DEFAULT_YES);
        byte[] secKey = null;
        if (encrypt) {
            byte[] secKey2;
            while (!Util.equals(secKey = Util.getPassphrase("\nPlease enter the private key passphrase for " + purpose + ": "), secKey2 = Util.getPassphrase("\nPlease re-enter the private key passphrase: "))) {
                err.println("\nPassphrases do not match!  Try again.\n");
            }
        }
        PrivateKey priv = keys.getPrivate();
        byte[] keyBytes = Util.getBytesFromPrivateKey(priv);
        byte[] encKeyBytes = null;
        if (encrypt) {
            int i;
            encKeyBytes = Util.encrypt(keyBytes, secKey, 4);
            for (i = 0; i < keyBytes.length; ++i) {
                keyBytes[i] = 0;
            }
            if (secKey == null) {
                throw new AssertionError();
            }
            for (i = 0; i < secKey.length; ++i) {
                secKey[i] = 0;
            }
        } else {
            encKeyBytes = Util.encrypt(keyBytes, secKey, 1);
        }
        FileOutputStream keyOut = new FileOutputStream(privKeyFile);
        keyOut.write(encKeyBytes);
        keyOut.close();
        PublicKey pub = keys.getPublic();
        keyOut = new FileOutputStream(pubKeyFile);
        keyOut.write(Util.getBytesFromPublicKey(pub));
        keyOut.close();
    }

    private static InetAddress getIPAddress(String prompt, InetAddress defaultAddr, boolean mustBeAccessible, int protocol) throws Exception {
        String localAddress = "";
        try {
            localAddress = defaultAddr != null ? Util.rfcIpRepr(defaultAddr) : SimpleSetup.getLocalHostUnderProtocol(protocol);
        }
        catch (Exception e) {
            localAddress = "";
        }
        if (localAddress.length() > 0) {
            prompt = prompt + " [" + localAddress + "]";
        }
        while (true) {
            String line;
            if ((line = SimpleSetup.responseToPrompt(prompt)).equals("") && localAddress.length() > 0) {
                line = localAddress;
            }
            try {
                InetAddress listenAddr = InetAddress.getByName(line);
                if (mustBeAccessible && listenAddr.getHostAddress().startsWith("127.")) {
                    throw new Exception("you must enter an address that is accessible from the network");
                }
                if (protocol == 6 && !(listenAddr instanceof Inet6Address)) {
                    throw new Exception("address is not a valid IPv6 address");
                }
                if (protocol == 4 && !(listenAddr instanceof Inet4Address)) {
                    throw new Exception("address is not a valid IPv4 address");
                }
                return listenAddr;
            }
            catch (Exception e) {
                out.println("Invalid address (" + e + "), please try again.");
                continue;
            }
            break;
        }
    }

    private static String getLocalHostUnderProtocol(int protocol) throws UnknownHostException {
        Field preferIPv6Address2;
        if (protocol == 0) {
            return Util.rfcIpRepr(InetAddress.getLocalHost());
        }
        String oldProp = System.getProperty("java.net.preferIPv6Addresses", "false");
        if (protocol == 6) {
            System.setProperty("java.net.preferIPv6Addresses", "true");
        } else {
            System.setProperty("java.net.preferIPv6Addresses", "false");
        }
        try {
            preferIPv6Address2 = InetAddress.class.getDeclaredField("preferIPv6Address");
            preferIPv6Address2.setAccessible(true);
            preferIPv6Address2.setBoolean(null, protocol == 6);
        }
        catch (Exception preferIPv6Address2) {
            // empty catch block
        }
        String localAddress = Util.rfcIpRepr(InetAddress.getLocalHost());
        System.setProperty("java.net.preferIPv6Addresses", oldProp);
        try {
            preferIPv6Address2 = InetAddress.class.getDeclaredField("preferIPv6Address");
            preferIPv6Address2.setAccessible(true);
            preferIPv6Address2.setBoolean(null, Boolean.valueOf(oldProp));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return localAddress;
    }

    private static String getContactPhone(String person, String org) throws Exception {
        String phoneNumber = null;
        String prompt = "Please enter the telephone number of ";
        if (person != null && !person.equals("")) {
            prompt = prompt + person + " or of ";
        }
        prompt = prompt + org + " (optional) [(none)]";
        while (phoneNumber == null) {
            phoneNumber = SimpleSetup.validatePhoneNumber(SimpleSetup.responseToPrompt(prompt));
        }
        return phoneNumber;
    }

    private static String validatePhoneNumber(String phoneNumber) {
        char c;
        int i;
        String problem = null;
        String newPhoneNumber = "";
        int openParenPosition = -1;
        int closeParenCount = 0;
        if ((phoneNumber = phoneNumber.trim()).equals("")) {
            return "";
        }
        for (i = 0; i < phoneNumber.length(); ++i) {
            c = phoneNumber.charAt(i);
            if (!ConfigCommon.validPhoneNumberChar(c)) {
                problem = "contains illegal character '" + c + "'";
            } else if (c == '-') {
                problem = i == 0 ? "begins with a dash" : (phoneNumber.charAt(i - 1) == '-' ? "contains consecutive hyphens" : null);
            } else if (c == '(') {
                if (openParenPosition > -1) {
                    problem = "contains more than one left parenthesis";
                } else {
                    openParenPosition = i;
                }
            } else if (c == ')') {
                String string = i == 0 ? "begins with a right parenthesis" : (openParenPosition == -1 ? "contains unmatched right parenthesis" : (openParenPosition == i - 1 ? "contains empty parentheses" : (problem = ++closeParenCount > 1 ? "contains more than one right parenthesis" : null)));
            }
            if (problem != null) break;
        }
        if (problem == null && openParenPosition > -1 && closeParenCount == 0) {
            problem = "containes unmatched left parenthesis";
        }
        if (problem != null) {
            out.println("\nTelephone number " + problem + ", please try again.\n");
            return null;
        }
        for (i = 0; i < phoneNumber.length(); ++i) {
            c = phoneNumber.charAt(i);
            if (c == '(' || c == ' ' && (newPhoneNumber.endsWith(" ") || newPhoneNumber.endsWith("-"))) continue;
            if (c == ')') {
                newPhoneNumber = newPhoneNumber + '-';
                continue;
            }
            if (c == '-' && newPhoneNumber.endsWith(" ")) {
                newPhoneNumber = newPhoneNumber.trim();
            }
            newPhoneNumber = newPhoneNumber + c;
        }
        if (!phoneNumber.equals(newPhoneNumber)) {
            out.println("\nF.Y.I.: Changing telephone number format to '" + newPhoneNumber + "'.\n");
            phoneNumber = newPhoneNumber;
        }
        return phoneNumber;
    }

    private static String getContactEmail(String person, String org) throws Exception {
        String emailAddress = null;
        String prompt = "Please enter the email address of ";
        if (person != null && !person.equals("")) {
            prompt = prompt + person + " or of ";
        }
        prompt = prompt + org;
        while (SimpleSetup.badEmailAddress(emailAddress = SimpleSetup.responseToPrompt(prompt))) {
        }
        return emailAddress;
    }

    private static boolean badEmailAddress(String emailAddress) {
        if ((emailAddress = emailAddress.trim()).length() == 0) {
            return true;
        }
        String message = null;
        String problem = null;
        int atCount = 0;
        int dotCount = 0;
        int atIndex = -1;
        for (int i = 0; i < emailAddress.length(); ++i) {
            if (emailAddress.charAt(i) == '@') {
                if (atCount != 0) {
                    problem = "too many '@' characters";
                    break;
                }
                ++atCount;
                atIndex = i;
                continue;
            }
            if (atCount <= 0 || emailAddress.charAt(i) != '.') continue;
            if (atIndex == i - 1) {
                problem = "'.' immediately after '@'";
                break;
            }
            ++dotCount;
        }
        if (problem == null) {
            String string = atCount == 0 ? "no '@' character" : (problem = dotCount == 0 ? "no '.' character in segment after '@' character" : null);
        }
        if (problem == null) {
            return false;
        }
        message = "Invalid email address (" + problem + "), please try again.";
        out.println(message);
        return true;
    }

    private static final int getInteger(String prompt, int defaultAnswer, int minimum, int maximum) throws Exception {
        if (prompt == null || prompt.length() < 1 || defaultAnswer != -1 && defaultAnswer < 0 || minimum != -1 && minimum < 0 || maximum != -1 && maximum < 0) {
            throw new Exception("PROGRAMMING ERROR: getInteger(" + prompt + ", " + minimum + ", " + maximum + ")");
        }
        String promptString = prompt.trim();
        if (defaultAnswer != -1) {
            promptString = promptString + " [" + defaultAnswer + "]";
        }
        String finalInstruction = "";
        if (minimum != -1) {
            finalInstruction = finalInstruction + " greater than " + (minimum - 1);
        }
        if (maximum != -1) {
            if (finalInstruction.length() > 0) {
                finalInstruction = finalInstruction + " and";
            }
            finalInstruction = finalInstruction + " less than " + (maximum + 1);
        }
        while (true) {
            String line;
            if ((line = SimpleSetup.responseToPrompt(promptString)).length() == 0) {
                if (defaultAnswer != -1) {
                    return defaultAnswer;
                }
            } else {
                try {
                    int number = Integer.parseInt(line);
                    if (!(number < 0 || minimum != -1 && number < minimum || maximum != -1 && number > maximum)) {
                        return number;
                    }
                    throw new Exception(number + " is unacceptable.");
                }
                catch (Exception e) {
                    out.println("ERROR: " + e);
                }
            }
            out.println("\nPlease enter a positive number" + finalInstruction + ".");
        }
    }

    private static final boolean getBoolean(String prompt, String defaultAnswer) throws Exception {
        if (prompt == null || prompt.length() < 1 || defaultAnswer == null || !defaultAnswer.equals(DEFAULT_NO) && !defaultAnswer.equals(DEFAULT_YES)) {
            throw new Exception("PROGRAMMING ERROR: getBoolean(" + prompt + ", " + defaultAnswer + ")");
        }
        String line;
        while ((line = SimpleSetup.responseToPrompt(prompt + "(y/n) [" + defaultAnswer + "]").toUpperCase()).length() != 0) {
            if (line.equals("N") || line.equals("NO")) {
                return false;
            }
            if (line.equals("Y") || line.equals("YES")) {
                return true;
            }
            out.println("\nUnrecognized response, try again.");
        }
        return defaultAnswer.equals(DEFAULT_YES);
    }

    private static final String responseToPrompt(String prompt) throws IOException {
        out.print("\n" + prompt + ": ");
        out.flush();
        return in.readLine().trim();
    }

    private static final String getInterval() throws Exception {
        String prompt = "(\"N\" (Never), \"M\" (Monthly), \"W\" (Weekly), or \"D\" (Daily))? [" + DEFAULT_INTERVAL + "] ";
        String line;
        while ((line = SimpleSetup.responseToPrompt(prompt)).length() != 0) {
            if (line.toUpperCase().equals("N") || line.toUpperCase().equals("Never")) {
                return "Never";
            }
            if (line.toUpperCase().equals("M") || line.toUpperCase().equals("Monthly")) {
                return "Monthly";
            }
            if (line.toUpperCase().equals("W") || line.toUpperCase().equals("Weekly")) {
                return "Weekly";
            }
            if (line.toUpperCase().equals("D") || line.toUpperCase().equals("Daily")) {
                return "Daily";
            }
            out.println("\nUnrecognized response.\n");
        }
        return DEFAULT_INTERVAL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyFile(File sourceFile, File destFile) throws IOException {
        FileInputStream source = null;
        FileOutputStream destination = null;
        try {
            int r;
            source = new FileInputStream(sourceFile);
            destination = new FileOutputStream(destFile);
            byte[] buf = new byte[8192];
            while ((r = source.read(buf)) > 0) {
                destination.write(buf, 0, r);
            }
        }
        finally {
            if (source != null) {
                source.close();
            }
            if (destination != null) {
                destination.close();
            }
        }
    }
}

