/*
 * Decompiled with CFR 0.152.
 */
package net.handle.server;

import java.util.Hashtable;
import java.util.Vector;
import org.hyperic.sigar.FileSystem;
import org.hyperic.sigar.FileSystemUsage;
import org.hyperic.sigar.Mem;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarException;

public class SigarWrapper {
    private final Sigar sig = new Sigar();

    public boolean isReady() {
        return this.sig.getNativeLibrary() != null;
    }

    public String getFQDN() throws SigarException {
        return this.sig.getFQDN();
    }

    public Vector getDiskInfo() throws SigarException {
        FileSystem[] fsystems;
        Vector diskInfoVector = new Vector();
        for (FileSystem currentSystem : fsystems = this.sig.getFileSystemList()) {
            Hashtable<String, Object> diskInfo = new Hashtable<String, Object>();
            String devName = currentSystem.getDevName();
            String dirName = currentSystem.getDirName();
            FileSystemUsage currentSystemUsage = this.sig.getFileSystemUsage(dirName);
            String name = devName + ":" + dirName;
            double diskQueue = currentSystemUsage.getDiskQueue();
            long freeBytes = currentSystemUsage.getFree();
            long usedBytes = currentSystemUsage.getUsed();
            diskInfo.put("name", name);
            diskInfo.put("queue", this.fixDoubleForJson(diskQueue));
            diskInfo.put("free", freeBytes);
            diskInfo.put("used", usedBytes);
            diskInfoVector.add(diskInfo);
        }
        return diskInfoVector;
    }

    private double fixDoubleForJson(double d) {
        if (Double.isNaN(d) || Double.isInfinite(d)) {
            return -1.0;
        }
        return d;
    }

    public Hashtable getMemInfo() throws SigarException {
        Hashtable<String, Long> memInfo = new Hashtable<String, Long>();
        Mem mem = this.sig.getMem();
        memInfo.put("used", mem.getActualUsed());
        memInfo.put("free", mem.getActualFree());
        return memInfo;
    }

    public Vector getLoadAverageInfo() throws SigarException {
        Vector<Double> loadAverageInfo = new Vector<Double>();
        double[] laArray = this.sig.getLoadAverage();
        for (int i = 0; i < 3; ++i) {
            loadAverageInfo.add(this.fixDoubleForJson(laArray[i]));
        }
        return loadAverageInfo;
    }
}

