/*
 * Decompiled with CFR 0.152.
 */
package net.handle.server;

import java.security.SecureRandom;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Random;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.handle.hdllib.AuthenticationInfo;
import net.handle.hdllib.Util;
import net.handle.server.ServerSideSessionInfo;

public class SessionManager {
    private final ConcurrentMap<Integer, ServerSideSessionInfo> sessionInfoDict = new ConcurrentHashMap<Integer, ServerSideSessionInfo>(10);
    private boolean keepRunning = true;
    private static Random sessionRandom;
    private static String sessionRandomLock;
    public static final int SESSION_NOT_AVAILABLE = -100;
    public static final int SESSION_MAXNUM_PER_SERVER = 10;

    public ServerSideSessionInfo getSession(int sessionId) {
        ServerSideSessionInfo ssinfo = (ServerSideSessionInfo)this.sessionInfoDict.get(sessionId);
        if (ssinfo != null) {
            ssinfo.touch();
            return ssinfo;
        }
        return null;
    }

    public void removeSession(int sessionId) {
        this.sessionInfoDict.remove(sessionId);
    }

    public boolean replaceServerSideSessionInfo(int sessionId, ServerSideSessionInfo newInfo) {
        if (newInfo == null) {
            System.err.println("The new session info is null. No info is replaced.");
            return true;
        }
        this.sessionInfoDict.put(sessionId, newInfo);
        newInfo.touch();
        return true;
    }

    public boolean addSession(ServerSideSessionInfo sessionInfo) {
        if (sessionInfo == null) {
            return true;
        }
        ServerSideSessionInfo ssinfo = sessionInfo;
        this.sessionInfoDict.put(ssinfo.sessionId, ssinfo);
        sessionInfo.touch();
        return true;
    }

    public void checkTimeoutSession() {
        CheckSessionTimeOut cst = new CheckSessionTimeOut();
        cst.setDaemon(true);
        cst.setPriority(1);
        cst.start();
    }

    public Vector<ServerSideSessionInfo> getSessions() {
        return new Vector<ServerSideSessionInfo>(this.sessionInfoDict.values());
    }

    public Vector<ServerSideSessionInfo> getSessions(AuthenticationInfo info) {
        if (info != null) {
            return this.getSessions(info.getUserIdHandle(), info.getUserIdIndex());
        }
        return null;
    }

    public Vector<ServerSideSessionInfo> getSessions(byte[] identityHandle, int identityIndex) {
        Vector<ServerSideSessionInfo> vecSessions = new Vector<ServerSideSessionInfo>();
        for (ServerSideSessionInfo sssinfo : this.sessionInfoDict.values()) {
            if (!Util.equals(sssinfo.identityKeyHandle, identityHandle) || sssinfo.identityKeyIndex != identityIndex) continue;
            vecSessions.addElement(sssinfo);
        }
        return vecSessions;
    }

    public Enumeration<Integer> getAllKeys() {
        return Collections.enumeration(this.sessionInfoDict.keySet());
    }

    public synchronized void shutdown() {
        if (!this.keepRunning) {
            return;
        }
        this.keepRunning = false;
    }

    public static final byte[] getGeneratedSecretKey() {
        byte[] sessionKey = new byte[512];
        SessionManager.getSessionRandom().nextBytes(sessionKey);
        return sessionKey;
    }

    public static final void initializeSessionKeyRandom() {
        SessionManager.initializeSessionKeyRandom(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void initializeSessionKeyRandom(byte[] seed) {
        if (sessionRandom == null) {
            String string = sessionRandomLock;
            synchronized (string) {
                if (sessionRandom == null) {
                    if (seed == null) {
                        sessionRandom = new SecureRandom();
                        sessionRandom.setSeed(System.nanoTime());
                    } else {
                        sessionRandom = new SecureRandom(seed);
                    }
                    sessionRandom.nextInt();
                }
            }
        }
    }

    private static Random getSessionRandom() {
        if (sessionRandom == null) {
            SessionManager.initializeSessionKeyRandom();
        }
        return sessionRandom;
    }

    static {
        sessionRandomLock = "sessionRandomLock";
    }

    private class CheckSessionTimeOut
    extends Thread {
        private CheckSessionTimeOut() {
        }

        @Override
        public void run() {
            while (SessionManager.this.keepRunning) {
                try {
                    Thread.sleep(60000L);
                    Iterator iter = SessionManager.this.sessionInfoDict.values().iterator();
                    while (iter.hasNext()) {
                        ServerSideSessionInfo ssinfo = (ServerSideSessionInfo)iter.next();
                        if (ssinfo == null || !ssinfo.hasExpired()) continue;
                        iter.remove();
                    }
                }
                catch (Throwable e) {
                    System.err.println("Error purging timeout session objects: " + e);
                }
            }
        }
    }
}

