/*
 * Decompiled with CFR 0.152.
 */
package net.handle.server;

import java.io.Closeable;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Enumeration;
import net.cnri.util.StreamTable;
import net.handle.hdllib.Common;
import net.handle.hdllib.Encoder;
import net.handle.hdllib.HandleException;
import net.handle.hdllib.HandleStorage;
import net.handle.hdllib.HandleValue;
import net.handle.hdllib.ScanCallback;
import net.handle.hdllib.Util;
import net.handle.hdllib.ValueReference;

public class SQLHandleStorage
implements HandleStorage {
    private static final String SQL_URL = "sql_url";
    private static final String SQL_LOGIN = "sql_login";
    private static final String SQL_PASSWD = "sql_passwd";
    private static final String SQL_DRIVER_CLASS = "sql_driver";
    private static final String SQL_READ_ONLY = "sql_read_only";
    private static final long CONN_LIFE_TIME = 21600000L;
    private static final long MAX_OPS_PER_CONN = 50000L;
    private String databaseURL;
    private String username;
    private String passwd;
    private boolean readOnly = false;
    private boolean compensateForOracleJDBCBug = false;
    private boolean storeHandleAsString = false;
    private boolean storeNaAsString = false;
    private boolean storeHandleValueTypeAsString = false;
    private boolean traceSql = false;
    private Connection sqlConnection = null;
    private long lastConnectTime = 0L;
    private long numOperations = 0L;
    private PreparedStatement haveNAStatement = null;
    private PreparedStatement addNAStatement = null;
    private PreparedStatement delNAStatement = null;
    private PreparedStatement createHandleStatement = null;
    private PreparedStatement getHandleStatement = null;
    private PreparedStatement handleExistsStatement = null;
    private PreparedStatement deleteHandleStatement = null;
    private PreparedStatement modifyValueStatement = null;
    private String HAVE_NA_STMT = "select count(*) from nas where na = ?";
    private String DEL_NA_STMT = "delete from nas where na = ?";
    private String ADD_NA_STMT = "insert into nas ( na ) values ( ? )";
    private String SCAN_HANDLES_STMT = "select distinct handle from handles order by handle";
    private String SCAN_HANDLES_FROM_STMT = "select distinct handle from handles where handle >= ? order by handle";
    private String SCAN_BYPREFIX_STMT = "select distinct handle from handles where handle like ?";
    private String SCAN_NAS_STMT = "select distinct na from nas order by na";
    private String SCAN_NAS_FROM_STMT = "select distinct na from nas where na >= ? order by na";
    private String DELETE_ALL_HDLS_STMT = "delete from handles";
    private String DELETE_ALL_NAS_STMT = "delete from nas";
    private String CREATE_HDL_STMT = "insert into handles ( handle, idx, type, data, ttl_type, ttl, timestamp, refs, admin_read, admin_write, pub_read, pub_write) values ( ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    private String GET_HDL_STMT = "select idx, type, data, ttl_type, ttl, timestamp, refs, admin_read, admin_write, pub_read, pub_write from handles where handle = ?";
    private String HDL_EXISTS_STMT = "select count(*) from handles where handle = ?";
    private String DELETE_HDL_STMT = "delete from handles where handle = ?";
    private String MOD_VALUE_STMT = "update handles set type = ?, data = ?, ttl_type = ?, ttl = ?, timestamp = ?, refs = ?, admin_read = ?, admin_write = ?, pub_read = ?, pub_write = ? where handle = ? and idx = ?";
    private static final String CFG_HAVE_NA_STMT = "have_na_stmt";
    private static final String CFG_DEL_NA_STMT = "del_na_stmt";
    private static final String CFG_ADD_NA_STMT = "add_na_stmt";
    private static final String CFG_SCAN_HANDLES_STMT = "scan_handles_stmt";
    private static final String CFG_SCAN_HANDLES_FROM_STMT = "scan_handles_from_stmt";
    private static final String CFG_SCAN_BYPREFIX_STMT = "scan_by_prefix_stmt";
    private static final String CFG_SCAN_NAS_STMT = "scan_nas_stmt";
    private static final String CFG_SCAN_NAS_FROM_STMT = "scan_nas_from_stmt";
    private static final String CFG_DELETE_ALL_HDLS_STMT = "delete_all_handles_stmt";
    private static final String CFG_DELETE_ALL_NAS_STMT = "delete_all_nas_stmt";
    private static final String CFG_CREATE_HDL_STMT = "create_handle_stmt";
    private static final String CFG_GET_HDL_STMT = "get_handle_stmt";
    private static final String CFG_HDL_EXISTS_STMT = "handle_exists_stmt";
    private static final String CFG_DELETE_HDL_STMT = "delete_handle_stmt";
    private static final String CFG_MOD_VALUE_STMT = "modify_value_stmt";
    private static final String CFG_FIX_ORACLE_BUG = "compensate_for_oracle_jdbc_bug";
    private static final String CFG_STORE_HANDLE_AS_STRING = "store_handle_as_string";
    private static final String CFG_STORE_NA_AS_STRING = "store_na_as_string";
    private static final String CFG_STORE_HANDLE_VALUE_TYPE_AS_STRING = "store_handle_value_type_as_string";
    private static final String CFG_TRACE_SQL = "trace_sql";
    private static final char[] HEX_VALUES = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    @Override
    public void init(StreamTable config) throws Exception {
        if (config.containsKey(SQL_DRIVER_CLASS)) {
            Class.forName(String.valueOf(config.get(SQL_DRIVER_CLASS)));
        }
        this.databaseURL = (String)config.get(SQL_URL);
        this.username = (String)config.get(SQL_LOGIN);
        this.passwd = (String)config.get(SQL_PASSWD);
        this.readOnly = config.getBoolean(SQL_READ_ONLY, false);
        this.compensateForOracleJDBCBug = config.getBoolean(CFG_FIX_ORACLE_BUG, false);
        this.storeHandleAsString = config.getBoolean(CFG_STORE_HANDLE_AS_STRING, false);
        this.storeNaAsString = config.getBoolean(CFG_STORE_NA_AS_STRING, false);
        this.storeHandleValueTypeAsString = config.getBoolean(CFG_STORE_HANDLE_VALUE_TYPE_AS_STRING, false);
        this.traceSql = config.getBoolean(CFG_TRACE_SQL, false);
        if (this.traceSql) {
            System.err.println("SQL URL: " + this.databaseURL + ", username " + this.username);
            StringBuilder sb = new StringBuilder("SQL config options: ");
            if (this.readOnly) {
                sb.append("readOnly ");
            }
            if (this.compensateForOracleJDBCBug) {
                sb.append("compensateForOracleJDBCBug ");
            }
            if (this.storeHandleAsString) {
                sb.append("storeHandleAsString ");
            }
            if (this.storeNaAsString) {
                sb.append("storeNaAsString ");
            }
            if (this.storeHandleValueTypeAsString) {
                sb.append("storeHandleValueTypeAsString ");
            }
            System.err.println(sb);
        }
        this.HAVE_NA_STMT = config.getStr(CFG_HAVE_NA_STMT, this.HAVE_NA_STMT);
        this.DEL_NA_STMT = config.getStr(CFG_DEL_NA_STMT, this.DEL_NA_STMT);
        this.ADD_NA_STMT = config.getStr(CFG_ADD_NA_STMT, this.ADD_NA_STMT);
        this.SCAN_HANDLES_STMT = config.getStr(CFG_SCAN_HANDLES_STMT, this.SCAN_HANDLES_STMT);
        this.SCAN_HANDLES_FROM_STMT = config.getStr(CFG_SCAN_HANDLES_FROM_STMT, this.SCAN_HANDLES_FROM_STMT);
        this.SCAN_BYPREFIX_STMT = config.getStr(CFG_SCAN_BYPREFIX_STMT, this.SCAN_BYPREFIX_STMT);
        this.SCAN_NAS_STMT = config.getStr(CFG_SCAN_NAS_STMT, this.SCAN_NAS_STMT);
        this.SCAN_NAS_FROM_STMT = config.getStr(CFG_SCAN_NAS_FROM_STMT, this.SCAN_NAS_FROM_STMT);
        this.DELETE_ALL_HDLS_STMT = config.getStr(CFG_DELETE_ALL_HDLS_STMT, this.DELETE_ALL_HDLS_STMT);
        this.DELETE_ALL_NAS_STMT = config.getStr(CFG_DELETE_ALL_NAS_STMT, this.DELETE_ALL_NAS_STMT);
        this.CREATE_HDL_STMT = config.getStr(CFG_CREATE_HDL_STMT, this.CREATE_HDL_STMT);
        this.GET_HDL_STMT = config.getStr(CFG_GET_HDL_STMT, this.GET_HDL_STMT);
        this.HDL_EXISTS_STMT = config.getStr(CFG_HDL_EXISTS_STMT, this.HDL_EXISTS_STMT);
        this.DELETE_HDL_STMT = config.getStr(CFG_DELETE_HDL_STMT, this.DELETE_HDL_STMT);
        this.MOD_VALUE_STMT = config.getStr(CFG_MOD_VALUE_STMT, this.MOD_VALUE_STMT);
        this.ensureOpenSingletonConnection();
    }

    private synchronized void ensureOpenSingletonConnection() throws HandleException {
        long now = System.currentTimeMillis();
        if (this.sqlConnection != null && (this.lastConnectTime < now - 21600000L || this.numOperations > 50000L)) {
            try {
                this.closePreparedStatements();
                this.sqlConnection.close();
                this.sqlConnection = null;
            }
            catch (Exception e) {
                System.err.println("Error resetting old connection: " + e);
                e.printStackTrace(System.err);
            }
        }
        try {
            if (this.sqlConnection != null && !this.sqlConnection.isClosed()) {
                return;
            }
        }
        catch (SQLException e) {
            System.err.println(e);
            e.printStackTrace(System.err);
        }
        if (this.sqlConnection != null) {
            try {
                this.closePreparedStatements();
                this.sqlConnection.close();
            }
            catch (Exception e) {
                System.err.println("Error cleaning up SQL connection: " + e);
                e.printStackTrace(System.err);
            }
            this.sqlConnection = null;
        }
        try {
            this.sqlConnection = this.getNewConnection();
            this.lastConnectTime = now;
            this.numOperations = 0L;
            this.haveNAStatement = this.sqlConnection.prepareStatement(this.HAVE_NA_STMT);
            this.delNAStatement = this.sqlConnection.prepareStatement(this.DEL_NA_STMT);
            this.addNAStatement = this.sqlConnection.prepareStatement(this.ADD_NA_STMT);
            this.createHandleStatement = this.sqlConnection.prepareStatement(this.CREATE_HDL_STMT);
            this.getHandleStatement = this.sqlConnection.prepareStatement(this.GET_HDL_STMT);
            this.handleExistsStatement = this.sqlConnection.prepareStatement(this.HDL_EXISTS_STMT);
            this.deleteHandleStatement = this.sqlConnection.prepareStatement(this.DELETE_HDL_STMT);
            this.modifyValueStatement = this.sqlConnection.prepareStatement(this.MOD_VALUE_STMT);
        }
        catch (SQLException e) {
            for (SQLException curr = e; curr != null; curr = curr.getNextException()) {
                System.err.println("Got SQL Exception " + curr);
                curr.printStackTrace();
            }
            throw new HandleException(1, "Error connecting", e);
        }
        catch (Exception e) {
            throw new HandleException(1, "Unable to setup sql connection", e);
        }
    }

    @Override
    public synchronized void shutdown() {
        this.closeSingletonConnection();
    }

    private synchronized void closeSingletonConnection() {
        if (this.sqlConnection != null) {
            try {
                this.closePreparedStatements();
                this.sqlConnection.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.sqlConnection = null;
        }
    }

    private synchronized void closePreparedStatements() {
        this.closeQuietly(this.haveNAStatement);
        this.closeQuietly(this.delNAStatement);
        this.closeQuietly(this.addNAStatement);
        this.closeQuietly(this.createHandleStatement);
        this.closeQuietly(this.getHandleStatement);
        this.closeQuietly(this.handleExistsStatement);
        this.closeQuietly(this.deleteHandleStatement);
        this.closeQuietly(this.modifyValueStatement);
    }

    private void closeQuietly(PreparedStatement p) {
        if (p != null) {
            try {
                p.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private Connection getNewConnection() throws SQLException {
        return DriverManager.getConnection(this.databaseURL, this.username, this.passwd);
    }

    @Override
    public synchronized boolean haveNA(byte[] authHandle) throws HandleException {
        this.ensureOpenSingletonConnection();
        ResultSet results = null;
        try {
            authHandle = Util.upperCase(authHandle);
            this.setNa(this.haveNAStatement, 1, authHandle);
            if (this.traceSql) {
                System.err.println("SQL: " + this.HAVE_NA_STMT + " " + Util.decodeString(authHandle));
            }
            results = this.haveNAStatement.executeQuery();
            ++this.numOperations;
            boolean bl = results.next() && results.getInt(1) > 0;
            return bl;
        }
        catch (Exception e) {
            this.closeSingletonConnection();
            throw new HandleException(1, "Error accessing NA data", e);
        }
        finally {
            if (results != null) {
                try {
                    results.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    @Override
    public synchronized void setHaveNA(byte[] authHandle, boolean flag) throws HandleException {
        if (this.readOnly) {
            throw new HandleException(18, "Server is read-only");
        }
        this.ensureOpenSingletonConnection();
        boolean currentlyHaveIt = this.haveNA(authHandle);
        if (currentlyHaveIt == flag) {
            return;
        }
        try {
            authHandle = Util.upperCase(authHandle);
            if (currentlyHaveIt) {
                this.setNa(this.delNAStatement, 1, authHandle);
                if (this.traceSql) {
                    System.err.println("SQL: " + this.DEL_NA_STMT + " " + Util.decodeString(authHandle));
                }
                this.delNAStatement.executeUpdate();
            } else {
                this.setNa(this.addNAStatement, 1, authHandle);
                if (this.traceSql) {
                    System.err.println("SQL: " + this.ADD_NA_STMT + " " + Util.decodeString(authHandle));
                }
                this.addNAStatement.executeUpdate();
            }
            ++this.numOperations;
        }
        catch (Exception e) {
            this.closeSingletonConnection();
            throw new HandleException(1, "Error accessing NA data", e);
        }
    }

    private synchronized boolean handleExists(byte[] handle) throws HandleException {
        this.ensureOpenSingletonConnection();
        ResultSet results = null;
        try {
            this.setHandle(this.handleExistsStatement, 1, handle);
            if (this.traceSql) {
                System.err.println("SQL: " + this.HDL_EXISTS_STMT + " " + Util.decodeString(handle));
            }
            boolean bl = (results = this.handleExistsStatement.executeQuery()).next() && results.getInt(1) > 0;
            return bl;
        }
        catch (Exception e) {
            this.closeSingletonConnection();
            throw new HandleException(1, "Error checking for existing handle", e);
        }
        finally {
            if (results != null) {
                try {
                    results.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    @Override
    public boolean exists(byte[] handle) throws HandleException {
        return this.handleExists(handle);
    }

    private static final String encodeString(String str) {
        int len = str.length();
        StringBuffer sb = new StringBuffer(len + 4);
        for (int i = 0; i < len; ++i) {
            char ch = str.charAt(i);
            if (ch >= '\u007f' || ch < ' ' || ch == '%') {
                sb.append('%');
                sb.append(HEX_VALUES[ch >> 12 & 0xF]);
                sb.append(HEX_VALUES[ch >> 8 & 0xF]);
                sb.append(HEX_VALUES[ch >> 4 & 0xF]);
                sb.append(HEX_VALUES[ch & 0xF]);
                continue;
            }
            sb.append(ch);
        }
        return sb.toString();
    }

    private static final char decodeChar(char ch1, char ch2, char ch3, char ch4) {
        int ich3;
        int ich2;
        int ich1;
        int n = ch1 >= 'a' ? ch1 - 97 + 10 : (ich1 = ch1 >= 'A' ? ch1 - 65 + 10 : ch1 - 48);
        int n2 = ch2 >= 'a' ? ch2 - 97 + 10 : (ich2 = ch2 >= 'A' ? ch2 - 65 + 10 : ch2 - 48);
        int n3 = ch3 >= 'a' ? ch3 - 97 + 10 : (ich3 = ch3 >= 'A' ? ch3 - 65 + 10 : ch3 - 48);
        int ich4 = ch4 >= 'a' ? ch4 - 97 + 10 : (ch4 >= 'A' ? ch4 - 65 + 10 : ch4 - 48);
        return (char)(ich1 << 12 | ich2 << 8 | ich3 << 4 | ich4);
    }

    private static final String decodeString(String str) {
        int len = str.length();
        StringBuffer sb = new StringBuffer(len);
        for (int i = 0; i < len; ++i) {
            char ch = str.charAt(i);
            if (ch == '%' && i < len - 4) {
                char encCh1 = str.charAt(++i);
                char encCh2 = str.charAt(++i);
                char encCh3 = str.charAt(++i);
                char encCh4 = str.charAt(++i);
                sb.append(SQLHandleStorage.decodeChar(encCh1, encCh2, encCh3, encCh4));
                continue;
            }
            sb.append(ch);
        }
        return sb.toString();
    }

    @Override
    public synchronized void createHandle(byte[] handle, HandleValue[] values) throws HandleException {
        if (this.readOnly) {
            throw new HandleException(18, "Server is read-only");
        }
        this.ensureOpenSingletonConnection();
        String handleStr = Util.decodeString(handle);
        if (this.handleExists(handle)) {
            throw new HandleException(5, handleStr);
        }
        if (values == null) {
            throw new HandleException(0);
        }
        try {
            try {
                this.sqlConnection.setAutoCommit(false);
                this.performCreation(handle, values);
                this.sqlConnection.commit();
            }
            catch (Exception sqlExc) {
                this.sqlConnection.rollback();
                throw sqlExc;
            }
            finally {
                this.sqlConnection.setAutoCommit(true);
            }
        }
        catch (Exception e) {
            this.closeSingletonConnection();
            throw new HandleException(1, "Error creating handle", e);
        }
        finally {
            ++this.numOperations;
        }
    }

    private void performCreation(byte[] handle, HandleValue[] values) throws SQLException {
        for (HandleValue val : values) {
            this.setHandle(this.createHandleStatement, 1, handle);
            this.createHandleStatement.setInt(2, val.getIndex());
            if (this.storeHandleValueTypeAsString) {
                this.createHandleStatement.setString(3, val.getTypeAsString());
            } else {
                this.createHandleStatement.setBytes(3, val.getType());
            }
            this.createHandleStatement.setBytes(4, val.getData());
            this.createHandleStatement.setByte(5, val.getTTLType());
            this.createHandleStatement.setInt(6, val.getTTL());
            this.createHandleStatement.setInt(7, val.getTimestamp());
            StringBuffer sb = new StringBuffer();
            ValueReference[] refs = val.getReferences();
            for (int rv = 0; refs != null && rv < refs.length; ++rv) {
                if (rv != 0) {
                    sb.append('\t');
                }
                sb.append(refs[rv].index);
                sb.append(':');
                sb.append(SQLHandleStorage.encodeWhitespace(Util.decodeString(refs[rv].handle)));
            }
            this.createHandleStatement.setString(8, SQLHandleStorage.encodeString(sb.toString()));
            this.createHandleStatement.setBoolean(9, val.getAdminCanRead());
            this.createHandleStatement.setBoolean(10, val.getAdminCanWrite());
            this.createHandleStatement.setBoolean(11, val.getAnyoneCanRead());
            this.createHandleStatement.setBoolean(12, val.getAnyoneCanWrite());
            if (this.traceSql) {
                System.err.println("SQL: " + this.CREATE_HDL_STMT + " " + Util.decodeString(handle) + "," + val.getIndex() + "," + val.getTypeAsString() + ",...," + val.getTTLType() + "," + val.getTTL() + "," + val.getTimestamp() + "," + SQLHandleStorage.encodeString(sb.toString()) + "," + val.getAdminCanRead() + "," + val.getAdminCanWrite() + "," + val.getAnyoneCanRead() + "," + val.getAnyoneCanWrite());
            }
            this.createHandleStatement.executeUpdate();
        }
    }

    public static final String encodeWhitespace(String str) {
        StringBuilder sb = new StringBuilder("");
        block6: for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            switch (ch) {
                case '\t': {
                    sb.append("\\t");
                    continue block6;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block6;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block6;
                }
                case '\\': {
                    sb.append("\\\\");
                    continue block6;
                }
                default: {
                    sb.append(ch);
                }
            }
        }
        return sb.toString();
    }

    public static final String decodeWhitespace(String str) {
        int len = str.length();
        StringBuilder sb = new StringBuilder(str.length());
        for (int currPos = 0; currPos < len; ++currPos) {
            char ch = str.charAt(currPos);
            if (ch == '\\') {
                if (++currPos >= len) {
                    sb.append(ch);
                    break;
                }
                ch = str.charAt(currPos);
                if (ch == 'n') {
                    sb.append('\n');
                    continue;
                }
                if (ch == 't') {
                    sb.append('\t');
                    continue;
                }
                if (ch == 'r') {
                    sb.append('\r');
                    continue;
                }
                sb.append(ch);
                continue;
            }
            sb.append(ch);
        }
        return sb.toString();
    }

    @Override
    public synchronized boolean deleteHandle(byte[] handle) throws HandleException {
        boolean deleted;
        if (this.readOnly) {
            throw new HandleException(18, "Server is read-only");
        }
        this.ensureOpenSingletonConnection();
        try {
            deleted = this.performDeletion(handle);
            ++this.numOperations;
        }
        catch (Exception e) {
            this.closeSingletonConnection();
            throw new HandleException(1, "Error deleting handle");
        }
        return deleted;
    }

    private boolean performDeletion(byte[] handle) throws SQLException {
        this.setHandle(this.deleteHandleStatement, 1, handle);
        if (this.traceSql) {
            System.err.println("SQL: " + this.DELETE_HDL_STMT + " " + Util.decodeString(handle));
        }
        boolean deleted = this.deleteHandleStatement.executeUpdate() > 0;
        return deleted;
    }

    @Override
    public synchronized byte[][] getRawHandleValues(byte[] handle, int[] indexList, byte[][] typeList) throws HandleException {
        byte[][] byArrayArray;
        this.ensureOpenSingletonConnection();
        ResultSet results = null;
        try {
            HandleValue value;
            this.setHandle(this.getHandleStatement, 1, handle);
            if (this.traceSql) {
                System.err.println("SQL: " + this.GET_HDL_STMT + " " + Util.decodeString(handle));
            }
            results = this.getHandleStatement.executeQuery();
            boolean allValues = !(typeList != null && typeList.length != 0 || indexList != null && indexList.length != 0);
            ArrayList<HandleValue> values = new ArrayList<HandleValue>();
            boolean handleExists = false;
            while (results.next()) {
                handleExists = true;
                value = new HandleValue();
                value.setIndex(results.getInt(1));
                if (this.storeHandleValueTypeAsString) {
                    value.setType(Util.encodeString(results.getString(2)));
                } else {
                    value.setType(this.getBytesFromResults(results, 2));
                }
                if (!allValues && !Util.isParentTypeInArray(typeList, value.getType()) && !Util.isInArray(indexList, value.getIndex())) continue;
                value.setData(this.getBytesFromResults(results, 3));
                value.setTTLType(results.getByte(4));
                value.setTTL(results.getInt(5));
                value.setTimestamp(results.getInt(6));
                String referencesStr = this.getDecodedStringFromResults(results, 7);
                String[] references = referencesStr == null ? new String[]{} : referencesStr.split("\t");
                if (referencesStr != null && referencesStr.length() > 0 && references.length > 0) {
                    ValueReference[] valReferences = new ValueReference[references.length];
                    for (int i = 0; i < references.length; ++i) {
                        valReferences[i] = new ValueReference();
                        int colIdx = references[i].indexOf(58);
                        try {
                            valReferences[i].index = Integer.parseInt(references[i].substring(0, colIdx));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        valReferences[i].handle = Util.encodeString(SQLHandleStorage.decodeWhitespace(references[i].substring(colIdx + 1)));
                    }
                    value.setReferences(valReferences);
                }
                value.setAdminCanRead(results.getBoolean(8));
                value.setAdminCanWrite(results.getBoolean(9));
                value.setAnyoneCanRead(results.getBoolean(10));
                value.setAnyoneCanWrite(results.getBoolean(11));
                values.add(value);
            }
            ++this.numOperations;
            if (!handleExists) {
                value = null;
                return value;
            }
            byte[][] rawValues = new byte[values.size()][];
            for (int i = 0; i < rawValues.length; ++i) {
                HandleValue value2 = (HandleValue)values.get(i);
                rawValues[i] = new byte[Encoder.calcStorageSize(value2)];
                Encoder.encodeHandleValue(rawValues[i], 0, value2);
            }
            byArrayArray = rawValues;
        }
        catch (Exception e) {
            this.closeSingletonConnection();
            throw new HandleException(1, "Error retrieving handle");
        }
        finally {
            if (results != null) {
                try {
                    results.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return byArrayArray;
    }

    @Override
    public synchronized void updateValue(byte[] handle, HandleValue[] values) throws HandleException {
        if (this.readOnly) {
            throw new HandleException(18, "Server is read-only");
        }
        if (!this.handleExists(handle)) {
            throw new HandleException(9);
        }
        this.createOrUpdateRecord(handle, values);
    }

    @Override
    public synchronized void createOrUpdateRecord(byte[] handle, HandleValue[] values) throws HandleException {
        if (this.readOnly) {
            throw new HandleException(18, "Server is read-only");
        }
        this.ensureOpenSingletonConnection();
        try {
            try {
                this.sqlConnection.setAutoCommit(false);
                this.performDeletion(handle);
                this.performCreation(handle, values);
                this.sqlConnection.commit();
            }
            catch (Exception sqlExc) {
                this.sqlConnection.rollback();
                throw sqlExc;
            }
            finally {
                this.sqlConnection.setAutoCommit(true);
            }
        }
        catch (Exception e) {
            this.closeSingletonConnection();
            throw new HandleException(1, "Error updating handle values", e);
        }
        finally {
            ++this.numOperations;
        }
    }

    @Override
    public boolean supportsDumpResumption() {
        return true;
    }

    @Override
    public void scanHandlesFrom(byte[] startingPoint, boolean inclusive, ScanCallback callback) throws HandleException {
        Connection connection = null;
        Statement scanStatement = null;
        ResultSet results = null;
        try {
            connection = this.getNewConnection();
            scanStatement = connection.prepareStatement(this.SCAN_HANDLES_FROM_STMT, 1003, 1007);
            this.setHandle((PreparedStatement)scanStatement, 1, startingPoint);
            boolean isMySql = connection.getMetaData().getDatabaseProductName().toLowerCase().contains("mysql");
            if (isMySql) {
                scanStatement.setFetchSize(Integer.MIN_VALUE);
            }
            if (this.traceSql) {
                System.err.println("SQL: " + this.SCAN_HANDLES_FROM_STMT + " " + Util.decodeString(startingPoint));
            }
            results = scanStatement.executeQuery();
            boolean hasNext = true;
            if (!inclusive) {
                hasNext = results.next();
            }
            if (hasNext) {
                while (results.next()) {
                    byte[] b = this.getHandleBytesFromResults(results, 1);
                    callback.scanHandle(b);
                }
            }
        }
        catch (SQLException e) {
            throw new HandleException(1, "SQL Error", e);
        }
        finally {
            if (results != null) {
                try {
                    results.close();
                }
                catch (Exception exception) {}
            }
            if (scanStatement != null) {
                try {
                    scanStatement.close();
                }
                catch (Exception exception) {}
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    @Override
    public void scanNAsFrom(byte[] startingPoint, boolean inclusive, ScanCallback callback) throws HandleException {
        Connection connection = null;
        Statement scanStatement = null;
        ResultSet results = null;
        try {
            connection = this.getNewConnection();
            scanStatement = connection.prepareStatement(this.SCAN_NAS_FROM_STMT, 1003, 1007);
            this.setNa((PreparedStatement)scanStatement, 1, Util.encodeString(Util.decodeString(startingPoint) + "_%"));
            boolean isMySql = connection.getMetaData().getDatabaseProductName().toLowerCase().contains("mysql");
            if (isMySql) {
                scanStatement.setFetchSize(Integer.MIN_VALUE);
            }
            if (this.traceSql) {
                System.err.println("SQL: " + this.SCAN_NAS_FROM_STMT + " " + Util.decodeString(startingPoint) + "_%");
            }
            results = scanStatement.executeQuery();
            boolean hasNext = true;
            if (!inclusive) {
                hasNext = results.next();
            }
            if (hasNext) {
                while (results.next()) {
                    byte[] b = this.getNaBytesFromResults(results, 1);
                    callback.scanHandle(b);
                }
            }
        }
        catch (SQLException e) {
            throw new HandleException(1, "SQL Error", e);
        }
        finally {
            if (results != null) {
                try {
                    results.close();
                }
                catch (Exception exception) {}
            }
            if (scanStatement != null) {
                try {
                    scanStatement.close();
                }
                catch (Exception exception) {}
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    @Override
    public void scanHandles(ScanCallback callback) throws HandleException {
        Connection connection = null;
        Statement scanStatement = null;
        ResultSet results = null;
        try {
            connection = this.getNewConnection();
            scanStatement = connection.prepareStatement(this.SCAN_HANDLES_STMT, 1003, 1007);
            boolean isMySql = connection.getMetaData().getDatabaseProductName().toLowerCase().contains("mysql");
            if (isMySql) {
                scanStatement.setFetchSize(Integer.MIN_VALUE);
            }
            if (this.traceSql) {
                System.err.println("SQL: " + this.SCAN_HANDLES_STMT);
            }
            results = scanStatement.executeQuery();
            while (results.next()) {
                byte[] b = this.getHandleBytesFromResults(results, 1);
                callback.scanHandle(b);
            }
        }
        catch (SQLException e) {
            throw new HandleException(1, "SQL Error", e);
        }
        finally {
            if (results != null) {
                try {
                    results.close();
                }
                catch (Exception exception) {}
            }
            if (scanStatement != null) {
                try {
                    scanStatement.close();
                }
                catch (Exception exception) {}
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    @Override
    public void scanNAs(ScanCallback callback) throws HandleException {
        Connection connection = null;
        Statement scanStatement = null;
        ResultSet results = null;
        try {
            connection = this.getNewConnection();
            scanStatement = connection.prepareStatement(this.SCAN_NAS_STMT, 1003, 1007);
            boolean isMySql = connection.getMetaData().getDatabaseProductName().toLowerCase().contains("mysql");
            if (isMySql) {
                scanStatement.setFetchSize(Integer.MIN_VALUE);
            }
            if (this.traceSql) {
                System.err.println("SQL: " + this.SCAN_NAS_STMT);
            }
            results = scanStatement.executeQuery();
            while (results.next()) {
                byte[] b = this.getNaBytesFromResults(results, 1);
                callback.scanHandle(b);
            }
        }
        catch (SQLException e) {
            throw new HandleException(1, "SQL Error", e);
        }
        finally {
            if (results != null) {
                try {
                    results.close();
                }
                catch (Exception exception) {}
            }
            if (scanStatement != null) {
                try {
                    scanStatement.close();
                }
                catch (Exception exception) {}
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    @Override
    public Enumeration<byte[]> getHandlesForNA(byte[] naHdl) throws HandleException {
        if (!this.haveNA(naHdl)) {
            throw new HandleException(0, "The requested prefix doesn't live here");
        }
        boolean isZeroNA = Util.startsWithCI(naHdl, Common.NA_HANDLE_PREFIX);
        if (isZeroNA) {
            naHdl = Util.getSuffixPart(naHdl);
        }
        return new ListHdlsEnum(naHdl);
    }

    @Override
    public void deleteAllRecords() throws HandleException {
        if (this.readOnly) {
            throw new HandleException(18, "Server is read-only");
        }
        Connection connection = null;
        Statement statement = null;
        try {
            connection = this.getNewConnection();
            statement = connection.createStatement();
            if (this.traceSql) {
                System.err.println("SQL: " + this.DELETE_ALL_HDLS_STMT);
            }
            statement.executeUpdate(this.DELETE_ALL_HDLS_STMT);
            if (this.traceSql) {
                System.err.println("SQL: " + this.DELETE_ALL_NAS_STMT);
            }
            statement.executeUpdate(this.DELETE_ALL_NAS_STMT);
        }
        catch (SQLException e) {
            throw new HandleException(1, "SQL Error", e);
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (Exception exception) {}
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    @Override
    public void checkpointDatabase() throws HandleException {
        throw new HandleException(15, "Checkpoint not supported in this storage type");
    }

    private final String getDecodedStringFromResults(ResultSet results, int i) throws SQLException {
        String s = results.getString(i);
        return s == null ? "" : SQLHandleStorage.decodeString(s);
    }

    private void setHandle(PreparedStatement statement, int i, byte[] x) throws SQLException {
        if (this.storeHandleAsString) {
            statement.setString(i, Util.decodeString(x));
        } else {
            statement.setBytes(i, x);
        }
    }

    private void setNa(PreparedStatement statement, int i, byte[] x) throws SQLException {
        if (this.storeNaAsString) {
            statement.setString(i, Util.decodeString(x));
        } else {
            statement.setBytes(i, x);
        }
    }

    private final byte[] getBytesFromResults(ResultSet results, int i) throws SQLException {
        if (this.compensateForOracleJDBCBug) {
            String s = results.getString(i);
            if (s == null) {
                return new byte[0];
            }
            return Util.encodeHexString(s);
        }
        byte[] b = results.getBytes(i);
        return b == null ? new byte[]{} : b;
    }

    private final byte[] getHandleBytesFromResults(ResultSet results, int i) throws SQLException {
        if (this.storeHandleAsString) {
            String s = results.getString(i);
            if (s == null) {
                return new byte[0];
            }
            return Util.encodeString(s);
        }
        return this.getBytesFromResults(results, i);
    }

    private final byte[] getNaBytesFromResults(ResultSet results, int i) throws SQLException {
        if (this.storeNaAsString) {
            String s = results.getString(i);
            if (s == null) {
                return new byte[0];
            }
            return Util.encodeString(s);
        }
        return this.getBytesFromResults(results, i);
    }

    private class ListHdlsEnum
    implements Enumeration<byte[]>,
    Closeable {
        private final Connection connection;
        private final byte[] prefix;
        private final PreparedStatement scanStatement;
        private final ResultSet results;
        private byte[] nextVal = null;
        private boolean isClosed = false;
        private final boolean listingDerivedPrefixes;

        ListHdlsEnum(byte[] prefix) throws HandleException {
            this.prefix = prefix;
            this.listingDerivedPrefixes = Util.startsWithCI(prefix, Common.NA_HANDLE_PREFIX);
            try {
                this.connection = SQLHandleStorage.this.getNewConnection();
                this.scanStatement = this.connection.prepareStatement(SQLHandleStorage.this.SCAN_BYPREFIX_STMT);
                String suffix = this.listingDerivedPrefixes ? ".%" : "/%";
                SQLHandleStorage.this.setHandle(this.scanStatement, 1, Util.encodeString(Util.decodeString(prefix) + suffix));
                if (SQLHandleStorage.this.traceSql) {
                    System.err.println("SQL: " + SQLHandleStorage.this.SCAN_BYPREFIX_STMT + " " + Util.decodeString(prefix) + suffix);
                }
                this.results = this.scanStatement.executeQuery();
            }
            catch (SQLException e) {
                this.close();
                throw new HandleException(1, "SQL Error", e);
            }
            this.getNextValue();
        }

        @Override
        public void close() {
            this.isClosed = true;
            if (this.results != null) {
                try {
                    this.results.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.scanStatement != null) {
                try {
                    this.scanStatement.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.connection != null) {
                try {
                    this.connection.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        @Override
        public boolean hasMoreElements() {
            return this.nextVal != null;
        }

        @Override
        public byte[] nextElement() {
            byte[] returnVal = this.nextVal;
            if (returnVal != null) {
                this.getNextValue();
            }
            return returnVal;
        }

        private void getNextValue() {
            this.nextVal = null;
            if (this.isClosed) {
                return;
            }
            try {
                if (this.results.next()) {
                    byte[] candNextVal = SQLHandleStorage.this.getHandleBytesFromResults(this.results, 1);
                    if (this.listingDerivedPrefixes ? candNextVal[this.prefix.length] == 46 : candNextVal[this.prefix.length] == 47) {
                        this.nextVal = candNextVal;
                    } else {
                        this.getNextValue();
                    }
                } else {
                    this.close();
                }
            }
            catch (Exception e) {
                this.close();
                throw new RuntimeException(new HandleException(1, "SQL Error", e));
            }
        }
    }
}

