/*
 * Decompiled with CFR 0.152.
 */
package net.handle.server;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import net.cnri.util.StreamTable;
import net.handle.hdllib.AbstractRequest;
import net.handle.hdllib.Interface;
import net.handle.hdllib.ServerInfo;
import net.handle.server.AbstractServer;
import net.handle.server.HandleServer;
import net.handle.server.HdlTcpInterface;
import net.handle.server.HdlUdpInterface;
import net.handle.server.Main;
import net.handle.server.dns.DnsTcpInterface;
import net.handle.server.dns.DnsUdpInterface;

public abstract class NetworkInterface
implements Runnable {
    private volatile boolean keepRunning = true;
    protected AbstractServer server;
    protected boolean needsGC = false;
    boolean processAdminRequests = true;
    boolean processQueries = true;
    protected Main main;
    protected ExecutorService handlerPool = null;
    public static final String INTFC_HDLTCP = "hdl_tcp";
    public static final String INTFC_HDLUDP = "hdl_udp";
    public static final String INTFC_HDLHTTP = "hdl_http";
    public static final String INTFC_DNSUDP = "dns_udp";
    public static final String INTFC_DNSTCP = "dns_tcp";

    public NetworkInterface(Main main) {
        this.main = main;
        this.server = main.getServer();
    }

    public static NetworkInterface getInstance(Main main, String frontEndLabel, StreamTable configTable) throws Exception {
        if (frontEndLabel.startsWith(INTFC_HDLUDP)) {
            return new HdlUdpInterface(main, (StreamTable)configTable.get(frontEndLabel + "_config"));
        }
        if (frontEndLabel.startsWith(INTFC_HDLTCP)) {
            return new HdlTcpInterface(main, (StreamTable)configTable.get(frontEndLabel + "_config"));
        }
        if (frontEndLabel.startsWith(INTFC_HDLHTTP)) {
            return null;
        }
        if (frontEndLabel.startsWith(INTFC_DNSUDP)) {
            return new DnsUdpInterface(main, (StreamTable)configTable.get(frontEndLabel + "_config"), main.getDNSConfig());
        }
        if (frontEndLabel.startsWith(INTFC_DNSTCP)) {
            return new DnsTcpInterface(main, (StreamTable)configTable.get(frontEndLabel + "_config"), main.getDNSConfig());
        }
        throw new Exception("Invalid interface type: \"" + frontEndLabel + "\"");
    }

    protected final void initialize() {
        if (this.server instanceof HandleServer) {
            ServerInfo svrInfo = ((HandleServer)this.server).getServerInfo();
            Interface[] ifcs = svrInfo.interfaces;
            int bindPort = this.getPort();
            byte protocol = this.getProtocol();
            for (int i = 0; ifcs != null && i < ifcs.length; ++i) {
                if (ifcs[i] == null || ifcs[i].port != bindPort || ifcs[i].protocol != protocol) continue;
                this.processAdminRequests = ifcs[i].type == 1 || ifcs[i].type == 3;
                this.processQueries = ifcs[i].type == 3 || ifcs[i].type == 2;
                break;
            }
        }
    }

    public abstract byte getProtocol();

    public abstract int getPort();

    final boolean needsGC() {
        return this.needsGC;
    }

    final void resetGC() {
        this.needsGC = false;
    }

    public String canProcessMsg(AbstractRequest req) {
        return Interface.canProcessMsg(req, this.processQueries, this.processAdminRequests);
    }

    @Override
    public final void run() {
        while (this.keepRunning) {
            try {
                this.serveRequests();
            }
            catch (Throwable t) {
                if (!this.keepRunning) {
                    return;
                }
                this.main.logError(100, "Error establishing interface: " + t);
                t.printStackTrace();
            }
            ExecutorService pool = this.handlerPool;
            if (pool != null) {
                pool.shutdown();
            }
            this.stopService();
            try {
                if (!this.keepRunning) continue;
                Thread.sleep(300000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (ThreadDeath e) {
            }
            catch (Throwable t) {
                this.main.logError(100, "Error sleeping!: " + t);
            }
        }
    }

    public final void stopRunning() {
        this.keepRunning = false;
        this.stopService();
        ExecutorService pool = this.handlerPool;
        if (pool != null) {
            pool.shutdown();
            boolean terminated = false;
            try {
                terminated = pool.awaitTermination(30L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            if (!terminated) {
                pool.shutdownNow();
                try {
                    terminated = pool.awaitTermination(30L, TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    protected abstract void stopService();

    public abstract void serveRequests();
}

