/*
 * Decompiled with CFR 0.152.
 */
package net.handle.server;

import com.google.gson.Gson;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.Hashtable;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import net.handle.util.FileSystemReadOnlyChecker;

public class MonitorDaemon
extends Thread {
    private Hashtable monitorData = new Hashtable();
    private volatile String monitorDataString;
    private final int sleepSeconds;
    private final long startTime;
    private final Gson gson = new Gson();
    private Object sigarWrapper;
    private final AtomicLong numRequests;
    private final AtomicLong numResolutionRequests;
    private final AtomicLong numAdminRequests;
    private final AtomicLong numTxnRequests;
    private final File baseDir;
    private AtomicInteger requestsPastMinute;
    private AtomicInteger peakRequestsPerMinute;
    private volatile boolean keepRunning = true;

    public MonitorDaemon(int sleepSeconds, long startTime, AtomicLong numRequests, AtomicLong numResolutionRequests, AtomicLong numAdminRequests, AtomicLong numTxnRequests, File baseDir) {
        super("MonitorDaemon");
        this.setDaemon(true);
        this.sleepSeconds = sleepSeconds;
        this.startTime = startTime;
        this.numRequests = numRequests;
        this.numResolutionRequests = numResolutionRequests;
        this.numAdminRequests = numAdminRequests;
        this.numTxnRequests = numTxnRequests;
        this.baseDir = baseDir;
        this.initializeSigarWrapper();
    }

    public void setRequestCounters(AtomicInteger requestsPastMinute, AtomicInteger peakRequestsPerMinute) {
        this.requestsPastMinute = requestsPastMinute;
        this.peakRequestsPerMinute = peakRequestsPerMinute;
    }

    private void initializeSigarWrapper() {
        try {
            Class.forName("org.hyperic.sigar.Sigar");
            this.sigarWrapper = Class.forName("net.handle.server.SigarWrapper").getConstructor(new Class[0]).newInstance(new Object[0]);
            if (!((Boolean)this.sigarWrapper.getClass().getMethod("isReady", new Class[0]).invoke(this.sigarWrapper, new Object[0])).booleanValue()) {
                this.sigarWrapper = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void run() {
        while (this.keepRunning) {
            try {
                this.monitorData = this.getServerInfo();
                this.monitorDataString = this.gson.toJson((Object)this.monitorData);
                for (int i = 0; i < this.sleepSeconds && this.keepRunning; ++i) {
                    Thread.sleep(1000L);
                }
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    public void shutdown() {
        this.keepRunning = false;
    }

    public String getStatusString() {
        return this.monitorDataString;
    }

    private Hashtable getServerInfo() {
        Hashtable<String, Object> systemInfo = new Hashtable<String, Object>();
        systemInfo.put("version", "9.0.3");
        if (this.sigarWrapper != null) {
            try {
                systemInfo.put("loadAvg", this.getLoadAverageInfo());
                systemInfo.put("domainName", this.getFQDN());
                systemInfo.put("mem", this.getMemInfo());
                systemInfo.put("diskInfo", this.getDiskInfo());
            }
            catch (InvocationTargetException e) {
                systemInfo.put("sigarError", e.getCause().toString());
            }
            catch (Exception e) {
                systemInfo.put("sigarError", e.toString());
            }
        }
        if (this.baseDir != null) {
            systemInfo.put("isReadOnly", this.testIfFileSystemIsReadOnly());
        }
        systemInfo.put("startTime", this.startTime);
        if (this.numRequests != null) {
            systemInfo.put("requests", this.getReqInfo());
        }
        if (this.requestsPastMinute != null) {
            systemInfo.put("requestsPerMinute", this.getProxyReqInfo());
        }
        systemInfo.put("lastUpdate", System.currentTimeMillis());
        return systemInfo;
    }

    private Hashtable getReqInfo() {
        Hashtable<String, AtomicLong> reqTable = new Hashtable<String, AtomicLong>();
        reqTable.put("resolution", this.numResolutionRequests);
        reqTable.put("admin", this.numAdminRequests);
        reqTable.put("txn", this.numTxnRequests);
        reqTable.put("total", this.numRequests);
        return reqTable;
    }

    private Hashtable getProxyReqInfo() {
        Hashtable<String, Integer> reqTable = new Hashtable<String, Integer>();
        reqTable.put("recent", this.requestsPastMinute.get());
        reqTable.put("peak", this.peakRequestsPerMinute.get());
        return reqTable;
    }

    private boolean testIfFileSystemIsReadOnly() {
        return FileSystemReadOnlyChecker.isReadOnly(this.baseDir);
    }

    private Object getFQDN() throws Exception {
        return this.sigarWrapper.getClass().getMethod("getFQDN", new Class[0]).invoke(this.sigarWrapper, new Object[0]);
    }

    private Object getLoadAverageInfo() throws Exception {
        return this.sigarWrapper.getClass().getMethod("getLoadAverageInfo", new Class[0]).invoke(this.sigarWrapper, new Object[0]);
    }

    private Object getDiskInfo() throws Exception {
        return this.sigarWrapper.getClass().getMethod("getDiskInfo", new Class[0]).invoke(this.sigarWrapper, new Object[0]);
    }

    private Object getMemInfo() throws Exception {
        return this.sigarWrapper.getClass().getMethod("getMemInfo", new Class[0]).invoke(this.sigarWrapper, new Object[0]);
    }
}

