/*
 * Decompiled with CFR 0.152.
 */
package net.handle.server;

import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Vector;
import net.cnri.util.StreamTable;
import net.cnri.util.StreamVector;
import net.handle.apps.servlet_proxy.DefaultServlet;
import net.handle.apps.servlet_proxy.HDLProxy;
import net.handle.apps.servlet_proxy.ResponseHeaderFilter;
import net.handle.hdllib.FilesystemConfiguration;
import net.handle.hdllib.HandleException;
import net.handle.hdllib.HandleResolver;
import net.handle.hdllib.MemCache;
import net.handle.hdllib.SiteInfo;
import net.handle.hdllib.Util;
import net.handle.server.AbstractServer;
import net.handle.server.HandleServer;
import net.handle.server.NetworkInterface;
import net.handle.server.ServerLog;
import net.handle.server.dns.DnsConfiguration;
import net.handle.server.replication.ReplicationDaemon;
import net.handle.server.servletcontainer.EmbeddedJetty;
import net.handle.server.servletcontainer.EmbeddedJettyConfig;
import net.handle.server.servletcontainer.HandleApiErrorHandler;
import net.handle.server.servletcontainer.HandleAuthorizationEnabledSessionHandler;
import net.handle.server.servletcontainer.auth.StandardHandleAuthenticationFilter;
import net.handle.server.servletcontainer.servlets.DisallowHttpZeroDotNineFilter;
import net.handle.server.servletcontainer.servlets.HandleJsonRestApiServlet;
import net.handle.server.servletcontainer.servlets.NativeServlet;
import net.handle.server.servletcontainer.servlets.PrefixesServlet;
import net.handle.server.servletcontainer.servlets.SessionsServlet;
import net.handle.server.servletcontainer.servlets.SiteServlet;
import net.handle.server.servletcontainer.servlets.UncaughtExceptionsFilter;
import net.handle.server.servletcontainer.servlets.UnknownApiServlet;
import net.handle.server.servletcontainer.servlets.VerificationsServlet;
import org.eclipse.jetty.security.ConstraintMapping;
import org.eclipse.jetty.security.ConstraintSecurityHandler;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.SessionManager;
import org.eclipse.jetty.server.handler.ErrorHandler;
import org.eclipse.jetty.server.session.SessionHandler;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.servlet.ServletMapping;
import org.eclipse.jetty.servlets.CrossOriginFilter;
import org.eclipse.jetty.servlets.GzipFilter;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.security.Constraint;

public class Main {
    public static final String SERVLET_CONTAINER_CONFIG = "servlet_container_config";
    public static final String CONNECTORS_CONFIG = "connectors";
    public static final String WEBSVR_HTTP_CONFIG = "http_config";
    public static final String WEBSVR_HTTPS_CONFIG = "https_config";
    protected AbstractServer server;
    protected Vector<NetworkInterface> interfaces;
    protected DnsConfiguration dnsConfig;
    protected StreamTable configTable;
    protected File serverDir;
    protected ServerLog logger;
    protected ThreadGroup interfaceThreadGroup = null;
    protected HandleResolver resolver = null;
    protected EmbeddedJetty embeddedJetty;
    private boolean logHttpAccesses;
    private static String[] args;
    private volatile boolean restart = false;
    private String restartScript = null;

    private static void printUsage() {
        System.err.println("Usage: hdl-server <config-directory>");
    }

    public static void main(String[] argv) {
        System.out.println("Handle.Net Server Software version 9.0.3");
        args = argv;
        String configDirStr = null;
        if (argv == null || argv.length != 1) {
            Main.printUsage();
            return;
        }
        configDirStr = argv[0];
        Main main = null;
        StreamTable configTable = new StreamTable();
        File serverDir = new File(configDirStr);
        if (!serverDir.exists() || !serverDir.isDirectory()) {
            System.err.println("Invalid configuration directory: " + configDirStr + ".");
            return;
        }
        try {
            configTable.readFromFile(new File(serverDir, "config.dct"));
        }
        catch (Exception e) {
            System.err.println("Error reading configuration: " + e);
            return;
        }
        try {
            main = new Main(serverDir, configTable);
            main.logError(25, "Handle.net Server Software version 9.0.3");
            main.initialize();
            main.start();
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            System.out.println("Error: " + e.getMessage());
            System.out.println("       (see the error log for details.)\n");
            System.out.println("Shutting down...");
            System.err.println("Shutting down...");
            if (main != null) {
                try {
                    main.shutdown();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            System.exit(0);
        }
    }

    public Main(File serverDir, StreamTable configTable) throws Exception {
        this.serverDir = serverDir;
        this.configTable = configTable;
        this.logger = new ServerLog(serverDir, configTable);
    }

    public StreamTable getConfig() {
        return this.configTable;
    }

    public boolean logHttpAccesses() {
        return this.logHttpAccesses;
    }

    public void setResolver(HandleResolver resolver) {
        this.resolver = resolver;
    }

    public File getConfigDir() {
        return this.serverDir;
    }

    public DnsConfiguration getDNSConfig() {
        return this.dnsConfig;
    }

    public void dumpFromPrimary(boolean deleteAll) throws Exception {
        this.dumpFromPrimary(deleteAll, null);
    }

    public void dumpFromPrimary(boolean deleteAll, SiteInfo[] sites) throws Exception {
        if (this.server != null) {
            throw new HandleException(15, "Server has already been initialized");
        }
        this.resolver = new HandleResolver();
        if (this.configTable.containsKey("tcp_timeout")) {
            int timeout = Integer.parseInt((String)this.configTable.get("tcp_timeout"));
            this.resolver.setTcpTimeout(timeout);
        }
        this.resolver.setCheckSignatures(true);
        boolean bl = this.resolver.traceMessages = this.configTable.getBoolean("trace_resolution") || this.configTable.getBoolean("trace_outgoing_messages");
        if (this.configTable.getBoolean("no_udp_resolution", false)) {
            this.resolver.setPreferredProtocols(new int[]{1, 2});
        }
        StreamTable config = (StreamTable)this.configTable.get("server_config");
        config.put("do_replication", false);
        config.put("enable_homed_prefix_na_lookup_optimization", false);
        this.server = AbstractServer.getInstance(this, this.configTable, this.resolver);
        if (!(this.server instanceof HandleServer)) {
            throw new HandleException(15, "server is of a type that cannot be replicated");
        }
        ReplicationDaemon replicator = new ReplicationDaemon((HandleServer)this.server, config, this.serverDir);
        replicator.dumpHandles(deleteAll, sites);
    }

    public void initialize() throws Exception {
        if (this.server != null) {
            throw new HandleException(15, "Server has already been initialized");
        }
        this.resolver = new HandleResolver();
        this.resolver.setCheckSignatures(true);
        FilesystemConfiguration.configureResolverUsingKeys(this.resolver, this.configTable);
        this.resolver.setCache(new MemCache(16384, 3600L));
        this.server = AbstractServer.getInstance(this, this.configTable, this.resolver);
        this.interfaces = new Vector();
        Object obj = this.configTable.get("interfaces");
        if (obj == null || !(obj instanceof Vector) || ((Vector)obj).size() < 1) {
            throw new Exception("No \"interfaces\" specified!");
        }
        this.dnsConfig = new DnsConfiguration(this.server, (StreamTable)this.configTable.get("dns_config"));
        Vector frontEndLabels = (Vector)obj;
        for (int i = 0; i < frontEndLabels.size(); ++i) {
            String frontEndLabel = String.valueOf(frontEndLabels.elementAt(i));
            NetworkInterface ifc = NetworkInterface.getInstance(this, frontEndLabel, this.configTable);
            if (ifc == null) continue;
            this.interfaces.addElement(ifc);
        }
        this.initEmbeddedJetty();
        if (this.embeddedJetty != null) {
            this.embeddedJetty.startPriorityDeploymentManager();
        }
    }

    public AbstractServer getServer() {
        return this.server;
    }

    public void start() throws Exception {
        this.server.start();
        this.interfaceThreadGroup = new ThreadGroup("Network Interfaces");
        for (int i = 0; i < this.interfaces.size(); ++i) {
            NetworkInterface interfc = this.interfaces.elementAt(i);
            Thread t = new Thread(this.interfaceThreadGroup, interfc);
            t.start();
        }
        if (this.embeddedJetty != null) {
            System.out.println("Starting HTTP server...");
            this.embeddedJetty.startHttpServer();
        }
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                Main.this.cleanUp();
            }
        });
        new ServerMonitor().start();
    }

    private void initEmbeddedJetty() throws Exception {
        StreamVector connectors;
        StreamTable servletContainerConfig = null;
        servletContainerConfig = (StreamTable)this.configTable.get(SERVLET_CONTAINER_CONFIG);
        if (servletContainerConfig != null && servletContainerConfig.getBoolean("log_accesses", false)) {
            this.logHttpAccesses = true;
        }
        StreamTable serverHttpConfig = null;
        StreamTable serverConfig = (StreamTable)this.configTable.get("server_config");
        if (serverConfig != null) {
            serverHttpConfig = (StreamTable)serverConfig.get(WEBSVR_HTTP_CONFIG);
        }
        if ((connectors = this.getConnectorConfigTables(servletContainerConfig)).isEmpty()) {
            return;
        }
        EmbeddedJettyConfig jettyConfig = new EmbeddedJettyConfig();
        jettyConfig.addContextAttribute("net.handle.server.Main", this);
        if (this.server instanceof HandleServer) {
            jettyConfig.addContextAttribute("net.handle.server.HandleServer", this.server);
        }
        jettyConfig.addSystemClass("net.handle.hdllib.");
        jettyConfig.addSystemClass("net.handle.server.");
        jettyConfig.addSystemClass("com.google.gson.");
        jettyConfig.setBaseDir(this.serverDir);
        jettyConfig.setResolver(this.resolver);
        for (Object connectorConfigTable : connectors) {
            this.configureEmbeddedJettyConnector(jettyConfig, (StreamTable)connectorConfigTable);
        }
        if ((servletContainerConfig == null || servletContainerConfig.getBoolean("enable_root_web_app", true)) && (serverHttpConfig == null || serverHttpConfig.getBoolean("enable_root_web_app", true))) {
            boolean enableTrace = this.getEnableTrace(servletContainerConfig, serverHttpConfig, connectors);
            this.configureDefaultRootWebApp(jettyConfig, serverHttpConfig, enableTrace);
        }
        this.embeddedJetty = new EmbeddedJetty(jettyConfig);
        this.embeddedJetty.setUpHttpServer();
    }

    private boolean getEnableTrace(StreamTable servletContainerConfig, StreamTable serverHttpConfig, StreamVector connectors) {
        if (servletContainerConfig != null && !servletContainerConfig.getBoolean("enable_trace", true)) {
            return false;
        }
        if (serverHttpConfig != null && !serverHttpConfig.getBoolean("enable_trace", true)) {
            return false;
        }
        for (Object obj : connectors) {
            boolean enableTrace;
            if (!(obj instanceof StreamTable) || (enableTrace = ((StreamTable)obj).getBoolean("enable_trace", true))) continue;
            return false;
        }
        return true;
    }

    private void configureDefaultRootWebApp(EmbeddedJettyConfig jettyConfig, StreamTable serverHttpConfig, boolean enableTrace) throws Exception {
        ServletMapping mapping;
        boolean enableProxy = true;
        if (serverHttpConfig != null) {
            enableProxy = serverHttpConfig.getBoolean("enable_proxy", true);
        }
        ServletContextHandler context = new ServletContextHandler(3);
        context.setSessionHandler((SessionHandler)new HandleAuthorizationEnabledSessionHandler());
        context.getSessionHandler().getSessionManager().setSessionTrackingModes(Collections.emptySet());
        context.setAttribute("net.handle.server.Main", (Object)this);
        context.setAttribute(SessionManager.class.getName(), (Object)context.getSessionHandler().getSessionManager());
        if (this.server instanceof HandleServer) {
            context.setAttribute("net.handle.server.HandleServer", (Object)this.server);
        }
        context.setContextPath("/");
        context.setBaseResource(Resource.newResource((URL)HDLProxy.class.getResource("resources/")));
        ServletHolder hdlProxy = new ServletHolder(HDLProxy.class.getName(), HDLProxy.class);
        hdlProxy.setInitOrder(1);
        context.getServletHandler().addServlet(hdlProxy);
        context.getServletHandler().addServlet(new ServletHolder(DefaultServlet.class.getName(), DefaultServlet.class));
        context.getServletHandler().addServlet(new ServletHolder(NativeServlet.class.getName(), NativeServlet.class));
        if (enableProxy) {
            mapping = new ServletMapping();
            mapping.setServletName(HDLProxy.class.getName());
            mapping.setPathSpec("/*");
            context.getServletHandler().addServletMapping(mapping);
            mapping = new ServletMapping();
            mapping.setServletName(DefaultServlet.class.getName());
            mapping.setPathSpec("/static/*");
            context.getServletHandler().addServletMapping(mapping);
        } else {
            mapping = new ServletMapping();
            mapping.setServletName(NativeServlet.class.getName());
            mapping.setPathSpec("/*");
            context.getServletHandler().addServletMapping(mapping);
        }
        ServletHolder handlesServletHolder = new ServletHolder(HandleJsonRestApiServlet.class.getName(), HandleJsonRestApiServlet.class);
        context.addServlet(handlesServletHolder, "/api/handles/*");
        ServletHolder unknownApiServletHolder = new ServletHolder(UnknownApiServlet.class.getName(), UnknownApiServlet.class);
        context.addServlet(unknownApiServletHolder, "/api/*");
        ServletHolder siteServletHolder = new ServletHolder(SiteServlet.class.getName(), SiteServlet.class);
        context.addServlet(siteServletHolder, "/api/site");
        ServletMapping mapping2 = new ServletMapping();
        mapping2.setServletName(SiteServlet.class.getName());
        mapping2.setPathSpec("/api/site/");
        context.getServletHandler().addServletMapping(mapping2);
        context.addServlet(new ServletHolder(VerificationsServlet.class.getName(), VerificationsServlet.class), "/api/verifications/*");
        context.addServlet(new ServletHolder(PrefixesServlet.class.getName(), PrefixesServlet.class), "/api/prefixes/*");
        context.addServlet(new ServletHolder(SessionsServlet.class.getName(), SessionsServlet.class), "/api/sessions/*");
        if (serverHttpConfig != null && serverHttpConfig.get("headers") != null) {
            StreamTable headersMap = (StreamTable)serverHttpConfig.get("headers");
            FilterHolder filterHolder = new FilterHolder(ResponseHeaderFilter.class);
            for (String header : headersMap.keySet()) {
                filterHolder.setInitParameter(header, headersMap.getStr(header));
            }
            context.addFilter(filterHolder, "/*", null);
        }
        FilterHolder filterHolder = new FilterHolder(CrossOriginFilter.class);
        filterHolder.setInitParameter("allowedMethods", "GET,POST,HEAD,PUT,DELETE");
        filterHolder.setInitParameter("allowedHeaders", "X-Requested-With,Authorization,Origin,Accept,Content-Type");
        filterHolder.setInitParameter("preflightMaxAge", "86400");
        filterHolder.setInitParameter("allowCredentials", "false");
        filterHolder.setInitParameter("chainPreflight", "false");
        context.addFilter(filterHolder, "/*", null);
        filterHolder = new FilterHolder(GzipFilter.class);
        filterHolder.setInitParameter("methods", "GET,POST,PUT,DELETE");
        filterHolder.setInitParameter("vary", "Accept-Encoding");
        context.addFilter(filterHolder, "/*", null);
        context.addFilter(UncaughtExceptionsFilter.class, "/api/*", null);
        context.addFilter(DisallowHttpZeroDotNineFilter.class, "/api/*", null);
        context.addFilter(StandardHandleAuthenticationFilter.class, "/api/*", null);
        context.setErrorHandler((ErrorHandler)new HandleApiErrorHandler());
        if (!enableTrace) {
            Constraint constraint = new Constraint();
            constraint.setName("Disable TRACE");
            constraint.setAuthenticate(true);
            ConstraintMapping constraintMapping = new ConstraintMapping();
            constraintMapping.setConstraint(constraint);
            constraintMapping.setMethod("TRACE");
            constraintMapping.setPathSpec("/");
            ConstraintSecurityHandler securityHandler = (ConstraintSecurityHandler)context.getSecurityHandler();
            securityHandler.addConstraintMapping(constraintMapping);
        }
        jettyConfig.addDefaultHandler((Handler)context);
    }

    private StreamVector getConnectorConfigTables(StreamTable servletContainerConfig) {
        StreamVector connectors;
        if (servletContainerConfig != null) {
            connectors = (StreamVector)servletContainerConfig.get(CONNECTORS_CONFIG);
            if (connectors == null) {
                connectors = new StreamVector();
            }
            if (servletContainerConfig.containsKey(WEBSVR_HTTP_CONFIG)) {
                connectors.add(servletContainerConfig.get(WEBSVR_HTTP_CONFIG));
            }
            if (servletContainerConfig.containsKey(WEBSVR_HTTPS_CONFIG)) {
                StreamTable table = (StreamTable)servletContainerConfig.get(WEBSVR_HTTPS_CONFIG);
                table.put("https", "yes");
                connectors.add(table);
            }
        } else {
            connectors = new StreamVector();
        }
        Vector labels = (Vector)this.configTable.get("interfaces");
        for (String label : labels) {
            if (!label.startsWith("hdl_http")) continue;
            StreamTable intfConfig = (StreamTable)this.configTable.get(label + "_config");
            if (label.contains("https")) {
                intfConfig.put("https", "yes");
            }
            connectors.add(intfConfig);
        }
        return connectors;
    }

    private void configureEmbeddedJettyConnector(EmbeddedJettyConfig jettyConfig, StreamTable connectorConfigTable) throws UnknownHostException {
        InetAddress httpListenAddress;
        EmbeddedJettyConfig.ConnectorConfig connectorConfig;
        block7: {
            connectorConfig = new EmbeddedJettyConfig.ConnectorConfig();
            connectorConfig.setHttps(connectorConfigTable.getBoolean("https", false));
            connectorConfig.setHttpOnly(connectorConfigTable.getBoolean("http_only", false));
            String webserverHttpAddressString = connectorConfigTable.getStr("bind_address");
            httpListenAddress = null;
            if (webserverHttpAddressString != null) {
                httpListenAddress = InetAddress.getByName(String.valueOf(webserverHttpAddressString));
            }
            connectorConfig.setPort(connectorConfigTable.getInt("bind_port", 0));
            connectorConfig.setRedirectPort(connectorConfigTable.getInt("redirect_port", 0));
            connectorConfig.setListenAddress(httpListenAddress);
            boolean useSelfSignedCert = connectorConfigTable.getBoolean("https_default_self_signed_cert", true);
            if (useSelfSignedCert) {
                connectorConfig.setHttpsUseSelfSignedCert(true);
                try {
                    X509Certificate[] certChain = this.server.getCertificateChain();
                    if (certChain != null && certChain.length > 0) {
                        connectorConfig.setHttpsCertificateChain(certChain);
                        connectorConfig.setHttpsPubKey(certChain[0].getPublicKey());
                        connectorConfig.setHttpsPrivKey(this.server.getCertificatePrivateKey());
                        break block7;
                    }
                    PublicKey pubKey = this.server.getPublicKey();
                    PrivateKey privKey = this.server.getPrivateKey();
                    connectorConfig.setHttpsPubKey(pubKey);
                    connectorConfig.setHttpsPrivKey(privKey);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                connectorConfig.setHttpsUseSelfSignedCert(false);
                connectorConfig.setHttpsKeyStorePassword(connectorConfigTable.getStr("https_keystore_password", null));
                connectorConfig.setHttpsKeyPassword(connectorConfigTable.getStr("https_key_password", null));
                connectorConfig.setHttpsKeyStoreFile(connectorConfigTable.getStr("https_keystore_file", null));
                connectorConfig.setHttpsAlias(connectorConfigTable.getStr("https_alias", null));
            }
        }
        connectorConfig.setHttpsClientAuth(connectorConfigTable.getStr("https_client_auth", "false"));
        jettyConfig.addConnector(connectorConfig);
        System.out.println((connectorConfig.isHttps() ? "HTTPS" : "HTTP") + " handle Request Listener:");
        System.out.println("   address: " + (httpListenAddress == null ? "ANY" : "" + Util.rfcIpRepr(httpListenAddress)));
        System.out.println("      port: " + connectorConfig.getPort());
        if (connectorConfigTable.getBoolean("log_accesses", false)) {
            this.logHttpAccesses = true;
        }
    }

    public void shutdown() {
        new Thread(){

            @Override
            public void run() {
                System.exit(0);
            }
        }.start();
    }

    private void stopAllThreads() {
        try {
            this.interfaceThreadGroup.stop();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected void cleanUp() {
        this.logError(25, "Shutting down server at " + new Date());
        while (this.interfaces.size() > 0) {
            NetworkInterface interfc = this.interfaces.elementAt(0);
            this.interfaces.removeElementAt(0);
            try {
                interfc.stopRunning();
            }
            catch (Throwable e) {
                this.logError(75, "unable to shut down interface " + interfc + "; reason: " + e);
            }
        }
        this.stopAllThreads();
        try {
            this.server.shutdown();
        }
        catch (Exception e) {
            String msg = "Exception shutting down handle server :" + e;
            this.logError(75, msg);
            System.err.println(msg);
            e.printStackTrace(System.err);
        }
        if (this.embeddedJetty != null) {
            this.embeddedJetty.stopHttpServer();
        }
        if (this.logger != null) {
            try {
                this.logger.shutdown();
            }
            catch (Exception e) {
                System.err.println("Error shutting down logger: " + e);
            }
        }
        if (this.restart) {
            try {
                this.restart();
            }
            catch (IOException e) {
                System.err.println("Error restarting server: " + e);
            }
        }
    }

    public boolean isRestarting() {
        return this.restart;
    }

    private void restart() throws IOException {
        String startServerCommand = this.getStartServerCommand();
        if (this.restartScript == null) {
            System.out.println("running: " + startServerCommand);
            Runtime.getRuntime().exec(startServerCommand);
        } else {
            String absoluteRestartScript = new File(this.serverDir, this.restartScript).getAbsolutePath();
            Object[] commandWithArgs = new String[]{absoluteRestartScript, this.serverDir.getAbsolutePath(), startServerCommand};
            System.out.println("Running restart script: " + Arrays.toString(commandWithArgs));
            Runtime.getRuntime().exec((String[])commandWithArgs);
        }
    }

    private String getStartServerCommand() {
        StringBuilder cmd = new StringBuilder();
        cmd.append(System.getProperty("java.home") + File.separator + "bin" + File.separator + "java ");
        for (String jvmArg : ManagementFactory.getRuntimeMXBean().getInputArguments()) {
            cmd.append(jvmArg + " ");
        }
        cmd.append("-cp ").append(ManagementFactory.getRuntimeMXBean().getClassPath()).append(" ");
        cmd.append(Main.class.getName()).append(" ");
        for (String arg : args) {
            cmd.append(arg).append(" ");
        }
        String command = cmd.toString();
        return command;
    }

    public synchronized void shutdownAndRestart() {
        if (this.restart) {
            return;
        }
        this.restart = true;
        this.shutdown();
    }

    public synchronized void shutdownAndRunScript(String restartScript) {
        if (this.restart) {
            return;
        }
        this.restart = true;
        this.restartScript = restartScript;
        this.shutdown();
    }

    public void logAccess(String accesssType, InetAddress addr, int opCode, int rsCode, String message, long time) {
        if (this.logger == null) {
            System.out.println("Access: type=" + accesssType + "; addr=" + Util.rfcIpRepr(addr) + "; opCode: " + opCode + "; respCode: " + rsCode + "; message: " + message + "; " + time + "ms");
        } else {
            this.logger.logAccess(accesssType, addr, opCode, rsCode, message, time);
        }
    }

    public void logError(int level, String message) {
        if (this.logger == null) {
            System.err.println("Error: level=" + level + "; message: " + message);
        } else {
            this.logger.logError(level, message);
        }
    }

    private class ServerMonitor
    extends Thread {
        File keepRunningFile;

        ServerMonitor() throws IOException {
            this.setDaemon(true);
            this.setName("Server Monitor");
            this.keepRunningFile = new File(Main.this.serverDir, "delete_this_to_stop_server");
            this.keepRunningFile.createNewFile();
            this.keepRunningFile.deleteOnExit();
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        if (!this.keepRunningFile.exists()) {
                            Main.this.shutdown();
                            System.exit(0);
                        }
                        Thread.sleep(1000L);
                    }
                }
                catch (Throwable throwable) {
                    continue;
                }
                break;
            }
        }
    }
}

