/*
 * Decompiled with CFR 0.152.
 */
package net.handle.server;

import java.net.DatagramPacket;
import java.net.DatagramSocket;
import net.handle.hdllib.AbstractRequest;
import net.handle.hdllib.AbstractResponse;
import net.handle.hdllib.Encoder;
import net.handle.hdllib.ErrorResponse;
import net.handle.hdllib.MessageEnvelope;
import net.handle.hdllib.ResponseMessageCallback;
import net.handle.hdllib.Util;
import net.handle.server.AbstractServer;
import net.handle.server.HandleServer;
import net.handle.server.HdlUdpInterface;
import net.handle.server.HdlUdpPendingRequest;
import net.handle.server.Main;
import net.handle.server.ServerSideSessionInfo;

public class HdlUdpRequestHandler
implements Runnable,
ResponseMessageCallback {
    private final DatagramPacket packet;
    private final DatagramSocket dsocket;
    private final AbstractServer server;
    private final Main main;
    private final HdlUdpInterface listener;
    private boolean logAccesses = false;
    private final MessageEnvelope envelope = new MessageEnvelope();
    private AbstractRequest currentRequest;
    private final long recvTime;
    public static final String ACCESS_TYPE = "UDP:HDL";
    public static final byte[] MSG_INVALID_MSG_SIZE = Util.encodeString("Invalid message length");

    public HdlUdpRequestHandler(Main main, DatagramSocket dsock, HdlUdpInterface listener, boolean logAccesses, DatagramPacket packet, long recvTime) {
        this.main = main;
        this.server = main.getServer();
        this.dsocket = dsock;
        this.logAccesses = logAccesses;
        this.listener = listener;
        this.packet = packet;
        this.recvTime = recvTime;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        byte[] pkt = null;
        int offset = 20;
        try {
            pkt = this.packet.getData();
            Encoder.decodeEnvelope(pkt, this.envelope);
            if (this.envelope.messageLength > 262144 || this.envelope.messageLength < 0) {
                this.handleResponse(new ErrorResponse(0, 4, MSG_INVALID_MSG_SIZE));
                return;
            }
            if (this.envelope.truncated) {
                HdlUdpPendingRequest req = this.listener.addMultiPacketListener(this.envelope, this.packet, this.packet.getAddress());
                if (req == null) {
                    return;
                }
                pkt = req.getMessage();
                offset = 0;
            }
            if (this.envelope.encrypted) {
                if (this.envelope.sessionId <= 0) {
                    this.main.logError(75, "Invalid session id. Request message not decrypted.");
                    System.err.println("Invalid session id. Request message not decrypted.");
                    this.handleResponse(new ErrorResponse(0, 501, Util.encodeString("Invalid session id. Unable to decrypt request message.")));
                    return;
                }
                ServerSideSessionInfo sssinfo = null;
                if (!(this.server instanceof HandleServer)) {
                    this.main.logError(75, "Session manager not available. Unable to decrypt request message.");
                    System.err.println("Session manager not available. Request message not decrypted.");
                    this.handleResponse(new ErrorResponse(0, 501, Util.encodeString("Session manager not available. Unable to decrypt request message.")));
                    return;
                }
                sssinfo = ((HandleServer)this.server).getSession(this.envelope.sessionId);
                if (sssinfo == null) {
                    this.main.logError(75, "Session information not available or time out. Unable to decrypt request message");
                    System.err.println("Session information not available or time out. Unable to decrypt request message.");
                    this.handleResponse(new ErrorResponse(0, 500, Util.encodeString("Session information not available or time out. Unable to decrypt request message.")));
                    return;
                }
                try {
                    pkt = sssinfo.decryptBuffer(pkt, offset, this.envelope.messageLength);
                    this.envelope.encrypted = false;
                    this.envelope.messageLength = pkt.length;
                    offset = 0;
                }
                catch (Exception e) {
                    this.main.logError(75, "Exception decrypting request: " + e);
                    e.printStackTrace();
                    System.err.println("Exception decrypting request with session key: " + e.getMessage());
                    this.handleResponse(new ErrorResponse(0, 501, Util.encodeString("Exception decrypting request with session key " + e)));
                    return;
                }
            }
            if (this.envelope.messageLength < 24) {
                this.handleResponse(new ErrorResponse(0, 4, MSG_INVALID_MSG_SIZE));
                return;
            }
            int opCode = Encoder.readOpCode(pkt, offset);
            if (opCode == 0) {
                this.handleResponse(new ErrorResponse(0, 4, Util.encodeString("Unknown opCode in message: " + opCode)));
                return;
            }
            this.currentRequest = (AbstractRequest)Encoder.decodeMessage(pkt, offset, this.envelope);
            String errMsg = this.listener.canProcessMsg(this.currentRequest);
            if (errMsg != null) {
                this.main.logError(75, errMsg);
                this.handleResponse(new ErrorResponse(this.currentRequest.opCode, 4, Util.encodeString(errMsg)));
                return;
            }
            this.server.processRequest(this.currentRequest, this);
            return;
        }
        catch (Throwable e) {
            this.handleResponse(new ErrorResponse(0, 2, Util.encodeString("Server error processing request, see server logs")));
            this.main.logError(75, String.valueOf(this.getClass()) + ": Exception processing request: " + e);
            e.printStackTrace(System.err);
        }
    }

    public void handleResponseError(String error) {
        this.main.logError(50, String.valueOf(this.getClass()) + ": Server error: " + error);
    }

    @Override
    public void handleResponse(AbstractResponse response) {
        try {
            byte[] msg = response.getEncodedMessage();
            boolean encrypted = false;
            if (response.sessionId > 0 && (response.encrypt || response.shouldEncrypt())) {
                ServerSideSessionInfo sssinfo = null;
                if (this.server instanceof HandleServer) {
                    sssinfo = ((HandleServer)this.server).getSession(response.sessionId);
                    if (sssinfo != null) {
                        try {
                            msg = sssinfo.encryptBuffer(msg, 0, msg.length);
                            encrypted = true;
                        }
                        catch (Exception e) {
                            this.main.logError(50, "Exception encrypting response: " + e);
                            System.err.println("Exception encrypting message with session key: " + e.getMessage());
                            encrypted = false;
                        }
                    }
                } else {
                    this.main.logError(50, "Session manager not available. Message not encrypted.");
                    System.err.println("Session manager not available. Message not encrypted.");
                    encrypted = false;
                }
            }
            this.envelope.encrypted = encrypted;
            this.envelope.messageLength = msg.length;
            this.envelope.messageId = 0;
            this.envelope.requestId = response.requestId;
            this.envelope.sessionId = response.sessionId;
            this.envelope.protocolMajorVersion = response.majorProtocolVersion;
            this.envelope.protocolMinorVersion = response.minorProtocolVersion;
            this.envelope.suggestMajorProtocolVersion = response.suggestMajorProtocolVersion;
            this.envelope.suggestMinorProtocolVersion = response.suggestMinorProtocolVersion;
            if (msg.length > 492) {
                int bytesRemaining = msg.length;
                while (bytesRemaining > 0) {
                    byte[] buf;
                    if (bytesRemaining <= 492) {
                        buf = new byte[bytesRemaining + 20];
                        System.arraycopy(msg, msg.length - bytesRemaining, buf, 20, bytesRemaining);
                    } else {
                        buf = new byte[512];
                        System.arraycopy(msg, msg.length - bytesRemaining, buf, 20, 492);
                    }
                    Encoder.encodeEnvelope(this.envelope, buf);
                    this.dsocket.send(new DatagramPacket(buf, buf.length, this.packet.getAddress(), this.packet.getPort()));
                    bytesRemaining -= 492;
                    ++this.envelope.messageId;
                }
            } else {
                byte[] buf = new byte[msg.length + 20];
                Encoder.encodeEnvelope(this.envelope, buf);
                System.arraycopy(msg, 0, buf, 20, msg.length);
                this.dsocket.send(new DatagramPacket(buf, buf.length, this.packet.getAddress(), this.packet.getPort()));
            }
        }
        catch (Exception e) {
            String clientString = "";
            try {
                clientString = " to " + Util.rfcIpRepr(this.dsocket.getInetAddress());
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.main.logError(75, String.valueOf(this.getClass()) + ": Exception sending response" + clientString + ": " + e);
            e.printStackTrace(System.err);
        }
        if (this.logAccesses && this.currentRequest != null) {
            long time = System.currentTimeMillis() - this.recvTime;
            this.main.logAccess("UDP:HDL(" + this.currentRequest.suggestMajorProtocolVersion + "." + this.currentRequest.suggestMinorProtocolVersion + ")", this.packet.getAddress(), this.currentRequest.opCode, response != null ? response.responseCode : 2, Util.getAccessLogString(this.currentRequest), time);
        }
    }
}

