/*
 * Decompiled with CFR 0.152.
 */
package net.handle.server;

import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.LinkedTransferQueue;
import java.util.concurrent.TimeUnit;
import net.cnri.util.GrowBeforeTransferQueueThreadPoolExecutor;
import net.cnri.util.StreamTable;
import net.handle.hdllib.MessageEnvelope;
import net.handle.hdllib.Util;
import net.handle.server.HdlUdpPendingRequest;
import net.handle.server.HdlUdpRequestHandler;
import net.handle.server.Main;
import net.handle.server.NetworkInterface;

public class HdlUdpInterface
extends NetworkInterface {
    private InetAddress bindAddress;
    private int threadLife = 500;
    private int bindPort = 2641;
    private int numThreads = 10;
    private int maxHandlers = 200;
    private boolean logAccesses = false;
    private DatagramSocket dsocket = null;
    private boolean keepServing = true;
    private final ConcurrentMap<String, HdlUdpPendingRequest> pendingRequests = new ConcurrentHashMap<String, HdlUdpPendingRequest>();

    public HdlUdpInterface(Main main, StreamTable config) throws Exception {
        super(main);
        this.init(config);
    }

    @Override
    public byte getProtocol() {
        return 0;
    }

    @Override
    public int getPort() {
        return this.bindPort;
    }

    private void init(StreamTable config) throws Exception {
        Object bindAddressStr = config.get("bind_address");
        this.bindAddress = bindAddressStr == null ? null : InetAddress.getByName(String.valueOf(bindAddressStr));
        this.bindPort = Integer.parseInt((String)config.get("bind_port"));
        try {
            this.numThreads = Integer.parseInt((String)config.get("num_threads"));
        }
        catch (Exception e) {
            this.main.logError(50, "unspecified thread count, using default: " + this.numThreads);
        }
        try {
            if (config.containsKey("max_handlers")) {
                this.maxHandlers = Integer.parseInt((String)config.get("max_handlers"));
            }
        }
        catch (Exception e) {
            this.main.logError(50, "unspecified max_handlers count, using default: " + this.maxHandlers);
        }
        try {
            if (config.containsKey("thread_life")) {
                this.threadLife = Integer.parseInt((String)config.get("thread_life"));
            }
        }
        catch (Exception e) {
            this.main.logError(50, "Invalid thread life, using default: " + this.threadLife);
        }
        this.logAccesses = config.getBoolean("log_accesses");
        super.initialize();
    }

    @Override
    protected void stopService() {
        this.keepServing = false;
        try {
            this.dsocket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void serveRequests() {
        this.keepServing = true;
        try {
            this.dsocket = this.bindAddress == null ? new DatagramSocket(this.bindPort) : new DatagramSocket(this.bindPort, this.bindAddress);
        }
        catch (Exception e) {
            this.main.logError(100, String.valueOf(this.getClass()) + ": Error setting up server socket: " + e);
            return;
        }
        System.out.println("UDP handle Request Listener:");
        System.out.println("   address: " + (this.bindAddress == null ? "ANY" : "" + Util.rfcIpRepr(this.bindAddress)));
        System.out.println("      port: " + this.bindPort);
        this.handlerPool = new GrowBeforeTransferQueueThreadPoolExecutor(this.numThreads, this.maxHandlers, 1L, TimeUnit.MINUTES, new LinkedTransferQueue());
        System.out.println("Starting UDP request handlers...");
        try {
            System.out.flush();
        }
        catch (Exception e) {
            // empty catch block
        }
        long recvTime = 0L;
        while (this.keepServing) {
            try {
                DatagramPacket dPacket = new DatagramPacket(new byte[512], 512);
                this.dsocket.receive(dPacket);
                recvTime = System.currentTimeMillis();
                this.handlerPool.execute(new HdlUdpRequestHandler(this.main, this.dsocket, this, this.logAccesses, dPacket, recvTime));
            }
            catch (Exception e) {
                if (!this.keepServing) continue;
                this.main.logError(75, "" + this.getClass() + ": Error handling request: " + e);
                e.printStackTrace(System.err);
            }
        }
        try {
            this.dsocket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    HdlUdpPendingRequest addMultiPacketListener(MessageEnvelope env, DatagramPacket pkt, InetAddress addr) {
        String id = HdlUdpPendingRequest.getRequestId(addr, env.requestId);
        HdlUdpPendingRequest req = null;
        HdlUdpPendingRequest existingReq = (HdlUdpPendingRequest)this.pendingRequests.get(id);
        if (existingReq == null) {
            req = new HdlUdpPendingRequest(id, env, pkt);
            existingReq = this.pendingRequests.putIfAbsent(id, req);
        }
        if (existingReq != null) {
            existingReq.addPacket(env, pkt);
            if (existingReq.isComplete()) {
                HdlUdpPendingRequest hdlUdpPendingRequest = existingReq;
                synchronized (hdlUdpPendingRequest) {
                    existingReq.notifyAll();
                }
            }
            return null;
        }
        if (req == null) {
            throw new AssertionError();
        }
        HdlUdpPendingRequest hdlUdpPendingRequest = req;
        synchronized (hdlUdpPendingRequest) {
            try {
                req.wait(5000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.pendingRequests.remove(req.idString);
        }
        if (!req.isComplete()) {
            return null;
        }
        return req;
    }
}

