/*
 * Decompiled with CFR 0.152.
 */
package net.handle.server;

import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.concurrent.LinkedTransferQueue;
import java.util.concurrent.TimeUnit;
import net.cnri.util.GrowBeforeTransferQueueThreadPoolExecutor;
import net.cnri.util.StreamTable;
import net.handle.hdllib.Util;
import net.handle.server.HdlTcpRequestHandler;
import net.handle.server.Main;
import net.handle.server.NetworkInterface;

public class HdlTcpInterface
extends NetworkInterface {
    private InetAddress bindAddress;
    private int threadLife = 200;
    private int maxHandlers = 200;
    private int bindPort = 2641;
    private int backlog;
    private int numThreads = 10;
    private int maxIdleTime = 300000;
    private boolean logAccesses = false;
    private ServerSocket socket = null;
    private boolean keepServing = true;

    public HdlTcpInterface(Main main, StreamTable config) throws Exception {
        super(main);
        this.init(config);
    }

    @Override
    public byte getProtocol() {
        return 1;
    }

    @Override
    public int getPort() {
        return this.bindPort;
    }

    private void init(StreamTable config) throws Exception {
        Object bindAddressStr = config.get("bind_address");
        this.bindAddress = bindAddressStr == null ? null : InetAddress.getByName(String.valueOf(bindAddressStr));
        this.bindPort = Integer.parseInt((String)config.get("bind_port"));
        this.backlog = Integer.parseInt((String)config.get("backlog", "-1"));
        try {
            if (config.containsKey("max_handlers")) {
                this.maxHandlers = Integer.parseInt((String)config.get("max_handlers"));
            }
        }
        catch (Exception e) {
            this.main.logError(50, "unspecified max_handlers count, using default: " + this.maxHandlers);
        }
        try {
            this.numThreads = Integer.parseInt((String)config.get("num_threads"));
        }
        catch (Exception e) {
            this.main.logError(50, "unspecified thread count, using default: " + this.numThreads);
        }
        try {
            if (config.containsKey("thread_life")) {
                this.threadLife = Integer.parseInt((String)config.get("thread_life"));
            }
        }
        catch (Exception e) {
            this.main.logError(50, "Invalid thread life, using default: " + this.threadLife);
        }
        try {
            if (config.containsKey("max_idle_time")) {
                this.maxIdleTime = Integer.parseInt((String)config.get("max_idle_time"));
                if (this.maxIdleTime < 0) {
                    throw new IllegalArgumentException();
                }
            }
        }
        catch (Exception e) {
            this.main.logError(50, "Invalid max_idle_time, using default: " + this.maxIdleTime);
        }
        this.logAccesses = config.getBoolean("log_accesses");
        super.initialize();
    }

    @Override
    protected void stopService() {
        this.keepServing = false;
        try {
            this.socket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void serveRequests() {
        this.keepServing = true;
        try {
            this.socket = this.bindAddress == null ? new ServerSocket(this.bindPort, this.backlog) : new ServerSocket(this.bindPort, this.backlog, this.bindAddress);
        }
        catch (Exception e) {
            this.main.logError(100, String.valueOf(this.getClass()) + ": Error setting up server socket: " + e);
            return;
        }
        System.out.println("TCP handle Request Listener:");
        System.out.println("   address: " + (this.bindAddress == null ? "ANY" : "" + Util.rfcIpRepr(this.bindAddress)));
        System.out.println("      port: " + this.bindPort);
        this.handlerPool = new GrowBeforeTransferQueueThreadPoolExecutor(this.numThreads, this.maxHandlers, 1L, TimeUnit.MINUTES, new LinkedTransferQueue());
        System.out.println("Starting TCP request handlers...");
        try {
            System.out.flush();
        }
        catch (Exception e) {
            // empty catch block
        }
        long recvTime = 0L;
        while (this.keepServing) {
            try {
                Socket newsock = this.socket.accept();
                newsock.setSoTimeout(this.maxIdleTime);
                recvTime = System.currentTimeMillis();
                this.handlerPool.execute(new HdlTcpRequestHandler(this.main, this, this.logAccesses, newsock, recvTime));
            }
            catch (Exception e) {
                if (!this.keepServing) continue;
                this.main.logError(75, String.valueOf(this.getClass()) + ": Error handling request: " + e);
                e.printStackTrace(System.err);
            }
        }
        try {
            this.socket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

