/*
 * Decompiled with CFR 0.152.
 */
package net.handle.server;

import java.security.SecureRandom;
import net.handle.hdllib.HandleException;
import net.handle.hdllib.HandleStorage;
import net.handle.hdllib.Util;

public class HandleSuffixMinter {
    private static final SecureRandom random = new SecureRandom();
    private final HandleStorage storage;
    private final boolean caseSensitive;
    private static final char[] hexArray = "0123456789abcdef".toCharArray();

    public HandleSuffixMinter(HandleStorage storage, boolean caseSensitive) {
        this.storage = storage;
        this.caseSensitive = caseSensitive;
    }

    public String mintNextSuffix(String handleInitialPortion) throws HandleException {
        String handle = null;
        boolean foundUniqueSuffix = false;
        while (!foundUniqueSuffix) {
            String handleEndPortion = this.generateRandomString();
            handle = handleInitialPortion + handleEndPortion;
            foundUniqueSuffix = this.isHandleUnique(handle);
        }
        return handle;
    }

    private String generateRandomString() {
        byte[] randomBytes = new byte[16];
        random.nextBytes(randomBytes);
        randomBytes[6] = (byte)(randomBytes[6] & 0xF);
        randomBytes[6] = (byte)(randomBytes[6] | 0x40);
        randomBytes[8] = (byte)(randomBytes[8] & 0x3F);
        randomBytes[8] = (byte)(randomBytes[8] | 0x80);
        return HandleSuffixMinter.bytesToHex(randomBytes);
    }

    private static String bytesToHex(byte[] bytes) {
        char[] hexChars = new char[36];
        int i = 0;
        for (int j = 0; j < bytes.length; ++j) {
            if (j == 4 || j == 6 || j == 8 || j == 10) {
                hexChars[i++] = 45;
            }
            int v = bytes[j] & 0xFF;
            hexChars[i++] = hexArray[v >>> 4];
            hexChars[i++] = hexArray[v & 0xF];
        }
        return new String(hexChars);
    }

    private boolean isHandleUnique(String handle) throws HandleException {
        byte[] handleBytes = Util.encodeString(handle);
        handleBytes = this.caseSensitive ? handleBytes : Util.upperCase(handleBytes);
        try {
            return this.storage.getRawHandleValues(handleBytes, null, null) == null;
        }
        catch (HandleException e) {
            if (e.getCode() == 9) {
                return true;
            }
            throw e;
        }
    }
}

