/*
 * Decompiled with CFR 0.152.
 */
package net.handle.server;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.cert.X509Certificate;
import java.util.Vector;
import net.cnri.util.StreamTable;
import net.handle.hdllib.AbstractRequest;
import net.handle.hdllib.AbstractResponse;
import net.handle.hdllib.ChallengeAnswerRequest;
import net.handle.hdllib.ChallengeResponse;
import net.handle.hdllib.Common;
import net.handle.hdllib.Encoder;
import net.handle.hdllib.ErrorResponse;
import net.handle.hdllib.GetSiteInfoResponse;
import net.handle.hdllib.HandleException;
import net.handle.hdllib.HandleResolver;
import net.handle.hdllib.ResolutionRequest;
import net.handle.hdllib.ResponseMessageCallback;
import net.handle.hdllib.SiteInfo;
import net.handle.hdllib.Util;
import net.handle.hdllib.ValueReference;
import net.handle.server.AbstractServer;
import net.handle.server.Main;

public class CacheServer
extends AbstractServer {
    private static final byte[] MSG_NOT_A_PRIMARY = Util.encodeString("Server is read-only");
    private static final byte[] MSG_CHALLENGE_NOT_FOUND = Util.encodeString("Challenge not found");
    public static final String THIS_SERVER_ID = "this_server_id";
    public static final String SERVER_ADMINS = "server_admins";
    public static final String SITE_INFO_FILE = "siteinfo.bin";
    public static final String PRIVATE_KEY_FILE = "privkey.bin";
    public static final String CACHE_STORAGE_FILE = "cache.jdb";
    public static final int RECURSION_LIMIT = 10;
    private static final byte[] SIGN_TEST = Util.encodeString("Testing...1..2..3");
    private ValueReference[] serverAdmins;
    private SiteInfo thisSite = null;
    private int thisServerNum = -1;
    private Signature serverSignature = null;
    private PublicKey pubKey = null;
    private PrivateKey privKey = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CacheServer(Main main, StreamTable config, HandleResolver resolver) throws Exception {
        super(main, config, resolver);
        int i;
        try {
            int thisId = Integer.parseInt((String)config.get(THIS_SERVER_ID));
            SiteInfo site = new SiteInfo();
            File siteInfoFile = new File(main.getConfigDir(), SITE_INFO_FILE);
            if (!siteInfoFile.exists() || !siteInfoFile.canRead()) {
                throw new Exception("Missing or inaccessible site info file: " + siteInfoFile.getAbsolutePath());
            }
            byte[] siteInfoBuf = new byte[(int)siteInfoFile.length()];
            try (FileInputStream in = new FileInputStream(siteInfoFile);){
                int r;
                int n = 0;
                while ((r = ((InputStream)in).read(siteInfoBuf, n, siteInfoBuf.length - n)) > 0) {
                    n += r;
                }
            }
            Encoder.decodeSiteInfoRecord(siteInfoBuf, 0, site);
            this.thisServerNum = -1;
            for (i = 0; i < site.servers.length; ++i) {
                if (site.servers[i].serverId != thisId) continue;
                this.thisServerNum = i;
            }
            if (this.thisServerNum < 0) {
                throw new Exception("Server ID " + thisId + " not found in site_info record!");
            }
            this.thisSite = site;
        }
        catch (Exception e) {
            System.err.println("Invalid site/server specification: " + e);
            throw e;
        }
        File privateKeyFile = new File(main.getConfigDir(), PRIVATE_KEY_FILE);
        if (!privateKeyFile.exists() || !privateKeyFile.canRead()) {
            System.err.println("Missing or inaccessible private key file: " + privateKeyFile.getAbsolutePath());
            System.err.println("Run hdl-keygen to generate a new set of keys");
            throw new Exception("Missing or inaccessible private key file: " + privateKeyFile.getAbsolutePath());
        }
        byte[] encKeyBytes = new byte[(int)privateKeyFile.length()];
        try (FileInputStream in = new FileInputStream(privateKeyFile);){
            int r;
            for (int n = 0; n < encKeyBytes.length && (r = in.read(encKeyBytes, n, encKeyBytes.length - n)) >= 0; n += r) {
            }
        }
        byte[] secKey = null;
        if (Util.requiresSecretKey(encKeyBytes)) {
            secKey = Util.getPassphrase("Enter the passphrase for this server's private key: ");
        }
        byte[] keyBytes = Util.decrypt(encKeyBytes, secKey);
        for (i = 0; secKey != null && i < secKey.length; ++i) {
            secKey[i] = 0;
        }
        this.privKey = Util.getPrivateKeyFromBytes(keyBytes, 0);
        this.serverSignature = Signature.getInstance(Util.getSigIdFromHashAlgId(Common.HASH_ALG_SHA1, this.privKey.getAlgorithm()));
        this.serverSignature.initSign(this.privKey);
        for (i = 0; i < keyBytes.length; ++i) {
            keyBytes[i] = 0;
        }
        this.pubKey = Util.getPublicKeyFromBytes(this.thisSite.servers[this.thisServerNum].publicKey, 0);
        this.serverSignature.update(SIGN_TEST);
        byte[] testSig = this.serverSignature.sign();
        Signature verifier = Signature.getInstance(this.serverSignature.getAlgorithm());
        verifier.initVerify(this.pubKey);
        verifier.update(SIGN_TEST);
        if (!verifier.verify(testSig)) {
            throw new Exception("Private key doesn't match public key from site info!");
        }
        if (config.containsKey(SERVER_ADMINS)) {
            try {
                Vector adminVect = (Vector)config.get(SERVER_ADMINS);
                this.serverAdmins = new ValueReference[adminVect.size()];
                for (int i2 = 0; i2 < adminVect.size(); ++i2) {
                    String adminStr = String.valueOf(adminVect.elementAt(i2));
                    int colIdx = adminStr.indexOf(58);
                    if (colIdx <= 0) {
                        throw new Exception("Invalid server administrator ID: \"" + adminStr + "\"");
                    }
                    this.serverAdmins[i2] = new ValueReference(Util.encodeString(adminStr.substring(colIdx + 1)), Integer.parseInt(adminStr.substring(0, colIdx)));
                }
            }
            catch (Exception e) {
                throw new Exception("Error processing server administrator list: " + e);
            }
        }
    }

    @Override
    public void dumpHandles() throws HandleException {
        throw new HandleException(11, "cannot dump handles to a caching server");
    }

    @Override
    public void processRequest(AbstractRequest req, ResponseMessageCallback callback) throws HandleException {
        this.processRequest(req, null, null, callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendResponse(ResponseMessageCallback callback, AbstractResponse response) throws HandleException {
        response.siteInfoSerial = this.thisSite.serialNumber;
        if (response.certify) {
            try {
                Signature signature = this.serverSignature;
                synchronized (signature) {
                    response.signMessage(this.serverSignature);
                }
            }
            catch (Exception e) {
                this.main.logError(75, "Exception signing response: " + e);
            }
        }
        callback.handleResponse(response);
    }

    private void processRequest(AbstractRequest req, ChallengeResponse cRes, ChallengeAnswerRequest crReq, ResponseMessageCallback callback) throws HandleException {
        switch (req.opCode) {
            case 2: {
                this.sendResponse(callback, new GetSiteInfoResponse(req, this.thisSite));
                return;
            }
            case 1: {
                this.sendResponse(callback, this.doResolution((ResolutionRequest)req, cRes, crReq));
                return;
            }
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 201: 
            case 300: 
            case 301: 
            case 400: 
            case 401: 
            case 402: 
            case 1000: 
            case 1001: 
            case 1002: 
            case 1003: {
                this.sendResponse(callback, new ErrorResponse(req, 2, MSG_NOT_A_PRIMARY));
                return;
            }
            case 200: {
                this.sendResponse(callback, new ErrorResponse(req, 405, MSG_CHALLENGE_NOT_FOUND));
                return;
            }
        }
        throw new HandleException(1, "Unknown operation: " + req.opCode);
    }

    private final AbstractResponse doResolution(ResolutionRequest req, ChallengeResponse cRes, ChallengeAnswerRequest crReq) throws HandleException {
        try {
            req.recursionCount = (short)(req.recursionCount + 1);
            if (req.recursionCount > 10) {
                return new ErrorResponse(req, 6, null);
            }
            req.clearBuffers();
            return this.resolver.processRequest(req);
        }
        catch (Exception e) {
            this.main.logError(0, String.valueOf(this.getClass()) + ": error getting values: " + e + " for request " + req);
            if (e instanceof HandleException) {
                throw (HandleException)e;
            }
            return new ErrorResponse(req, 2, Util.encodeString(String.valueOf(e)));
        }
    }

    @Override
    public void shutdown() {
        this.keepRunning = false;
    }

    @Override
    public PublicKey getPublicKey() {
        return this.pubKey;
    }

    @Override
    public PrivateKey getPrivateKey() {
        return this.privKey;
    }

    @Override
    public X509Certificate[] getCertificateChain() {
        return null;
    }

    @Override
    public X509Certificate getCertificate() {
        return null;
    }

    @Override
    public PrivateKey getCertificatePrivateKey() {
        return null;
    }
}

