/*
 * Decompiled with CFR 0.152.
 */
package net.handle.jdb;

import net.handle.jdb.Block;
import net.handle.jdb.LongTableEnumerator;
import net.handle.jdb.TableEntry;

public class LongTable {
    private transient TableEntry[] table;
    private transient int count;
    private int threshold;
    private final float loadFactor;
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private static final int DEFAULT_TABLE_CAPACITY = 101;

    public LongTable(int initialCapacity, float loadFactor) {
        if (initialCapacity < 1 || (double)loadFactor <= 0.0) {
            throw new IllegalArgumentException();
        }
        this.loadFactor = loadFactor;
        this.table = new TableEntry[initialCapacity];
        this.threshold = (int)((float)initialCapacity * loadFactor);
    }

    public LongTable(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public LongTable() {
        this(101, 0.75f);
    }

    public int size() {
        return this.count;
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    public synchronized LongTableEnumerator keys() {
        return new LongTableEnumerator(this.table);
    }

    public synchronized boolean contains(Block value) {
        if (value == null) {
            throw new NullPointerException();
        }
        TableEntry[] tab = this.table;
        int i = tab.length;
        while (i-- > 0) {
            TableEntry e = tab[i];
            while (e != null) {
                if (e.value.equals(value)) {
                    return true;
                }
                e = e.next;
            }
        }
        return false;
    }

    public synchronized boolean containsKey(long key) {
        TableEntry[] tab = this.table;
        int hash = (int)(key & 0xFFFFFFFFFFFFFFFFL | (key & 0xFFFFFFFF00000000L) >> 32);
        int index = (hash & Integer.MAX_VALUE) % tab.length;
        TableEntry e = tab[index];
        while (e != null) {
            if (e.key == key && e.hash == hash) {
                return true;
            }
            e = e.next;
        }
        return false;
    }

    public synchronized Block get(long key) {
        TableEntry[] tab = this.table;
        int hash = (int)(key & 0xFFFFFFFFFFFFFFFFL | (key & 0xFFFFFFFF00000000L) >> 32);
        int index = (hash & Integer.MAX_VALUE) % tab.length;
        TableEntry e = tab[index];
        while (e != null) {
            if (e.key == key && e.hash == hash) {
                return e.value;
            }
            e = e.next;
        }
        return null;
    }

    protected void rehash() {
        int oldCapacity = this.table.length;
        TableEntry[] oldTable = this.table;
        int newCapacity = oldCapacity * 2 + 1;
        TableEntry[] newTable = new TableEntry[newCapacity];
        this.threshold = (int)((float)newCapacity * this.loadFactor);
        this.table = newTable;
        int i = oldCapacity;
        while (i-- > 0) {
            TableEntry old = oldTable[i];
            while (old != null) {
                TableEntry e = old;
                old = old.next;
                int index = (e.hash & Integer.MAX_VALUE) % newCapacity;
                e.next = newTable[index];
                newTable[index] = e;
            }
        }
    }

    public synchronized void put(long key, Block value) {
        if (value == null) {
            throw new NullPointerException();
        }
        TableEntry[] tab = this.table;
        int hash = (int)(key & 0xFFFFFFFFFFFFFFFFL | (key & 0xFFFFFFFF00000000L) >> 32);
        int index = (hash & Integer.MAX_VALUE) % tab.length;
        TableEntry e = tab[index];
        while (e != null) {
            if (e.key == key && e.hash == hash) {
                e.value = value;
                return;
            }
            e = e.next;
        }
        if (this.count >= this.threshold) {
            this.rehash();
            this.put(key, value);
            return;
        }
        e = new TableEntry();
        e.hash = hash;
        e.key = key;
        e.value = value;
        e.next = tab[index];
        tab[index] = e;
        ++this.count;
    }

    public synchronized void remove(long key) {
        TableEntry[] tab = this.table;
        int hash = (int)(key & 0xFFFFFFFFFFFFFFFFL | (key & 0xFFFFFFFF00000000L) >> 32);
        int index = (hash & Integer.MAX_VALUE) % tab.length;
        TableEntry e = tab[index];
        TableEntry prev = null;
        while (e != null) {
            if (e.key == key && e.hash == hash) {
                if (prev == null) {
                    tab[index] = e.next;
                } else {
                    prev.next = e.next;
                }
                --this.count;
                return;
            }
            prev = e;
            e = e.next;
        }
    }

    public synchronized void clear() {
        TableEntry[] tab = this.table;
        int index = tab.length;
        while (--index >= 0) {
            tab[index] = null;
        }
        this.count = 0;
    }
}

