/*
 * Decompiled with CFR 0.152.
 */
package net.handle.hdllib.trust;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.handle.hdllib.Common;
import net.handle.hdllib.HandleRecord;
import net.handle.hdllib.HandleResolver;
import net.handle.hdllib.HandleSignature;
import net.handle.hdllib.HandleValue;
import net.handle.hdllib.Util;
import net.handle.hdllib.trust.ChainBuilder;
import net.handle.hdllib.trust.ChainVerificationReport;
import net.handle.hdllib.trust.ChainVerifier;
import net.handle.hdllib.trust.IssuedSignature;
import net.handle.hdllib.trust.JsonWebSignature;
import net.handle.hdllib.trust.JsonWebSignatureFactory;
import net.handle.hdllib.trust.TrustException;

public class HandleRecordTrustVerifier {
    private final ChainBuilder chainBuilder;
    private final ChainVerifier chainVerifier;
    private boolean isThrowing;

    public HandleRecordTrustVerifier(HandleResolver resolver) {
        this.chainBuilder = new ChainBuilder(resolver);
        this.chainVerifier = new ChainVerifier(resolver.getConfiguration().getRootKeys());
    }

    public HandleRecordTrustVerifier(ChainBuilder chainBuilder, ChainVerifier chainVerifier) {
        this.chainBuilder = chainBuilder;
        this.chainVerifier = chainVerifier;
    }

    public void setThrowing(boolean isThrowing) {
        this.isThrowing = isThrowing;
    }

    public boolean validateHandleRecord(HandleRecord handleRecord) throws TrustException {
        List<HandleValue> valuesList = handleRecord.getValues();
        HashSet<Integer> donaVerifiedValues = new HashSet<Integer>();
        HashSet<Integer> localCertVerifiedValues = new HashSet<Integer>();
        boolean localCertNeeded = false;
        try {
            List<JsonWebSignature> signatures = this.getJsonWebSignaturesFromValues(handleRecord.getValuesAsArray());
            if (signatures.isEmpty()) {
                if (this.isThrowing) {
                    throw new TrustException("No signatures");
                }
                return false;
            }
            for (JsonWebSignature jws : signatures) {
                List<IssuedSignature> chain = this.chainBuilder.buildChain(jws);
                ChainVerificationReport report = this.chainVerifier.verifyValues(handleRecord.getHandle(), valuesList, chain);
                if (!report.canTrust()) {
                    if (this.isThrowing) {
                        throw new TrustException("Chain not trusted");
                    }
                    return false;
                }
                if (!report.valuesReport.badDigestValues.isEmpty()) {
                    if (this.isThrowing) {
                        throw new TrustException("Bad digests");
                    }
                    return false;
                }
                if (!report.valuesReport.missingValues.isEmpty()) {
                    if (this.isThrowing) {
                        throw new TrustException("Missing values");
                    }
                    return false;
                }
                localCertNeeded = report.chainNeedsRequiredSigner;
                if (report.canTrustAndAuthorized()) {
                    donaVerifiedValues.addAll(report.valuesReport.verifiedValues);
                }
                if (!report.canTrustAndAuthorizedUpToRequiredSigner()) continue;
                localCertVerifiedValues.addAll(report.valuesReport.verifiedValues);
            }
        }
        catch (TrustException e) {
            if (this.isThrowing) {
                throw e;
            }
            return false;
        }
        if (HandleRecordTrustVerifier.isAllValuesThatNeedSignatureInVerifiedSet(handleRecord, donaVerifiedValues)) {
            if (!localCertNeeded) {
                return true;
            }
            if (HandleRecordTrustVerifier.isAllValuesThatNeedSignatureInVerifiedSet(handleRecord, localCertVerifiedValues)) {
                return true;
            }
            if (this.isThrowing) {
                throw new TrustException("Failure of required signer");
            }
            return false;
        }
        if (this.isThrowing) {
            throw new TrustException("Unsigned values");
        }
        return false;
    }

    private List<JsonWebSignature> getJsonWebSignaturesFromValues(HandleValue[] newValues) throws TrustException {
        HandleValue[] hsSignatureValues = HandleRecordTrustVerifier.getSignatureValues(newValues);
        ArrayList<JsonWebSignature> signatures = new ArrayList<JsonWebSignature>();
        if (hsSignatureValues == null) {
            return signatures;
        }
        for (HandleValue hsSignatureValue : hsSignatureValues) {
            JsonWebSignature signature = JsonWebSignatureFactory.getInstance().deserialize(hsSignatureValue.getDataAsString());
            signatures.add(signature);
        }
        return signatures;
    }

    private static boolean isAllValuesThatNeedSignatureInVerifiedSet(HandleRecord newRecord, Set<Integer> verifiedValues) {
        for (HandleValue value : newRecord.getValues()) {
            int index = value.getIndex();
            if (verifiedValues.contains(index) || !HandleRecordTrustVerifier.valueNeedsSignature(newRecord.getHandle(), value)) continue;
            return false;
        }
        return true;
    }

    private static boolean valueNeedsSignature(String handle, HandleValue value) {
        if (value.hasType(Common.HS_SIGNATURE_TYPE)) {
            return false;
        }
        if (!value.getAnyoneCanRead()) {
            return false;
        }
        return !"0.NA/0.NA".equalsIgnoreCase(handle) || !value.hasType(HandleSignature.SIGNATURE_TYPE) && !value.hasType(HandleSignature.METADATA_TYPE);
    }

    private static HandleValue[] getSignatureValues(HandleValue[] newValues) {
        return Util.filterValues(newValues, null, Common.HS_SIGNATURE_TYPE_LIST);
    }
}

