/*
 * Decompiled with CFR 0.152.
 */
package net.handle.hdllib.trust;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.handle.hdllib.Common;
import net.handle.hdllib.Encoder;
import net.handle.hdllib.HandleException;
import net.handle.hdllib.HandleRecord;
import net.handle.hdllib.HandleResolver;
import net.handle.hdllib.HandleStorage;
import net.handle.hdllib.HandleValue;
import net.handle.hdllib.Util;
import net.handle.hdllib.ValueReference;
import net.handle.hdllib.trust.HandleClaimsSet;
import net.handle.hdllib.trust.HandleVerifier;
import net.handle.hdllib.trust.IssuedSignature;
import net.handle.hdllib.trust.JsonWebSignature;
import net.handle.hdllib.trust.JsonWebSignatureFactory;
import net.handle.hdllib.trust.TrustException;

public class ChainBuilder {
    private static final int MAX_CHAIN_LENGTH = 50;
    private Map<String, HandleRecord> handleMap;
    private HandleResolver resolver;
    private HandleStorage storage;
    private final JsonWebSignatureFactory signatureFactory = JsonWebSignatureFactory.getInstance();
    private final HandleVerifier handleVerifier = new HandleVerifier();

    public ChainBuilder(Map<String, HandleRecord> handleMap, HandleResolver resolver) {
        this.handleMap = handleMap;
        this.fixHandleMapCase();
        this.resolver = resolver;
    }

    public ChainBuilder(HandleResolver resolver) {
        this.resolver = resolver;
    }

    public ChainBuilder(HandleStorage storage) {
        this.storage = storage;
    }

    public ChainBuilder(HandleStorage storage, HandleResolver resolver) {
        this.storage = storage;
        this.resolver = resolver;
    }

    private void fixHandleMapCase() {
        HashMap<String, HandleRecord> newEntries = null;
        for (Map.Entry<String, HandleRecord> entry : this.handleMap.entrySet()) {
            String upperCaseKey;
            String key = entry.getKey();
            if (key.equals(upperCaseKey = Util.upperCasePrefix(key))) continue;
            if (newEntries == null) {
                newEntries = new HashMap<String, HandleRecord>();
            }
            newEntries.put(upperCaseKey, entry.getValue());
        }
        if (newEntries != null) {
            this.handleMap.putAll(newEntries);
        }
    }

    public List<IssuedSignature> buildChain(JsonWebSignature childSignature) throws TrustException {
        HandleClaimsSet childClaims;
        ArrayList<IssuedSignature> result = new ArrayList<IssuedSignature>();
        HashSet<String> seenIds = new HashSet<String>();
        List<String> chain = null;
        while (true) {
            JsonWebSignature parentSignature;
            String parentSignatureString;
            String nextLinkInChain;
            if ((childClaims = this.handleVerifier.getHandleClaimsSet(childSignature)) == null) {
                throw new TrustException("signature payload not valid");
            }
            if (childClaims.isSelfIssued()) break;
            if (result.size() >= 50) {
                throw new TrustException("chain too long");
            }
            boolean noChain = false;
            if ((chain == null || chain.isEmpty()) && ((chain = childClaims.chain) == null || chain.isEmpty())) {
                noChain = true;
                String handleOfIssuer = ValueReference.fromString(childClaims.iss).getHandleAsString();
                chain = Collections.singletonList(handleOfIssuer);
            }
            if (seenIds.contains(nextLinkInChain = chain.get(0))) {
                throw new TrustException("cycle in chain");
            }
            seenIds.add(nextLinkInChain);
            try {
                parentSignatureString = this.lookup(nextLinkInChain, childClaims.iss);
            }
            catch (HandleException e) {
                throw new TrustException("handle resolution exception", (Throwable)e);
            }
            if (parentSignatureString == null) {
                if (noChain) {
                    throw new TrustException("no chain and unable to resolve issuer " + nextLinkInChain);
                }
                throw new TrustException("unable to resolve chain " + nextLinkInChain);
            }
            try {
                parentSignature = this.signatureFactory.deserialize(parentSignatureString);
            }
            catch (TrustException e) {
                if (noChain) {
                    throw new TrustException("no chain and not a signature at issuer " + nextLinkInChain);
                }
                throw new TrustException("not a signature at chain " + nextLinkInChain);
            }
            HandleClaimsSet parentClaims = this.handleVerifier.getHandleClaimsSet(parentSignature);
            if (parentClaims == null) {
                throw new TrustException("signature payload not valid");
            }
            if (!Util.equalsPrefixCI(parentClaims.sub, childClaims.iss)) {
                throw new TrustException("chain is broken");
            }
            IssuedSignature issuedSignature = new IssuedSignature(childSignature, parentClaims.publicKey, parentClaims.perms);
            result.add(issuedSignature);
            childSignature = parentSignature;
            chain = chain.subList(1, chain.size());
        }
        IssuedSignature issuedSignature = new IssuedSignature(childSignature, childClaims.publicKey, childClaims.perms);
        result.add(issuedSignature);
        return result;
    }

    private String lookup(String nextLinkInChain, String subject) throws HandleException {
        HandleRecord record;
        ValueReference valueReference = ValueReference.fromString(nextLinkInChain);
        if (valueReference.index > 0) {
            HandleValue value = null;
            if (this.handleMap != null) {
                value = this.handleMapLookup(valueReference);
            }
            if (value == null && this.storage != null) {
                value = this.storageLookup(valueReference);
            }
            if (value == null && this.resolver != null) {
                value = this.resolver.resolveValueReference(valueReference);
            }
            if (value == null) {
                return null;
            }
            return value.getDataAsString();
        }
        List<HandleValue> values = null;
        if (this.handleMap != null && (record = this.handleMap.get(Util.upperCasePrefix(valueReference.getHandleAsString()))) != null) {
            values = record.getValues();
        }
        if (values == null && this.storage != null) {
            values = this.storageLookup(valueReference.handle);
        }
        if (values == null && this.resolver != null) {
            values = Arrays.asList(this.resolver.resolveHandle(valueReference.handle));
        }
        if (values == null) {
            return null;
        }
        JsonWebSignature latestCert = this.getLatestHsCertAboutSubject(subject, values);
        if (latestCert == null) {
            return null;
        }
        return latestCert.serialize();
    }

    private HandleValue storageLookup(ValueReference valueReference) throws HandleException {
        byte[][] handleValuesBytes = this.storage.getRawHandleValues(Util.upperCasePrefix(valueReference.handle), new int[]{valueReference.index}, null);
        if (handleValuesBytes == null || handleValuesBytes.length == 0) {
            return null;
        }
        HandleValue[] handleValues = Encoder.decodeHandleValues(handleValuesBytes);
        return handleValues[0];
    }

    private List<HandleValue> storageLookup(byte[] handle) throws HandleException {
        byte[][] handleValuesBytes = this.storage.getRawHandleValues(Util.upperCasePrefix(handle), null, null);
        if (handleValuesBytes == null || handleValuesBytes.length == 0) {
            return null;
        }
        HandleValue[] handleValues = Encoder.decodeHandleValues(handleValuesBytes);
        return Arrays.asList(handleValues);
    }

    private HandleValue handleMapLookup(ValueReference valueReference) {
        HandleRecord record = this.handleMap.get(Util.upperCasePrefix(valueReference.getHandleAsString()));
        if (record == null) {
            return null;
        }
        return record.getValueAtIndex(valueReference.index);
    }

    JsonWebSignature getLatestHsCertAboutSubject(String subject, List<HandleValue> values) throws TrustException {
        JsonWebSignature latestCertAboutSubject = null;
        HandleClaimsSet latestCertClaimsSet = null;
        for (HandleValue value : values) {
            if (!value.hasType(Common.HS_CERT_TYPE)) continue;
            String signatureString = value.getDataAsString();
            JsonWebSignature signature = this.signatureFactory.deserialize(signatureString);
            HandleClaimsSet claimsSet = this.handleVerifier.getHandleClaimsSet(signature);
            if (!subject.equals(claimsSet.sub)) continue;
            if (latestCertAboutSubject == null) {
                latestCertAboutSubject = signature;
                latestCertClaimsSet = claimsSet;
                continue;
            }
            if (!ChainBuilder.issuedLater(claimsSet, latestCertClaimsSet)) continue;
            latestCertAboutSubject = signature;
            latestCertClaimsSet = claimsSet;
        }
        return latestCertAboutSubject;
    }

    private static boolean issuedLater(HandleClaimsSet claims1, HandleClaimsSet claims2) {
        if (claims1.iat == null) {
            return false;
        }
        if (claims2.iat == null) {
            return true;
        }
        return claims1.iat > claims2.iat;
    }
}

