/*
 * Decompiled with CFR 0.152.
 */
package net.handle.hdllib;

import java.util.Arrays;
import net.handle.hdllib.Util;

public class ValueReference {
    public byte[] handle;
    public int index;

    public ValueReference() {
    }

    public ValueReference(byte[] handle, int index) {
        this.handle = handle;
        this.index = index;
    }

    public ValueReference(String handleString, int index) {
        this.handle = Util.encodeString(handleString);
        this.index = index;
    }

    public String toString() {
        return String.valueOf(this.index) + ':' + Util.decodeString(this.handle);
    }

    public static ValueReference fromString(String s) {
        if (s == null) {
            return null;
        }
        int colon = s.indexOf(58);
        if (colon < 0) {
            return new ValueReference(Util.encodeString(s), 0);
        }
        String maybeIndex = s.substring(0, colon);
        if (ValueReference.isDigits(maybeIndex)) {
            String handle = s.substring(colon + 1);
            return new ValueReference(Util.encodeString(handle), Integer.parseInt(maybeIndex));
        }
        return new ValueReference(Util.encodeString(s), 0);
    }

    public String getHandleAsString() {
        return Util.decodeString(this.handle);
    }

    private static boolean isDigits(String s) {
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            if (ch >= '0' && ch <= '9') continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(Util.upperCasePrefix(this.handle));
        result = 31 * result + this.index;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ValueReference other = (ValueReference)obj;
        if (!Util.equalsPrefixCI(this.handle, other.handle)) {
            return false;
        }
        return this.index == other.index;
    }

    public boolean isMatchedBy(ValueReference other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!Util.equalsPrefixCI(this.handle, other.handle)) {
            return false;
        }
        return this.index == 0 || this.index == other.index;
    }
}

