/*
 * Decompiled with CFR 0.152.
 */
package net.handle.hdllib;

import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.DSAPrivateKeySpec;
import java.security.spec.DSAPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.DHParameterSpec;
import javax.crypto.spec.DHPublicKeySpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import net.handle.hdllib.AbstractMessage;
import net.handle.hdllib.AbstractRequest;
import net.handle.hdllib.Attribute;
import net.handle.hdllib.Common;
import net.handle.hdllib.Encoder;
import net.handle.hdllib.HandleException;
import net.handle.hdllib.HandleValue;
import net.handle.hdllib.NamespaceInfo;
import net.handle.hdllib.ServerInfo;
import net.handle.hdllib.SiteInfo;
import net.handle.security.HdlSecurityProvider;

public abstract class Util {
    private static final char[] HEX_VALUES = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    public static final byte CASE_DIFF = -32;
    static final Random RANDOM = new Random();
    static final Random SECURE_RANDOM = new SecureRandom();
    static final Comparator<SiteInfo> SITE_INFO_RESPONSE_TIME_COMPARATOR = (o1, o2) -> Long.signum(o1.responseTime - o2.responseTime);
    private static final int SUPPRESS_WARNINGS_ENCRYPT_DES_ECB_PKCS5 = 0;

    public static final boolean looksLikeBinary(byte[] buf) {
        if (buf == null) {
            return true;
        }
        if (!Util.isValidString(buf, 0, buf.length)) {
            return true;
        }
        for (byte b : buf) {
            if (b >= 9 && b <= 19 || (b < 0 || b >= 32) && b != 127) continue;
            return true;
        }
        return false;
    }

    public static final byte[] duplicateByteArray(byte[] buf) {
        if (buf == null) {
            return null;
        }
        byte[] newbuf = new byte[buf.length];
        System.arraycopy(buf, 0, newbuf, 0, newbuf.length);
        return newbuf;
    }

    public static final String decodeHexString(byte[] buf, int offset, int len, boolean formatNicely) {
        if (buf == null || buf.length <= 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        for (int i = offset; i < offset + len; ++i) {
            if (formatNicely && i > 0 && i % 16 == 0) {
                sb.append('\n');
            }
            sb.append(HEX_VALUES[(buf[i] & 0xF0) >>> 4]);
            sb.append(HEX_VALUES[buf[i] & 0xF]);
        }
        return sb.toString();
    }

    public static final String decodeHexString(byte[] buf, boolean formatNicely) {
        return Util.decodeHexString(buf, 0, buf.length, formatNicely);
    }

    public static final byte[] encodeHexString(String s) {
        int i;
        s = s.toUpperCase().trim();
        byte[] buf = new byte[s.length() / 2 + 1];
        for (i = 0; i < buf.length; ++i) {
            buf[i] = 0;
        }
        i = 0;
        boolean lowNibble = false;
        for (int c = 0; c < s.length(); ++c) {
            char ch = s.charAt(c);
            if (ch >= '0' && ch <= '9') {
                if (lowNibble) {
                    int n = i++;
                    buf[n] = (byte)(buf[n] | ch - 48);
                } else {
                    buf[i] = (byte)(ch - 48 << 4);
                }
                lowNibble = !lowNibble;
                continue;
            }
            if (ch < 'A' || ch > 'F') continue;
            if (lowNibble) {
                int n = i++;
                buf[n] = (byte)(buf[n] | ch - 65 + 10);
            } else {
                buf[i] = (byte)(ch - 65 + 10 << 4);
            }
            lowNibble = !lowNibble;
        }
        byte[] realBuf = !lowNibble ? new byte[i] : new byte[i + 1];
        System.arraycopy(buf, 0, realBuf, 0, realBuf.length);
        return realBuf;
    }

    public static final byte[] encodeString(String s) {
        try {
            return s.getBytes("UTF8");
        }
        catch (Exception e) {
            System.err.println(e);
            return s.getBytes();
        }
    }

    public static final String decodeString(byte[] buf) {
        if (buf == null || buf.length == 0) {
            return "";
        }
        try {
            return new String(buf, "UTF8");
        }
        catch (Exception e) {
            System.err.println(e);
            return new String(buf);
        }
    }

    public static final String decodeString(byte[] buf, int offset, int len) {
        if (buf == null || buf.length == 0) {
            return "";
        }
        try {
            return new String(buf, offset, len, "UTF8");
        }
        catch (Exception e) {
            System.err.println(e);
            return new String(buf, offset, len);
        }
    }

    public static final boolean isValidString(byte[] buf, int offset, int len) {
        int byte2mask = 0;
        int trailing = 0;
        int i = offset;
        while (i < len) {
            byte c = buf[i++];
            if (trailing != 0) {
                if ((c & 0xC0) == 128) {
                    if (byte2mask != 0) {
                        if ((c & byte2mask) != 0) {
                            byte2mask = 0;
                        } else {
                            return false;
                        }
                    }
                    --trailing;
                    continue;
                }
                return false;
            }
            if ((c & 0x80) == 0) continue;
            if ((c & 0xE0) == 192) {
                if ((c & 0x1E) != 0) {
                    trailing = 1;
                    continue;
                }
                return false;
            }
            if ((c & 0xF0) == 224) {
                if ((c & 0xF) == 0) {
                    byte2mask = 32;
                }
                trailing = 2;
                continue;
            }
            if ((c & 0xF8) == 240) {
                if ((c & 7) == 0) {
                    byte2mask = 48;
                }
                trailing = 3;
                continue;
            }
            if ((c & 0xFC) == 248) {
                if ((c & 3) == 0) {
                    byte2mask = 56;
                }
                trailing = 4;
                continue;
            }
            if ((c & 0xFE) == 252) {
                if ((c & 1) == 0) {
                    byte2mask = 60;
                }
                trailing = 5;
                continue;
            }
            return false;
        }
        return trailing == 0;
    }

    public static final boolean hasSlash(byte[] handle) {
        return Util.indexOf(handle, (byte)47) >= 0;
    }

    @Deprecated
    public static final byte[] getIDPart(byte[] handle) {
        return Util.getSuffixPart(handle);
    }

    @Deprecated
    public static final byte[] getNAPart(byte[] handle) {
        return Util.getPrefixPart(handle);
    }

    @Deprecated
    public static final byte[] getNAHandle(byte[] handle) {
        return Util.getZeroNAHandle(handle);
    }

    public static final byte[] getZeroNAHandle(byte[] handle) {
        int slashIndex = Util.indexOf(handle, (byte)47);
        if (slashIndex >= 0) {
            byte[] naHandle = new byte[slashIndex + Common.NA_HANDLE_PREFIX.length];
            System.arraycopy(Common.NA_HANDLE_PREFIX, 0, naHandle, 0, Common.NA_HANDLE_PREFIX.length);
            System.arraycopy(handle, 0, naHandle, Common.NA_HANDLE_PREFIX.length, slashIndex);
            Util.upperCaseInPlace(naHandle);
            return naHandle;
        }
        return Common.ROOT_HANDLE;
    }

    public static String getZeroNAHandle(String handle) {
        return Util.decodeString(Util.getZeroNAHandle(Util.encodeString(handle)));
    }

    public static final byte[] convertSlashlessHandleToZeroNaHandle(byte[] handle) {
        if (Util.hasSlash(handle)) {
            return handle;
        }
        byte[] result = new byte[Common.NA_HANDLE_PREFIX.length + handle.length];
        System.arraycopy(Common.NA_HANDLE_PREFIX, 0, result, 0, Common.NA_HANDLE_PREFIX.length);
        System.arraycopy(handle, 0, result, Common.NA_HANDLE_PREFIX.length, handle.length);
        Util.upperCaseInPlace(result);
        return result;
    }

    public static final boolean isSubNAHandle(byte[] handle) {
        if (Util.startsWithCI(handle, Common.NA_HANDLE_PREFIX)) {
            byte dot = 46;
            for (int i = Common.NA_HANDLE_PREFIX.length; i < handle.length; ++i) {
                if (handle[i] != dot) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isSubNAHandle(String handle) {
        return Util.isSubNAHandle(Util.encodeString(handle));
    }

    public static final byte[] getParentNAOfNAHandle(byte[] naHandle) {
        int parentEndIdx;
        int slashIdx = Util.indexOf(naHandle, (byte)47);
        byte dot = 46;
        for (parentEndIdx = naHandle.length - 1; parentEndIdx > slashIdx; --parentEndIdx) {
            if (naHandle[parentEndIdx] != dot) continue;
            --parentEndIdx;
            break;
        }
        byte[] parentNAHandle = new byte[Common.NA_HANDLE_PREFIX.length + (parentEndIdx - slashIdx)];
        int loc = 0;
        System.arraycopy(Common.NA_HANDLE_PREFIX, 0, parentNAHandle, loc, Common.NA_HANDLE_PREFIX.length);
        System.arraycopy(naHandle, slashIdx + 1, parentNAHandle, Common.NA_HANDLE_PREFIX.length, parentEndIdx - slashIdx);
        return parentNAHandle;
    }

    public static String getParentNAOfNAHandle(String naHandle) {
        return Util.decodeString(Util.getParentNAOfNAHandle(Util.encodeString(naHandle)));
    }

    public static boolean isHandleUnderPrefix(String handle, String prefix) {
        prefix = Util.upperCase(prefix);
        handle = Util.upperCasePrefix(handle);
        if (!prefix.startsWith("0.NA/")) {
            return false;
        }
        String actualPrefix = prefix.substring("0.NA/".length());
        return handle.startsWith(actualPrefix + "/");
    }

    public static boolean isDerivedFrom(String handle, String ancestorHandle) {
        ancestorHandle = Util.upperCase(ancestorHandle);
        if (!(handle = Util.upperCase(handle)).startsWith("0.NA/")) {
            return false;
        }
        return handle.startsWith(ancestorHandle + ".");
    }

    public static final byte[] getPrefixPart(byte[] handle) {
        int slashIndex = Util.indexOf(handle, (byte)47);
        return slashIndex < 0 ? Common.NA_HANDLE_PREFIX_NOSLASH : Util.substring(handle, 0, slashIndex);
    }

    public static String getPrefixPart(String handle) {
        return Util.decodeString(Util.getPrefixPart(Util.encodeString(handle)));
    }

    public static final byte[] getSuffixPart(byte[] handle) {
        int slashIndex = Util.indexOf(handle, (byte)47);
        return slashIndex < 0 ? handle : Util.substring(handle, slashIndex + 1, handle.length);
    }

    public static String getSuffixPart(String handle) {
        return Util.decodeString(Util.getSuffixPart(Util.encodeString(handle)));
    }

    public static final boolean startsWith(byte[] b1, byte[] b2) {
        if (b1.length < b2.length) {
            return false;
        }
        for (int i = 0; i < b2.length; ++i) {
            if (b1[i] == b2[i]) continue;
            return false;
        }
        return true;
    }

    public static final boolean equals(byte[] b1, byte[] b2) {
        if (b1 == null && b2 == null) {
            return true;
        }
        if (b1 == null || b2 == null) {
            return false;
        }
        if (b1.length != b2.length) {
            return false;
        }
        for (int i = 0; i < b1.length; ++i) {
            if (b1[i] == b2[i]) continue;
            return false;
        }
        return true;
    }

    public static final boolean equals(byte[] b1, int b1Start, byte[] b2, int b2Start) {
        if (b1 == null && b2 == null) {
            return true;
        }
        if (b1 == null || b2 == null) {
            return false;
        }
        if (b1.length - b1Start != b2.length - b2Start) {
            return false;
        }
        while (b1Start < b1.length) {
            if (b1[b1Start] != b2[b2Start]) {
                return false;
            }
            ++b1Start;
            ++b2Start;
        }
        return true;
    }

    public static final byte[] upperCase(byte[] b) {
        if (b == null || b.length == 0) {
            return new byte[0];
        }
        int sz = b.length;
        byte[] b2 = new byte[sz];
        System.arraycopy(b, 0, b2, 0, sz);
        for (int i = sz - 1; i >= 0; --i) {
            if (b2[i] < 97 || b2[i] > 122) continue;
            int n = i;
            b2[n] = (byte)(b2[n] + -32);
        }
        return b2;
    }

    public static String upperCase(String s) {
        if (s == null) {
            return "";
        }
        return Util.decodeString(Util.upperCase(Util.encodeString(s)));
    }

    public static final byte[] upperCaseInPlace(byte[] b) {
        if (b == null || b.length == 0) {
            return b;
        }
        for (int i = 0; i < b.length; ++i) {
            if (b[i] < 97 || b[i] > 122) continue;
            int n = i;
            b[n] = (byte)(b[n] + -32);
        }
        return b;
    }

    public static final byte[] upperCasePrefix(byte[] b) {
        if (b == null || b.length == 0) {
            return new byte[0];
        }
        if (Util.startsWith(b, Common.GLOBAL_NA_PREFIX)) {
            return Util.upperCase(b);
        }
        int sz = b.length;
        byte[] b2 = new byte[sz];
        System.arraycopy(b, 0, b2, 0, sz);
        boolean inPrefix = true;
        for (int i = 0; i < sz; ++i) {
            if (inPrefix && b2[i] >= 97 && b2[i] <= 122) {
                int n = i;
                b2[n] = (byte)(b2[n] + -32);
            }
            if (b2[i] != 47) continue;
            inPrefix = false;
        }
        return b2;
    }

    public static String upperCasePrefix(String s) {
        if (s == null) {
            return "";
        }
        return Util.decodeString(Util.upperCasePrefix(Util.encodeString(s)));
    }

    public static final byte[] upperCasePrefixInPlace(byte[] b) {
        if (b == null || b.length == 0) {
            return b;
        }
        if (Util.startsWith(b, Common.GLOBAL_NA_PREFIX)) {
            return Util.upperCaseInPlace(b);
        }
        boolean inPrefix = true;
        for (int i = 0; i < b.length; ++i) {
            if (inPrefix && b[i] >= 97 && b[i] <= 122) {
                int n = i;
                b[n] = (byte)(b[n] + -32);
            }
            if (b[i] != 47) continue;
            inPrefix = false;
        }
        return b;
    }

    public static final boolean equalsCI(byte[] b1, byte[] b2) {
        if (b1 == null && b2 == null) {
            return true;
        }
        if (b1 == null || b2 == null) {
            return false;
        }
        return Util.equalsCI(b1, b1.length, b2, b2.length);
    }

    public static boolean equalsCI(String s1, String s2) {
        if (s1 == null && s2 == null) {
            return true;
        }
        if (s1 == null || s2 == null) {
            return false;
        }
        return Util.equalsCI(Util.encodeString(s1), Util.encodeString(s2));
    }

    public static final boolean equalsCI(byte[] b1, int b1Len, byte[] b2, int b2Len) {
        if (b1 == null && b2 == null) {
            return true;
        }
        if (b1 == null || b2 == null) {
            return false;
        }
        if (b1Len != b2Len || b1Len > b1.length || b2Len > b2.length) {
            return false;
        }
        for (int i = 0; i < b1Len; ++i) {
            byte byte1 = b1[i];
            byte byte2 = b2[i];
            if (byte1 == byte2) continue;
            if (byte1 >= 97 && byte1 <= 122) {
                byte1 = (byte)(byte1 - 32);
            }
            if (byte2 >= 97 && byte2 <= 122) {
                byte2 = (byte)(byte2 - 32);
            }
            if (byte1 == byte2) continue;
            return false;
        }
        return true;
    }

    public static final boolean equalsPrefixCI(byte[] b1, byte[] b2) {
        if (b1 == null && b2 == null) {
            return true;
        }
        if (b1 == null || b2 == null) {
            return false;
        }
        return Util.equalsPrefixCI(b1, b1.length, b2, b2.length);
    }

    public static final boolean equalsPrefixCI(String s1, String s2) {
        if (s1 == null && s2 == null) {
            return true;
        }
        if (s1 == null || s2 == null) {
            return false;
        }
        return Util.equalsPrefixCI(Util.encodeString(s1), Util.encodeString(s2));
    }

    public static final boolean equalsPrefixCI(byte[] b1, int b1Len, byte[] b2, int b2Len) {
        if (b1 == null && b2 == null) {
            return true;
        }
        if (b1 == null || b2 == null) {
            return false;
        }
        if (b1Len != b2Len || b1Len > b1.length || b2Len > b2.length) {
            return false;
        }
        boolean global = Util.startsWith(b1, Common.GLOBAL_NA_PREFIX);
        boolean inPrefix = true;
        for (int i = 0; i < b1Len; ++i) {
            byte byte1 = b1[i];
            byte byte2 = b2[i];
            if (byte1 == 47 && !global) {
                inPrefix = false;
            }
            if (byte1 == byte2) continue;
            if (inPrefix && byte1 >= 97 && byte1 <= 122) {
                byte1 = (byte)(byte1 - 32);
            }
            if (inPrefix && byte2 >= 97 && byte2 <= 122) {
                byte2 = (byte)(byte2 - 32);
            }
            if (byte1 == byte2) continue;
            return false;
        }
        return true;
    }

    public static final boolean startsWithCI(byte[] b1, byte[] b2) {
        if (b1.length < b2.length) {
            return false;
        }
        for (int i = 0; i < b2.length; ++i) {
            byte byte1 = b1[i];
            byte byte2 = b2[i];
            if (byte1 == byte2) continue;
            if (byte1 >= 97 && byte1 <= 122) {
                byte1 = (byte)(byte1 - 32);
            }
            if (byte2 >= 97 && byte2 <= 122) {
                byte2 = (byte)(byte2 - 32);
            }
            if (byte1 == byte2) continue;
            return false;
        }
        return true;
    }

    public static boolean startsWithCI(String s1, String s2) {
        return Util.startsWithCI(Util.encodeString(s1), Util.encodeString(s2));
    }

    public static final byte[] substring(byte[] b, int i1) {
        return Util.substring(b, i1, b.length);
    }

    public static final byte[] substring(byte[] b, int i1, int i2) {
        byte[] rb = new byte[i2 - i1];
        System.arraycopy(b, i1, rb, 0, i2 - i1);
        return rb;
    }

    public static final int indexOf(byte[] b, byte ch) {
        for (int i = 0; i < b.length; ++i) {
            if (b[i] != ch) continue;
            return i;
        }
        return -1;
    }

    public static final int countValuesOfType(HandleValue[] values, byte[] type) {
        if (values == null) {
            return 0;
        }
        int matches = 0;
        for (HandleValue value : values) {
            if (!Util.equals(value.type, type)) continue;
            ++matches;
        }
        return matches;
    }

    public static String rfcIpPortRepr(InetAddress addr, int port) {
        if (!(addr instanceof Inet6Address)) {
            return addr.getHostAddress() + ":" + port;
        }
        return "[" + Util.rfcIpRepr(addr) + "]:" + port;
    }

    private static int[] intsFromStringIPv6Address(String ipv6Address) {
        String[] tokenizedAddress = ipv6Address.split(":");
        if (tokenizedAddress.length != 8) {
            return null;
        }
        int[] integerAddress = new int[8];
        for (int i = 0; i < 8; ++i) {
            if (tokenizedAddress[i].length() == 0) {
                return null;
            }
            try {
                integerAddress[i] = Integer.parseInt(tokenizedAddress[i], 16);
                continue;
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return integerAddress;
    }

    private static int[] intsFromByteIPv6Address(byte[] ipv6Address) {
        if (ipv6Address.length != 16) {
            return null;
        }
        int[] integerAddress = new int[8];
        for (int i = 0; i < 16; i += 2) {
            integerAddress[i / 2] = (ipv6Address[i] & 0xFF) << 8 | ipv6Address[i + 1] & 0xFF;
        }
        return integerAddress;
    }

    private static String integerIPv6AddressToString(int[] integerAddress) {
        int i;
        StringBuilder sb = new StringBuilder();
        boolean previousWasZero = false;
        int currentZeros = 0;
        int currentZeroStartIndex = 0;
        int largestZeros = 0;
        int largestZeroStartIndex = -1;
        for (i = 0; i < 8; ++i) {
            if (integerAddress[i] == 0) {
                if (!previousWasZero) {
                    currentZeroStartIndex = i;
                    previousWasZero = true;
                }
                ++currentZeros;
                continue;
            }
            previousWasZero = false;
            if (currentZeros > largestZeros) {
                largestZeroStartIndex = currentZeroStartIndex;
                largestZeros = currentZeros;
            }
            currentZeros = 0;
        }
        if (largestZeros == 1) {
            largestZeroStartIndex = -1;
        }
        for (i = 0; i < 8; ++i) {
            if (i != largestZeroStartIndex) {
                sb.append(Integer.toHexString(integerAddress[i]));
                if (i >= 7) continue;
                sb.append(":");
                continue;
            }
            if (i == 0) {
                sb.append(":");
            }
            i += largestZeros - 1;
            sb.append(":");
        }
        return sb.toString();
    }

    public static String rfcIpRepr(byte[] ipv6Address) {
        int[] ints = Util.intsFromByteIPv6Address(ipv6Address);
        if (ints == null) {
            if (ipv6Address == null) {
                return null;
            }
            if (ipv6Address.length == 4) {
                return (ipv6Address[0] & 0xFF) + "." + (ipv6Address[1] & 0xFF) + "." + (ipv6Address[2] & 0xFF) + "." + (ipv6Address[3] & 0xFF);
            }
            throw new IllegalArgumentException();
        }
        return Util.integerIPv6AddressToString(ints);
    }

    public static String rfcIpRepr(InetAddress addr) {
        int[] integerAddress;
        String fullAddress;
        if (addr == null) {
            return null;
        }
        if (!(addr instanceof Inet6Address)) {
            return addr.getHostAddress();
        }
        String IPv6Addr = fullAddress = addr.getHostAddress();
        String scope = null;
        int percent = fullAddress.indexOf(37);
        if (percent >= 0) {
            IPv6Addr = fullAddress.substring(0, percent);
            scope = fullAddress.substring(percent + 1);
        }
        if ((integerAddress = Util.intsFromStringIPv6Address(IPv6Addr)) == null) {
            return fullAddress;
        }
        String res = Util.integerIPv6AddressToString(integerAddress);
        if (scope != null) {
            return res + "%" + scope;
        }
        return res;
    }

    public static final boolean isParentTypeInArray(byte[][] a, byte[] val) {
        if (a == null) {
            return false;
        }
        if (val == null || val.length <= 0) {
            return false;
        }
        for (int i = a.length - 1; i >= 0; --i) {
            byte[] queryType = a[i];
            if (queryType.length > 0 && queryType[queryType.length - 1] == 46) {
                if (Util.startsWithCI(val, queryType)) {
                    return true;
                }
                if (!Util.equalsCI(queryType, queryType.length - 1, val, val.length)) continue;
                return true;
            }
            if (!Util.equalsCI(queryType, val)) continue;
            return true;
        }
        return false;
    }

    public static final boolean isInArray(int[] a, int val) {
        if (a == null) {
            return false;
        }
        for (int element : a) {
            if (element != val) continue;
            return true;
        }
        return false;
    }

    public static final boolean isInArray(byte[][] a, byte[] val) {
        if (a == null) {
            return false;
        }
        for (byte[] element : a) {
            if (!Util.equals(element, val)) continue;
            return true;
        }
        return false;
    }

    public static final int getNextUnusedIndex(HandleValue[] values, int firstIdx) {
        int nextIdx = firstIdx;
        while (true) {
            for (HandleValue val : values) {
                if (val == null || val.getIndex() != nextIdx) continue;
                ++nextIdx;
            }
            break;
        }
        return nextIdx;
    }

    public static SiteInfo getAltSiteInfo(SiteInfo site) {
        if (site.attributes == null) {
            return null;
        }
        ArrayList<ServerInfo> altServers = new ArrayList<ServerInfo>();
        HashMap<Integer, ServerInfo> id2Server = null;
        for (Attribute attribute : site.attributes) {
            ServerInfo serverInfo;
            int serverId;
            String name = Util.decodeString(attribute.name);
            if ("alt_addr".equals(name) && site.servers.length == 1) {
                ServerInfo newServer = Util.altServer(site.servers[0], attribute.value);
                if (newServer == null) continue;
                altServers.add(newServer);
                continue;
            }
            if (!name.startsWith("alt_addr.")) continue;
            int periodIndex = name.indexOf(".");
            String serverIdString = name.substring(periodIndex + 1);
            try {
                serverId = Integer.parseInt(serverIdString);
            }
            catch (NumberFormatException e) {
                System.err.println("Error decoding alt_addr: " + name + "\n  " + e);
                e.printStackTrace(System.err);
                continue;
            }
            if (id2Server == null) {
                id2Server = site.getId2ServerMap();
            }
            if ((serverInfo = id2Server.get(serverId).cloneServerInfo()) == null) {
                System.err.println("Error decoding alt_addr: " + name + "\n  ");
                System.err.println("No server " + serverId);
                continue;
            }
            ServerInfo newServer = Util.altServer(site.servers[0], attribute.value);
            if (newServer == null) continue;
            altServers.add(newServer);
        }
        if (altServers.size() > 0) {
            SiteInfo altSiteInfo = new SiteInfo(site);
            altSiteInfo.servers = altServers.toArray(new ServerInfo[1]);
            return altSiteInfo;
        }
        return null;
    }

    public static byte[] fill16(byte[] bytes) {
        if (bytes.length == 16) {
            return bytes;
        }
        byte[] res = new byte[16];
        System.arraycopy(bytes, 0, res, 16 - bytes.length, bytes.length);
        return res;
    }

    private static ServerInfo altServer(ServerInfo orig, byte[] newAddr) {
        String addressString = Util.decodeString(newAddr);
        InetAddress address = null;
        try {
            address = InetAddress.getByName(addressString);
        }
        catch (UnknownHostException e) {
            System.err.println("Error decoding alt_addr: " + addressString + "\n  " + e);
            e.printStackTrace(System.err);
            return null;
        }
        ServerInfo serverInfo = orig.cloneServerInfo();
        serverInfo.ipAddress = Util.fill16(address.getAddress());
        return serverInfo;
    }

    public static SiteInfo[] getSitesFromValues(HandleValue[] values) {
        if (values == null) {
            return null;
        }
        ArrayList<SiteInfo> sites = new ArrayList<SiteInfo>();
        for (HandleValue value : values) {
            if (!Util.isInArray(Common.SITE_INFO_TYPES, value.type)) continue;
            try {
                SiteInfo newSite = new SiteInfo();
                Encoder.decodeSiteInfoRecord(value.data, 0, newSite);
                sites.add(newSite);
            }
            catch (Exception e) {
                System.err.println("Error decoding site record: " + e);
                e.printStackTrace(System.err);
            }
        }
        if (sites.isEmpty()) {
            return null;
        }
        return sites.toArray(new SiteInfo[sites.size()]);
    }

    public static SiteInfo[] getSitesAndAltSitesFromValues(HandleValue[] values) {
        return Util.getSitesAndAltSitesFromValues(values, Common.SITE_INFO_TYPES);
    }

    public static SiteInfo[] getSitesAndAltSitesFromValues(HandleValue[] values, byte[][] types) {
        if (values == null) {
            return null;
        }
        ArrayList<SiteInfo> sites = new ArrayList<SiteInfo>();
        for (HandleValue value : values) {
            if (!Util.isInArray(types, value.type)) continue;
            try {
                SiteInfo newSite = new SiteInfo();
                Encoder.decodeSiteInfoRecord(value.data, 0, newSite);
                sites.add(newSite);
                SiteInfo altSite = Util.getAltSiteInfo(newSite);
                if (altSite == null) continue;
                sites.add(altSite);
            }
            catch (Exception e) {
                System.err.println("Error decoding site record: " + e);
                e.printStackTrace(System.err);
            }
        }
        if (sites.isEmpty()) {
            return null;
        }
        return sites.toArray(new SiteInfo[sites.size()]);
    }

    public static NamespaceInfo getNamespaceFromValues(HandleValue[] values) {
        NamespaceInfo nsInfo = null;
        int currentNSIdx = 0;
        for (int i = 0; values != null && i < values.length; ++i) {
            if (values[i] == null || !values[i].hasType(Common.NAMESPACE_INFO_TYPE) || nsInfo != null && values[i].index >= currentNSIdx) continue;
            try {
                nsInfo = new NamespaceInfo(values[i]);
                currentNSIdx = values[i].index;
                continue;
            }
            catch (HandleException e) {
                System.err.println("Error decoding namespace info: " + e);
                e.printStackTrace(System.err);
            }
        }
        return nsInfo;
    }

    public static final SiteInfo[] orderSitesByPreference(SiteInfo[] sites) {
        int i;
        if (sites == null) {
            return new SiteInfo[0];
        }
        if (sites.length == 1) {
            return sites;
        }
        long[] responseTimes = new long[sites.length];
        byte[] randomBytes = new byte[sites.length];
        RANDOM.nextBytes(randomBytes);
        SiteInfo[] sitesInOriginalOrder = (SiteInfo[])sites.clone();
        for (i = 0; i < sites.length; ++i) {
            long rt;
            responseTimes[i] = rt = sites[i].responseTime;
            sites[i].responseTime = rt + (long)randomBytes[i];
        }
        Arrays.sort(sites, SITE_INFO_RESPONSE_TIME_COMPARATOR);
        for (i = 0; i < sites.length; ++i) {
            sitesInOriginalOrder[i].responseTime = responseTimes[i];
        }
        String preferredGlobal = System.getProperty("hdllib.preferredGlobal");
        if (preferredGlobal != null) {
            for (int j = 0; j < sites.length; ++j) {
                for (ServerInfo server : sites[j].servers) {
                    if (!preferredGlobal.equals(server.getAddressString())) continue;
                    SiteInfo temp = sites[0];
                    sites[0] = sites[j];
                    sites[j] = temp;
                }
            }
        }
        return sites;
    }

    public static SiteInfo getPrimarySite(SiteInfo[] sites) {
        for (SiteInfo site : sites) {
            if (!site.isPrimary) continue;
            return site;
        }
        return null;
    }

    public static HandleValue[] filterValues(HandleValue[] allValues, int[] indexList, byte[][] typeList) {
        if (allValues == null) {
            return null;
        }
        if (!(indexList != null && indexList.length != 0 || typeList != null && typeList.length != 0)) {
            return allValues;
        }
        ArrayList<HandleValue> values = new ArrayList<HandleValue>(allValues.length);
        for (HandleValue value : allValues) {
            if ((typeList == null || typeList.length <= 0 || !Util.isParentTypeInArray(typeList, value.getType())) && (indexList == null || indexList.length <= 0 || !Util.isInArray(indexList, value.getIndex()))) continue;
            values.add(value);
        }
        return values.toArray(new HandleValue[values.size()]);
    }

    public static List<HandleValue> filterOnlyPublicValues(List<HandleValue> values) {
        ArrayList<HandleValue> res = null;
        for (int i = values.size() - 1; i >= 0; --i) {
            HandleValue value = values.get(i);
            if (value.getAnyoneCanRead()) continue;
            if (res == null) {
                res = new ArrayList<HandleValue>(values);
            }
            res.remove(i);
        }
        if (res == null) {
            return values;
        }
        return res;
    }

    public static final byte[] getPassphrase(String prompt) throws Exception {
        byte[] passphrase = new byte[2048];
        int charIdx = 0;
        System.out.println(prompt);
        System.out.println("Note: Your passphrase will be displayed as it is entered");
        System.out.flush();
        while (true) {
            int input;
            if ((input = System.in.read()) == 13) {
                continue;
            }
            if (input < 0 || input == 10) break;
            passphrase[charIdx++] = (byte)input;
        }
        byte[] secKey = new byte[charIdx];
        System.arraycopy(passphrase, 0, secKey, 0, charIdx);
        for (int i = 0; i < passphrase.length; ++i) {
            passphrase[i] = 0;
        }
        return secKey;
    }

    public static byte[] getHashAlgIdFromSigId(String signatureAlgorithm) throws HandleException {
        if (signatureAlgorithm.startsWith("SHA1")) {
            return Common.HASH_ALG_SHA1;
        }
        if (signatureAlgorithm.startsWith("SHA256")) {
            return Common.HASH_ALG_SHA256;
        }
        if (signatureAlgorithm.startsWith("MD5")) {
            return Common.HASH_ALG_MD5;
        }
        throw new HandleException(13, "Unknown signature algorithm: " + signatureAlgorithm);
    }

    public static String getSigIdFromHashAlgId(byte[] hashAlgId, String sigKeyType) throws HandleException {
        if (Util.equals(hashAlgId, Common.HASH_ALG_SHA1) || Util.equals(hashAlgId, Common.HASH_ALG_SHA1_ALTERNATE)) {
            return "SHA1with" + sigKeyType;
        }
        if (Util.equals(hashAlgId, Common.HASH_ALG_SHA256) || Util.equals(hashAlgId, Common.HASH_ALG_SHA256_ALTERNATE)) {
            return "SHA256with" + sigKeyType;
        }
        if (Util.equals(hashAlgId, Common.HASH_ALG_MD5)) {
            return "MD5with" + sigKeyType;
        }
        if (hashAlgId.length == 1 && hashAlgId[0] == 2) {
            return "SHA1with" + sigKeyType;
        }
        if (hashAlgId.length == 1 && hashAlgId[0] == 3) {
            return "SHA256with" + sigKeyType;
        }
        if (hashAlgId.length == 1 && hashAlgId[0] == 1) {
            return "MD5with" + sigKeyType;
        }
        throw new HandleException(13, "Unknown hash algorithm ID: " + Util.decodeString(hashAlgId));
    }

    public static String getDefaultSigId(String algorithm) {
        return "SHA256with" + algorithm;
    }

    public static String getDefaultSigId(String algorithm, AbstractMessage message) throws HandleException {
        if (message.hasEqualOrGreaterVersion(2, 7)) {
            String res = Util.getDefaultSigId(algorithm);
            if ("SHA256withDSA".equals(res) && !message.hasEqualOrGreaterVersion(2, 11)) {
                res = "SHA1withDSA";
            }
            return res;
        }
        return Util.getSigIdFromHashAlgId(Common.HASH_ALG_SHA1, algorithm);
    }

    public static byte[] getBytesFromPrivateKey(PrivateKey key) throws Exception {
        if (key instanceof DSAPrivateKey) {
            DSAPrivateKey dsaKey = (DSAPrivateKey)key;
            byte[] x = dsaKey.getX().toByteArray();
            DSAParams params = dsaKey.getParams();
            byte[] p = params.getP().toByteArray();
            byte[] q = params.getQ().toByteArray();
            byte[] g = params.getG().toByteArray();
            byte[] enc = new byte[20 + Common.KEY_ENCODING_DSA_PRIVATE.length + x.length + p.length + q.length + g.length];
            int loc = 0;
            loc += Encoder.writeByteArray(enc, loc, Common.KEY_ENCODING_DSA_PRIVATE);
            loc += Encoder.writeByteArray(enc, loc, x);
            loc += Encoder.writeByteArray(enc, loc, p);
            loc += Encoder.writeByteArray(enc, loc, q);
            loc += Encoder.writeByteArray(enc, loc, g);
            return enc;
        }
        if (key instanceof RSAPrivateKey) {
            RSAPrivateKey rsaKey = (RSAPrivateKey)key;
            if (rsaKey instanceof RSAPrivateCrtKey) {
                RSAPrivateCrtKey rsacrtKey = (RSAPrivateCrtKey)rsaKey;
                byte[] x = rsacrtKey.getModulus().toByteArray();
                byte[] ex = rsacrtKey.getPrivateExponent().toByteArray();
                byte[] pubEx = rsacrtKey.getPublicExponent().toByteArray();
                byte[] p = rsacrtKey.getPrimeP().toByteArray();
                byte[] q = rsacrtKey.getPrimeQ().toByteArray();
                byte[] exP = rsacrtKey.getPrimeExponentP().toByteArray();
                byte[] exQ = rsacrtKey.getPrimeExponentQ().toByteArray();
                byte[] coeff = rsacrtKey.getCrtCoefficient().toByteArray();
                byte[] enc = new byte[36 + Common.KEY_ENCODING_RSACRT_PRIVATE.length + x.length + ex.length + pubEx.length + p.length + q.length + exP.length + exQ.length + coeff.length];
                int loc = 0;
                loc += Encoder.writeByteArray(enc, loc, Common.KEY_ENCODING_RSACRT_PRIVATE);
                loc += Encoder.writeByteArray(enc, loc, x);
                loc += Encoder.writeByteArray(enc, loc, pubEx);
                loc += Encoder.writeByteArray(enc, loc, ex);
                loc += Encoder.writeByteArray(enc, loc, p);
                loc += Encoder.writeByteArray(enc, loc, q);
                loc += Encoder.writeByteArray(enc, loc, exP);
                loc += Encoder.writeByteArray(enc, loc, exQ);
                loc += Encoder.writeByteArray(enc, loc, coeff);
                return enc;
            }
            byte[] x = rsaKey.getModulus().toByteArray();
            byte[] y = rsaKey.getPrivateExponent().toByteArray();
            byte[] enc = new byte[12 + Common.KEY_ENCODING_RSA_PRIVATE.length + x.length + y.length];
            int loc = 0;
            loc += Encoder.writeByteArray(enc, loc, Common.KEY_ENCODING_RSA_PRIVATE);
            loc += Encoder.writeByteArray(enc, loc, x);
            loc += Encoder.writeByteArray(enc, loc, y);
            return enc;
        }
        throw new HandleException(0, "Unknown private key type: \"" + key + '\"');
    }

    public static PrivateKey getPrivateKeyFromBytes(byte[] pkBuf) throws HandleException, InvalidKeySpecException {
        return Util.getPrivateKeyFromBytes(pkBuf, 0);
    }

    public static PrivateKey getPrivateKeyFromBytes(byte[] pkBuf, int offset) throws HandleException, InvalidKeySpecException {
        byte[] keyType = Encoder.readByteArray(pkBuf, offset);
        offset += 4 + keyType.length;
        if (Util.equals(keyType, Common.KEY_ENCODING_DSA_PRIVATE)) {
            byte[] x = Encoder.readByteArray(pkBuf, offset);
            byte[] p = Encoder.readByteArray(pkBuf, offset += 4 + x.length);
            byte[] q = Encoder.readByteArray(pkBuf, offset += 4 + p.length);
            byte[] g = Encoder.readByteArray(pkBuf, offset += 4 + q.length);
            offset += 4 + g.length;
            DSAPrivateKeySpec keySpec = new DSAPrivateKeySpec(new BigInteger(1, x), new BigInteger(1, p), new BigInteger(1, q), new BigInteger(1, g));
            try {
                KeyFactory dsaKeyFactory = KeyFactory.getInstance("DSA");
                return dsaKeyFactory.generatePrivate(keySpec);
            }
            catch (NoSuchAlgorithmException e) {
                throw new HandleException(26, "DSA encryption not supported", e);
            }
        }
        if (Util.equals(keyType, Common.KEY_ENCODING_RSA_PRIVATE)) {
            byte[] m = Encoder.readByteArray(pkBuf, offset);
            byte[] exp = Encoder.readByteArray(pkBuf, offset += 4 + m.length);
            offset += 4 + exp.length;
            RSAPrivateKeySpec keySpec = new RSAPrivateKeySpec(new BigInteger(1, m), new BigInteger(1, exp));
            try {
                KeyFactory rsaKeyFactory = KeyFactory.getInstance("RSA");
                return rsaKeyFactory.generatePrivate(keySpec);
            }
            catch (NoSuchAlgorithmException e) {
                throw new HandleException(26, "RSA encryption not supported", e);
            }
        }
        if (Util.equals(keyType, Common.KEY_ENCODING_RSACRT_PRIVATE)) {
            byte[] n = Encoder.readByteArray(pkBuf, offset);
            byte[] pubEx = Encoder.readByteArray(pkBuf, offset += 4 + n.length);
            byte[] ex = Encoder.readByteArray(pkBuf, offset += 4 + pubEx.length);
            byte[] p = Encoder.readByteArray(pkBuf, offset += 4 + ex.length);
            byte[] q = Encoder.readByteArray(pkBuf, offset += 4 + p.length);
            byte[] exP = Encoder.readByteArray(pkBuf, offset += 4 + q.length);
            byte[] exQ = Encoder.readByteArray(pkBuf, offset += 4 + exP.length);
            byte[] coeff = Encoder.readByteArray(pkBuf, offset += 4 + exQ.length);
            offset += 4 + coeff.length;
            RSAPrivateCrtKeySpec keySpec = new RSAPrivateCrtKeySpec(new BigInteger(1, n), new BigInteger(1, pubEx), new BigInteger(1, ex), new BigInteger(1, p), new BigInteger(1, q), new BigInteger(1, exP), new BigInteger(1, exQ), new BigInteger(1, coeff));
            try {
                KeyFactory rsaKeyFactory = KeyFactory.getInstance("RSA");
                return rsaKeyFactory.generatePrivate(keySpec);
            }
            catch (NoSuchAlgorithmException e) {
                throw new HandleException(26, "RSA encryption not supported", e);
            }
        }
        throw new HandleException(0, "Unknown format for private key: \"" + Util.decodeString(keyType) + '\"');
    }

    public static byte[] getBytesFromPublicKey(PublicKey key) throws HandleException {
        int flags = 0;
        if (key instanceof DSAPublicKey) {
            DSAPublicKey dsaKey = (DSAPublicKey)key;
            byte[] y = dsaKey.getY().toByteArray();
            DSAParams params = dsaKey.getParams();
            byte[] p = params.getP().toByteArray();
            byte[] q = params.getQ().toByteArray();
            byte[] g = params.getG().toByteArray();
            byte[] enc = new byte[20 + Common.KEY_ENCODING_DSA_PUBLIC.length + 2 + y.length + p.length + q.length + g.length];
            int loc = 0;
            loc += Encoder.writeByteArray(enc, loc, Common.KEY_ENCODING_DSA_PUBLIC);
            loc += Encoder.writeInt2(enc, loc, flags);
            loc += Encoder.writeByteArray(enc, loc, q);
            loc += Encoder.writeByteArray(enc, loc, p);
            loc += Encoder.writeByteArray(enc, loc, g);
            loc += Encoder.writeByteArray(enc, loc, y);
            return enc;
        }
        if (key instanceof RSAPublicKey) {
            RSAPublicKey rsaKey = (RSAPublicKey)key;
            byte[] m = rsaKey.getModulus().toByteArray();
            byte[] ex = rsaKey.getPublicExponent().toByteArray();
            byte[] enc = new byte[16 + m.length + ex.length + 2 + Common.KEY_ENCODING_RSA_PUBLIC.length];
            int loc = 0;
            loc += Encoder.writeByteArray(enc, loc, Common.KEY_ENCODING_RSA_PUBLIC);
            loc += Encoder.writeInt2(enc, loc, flags);
            loc += Encoder.writeByteArray(enc, loc, ex);
            loc += Encoder.writeByteArray(enc, loc, m);
            return enc;
        }
        if (key instanceof DHPublicKey) {
            DHPublicKey dhKey = (DHPublicKey)key;
            DHParameterSpec dhSpec = dhKey.getParams();
            byte[] y = dhKey.getY().toByteArray();
            byte[] p = dhSpec.getP().toByteArray();
            byte[] g = dhSpec.getG().toByteArray();
            byte[] enc = new byte[y.length + g.length + p.length + 16 + Common.KEY_ENCODING_DH_PUBLIC.length + 2];
            int offset = Encoder.writeByteArray(enc, 0, Common.KEY_ENCODING_DH_PUBLIC);
            offset += Encoder.writeInt2(enc, offset, flags);
            offset += Encoder.writeByteArray(enc, offset, y);
            offset += Encoder.writeByteArray(enc, offset, p);
            offset += Encoder.writeByteArray(enc, offset, g);
            return enc;
        }
        throw new HandleException(0, "Unknown public key type: \"" + key + '\"');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PublicKey getPublicKeyFromFile(String filename) throws Exception {
        File f = new File(filename);
        FileInputStream in = new FileInputStream(f);
        byte[] buf = new byte[(int)f.length()];
        try {
            int r;
            int n = 0;
            while ((r = in.read(buf, n, buf.length - n)) > 0) {
                n += r;
            }
        }
        finally {
            in.close();
        }
        return Util.getPublicKeyFromBytes(buf, 0);
    }

    public static PublicKey getPublicKeyFromBytes(byte[] pkBuf) throws Exception {
        return Util.getPublicKeyFromBytes(pkBuf, 0);
    }

    public static PublicKey getPublicKeyFromBytes(byte[] pkBuf, int offset) throws Exception {
        byte[] keyType = Encoder.readByteArray(pkBuf, offset);
        offset += 4 + keyType.length;
        offset += 2;
        if (Util.equals(keyType, Common.KEY_ENCODING_DSA_PUBLIC)) {
            byte[] q = Encoder.readByteArray(pkBuf, offset);
            byte[] p = Encoder.readByteArray(pkBuf, offset += 4 + q.length);
            byte[] g = Encoder.readByteArray(pkBuf, offset += 4 + p.length);
            byte[] y = Encoder.readByteArray(pkBuf, offset += 4 + g.length);
            offset += 4 + y.length;
            DSAPublicKeySpec keySpec = new DSAPublicKeySpec(new BigInteger(1, y), new BigInteger(1, p), new BigInteger(1, q), new BigInteger(1, g));
            try {
                KeyFactory dsaKeyFactory = KeyFactory.getInstance("DSA");
                return dsaKeyFactory.generatePublic(keySpec);
            }
            catch (NoSuchAlgorithmException e) {
                throw new HandleException(26, "DSA encryption not supported", e);
            }
        }
        if (Util.equals(keyType, Common.KEY_ENCODING_RSA_PUBLIC)) {
            byte[] ex = Encoder.readByteArray(pkBuf, offset);
            byte[] m = Encoder.readByteArray(pkBuf, offset += 4 + ex.length);
            offset += 4 + m.length;
            RSAPublicKeySpec keySpec = new RSAPublicKeySpec(new BigInteger(1, m), new BigInteger(1, ex));
            try {
                KeyFactory rsaKeyFactory = KeyFactory.getInstance("RSA");
                return rsaKeyFactory.generatePublic(keySpec);
            }
            catch (NoSuchAlgorithmException e) {
                throw new HandleException(26, "RSA encryption not supported", e);
            }
        }
        if (Util.equals(keyType, Common.KEY_ENCODING_DH_PUBLIC)) {
            byte[] y = Encoder.readByteArray(pkBuf, offset);
            byte[] p = Encoder.readByteArray(pkBuf, offset += 4 + y.length);
            byte[] g = Encoder.readByteArray(pkBuf, offset += 4 + p.length);
            offset += 4 + g.length;
            DHPublicKeySpec keySpec = new DHPublicKeySpec(new BigInteger(1, y), new BigInteger(1, p), new BigInteger(1, g));
            try {
                KeyFactory dhKeyFactory = KeyFactory.getInstance("DiffieHellman");
                return dhKeyFactory.generatePublic(keySpec);
            }
            catch (NoSuchAlgorithmException e) {
                throw new HandleException(26, "DH encryption not supported", e);
            }
        }
        throw new HandleException(0, "Unknown format for public key: \"" + Util.decodeString(keyType) + '\"');
    }

    public static List<PublicKey> getPublicKeysFromValues(HandleValue[] values) {
        ArrayList<PublicKey> keys = new ArrayList<PublicKey>();
        for (HandleValue value : values) {
            if (!value.hasType(Common.PUBLIC_KEY_TYPE)) continue;
            try {
                keys.add(Util.getPublicKeyFromBytes(value.getData()));
            }
            catch (Exception e) {
                System.err.println("Error parsing key " + value);
            }
        }
        return keys;
    }

    public static byte[] encrypt(byte[] cleartext, byte[] secretKey) throws Exception {
        if (secretKey == null) {
            return Util.encrypt(cleartext, null, 1);
        }
        return Util.encrypt(cleartext, secretKey, 4);
    }

    public static byte[] encrypt(byte[] cleartext, byte[] secretKey, int encType) throws Exception {
        HdlSecurityProvider cryptoProvider = HdlSecurityProvider.getInstance();
        switch (encType) {
            case 0: {
                if (cryptoProvider == null) {
                    throw new HandleException(14, "Encryption engine missing");
                }
                secretKey = Util.doMD5Digest(new byte[][]{secretKey});
                Cipher encryptCipher = cryptoProvider.getCipher(1, secretKey, 1, null, 2, 0);
                byte[] enc = encryptCipher.doFinal(cleartext, 0, cleartext.length);
                byte[] enc2 = new byte[enc.length + 4];
                Encoder.writeInt(enc2, 0, encType);
                System.arraycopy(enc, 0, enc2, 4, enc.length);
                return enc2;
            }
            case 2: {
                if (cryptoProvider == null) {
                    throw new HandleException(14, "Encryption engine missing");
                }
                secretKey = Util.doMD5Digest(new byte[][]{secretKey});
                Cipher encryptCipher = cryptoProvider.getCipher(1, secretKey, 1, null, 2, 4);
                byte[] enc = encryptCipher.doFinal(cleartext, 0, cleartext.length);
                byte[] iv = encryptCipher.getIV();
                byte[] enc2 = new byte[enc.length + iv.length + 4];
                Encoder.writeInt(enc2, 0, encType);
                System.arraycopy(iv, 0, enc2, 4, iv.length);
                System.arraycopy(enc, 0, enc2, 4 + iv.length, enc.length);
                return enc2;
            }
            case 3: {
                if (cryptoProvider == null) {
                    throw new HandleException(14, "Encryption engine missing");
                }
                byte[] salt = new byte[16];
                SECURE_RANDOM.nextBytes(salt);
                int iterations = 10000;
                secretKey = Util.doPBKDF2(secretKey, salt, iterations, 192);
                Cipher encryptCipher = cryptoProvider.getCipher(2, secretKey, 1, null, 2, 4);
                byte[] enc = encryptCipher.doFinal(cleartext, 0, cleartext.length);
                byte[] iv = encryptCipher.getIV();
                byte[] enc2 = new byte[8 + salt.length + 4 + 4 + 4 + iv.length + 4 + enc.length];
                int offset = 0;
                offset += Encoder.writeInt(enc2, offset, encType);
                offset += Encoder.writeByteArray(enc2, offset, salt);
                offset += Encoder.writeInt(enc2, offset, iterations);
                offset += Encoder.writeInt(enc2, offset, 192);
                offset += Encoder.writeByteArray(enc2, offset, iv);
                offset += Encoder.writeByteArray(enc2, offset, enc);
                return enc2;
            }
            case 4: {
                if (cryptoProvider == null) {
                    throw new HandleException(14, "Encryption engine missing");
                }
                byte[] salt = new byte[16];
                SECURE_RANDOM.nextBytes(salt);
                int iterations = 10000;
                secretKey = Util.doPBKDF2(secretKey, salt, iterations, 128);
                Cipher encryptCipher = cryptoProvider.getCipher(3, secretKey, 1, null, 2, 4);
                byte[] enc = encryptCipher.doFinal(cleartext, 0, cleartext.length);
                byte[] iv = encryptCipher.getIV();
                byte[] enc2 = new byte[8 + salt.length + 4 + 4 + 4 + iv.length + 4 + enc.length];
                int offset = 0;
                offset += Encoder.writeInt(enc2, offset, encType);
                offset += Encoder.writeByteArray(enc2, offset, salt);
                offset += Encoder.writeInt(enc2, offset, iterations);
                offset += Encoder.writeInt(enc2, offset, 128);
                offset += Encoder.writeByteArray(enc2, offset, iv);
                offset += Encoder.writeByteArray(enc2, offset, enc);
                return enc2;
            }
            case 1: {
                System.err.println("Warning: data not encrypted");
                byte[] enc2 = new byte[cleartext.length + 4];
                Encoder.writeInt(enc2, 0, encType);
                System.arraycopy(cleartext, 0, enc2, 4, cleartext.length);
                return enc2;
            }
        }
        throw new HandleException(16, "Unknown algorithm ID: " + encType);
    }

    public static byte[] doPBKDF2(byte[] password, byte[] salt, int iterations, int length) throws NoSuchAlgorithmException, InvalidKeySpecException {
        SecretKeyFactory factory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA1");
        char[] charPassword = new char[password.length];
        for (int i = 0; i < password.length; ++i) {
            charPassword[i] = (char)(password[i] & 0xFF);
        }
        PBEKeySpec spec = new PBEKeySpec(charPassword, salt, iterations, length);
        SecretKey tmp = factory.generateSecret(spec);
        return tmp.getEncoded();
    }

    public static byte[] constructPbkdf2Encoding(byte[] salt, int iterations, int keyLength, byte[] mac) {
        byte[] res = new byte[12 + salt.length + 4 + mac.length];
        int offset = 0;
        offset += Encoder.writeByteArray(res, offset, salt);
        offset += Encoder.writeInt(res, offset, iterations);
        offset += Encoder.writeInt(res, offset, keyLength);
        offset += Encoder.writeByteArray(res, offset, mac);
        return res;
    }

    public static final boolean requiresSecretKey(byte[] ciphertext) throws Exception {
        int encryptionType = Encoder.readInt(ciphertext, 0);
        return encryptionType != 1;
    }

    public static byte[] decrypt(byte[] ciphertext, byte[] secretKey) throws Exception {
        HdlSecurityProvider cryptoProvider = HdlSecurityProvider.getInstance();
        int encryptionType = Encoder.readInt(ciphertext, 0);
        switch (encryptionType) {
            case 0: {
                if (cryptoProvider == null) {
                    throw new HandleException(14, "Encryption engine missing");
                }
                secretKey = Util.doMD5Digest(new byte[][]{secretKey});
                try {
                    Cipher decryptCipher = cryptoProvider.getCipher(1, secretKey, 2, null, 2, 3);
                    return decryptCipher.doFinal(ciphertext, 4, ciphertext.length - 4);
                }
                catch (Exception e) {
                    throw new Exception("Unable to decrypt");
                }
            }
            case 2: {
                if (cryptoProvider == null) {
                    throw new HandleException(14, "Encryption engine missing");
                }
                secretKey = Util.doMD5Digest(new byte[][]{secretKey});
                try {
                    byte[] iv = Util.substring(ciphertext, 4, 12);
                    ciphertext = Util.substring(ciphertext, 12);
                    Cipher decryptCipher = cryptoProvider.getCipher(1, secretKey, 2, iv, 2, 4);
                    return decryptCipher.doFinal(ciphertext, 0, ciphertext.length);
                }
                catch (Exception e) {
                    throw new Exception("Unable to decrypt");
                }
            }
            case 3: {
                if (cryptoProvider == null) {
                    throw new HandleException(14, "Encryption engine missing");
                }
                try {
                    int offset = 4;
                    byte[] salt = Encoder.readByteArray(ciphertext, offset);
                    int iterations = Encoder.readInt(ciphertext, offset += 4 + salt.length);
                    int keyLength = Encoder.readInt(ciphertext, offset += 4);
                    secretKey = Util.doPBKDF2(secretKey, salt, iterations, keyLength);
                    byte[] iv = Encoder.readByteArray(ciphertext, offset += 4);
                    ciphertext = Encoder.readByteArray(ciphertext, offset += 4 + iv.length);
                    Cipher decryptCipher = cryptoProvider.getCipher(2, secretKey, 2, iv, 2, 4);
                    return decryptCipher.doFinal(ciphertext, 0, ciphertext.length);
                }
                catch (Exception e) {
                    throw new Exception("Unable to decrypt");
                }
            }
            case 4: {
                if (cryptoProvider == null) {
                    throw new HandleException(14, "Encryption engine missing");
                }
                try {
                    int offset = 4;
                    byte[] salt = Encoder.readByteArray(ciphertext, offset);
                    int iterations = Encoder.readInt(ciphertext, offset += 4 + salt.length);
                    int keyLength = Encoder.readInt(ciphertext, offset += 4);
                    secretKey = Util.doPBKDF2(secretKey, salt, iterations, keyLength);
                    byte[] iv = Encoder.readByteArray(ciphertext, offset += 4);
                    ciphertext = Encoder.readByteArray(ciphertext, offset += 4 + iv.length);
                    Cipher decryptCipher = cryptoProvider.getCipher(3, secretKey, 2, iv, 2, 4);
                    return decryptCipher.doFinal(ciphertext, 0, ciphertext.length);
                }
                catch (Exception e) {
                    throw new Exception("Unable to decrypt");
                }
            }
            case 1: {
                byte[] cleartext = new byte[ciphertext.length - 4];
                System.arraycopy(ciphertext, 4, cleartext, 0, cleartext.length);
                return cleartext;
            }
        }
        throw new HandleException(0, "Unknown encryption type code: " + encryptionType);
    }

    private static final MessageDigest getSHA1Digest() throws HandleException {
        try {
            return MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException e) {
            throw new HandleException(14, "SHA1 algorithm not found", e);
        }
    }

    private static final MessageDigest getSHA256Digest() throws HandleException {
        try {
            return MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            throw new HandleException(14, "SHA-256 algorithm not found", e);
        }
    }

    public static final byte[] doSHA1Digest(byte[] ... bufs) throws HandleException {
        MessageDigest digest = Util.getSHA1Digest();
        for (byte[] buf : bufs) {
            digest.update(buf);
        }
        return digest.digest();
    }

    public static byte[] doHmacSHA1(byte[] buf, byte[] key) throws HandleException {
        try {
            Mac mac = Mac.getInstance("HmacSHA1");
            mac.init(new SecretKeySpec(key, "HmacSHA1"));
            return mac.doFinal(buf);
        }
        catch (NoSuchAlgorithmException e) {
            throw new HandleException(14, "HmacSHA1 algorithm not found", e);
        }
        catch (InvalidKeyException e) {
            throw new HandleException(14, "HmacSHA1 key error", e);
        }
    }

    public static byte[] doHmacSHA256(byte[] buf, byte[] key) throws HandleException {
        try {
            Mac mac = Mac.getInstance("HmacSHA256");
            mac.init(new SecretKeySpec(key, "HmacSHA256"));
            return mac.doFinal(buf);
        }
        catch (NoSuchAlgorithmException e) {
            throw new HandleException(14, "HmacSHA256 algorithm not found", e);
        }
        catch (InvalidKeyException e) {
            throw new HandleException(14, "HmacSHA256 key error", e);
        }
    }

    public static byte[] doPbkdf2HmacSHA1(byte[] buf, byte[] key, byte[] paramsToMatch) throws HandleException {
        int keyLength;
        int iterations;
        byte[] salt;
        if (paramsToMatch != null) {
            int offset = 0;
            salt = Encoder.readByteArray(paramsToMatch, offset);
            iterations = Encoder.readInt(paramsToMatch, offset += 4 + salt.length);
            keyLength = Encoder.readInt(paramsToMatch, offset += 4);
            offset += 4;
        } else {
            salt = new byte[16];
            SECURE_RANDOM.nextBytes(salt);
            iterations = 10000;
            keyLength = 160;
        }
        try {
            byte[] derivedKey = Util.doPBKDF2(key, salt, iterations, keyLength);
            byte[] mac = Util.doHmacSHA1(buf, derivedKey);
            return Util.constructPbkdf2Encoding(salt, iterations, keyLength, mac);
        }
        catch (NoSuchAlgorithmException e) {
            throw new HandleException(14, "PBKDF2WithHmacSHA1 algorithm not found", e);
        }
        catch (InvalidKeySpecException e) {
            throw new HandleException(14, "PBKDF2WithHmacSHA1 key error", e);
        }
    }

    public static byte[] doSHA256Digest(byte[] ... bufs) throws HandleException {
        MessageDigest digest = Util.getSHA256Digest();
        for (byte[] buf : bufs) {
            digest.update(buf);
        }
        return digest.digest();
    }

    private static final synchronized MessageDigest getMD5Digest() throws HandleException {
        try {
            return MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new HandleException(14, "MD-5 algorithm not found", e);
        }
    }

    public static final byte[] doMD5Digest(byte[] ... bufs) throws HandleException {
        MessageDigest digest = Util.getMD5Digest();
        for (byte[] buf : bufs) {
            digest.update(buf);
        }
        return digest.digest();
    }

    public static final byte[] doDigest(byte digestType, byte[] ... bufs) throws HandleException {
        switch (digestType) {
            case 3: {
                return Util.doSHA256Digest(bufs);
            }
            case 2: {
                return Util.doSHA1Digest(bufs);
            }
            case 0: 
            case 1: {
                return Util.doMD5Digest(bufs);
            }
        }
        throw new HandleException(0, "Invalid hash type: " + digestType);
    }

    public static final byte[] doMac(byte digestType, byte[] buf, byte[] key) throws HandleException {
        return Util.doMac(digestType, buf, key, null);
    }

    public static final byte[] doMac(byte digestType, byte[] buf, byte[] key, byte[] paramsToMatch) throws HandleException {
        switch (digestType) {
            case 34: {
                return Util.doPbkdf2HmacSHA1(buf, key, paramsToMatch);
            }
            case 19: {
                return Util.doHmacSHA256(buf, key);
            }
            case 18: {
                return Util.doHmacSHA1(buf, key);
            }
            case 3: {
                return Util.doSHA256Digest(key, buf, key);
            }
            case 2: {
                return Util.doSHA1Digest(key, buf, key);
            }
            case 0: 
            case 1: {
                return Util.doMD5Digest(key, buf, key);
            }
        }
        throw new HandleException(0, "Invalid hash type: " + digestType);
    }

    public static final byte[] doDigest(byte[] digestType, byte[] ... bufs) throws HandleException {
        if (digestType.length == 1) {
            return Util.doDigest(digestType[0], bufs);
        }
        if (Util.equals(digestType, Common.HASH_ALG_SHA1) || Util.equals(digestType, Common.HASH_ALG_SHA1_ALTERNATE)) {
            return Util.doDigest((byte)2, bufs);
        }
        if (Util.equals(digestType, Common.HASH_ALG_MD5)) {
            return Util.doDigest((byte)1, bufs);
        }
        if (Util.equals(digestType, Common.HASH_ALG_SHA256) || Util.equals(digestType, Common.HASH_ALG_SHA256_ALTERNATE)) {
            return Util.doDigest((byte)3, bufs);
        }
        throw new HandleException(0, "Invalid hash type: " + Util.decodeString(digestType));
    }

    public static final byte[] doMac(byte[] digestType, byte[] buf, byte[] key) throws HandleException {
        if (digestType.length == 1) {
            return Util.doMac(digestType[0], buf, key);
        }
        if (Util.equals(digestType, Common.HASH_ALG_SHA1) || Util.equals(digestType, Common.HASH_ALG_SHA1_ALTERNATE)) {
            return Util.doMac((byte)2, buf, key);
        }
        if (Util.equals(digestType, Common.HASH_ALG_MD5)) {
            return Util.doMac((byte)1, buf, key);
        }
        if (Util.equals(digestType, Common.HASH_ALG_SHA256) || Util.equals(digestType, Common.HASH_ALG_SHA256_ALTERNATE)) {
            return Util.doMac((byte)3, buf, key);
        }
        if (Util.equalsIgnoreCaseAndPunctuation(digestType, Common.HASH_ALG_HMAC_SHA1)) {
            return Util.doMac((byte)18, buf, key);
        }
        if (Util.equalsIgnoreCaseAndPunctuation(digestType, Common.HASH_ALG_HMAC_SHA256)) {
            return Util.doMac((byte)19, buf, key);
        }
        throw new HandleException(0, "Invalid hash type: " + Util.decodeString(digestType));
    }

    public static boolean equalsIgnoreCaseAndPunctuation(byte[] a, byte[] b) {
        int i = 0;
        int j = 0;
        while (i < a.length || j < b.length) {
            byte bch;
            byte ach = i >= a.length ? (byte)0 : a[i];
            byte by = bch = j >= b.length ? (byte)0 : b[j];
            if (ach == bch) {
                ++i;
                ++j;
                continue;
            }
            if (ach >= 97 && ach <= 122) {
                ach = (byte)(ach - 32);
            }
            if (i >= a.length || ach >= 65 && ach <= 90 || ach >= 48 && ach <= 57) {
                if (bch >= 97 && bch <= 122) {
                    bch = (byte)(bch - 32);
                }
                if (j >= b.length || bch >= 65 && bch <= 90 || bch >= 48 && bch <= 57) {
                    if (ach == bch) {
                        ++i;
                        ++j;
                        continue;
                    }
                    return false;
                }
                ++j;
                continue;
            }
            ++i;
        }
        return true;
    }

    public static void sortNumberArray(Number[] a) {
        Util.quicksortAscending(a, 0, a.length - 1);
    }

    private static void quicksortAscending(Number[] a, int first, int last) {
        if (first < last) {
            int piv_index = Util.partitionAscending(a, first, last);
            Util.quicksortAscending(a, first, piv_index - 1);
            Util.quicksortAscending(a, piv_index, last);
        }
    }

    private static int partitionAscending(Number[] a, int first, int last) {
        Number pivot = a[(first + last) / 2];
        while (first <= last) {
            while (a[first].doubleValue() < pivot.doubleValue()) {
                ++first;
            }
            while (a[last].doubleValue() > pivot.doubleValue()) {
                --last;
            }
            if (first > last) continue;
            Number temp = a[first];
            a[first] = a[last];
            a[last] = temp;
            ++first;
            --last;
        }
        return first;
    }

    @Deprecated
    public static byte[] encrypt(PublicKey encryptingKey, byte[] secretKey) throws Exception {
        return Util.encrypt(encryptingKey, secretKey, 2, 0);
    }

    public static byte[] encrypt(PublicKey encryptingKey, byte[] secretKey, int majorProtocolVersion, int minorProtocolVersion) throws Exception {
        if (encryptingKey != null && encryptingKey instanceof RSAPublicKey) {
            Cipher cipher = Cipher.getInstance("RSA/EBC/PKCS1");
            cipher.init(1, encryptingKey);
            return cipher.doFinal(secretKey);
        }
        throw new HandleException(1, "Unsupported key for encrypt: " + encryptingKey);
    }

    public static byte[] getBytesFromFile(String file) {
        return Util.getBytesFromFile(new File(file));
    }

    public static byte[] getBytesFromFile(File file) {
        byte[] rawKey = null;
        try {
            rawKey = new byte[(int)file.length()];
            FileInputStream in = new FileInputStream(file);
            int r = 0;
            for (int n = 0; n < rawKey.length && (r = ((InputStream)in).read(rawKey, n, rawKey.length - n)) > 0; n += r) {
            }
            ((InputStream)in).close();
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        return rawKey;
    }

    public static byte[] getBytesFromInputStream(InputStream in) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        byte[] buf = new byte[4096];
        int r = 0;
        while ((r = in.read(buf)) > 0) {
            bout.write(buf, 0, r);
        }
        return bout.toByteArray();
    }

    public static void readFully(InputStream in, byte[] b) throws IOException {
        Util.readFully(in, b, 0, b.length);
    }

    public static void readFully(InputStream in, byte[] b, int off, int len) throws IOException {
        int r;
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || len > b.length - off) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        int n = 0;
        while ((r = in.read(b, off + n, len - n)) > 0) {
            n += r;
        }
        if (n < len) {
            throw new EOFException();
        }
    }

    public static boolean writeBytesToFile(String file, byte[] keyBytes) {
        return Util.writeBytesToFile(new File(file), keyBytes);
    }

    public static boolean writeBytesToFile(File file, byte[] keyBytes) {
        boolean bl;
        FileOutputStream out = new FileOutputStream(file);
        try {
            out.write(keyBytes);
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    out.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
                return false;
            }
        }
        out.close();
        return bl;
    }

    public static boolean isMatchingKeyPair(PublicKey pubkey, PrivateKey privkey) throws HandleException {
        if (pubkey == null && privkey != null) {
            return false;
        }
        if (pubkey != null && privkey == null) {
            return false;
        }
        if (pubkey == null) {
            return true;
        }
        if (!pubkey.getAlgorithm().equals(privkey.getAlgorithm())) {
            return false;
        }
        try {
            byte[] toBeSigned = new byte[2048];
            new Random().nextBytes(toBeSigned);
            String alg = Util.getDefaultSigId(privkey.getAlgorithm());
            Signature sig = Signature.getInstance(alg);
            sig.initSign(privkey);
            sig.update(toBeSigned);
            byte[] signatureBytes = sig.sign();
            sig.initVerify(pubkey);
            sig.update(toBeSigned);
            return sig.verify(signatureBytes);
        }
        catch (Exception e) {
            if (e instanceof HandleException) {
                throw (HandleException)e;
            }
            throw new HandleException(13, "Error checking keys: " + e);
        }
    }

    @Deprecated
    public static byte[] decrypt(PrivateKey privKey, byte[] ciphertext) throws Exception {
        return Util.decrypt(privKey, ciphertext, 2, 0);
    }

    public static byte[] decrypt(PrivateKey privKey, byte[] ciphertext, int majorProtocolVersion, int minorProtocolVersion) throws Exception {
        if (privKey != null && privKey instanceof RSAPrivateKey) {
            Cipher cipher = Cipher.getInstance("RSA/EBC/PKCS1");
            cipher.init(2, privKey);
            return cipher.doFinal(ciphertext);
        }
        throw new HandleException(1, "Unsupported key for decrypt: " + privKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PrivateKey getPrivateKeyFromFileWithPassphrase(File privKeyFile, String passphrase) throws Exception {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        FileInputStream fin = new FileInputStream(privKeyFile);
        byte[] buf = new byte[1024];
        int r = 0;
        try {
            while ((r = fin.read(buf)) >= 0) {
                bout.write(buf, 0, r);
            }
        }
        finally {
            fin.close();
        }
        byte[] privateKeyFileContents = bout.toByteArray();
        byte[] passphraseBytes = null;
        if (passphrase != null && Util.requiresSecretKey(privateKeyFileContents)) {
            passphraseBytes = passphrase.getBytes("UTF-8");
        }
        byte[] decryptedPrivateKey = Util.decrypt(privateKeyFileContents, passphraseBytes);
        return Util.getPrivateKeyFromBytes(decryptedPrivateKey, 0);
    }

    public static byte[] concat(byte[] first, byte[] second) {
        if (second.length == 0) {
            return first;
        }
        if (first.length == 0) {
            return second;
        }
        byte[] result = new byte[first.length + second.length];
        System.arraycopy(first, 0, result, 0, first.length);
        System.arraycopy(second, 0, result, first.length, second.length);
        return result;
    }

    public static String getAccessLogString(AbstractRequest req) {
        if (req == null) {
            return " /";
        }
        StringBuilder sb = new StringBuilder();
        try {
            if (req.authInfo != null) {
                sb.append("adm=").append(req.authInfo.getUserIdIndex()).append(":");
                Util.encodeForAccessLog(sb, Util.decodeString(req.authInfo.getUserIdHandle()));
            }
            sb.append(" ");
        }
        catch (Exception e) {
            sb.setLength(0);
        }
        Util.encodeForAccessLog(sb, Util.decodeString(req.handle));
        return sb.toString();
    }

    private static void encodeForAccessLog(StringBuilder sb, String s) {
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            if (ch == '%') {
                sb.append("%25");
                continue;
            }
            if (ch == ' ') {
                sb.append("%20");
                continue;
            }
            if (ch == '\n') {
                sb.append("%0A");
                continue;
            }
            if (ch == '\r') {
                sb.append("%0D");
                continue;
            }
            if (ch == '&') {
                sb.append("%26");
                continue;
            }
            if (ch == '?') {
                sb.append("%3F");
                continue;
            }
            if (ch == '#') {
                sb.append("%23");
                continue;
            }
            if (ch == '\"') {
                sb.append("%22");
                continue;
            }
            sb.append(ch);
        }
    }
}

