/*
 * Decompiled with CFR 0.152.
 */
package net.handle.hdllib;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.HashMap;
import net.handle.hdllib.Attribute;
import net.handle.hdllib.Encoder;
import net.handle.hdllib.HandleException;
import net.handle.hdllib.Interface;
import net.handle.hdllib.ServerInfo;
import net.handle.hdllib.Util;

public class SiteInfo {
    public static final byte HASH_TYPE_BY_PREFIX = 0;
    public static final byte HASH_TYPE_BY_SUFFIX = 1;
    public static final byte HASH_TYPE_BY_ALL = 2;
    public static final short PRIMARY_SITE = 128;
    public static final short MULTI_PRIMARY = 64;
    public int dataFormatVersion = 1;
    public int serialNumber;
    public byte majorProtocolVersion = (byte)2;
    public byte minorProtocolVersion = (byte)11;
    public boolean isPrimary;
    public boolean multiPrimary;
    public boolean isRoot = false;
    public long responseTime;
    public byte hashOption = (byte)2;
    public byte[] hashFilter;
    public ServerInfo[] servers;
    public Attribute[] attributes;

    public SiteInfo() {
    }

    public SiteInfo(int siteVersion, boolean isPrimary, boolean isMultiPrimary, byte hashingOption, String siteDescription, InetAddress listenAddr, int port, int httpPort, File pubKeyFile, boolean disableUDP) throws IOException {
        this.serialNumber = siteVersion;
        this.isPrimary = isPrimary;
        this.multiPrimary = isMultiPrimary;
        this.hashOption = hashingOption;
        if (siteDescription != null) {
            this.attributes = new Attribute[]{new Attribute(Util.encodeString("desc"), Util.encodeString(siteDescription))};
        }
        this.servers = new ServerInfo[]{new ServerInfo()};
        this.servers[0].serverId = 1;
        byte[] addr1 = listenAddr.getAddress();
        byte[] addr2 = new byte[16];
        for (int i = 0; i < 16; ++i) {
            addr2[i] = 0;
        }
        System.arraycopy(addr1, 0, addr2, addr2.length - addr1.length, addr1.length);
        this.servers[0].ipAddress = addr2;
        byte[] pkbuf = new byte[(int)pubKeyFile.length()];
        FileInputStream pubKeyIn = new FileInputStream(pubKeyFile);
        int r = 0;
        for (int n = 0; n < pkbuf.length && (r = pubKeyIn.read(pkbuf, n, pkbuf.length - n)) >= 0; n += r) {
        }
        pubKeyIn.close();
        this.servers[0].publicKey = pkbuf;
        this.servers[0].interfaces = disableUDP ? new Interface[]{new Interface(3, 1, port), new Interface(3, 2, httpPort)} : new Interface[]{new Interface(3, 1, port), new Interface(2, 0, port), new Interface(3, 2, httpPort)};
    }

    public SiteInfo(int siteVersion, boolean isPrimary, boolean isMultiPrimary, byte hashingOption, String siteDescription, InetAddress listenAddr, InetAddress altAddr, int port, int httpPort, File pubKeyFile, boolean disableUDP) throws IOException {
        this(siteVersion, isPrimary, isMultiPrimary, hashingOption, siteDescription, listenAddr, port, httpPort, pubKeyFile, disableUDP);
        Attribute desc = this.attributes[0];
        this.attributes = new Attribute[2];
        this.attributes[0] = desc;
        Attribute altAddrAttribute = new Attribute();
        altAddrAttribute.name = Util.encodeString("alt_addr.1");
        altAddrAttribute.value = Util.encodeString(Util.rfcIpRepr(altAddr));
        this.attributes[1] = altAddrAttribute;
    }

    public SiteInfo(SiteInfo site) {
        int i;
        this.serialNumber = site.serialNumber;
        this.isPrimary = site.isPrimary;
        this.multiPrimary = site.multiPrimary;
        this.hashOption = site.hashOption;
        this.dataFormatVersion = site.dataFormatVersion;
        this.isRoot = site.isRoot;
        this.responseTime = site.responseTime;
        this.majorProtocolVersion = site.majorProtocolVersion;
        this.minorProtocolVersion = site.minorProtocolVersion;
        this.hashFilter = new byte[site.hashFilter.length];
        System.arraycopy(site.hashFilter, 0, this.hashFilter, 0, site.hashFilter.length);
        if (site.attributes != null) {
            this.attributes = new Attribute[site.attributes.length];
            for (i = 0; i < site.attributes.length; ++i) {
                this.attributes[i] = new Attribute(site.attributes[i].name, site.attributes[i].value);
            }
        }
        if (site.servers != null) {
            this.servers = new ServerInfo[site.servers.length];
            for (i = 0; i < site.servers.length; ++i) {
                this.servers[i] = site.servers[i].cloneServerInfo();
            }
        }
    }

    public byte[] getAttribute(byte[] attribute) {
        if (this.attributes != null) {
            for (Attribute existingAttribute : this.attributes) {
                if (!Util.equals(attribute, existingAttribute.name)) continue;
                return existingAttribute.value;
            }
        }
        return null;
    }

    public static final int getHandleHash(byte[] handle, int hashOption) throws HandleException {
        byte[] hashPart;
        switch (hashOption) {
            case 0: {
                hashPart = Util.upperCaseInPlace(Util.getPrefixPart(handle));
                break;
            }
            case 1: {
                hashPart = Util.upperCaseInPlace(Util.getSuffixPart(handle));
                break;
            }
            case 2: {
                hashPart = Util.upperCase(handle);
                break;
            }
            default: {
                throw new HandleException(0, "Unknown hash method: " + hashOption);
            }
        }
        byte[] digest = Util.doMD5Digest(new byte[][]{hashPart});
        return Math.abs(Encoder.readInt(digest, digest.length - 4));
    }

    public final int determineServerNum(byte[] handle) throws HandleException {
        return SiteInfo.determineServerNum(handle, this.hashOption, this.servers.length);
    }

    public static final int determineServerNum(byte[] handle, int hashOption, int numServers) throws HandleException {
        return SiteInfo.getHandleHash(handle, hashOption) % numServers;
    }

    public ServerInfo determineServer(byte[] handle) throws HandleException {
        return this.servers[SiteInfo.determineServerNum(handle, this.hashOption, this.servers.length)];
    }

    public String toString() {
        String servList = "";
        if (this.servers != null) {
            servList = servList + this.servers[0];
            for (int i = 1; i < this.servers.length; ++i) {
                servList = servList + ", " + this.servers[i];
            }
        }
        return "version: " + this.majorProtocolVersion + '.' + this.minorProtocolVersion + "; serial:" + this.serialNumber + "; primary:" + (this.isPrimary ? "y; " : "n; ") + "servers=[" + servList + "]";
    }

    public HashMap<Integer, ServerInfo> getId2ServerMap() {
        HashMap<Integer, ServerInfo> id2Server = new HashMap<Integer, ServerInfo>();
        for (ServerInfo server : this.servers) {
            int id = server.serverId;
            id2Server.put(id, server);
        }
        return id2Server;
    }

    public static final void main(String[] argv) throws Exception {
        for (String hdl : argv) {
            System.out.println("Handle: " + hdl);
            int hashResult = SiteInfo.getHandleHash(Util.encodeString(hdl), 0);
            System.out.println("  hash by prefix: " + hashResult + "; #servers: 2=" + hashResult % 2 + ", 3=" + hashResult % 3 + ", 4=" + hashResult % 4);
            hashResult = SiteInfo.getHandleHash(Util.encodeString(hdl), 1);
            System.out.println("  hash by suffix: " + hashResult + "; #servers: 2=" + hashResult % 2 + ", 3=" + hashResult % 3 + ", 4=" + hashResult % 4);
            hashResult = SiteInfo.getHandleHash(Util.encodeString(hdl), 2);
            System.out.println("  hash by all: " + hashResult + "; #servers: 2=" + hashResult % 2 + ", 3=" + hashResult % 3 + ", 4=" + hashResult % 4);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(SiteInfo.emptyToNull(this.attributes));
        result = 31 * result + this.dataFormatVersion;
        result = 31 * result + Arrays.hashCode(SiteInfo.emptyToNull(this.hashFilter));
        result = 31 * result + this.hashOption;
        result = 31 * result + (this.isPrimary ? 1231 : 1237);
        result = 31 * result + this.majorProtocolVersion;
        result = 31 * result + this.minorProtocolVersion;
        result = 31 * result + (this.multiPrimary ? 1231 : 1237);
        result = 31 * result + this.serialNumber;
        result = 31 * result + Arrays.hashCode(SiteInfo.emptyToNull(this.servers));
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SiteInfo other = (SiteInfo)obj;
        if (!Arrays.equals(SiteInfo.emptyToNull(this.attributes), SiteInfo.emptyToNull(other.attributes))) {
            return false;
        }
        if (this.dataFormatVersion != other.dataFormatVersion) {
            return false;
        }
        if (!Arrays.equals(SiteInfo.emptyToNull(this.hashFilter), SiteInfo.emptyToNull(other.hashFilter))) {
            return false;
        }
        if (this.hashOption != other.hashOption) {
            return false;
        }
        if (this.isPrimary != other.isPrimary) {
            return false;
        }
        if (this.majorProtocolVersion != other.majorProtocolVersion) {
            return false;
        }
        if (this.minorProtocolVersion != other.minorProtocolVersion) {
            return false;
        }
        if (this.multiPrimary != other.multiPrimary) {
            return false;
        }
        if (this.serialNumber != other.serialNumber) {
            return false;
        }
        return Arrays.equals(SiteInfo.emptyToNull(this.servers), SiteInfo.emptyToNull(other.servers));
    }

    private static byte[] emptyToNull(byte[] array) {
        if (array == null || array.length == 0) {
            return null;
        }
        return array;
    }

    private static <T> T[] emptyToNull(T[] array) {
        if (array == null || array.length == 0) {
            return null;
        }
        return array;
    }

    public String getDomainForServer(int which) {
        byte[] domainBytes = null;
        if (which >= 0) {
            domainBytes = this.getAttribute(Util.encodeString("domain." + which));
        }
        if (domainBytes == null) {
            domainBytes = this.getAttribute(Util.encodeString("domain"));
        }
        if (domainBytes == null) {
            return null;
        }
        return Util.decodeString(domainBytes);
    }

    public boolean hasZeroAddressServersAndDomain() {
        for (int i = 0; i < this.servers.length; ++i) {
            ServerInfo server = this.servers[i];
            if (!server.hasAllZerosAddress() || this.getDomainForServer(i) == null) continue;
            return true;
        }
        return false;
    }
}

