/*
 * Decompiled with CFR 0.152.
 */
package net.handle.hdllib;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import net.cnri.simplexml.XParser;
import net.cnri.simplexml.XTag;
import net.handle.hdllib.HandleException;
import net.handle.hdllib.HandleResolver;
import net.handle.hdllib.HandleValue;
import net.handle.hdllib.TemplateBuilder;

public class NamespaceInfo {
    public static final String STATUS_ACTIVE = "active";
    public static final String STATUS_INACTIVE = "inactive";
    public static final String CONTACT_TAG = "contact";
    public static final String STATUS_MSG_TAG = "statusmsg";
    public static final String STATUS_TAG = "status";
    public static final String TEMPLATE_TAG = "template";
    public static final String LOCATIONS_TAG = "locs";
    public static final String TEMPLATE_DELIMITER_ATT = "delimiter";
    private static XParser xmlParser = new XParser();
    private final XTag xmlInfo;
    private NamespaceInfo parentNamespace = null;

    public NamespaceInfo(HandleValue namespaceValue) throws HandleException {
        this(namespaceValue.getData());
    }

    public NamespaceInfo(byte[] rawInfo) throws HandleException {
        try {
            this.xmlInfo = xmlParser.parse(new InputStreamReader((InputStream)new ByteArrayInputStream(rawInfo), "UTF8"), false);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            if (e instanceof HandleException) {
                throw (HandleException)e;
            }
            throw new HandleException(0, "Error parsing namespace information: " + e);
        }
    }

    public NamespaceInfo() {
        this.xmlInfo = new XTag("NAMESPACE");
    }

    public void setParentNamespace(NamespaceInfo parent) {
        this.parentNamespace = parent;
    }

    public NamespaceInfo getParentNamespace() {
        return this.parentNamespace;
    }

    public String getResponsiblePartyContactAddress() {
        return this.xmlInfo.getStrSubTag(CONTACT_TAG, null);
    }

    public String getStatusMessage() {
        return this.xmlInfo.getStrSubTag(STATUS_MSG_TAG, null);
    }

    public String getNamespaceStatus() {
        return this.xmlInfo.getStrSubTag(STATUS_TAG, STATUS_ACTIVE);
    }

    public List<String> getLocationTemplateHandles() {
        ArrayList<String> res = new ArrayList<String>();
        boolean suppressParents = false;
        for (XTag subtag : this.xmlInfo.getSubTags()) {
            if (!LOCATIONS_TAG.equals(subtag.getName())) continue;
            res.add(subtag.getStrValue());
            suppressParents = suppressParents || subtag.getBoolAttribute("no_nslocs", false);
        }
        if (this.parentNamespace != null && !suppressParents) {
            res.addAll(this.parentNamespace.getLocationTemplateHandles());
        }
        if (res.isEmpty()) {
            return null;
        }
        return res;
    }

    public String templateDelimiter() {
        XTag templateTag = this.xmlInfo.getSubTag(TEMPLATE_TAG);
        if (templateTag != null) {
            return templateTag.getAttribute(TEMPLATE_DELIMITER_ATT);
        }
        if (this.parentNamespace != null) {
            return this.parentNamespace.templateDelimiter();
        }
        return null;
    }

    public HandleValue[] templateConstruct(HandleValue[] origvals, String handle, String base, String extension, boolean caseSensitive, HandleResolver resolver, short recursionCount) {
        TemplateBuilder tb = new TemplateBuilder(origvals, handle, base, extension, caseSensitive, resolver, recursionCount);
        this.setupTemplateBuilderForNamespace(tb);
        return tb.templateConstruct();
    }

    void setupTemplateBuilderForNamespace(TemplateBuilder tb) {
        tb.setXml(this.xmlInfo);
        tb.setParentNamespace(this.parentNamespace);
    }

    public XTag getInheritedTag(String name) {
        XTag tag = this.xmlInfo.getSubTag(TEMPLATE_TAG);
        if (tag != null) {
            return tag;
        }
        if (this.parentNamespace != null) {
            return this.parentNamespace.getInheritedTag(name);
        }
        return null;
    }

    public String toString() {
        return (this.xmlInfo == null ? "<null>" : this.xmlInfo.toString()) + "Parent: " + (this.parentNamespace == null ? "<null>" : String.valueOf(this.parentNamespace));
    }
}

