/*
 * Decompiled with CFR 0.152.
 */
package net.handle.hdllib;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.handle.hdllib.HandleValue;
import net.handle.hdllib.Util;

public class HandleRecord {
    private String handle;
    private List<HandleValue> values;

    public HandleRecord() {
    }

    public HandleRecord(String handle, HandleValue[] valuesArray) {
        this.handle = handle;
        if (valuesArray != null) {
            this.values = new ArrayList<HandleValue>();
            this.values.addAll(Arrays.asList(valuesArray));
        } else {
            this.values = null;
        }
    }

    public HandleRecord(String handle, List<HandleValue> values) {
        this.handle = handle;
        this.values = values;
    }

    public String getHandle() {
        return this.handle;
    }

    public void setHandle(String handle) {
        this.handle = handle;
    }

    public byte[] getHandleBytes() {
        return Util.encodeString(this.handle);
    }

    public List<HandleValue> getValues() {
        return this.values;
    }

    public void setValues(List<HandleValue> values) {
        this.values = values;
    }

    public void setValues(HandleValue[] valuesArray) {
        if (valuesArray != null) {
            this.values = new ArrayList<HandleValue>();
            this.values.addAll(Arrays.asList(valuesArray));
        } else {
            this.values = null;
        }
    }

    public HandleValue[] getValuesAsArray() {
        if (this.values == null) {
            return null;
        }
        HandleValue[] result = this.values.toArray(new HandleValue[this.values.size()]);
        return result;
    }

    public HandleValue getValueAtIndex(int index) {
        if (this.values == null) {
            return null;
        }
        for (HandleValue value : this.values) {
            if (value.getIndex() != index) continue;
            return value;
        }
        return null;
    }

    public List<HandleValue> getValuesOfType(String type) {
        ArrayList<HandleValue> result = new ArrayList<HandleValue>();
        if (this.values == null) {
            return result;
        }
        for (HandleValue value : this.values) {
            byte[] typeBytes = value.getType();
            String valueType = Util.decodeString(typeBytes);
            if (!type.equals(valueType)) continue;
            result.add(value);
        }
        return result;
    }
}

