/*
 * Decompiled with CFR 0.152.
 */
package net.handle.dnslib;

import java.util.HashSet;
import java.util.List;
import net.handle.dnslib.Cache;
import net.handle.dnslib.DomainName;
import net.handle.dnslib.Message;
import net.handle.dnslib.NameResolver;
import net.handle.dnslib.ParseException;
import net.handle.dnslib.Question;
import net.handle.dnslib.RRSet;
import net.handle.dnslib.ResourceRecord;
import net.handle.dnslib.Storage;
import net.handle.hdllib.HandleException;

public class NameServer {
    private final List<Storage> storageList;
    private final NameResolver resolver;
    private Cache cache;
    public static final ResourceRecord A_ROOT_REFERRAL;

    public NameServer(List<Storage> storageList, NameResolver resolver) {
        this.storageList = storageList;
        this.resolver = resolver;
    }

    public void shutdown() {
        this.cache.shutdown();
    }

    public void setCache(int prefetcherThreads, int size) {
        if (size <= 0) {
            return;
        }
        this.cache = new Cache(query -> this.realRespondToQuery(query), prefetcherThreads, size);
    }

    private Storage getZoneStorageFor(DomainName name) {
        int length = -1;
        Storage res = null;
        for (Storage s : this.storageList) {
            DomainName zone = s.getZone();
            if (zone.length() <= length || !name.descendsFrom(zone)) continue;
            length = zone.length();
            res = s;
        }
        return res;
    }

    public Message respondToBytes(byte[] queryBytes, boolean allowRecursion, int[] udpPayloadArr) {
        Message query = new Message();
        try {
            query.parseWire(queryBytes);
        }
        catch (ParseException e) {
            e.printStackTrace();
            Message response = Message.initialResponse(query, allowRecursion, false);
            response.setResponseCode((byte)1);
            return response;
        }
        if (udpPayloadArr != null) {
            udpPayloadArr[0] = query.getUDPPayloadSize();
        }
        return this.respondToQuery(query, allowRecursion);
    }

    public Message refusalResponse(byte[] queryBytes) {
        Message query = new Message();
        try {
            query.parseWire(queryBytes);
        }
        catch (ParseException e) {
            e.printStackTrace();
            Message response = Message.initialResponse(query, false, false);
            if (response == null) {
                return response;
            }
            response.setResponseCode((byte)1);
            return response;
        }
        Message response = Message.initialResponse(query, false, false);
        if (response == null) {
            return response;
        }
        response.setResponseCode((byte)5);
        return response;
    }

    public Message respondToQuery(Message query, boolean allowRecursion) {
        Message response;
        if (allowRecursion && query.getRecursionDesired() && this.resolver != null) {
            return this.resolver.respondToQuery(query);
        }
        if (this.cache != null && (response = this.cache.get(query)) != null) {
            return response;
        }
        return this.realRespondToQuery(query);
    }

    Message realRespondToQuery(Message query) {
        boolean authorityIsReferralOrSOA;
        Message response = Message.initialResponse(query, false, false);
        if (response == null || response.getExtendedResponseCode() != 0) {
            return response;
        }
        Storage storage = null;
        try {
            storage = this.accumulateAnswers(response, query.getQuestion().getName(), query.getQuestion().getType(), false);
        }
        catch (HandleException e) {
            e.printStackTrace();
            response.setResponseCode((byte)2);
            return response;
        }
        boolean bl = authorityIsReferralOrSOA = storage == null;
        if (!authorityIsReferralOrSOA && storage != null && !response.answer.keySet().contains(new Question(storage.getZone(), 2, 1))) {
            try {
                List<ResourceRecord> nsRecords = storage.getNSRecords(storage.getZone());
                if (nsRecords != null) {
                    for (ResourceRecord rr : nsRecords) {
                        response.authority.add(rr);
                    }
                }
            }
            catch (HandleException e) {
                e.printStackTrace();
            }
        }
        this.additionalSectionProcessing(response, authorityIsReferralOrSOA);
        if (this.cache != null) {
            this.cache.put(query, response);
        }
        return response;
    }

    private Storage accumulateAnswers(Message response, DomainName name, int type, boolean followingCNAME) throws HandleException {
        DomainName nextName;
        Storage storage = this.getZoneStorageFor(name);
        if (storage == null) {
            response.authority.add(A_ROOT_REFERRAL);
            return null;
        }
        DomainName zone = storage.getZone();
        ResourceRecord soaRecord = storage.getSOARecord(zone);
        if (soaRecord == null) {
            List<ResourceRecord> zoneCutRecords = storage.getNSRecords(zone);
            if (zoneCutRecords != null && zoneCutRecords.size() > 0) {
                for (ResourceRecord rr : zoneCutRecords) {
                    response.authority.add(rr);
                }
            } else {
                response.authority.add(A_ROOT_REFERRAL);
            }
            if (!followingCNAME) {
                response.authAnswer = false;
            }
            return null;
        }
        response.authAnswer = true;
        DomainName match = zone;
        DomainName longestExistingAncestor = zone;
        while (match.length() < name.length()) {
            List<ResourceRecord> zoneCutRecords = storage.getNSRecords(match = match.ancestorChildOf(name));
            if (zoneCutRecords == null) continue;
            longestExistingAncestor = match;
            if (zoneCutRecords.size() <= 0) continue;
            for (ResourceRecord rr : zoneCutRecords) {
                response.authority.add(rr);
            }
            if (!followingCNAME) {
                response.authAnswer = false;
            }
            return null;
        }
        List<ResourceRecord> records = storage.getRecords(name, type);
        if (records == null) {
            DomainName wildcard = name;
            while (wildcard.length() > longestExistingAncestor.length()) {
                List<ResourceRecord> zoneCutRecords = storage.getWildcardNSRecords(wildcard = wildcard.asteriskLabelSibling(), name);
                if (zoneCutRecords != null) {
                    if (zoneCutRecords.size() > 0) {
                        for (ResourceRecord rr : zoneCutRecords) {
                            response.authority.add(rr);
                        }
                        if (!followingCNAME) {
                            response.authAnswer = false;
                        }
                        return null;
                    }
                    records = storage.getWildcardRecords(wildcard, name, type);
                    if (records != null) break;
                }
                wildcard = wildcard.parent();
            }
            if (records == null) {
                if (!followingCNAME) {
                    response.setResponseCode((byte)3);
                    response.authority.add(soaRecord);
                }
                return null;
            }
        }
        if (records.size() == 0) {
            response.authority.add(soaRecord);
            return null;
        }
        ResourceRecord cname = null;
        boolean cnamePossible = type != 5 && type != 255;
        for (ResourceRecord rr : records) {
            response.answer.add(rr);
            if (!cnamePossible || rr.getType() != 5) continue;
            if (cname != null) {
                cnamePossible = false;
                cname = null;
                continue;
            }
            cname = rr;
        }
        if (cname != null && (nextName = cname.nameFromData()) != null) {
            boolean loop = false;
            for (Question q : response.answer.keySet()) {
                if (!q.getName().equals(nextName)) continue;
                loop = true;
                break;
            }
            if (!loop && this.accumulateAnswers(response, nextName, type, true) == null) {
                storage = null;
            }
        }
        return storage;
    }

    private void additionalSectionProcessing(Message message, boolean authorityIsReferralOrSOA) {
        HashSet<Question> questions = new HashSet<Question>();
        message.additionalFromAnswerOrReferral = new HashSet<Question>();
        for (RRSet rrs : message.answer.values()) {
            for (ResourceRecord rr : rrs) {
                for (Question q : rr.additionalSectionProcessing()) {
                    questions.add(q);
                    message.additionalFromAnswerOrReferral.add(q);
                }
            }
        }
        for (RRSet rrs : message.authority.values()) {
            for (ResourceRecord rr : rrs) {
                for (Question q : rr.additionalSectionProcessing()) {
                    questions.add(q);
                    if (!authorityIsReferralOrSOA) continue;
                    message.additionalFromAnswerOrReferral.add(q);
                }
            }
        }
        for (Question q : message.answer.keySet()) {
            questions.remove(q);
        }
        for (Question q : message.authority.keySet()) {
            questions.remove(q);
        }
        for (Question q : questions) {
            try {
                List<ResourceRecord> rrs;
                Storage storage = this.getZoneStorageFor(q.getName());
                if (storage == null || (rrs = storage.getRecords(q.getName(), q.getType(), false)) == null) continue;
                for (ResourceRecord rr : rrs) {
                    message.additional.add(rr);
                }
            }
            catch (HandleException e) {
                e.printStackTrace();
            }
        }
    }

    static {
        try {
            A_ROOT_REFERRAL = new ResourceRecord(DomainName.ROOT, 2, 1, 0, "A.ROOT-SERVERS.NET.");
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }
}

