/*
 * Decompiled with CFR 0.152.
 */
package net.handle.apps.tools;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import net.handle.jdb.DBHash;
import net.handle.server.DBTxn;

class RecoverJDB {
    private final File hdlDBFile;
    private final File naDBFile;
    private final File hdlBackupFile;
    private final File naBackupFile;
    private final File txnFile;

    RecoverJDB(File hdlBackupFile, File hdlDBFile, File naBackupFile, File naDBFile, File txnFile) {
        this.hdlBackupFile = hdlBackupFile;
        this.hdlDBFile = hdlDBFile;
        this.naBackupFile = naBackupFile;
        this.naDBFile = naDBFile;
        this.txnFile = txnFile;
    }

    void doRecovery() throws Exception {
        System.out.println("Restoring backup databases...");
        System.out.flush();
        if (this.hdlBackupFile.exists()) {
            RecoverJDB.copyFile(this.hdlBackupFile, this.hdlDBFile);
        } else {
            this.hdlDBFile.delete();
        }
        if (this.naBackupFile.exists()) {
            RecoverJDB.copyFile(this.naBackupFile, this.naDBFile);
        } else {
            this.naDBFile.delete();
        }
        System.out.println("Opening databases...");
        System.out.flush();
        DBHash hdlDB = new DBHash(this.hdlDBFile, 5000, 1000);
        DBHash naDB = new DBHash(this.naDBFile, 1000, 500);
        System.out.println("Restoring from transactions...");
        System.out.flush();
        try (BufferedInputStream txnInput = new BufferedInputStream(new FileInputStream(this.txnFile));){
            DBTxn txn = null;
            block12: while ((txn = DBTxn.readTxn(txnInput)) != null) {
                System.err.println("Restore txn: " + txn);
                switch (txn.getAction()) {
                    case 0: {
                        hdlDB.setValue(txn.getKey(), txn.getValue());
                        continue block12;
                    }
                    case 1: {
                        hdlDB.deleteValue(txn.getKey());
                        continue block12;
                    }
                    case 2: {
                        naDB.setValue(txn.getKey(), txn.getValue());
                        continue block12;
                    }
                    case 3: {
                        naDB.deleteValue(txn.getKey());
                        continue block12;
                    }
                    case 4: {
                        hdlDB.deleteAllRecords();
                        naDB.deleteAllRecords();
                        continue block12;
                    }
                }
                throw new Exception("Error: Unknown action in transaction log: " + txn.getAction());
            }
        }
        hdlDB.close();
        naDB.close();
    }

    private static final void copyFile(File source, File dest) throws IOException {
        byte[] buf = new byte[10000];
        try (FileInputStream fin = new FileInputStream(source);
             FileOutputStream fout = new FileOutputStream(dest);){
            int r;
            while ((r = fin.read(buf)) >= 0) {
                fout.write(buf, 0, r);
            }
        }
    }

    private static final void printUsage() {
        System.err.println("usage: java net.handle.apps.tools.RecoverJDB <server_directory>");
    }

    public static void main(String[] argv) throws Exception {
        File txnFile;
        if (argv.length < 1) {
            RecoverJDB.printUsage();
            System.exit(1);
            return;
        }
        File hsDir = new File(argv[0]);
        System.err.println("directory: " + hsDir);
        if (!hsDir.exists() || !hsDir.isDirectory()) {
            System.err.println("Server directory doesn't exist!");
            System.exit(1);
            return;
        }
        File hdlBackupFile = new File(hsDir, "handles.bak");
        System.err.println(" backup file: " + hdlBackupFile);
        File hdlDBFile = new File(hsDir, "handles.jdb");
        System.err.println(" DB file: " + hdlDBFile);
        boolean haveHDLBackup = hdlBackupFile.exists();
        if (!haveHDLBackup) {
            System.err.println("Warning: Handle backup file (handles.bak) doesn't exist; assuming all changes are in the dbtxns.log file and that we can safely delete the current database.");
        }
        File naBackupFile = new File(hsDir, "nas.bak");
        File naDBFile = new File(hsDir, "nas.jdb");
        boolean haveNABackup = naBackupFile.exists();
        if (!haveNABackup) {
            System.err.println("Warning: NA backup file (nas.bak) doesn't exist; assuming all changes are in the dbtxns.log file and that we can safely delete the current database.");
        }
        if (!(txnFile = new File(hsDir, "dbtxns.log")).exists()) {
            System.err.println("Error: Transaction log file (dbtxns.log) doesn't exist!");
            System.exit(1);
            return;
        }
        System.out.println("Welcome to the Handle Server database recovery tool.\n");
        System.out.println("This tool should only be used if the handle database");
        System.out.println("has somehow been corrupted.\n");
        System.out.println("WARNING:  This program will attempt to restore the handles.jdb");
        System.out.println("and nas.jdb files.  If you would like to keep the current");
        System.out.println("contents of these files then BACK THEM UP NOW!\n");
        System.out.println("Type the word \"continue\" and hit ENTER to continue\n");
        System.out.flush();
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
        String line = in.readLine();
        if (line == null || !line.trim().toUpperCase().equals("CONTINUE")) {
            System.out.println("Exiting...");
            System.out.flush();
            return;
        }
        RecoverJDB recoverer = new RecoverJDB(hdlBackupFile, hdlDBFile, naBackupFile, naDBFile, txnFile);
        recoverer.doRecovery();
    }
}

