/*
 * Decompiled with CFR 0.152.
 */
package net.handle.apps.tools;

import com.google.gson.Gson;
import com.google.gson.stream.JsonReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import net.cnri.util.SimpleCommandLine;
import net.cnri.util.StreamTable;
import net.handle.hdllib.GsonUtility;
import net.handle.hdllib.HandleException;
import net.handle.hdllib.HandleRecord;
import net.handle.hdllib.HandleStorage;
import net.handle.hdllib.Util;
import net.handle.server.HandleStorageFactory;

public class LoadHandlesIntoStorageFromJson {
    public static Gson gson = GsonUtility.getPrettyGson();
    public static String inputFileName = null;
    public static String configDirStr = null;

    public static void printHelp() {
        System.out.println("-f\tThe path to the input json file containing handle records.");
        System.out.println();
        System.out.println("-h\tHandle server directory.");
        System.out.println();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        SimpleCommandLine cl = new SimpleCommandLine(new String[]{"f", "h"});
        cl.parse(args);
        if (!cl.hasOption("f")) {
            System.out.println("Missing f");
            LoadHandlesIntoStorageFromJson.printHelp();
            return;
        }
        inputFileName = cl.getOptionArgument("f");
        if (!cl.hasOption("h")) {
            System.out.println("Missing h");
            LoadHandlesIntoStorageFromJson.printHelp();
            return;
        }
        configDirStr = cl.getOptionArgument("h");
        File serverDir = new File(configDirStr);
        if (!serverDir.exists() || !serverDir.isDirectory()) {
            System.err.println("Invalid configuration directory: " + configDirStr + ".");
            return;
        }
        StreamTable configTable = new StreamTable();
        try {
            configTable.readFromFile(new File(serverDir, "config.dct"));
        }
        catch (Exception e) {
            System.err.println("Error reading configuration: " + e);
            return;
        }
        StreamTable serverConfig = (StreamTable)configTable.get("server_config");
        HandleStorage storage = HandleStorageFactory.getStorage(serverDir, serverConfig, true, false);
        File inputFile = new File(inputFileName);
        JsonReader reader = new JsonReader((Reader)new InputStreamReader((InputStream)new FileInputStream(inputFile), "UTF-8"));
        try {
            reader.beginObject();
            while (reader.hasNext()) {
                String name = reader.nextName();
                if ("homedPrefixes".equals(name)) {
                    reader.beginArray();
                    while (reader.hasNext()) {
                        String prefix = reader.nextString();
                        try {
                            LoadHandlesIntoStorageFromJson.homePrefix(prefix, storage);
                        }
                        catch (HandleException e) {
                            e.printStackTrace();
                        }
                    }
                    reader.endArray();
                    continue;
                }
                if (!"handleRecords".equals(name)) continue;
                reader.beginObject();
                while (reader.hasNext()) {
                    String handle = reader.nextName();
                    HandleRecord handleRecord = LoadHandlesIntoStorageFromJson.readNextHandleRecord(reader);
                    try {
                        LoadHandlesIntoStorageFromJson.createHandleRecordInStorage(handleRecord, storage);
                    }
                    catch (HandleException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        finally {
            reader.close();
            storage.shutdown();
        }
    }

    public static void homePrefix(String prefix, HandleStorage storage) throws HandleException {
        storage.setHaveNA(Util.upperCaseInPlace(Util.encodeString(prefix)), true);
        System.out.println("Homed PREFIX: " + prefix);
    }

    public static void createHandleRecordInStorage(HandleRecord handleRecord, HandleStorage storage) throws HandleException {
        String handle = handleRecord.getHandle();
        byte[] handleBytes = Util.encodeString(handle);
        byte[][] chunks = storage.getRawHandleValues(handleBytes, null, null);
        if (chunks == null) {
            storage.createHandle(handleBytes, handleRecord.getValuesAsArray());
        } else {
            storage.updateValue(handleBytes, handleRecord.getValuesAsArray());
        }
        System.out.println("Created: " + handle);
    }

    public static HandleRecord readNextHandleRecord(JsonReader reader) {
        HandleRecord handleRecord = (HandleRecord)gson.fromJson(reader, HandleRecord.class);
        return handleRecord;
    }
}

