/*
 * Decompiled with CFR 0.152.
 */
package net.handle.apps.tools;

import com.google.gson.Gson;
import com.google.gson.stream.JsonReader;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.InetAddress;
import java.security.PrivateKey;
import net.cnri.util.SimpleCommandLine;
import net.handle.hdllib.AuthenticationInfo;
import net.handle.hdllib.CreateHandleRequest;
import net.handle.hdllib.GsonUtility;
import net.handle.hdllib.HandleException;
import net.handle.hdllib.HandleRecord;
import net.handle.hdllib.HandleResolver;
import net.handle.hdllib.PublicKeyAuthenticationInfo;
import net.handle.hdllib.Util;
import net.handle.hdllib.ValueReference;

public class LoadHandlesFromJson {
    public static Gson gson = GsonUtility.getPrettyGson();
    public static HandleResolver resolver = new HandleResolver();
    public static String inputFileName = null;
    public static String ipAddress = "127.0.0.1";
    public static InetAddress addr = null;
    public static int port = 2641;
    public static String authId = null;
    public static String privateKeyFileName = null;
    public static PrivateKey authPrivateKey = null;
    public static AuthenticationInfo authInfo = null;

    public static void printHelp() {
        System.out.println("-f\tThe path to the input json file containing handle records.");
        System.out.println();
        System.out.println("-i\tIP address of the handle server (Default 127.0.0.1).");
        System.out.println();
        System.out.println("-p\tPort of the handle server (Default 2641).");
        System.out.println();
        System.out.println("-authid\tThe index:handle of the identity performing the operation.");
        System.out.println();
        System.out.println("-privatekey\tPath to the private key for the identity performing the operation.");
        System.out.println();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        SimpleCommandLine cl = new SimpleCommandLine(new String[]{"f", "i", "p", "authid", "privatekey"});
        cl.parse(args);
        if (!cl.hasOption("f")) {
            System.out.println("Missing f");
            LoadHandlesFromJson.printHelp();
            return;
        }
        inputFileName = cl.getOptionArgument("f");
        if (cl.hasOption("i")) {
            ipAddress = cl.getOptionArgument("i");
        } else {
            LoadHandlesFromJson.printHelp();
        }
        addr = InetAddress.getByName(ipAddress);
        if (cl.hasOption("p")) {
            port = Integer.parseInt(cl.getOptionArgument("p"));
        } else {
            LoadHandlesFromJson.printHelp();
        }
        if (!cl.hasOption("authid")) {
            System.out.println("Missing authid");
            LoadHandlesFromJson.printHelp();
            return;
        }
        authId = cl.getOptionArgument("authid");
        if (!cl.hasOption("privatekey")) {
            System.out.println("Missing privatekey");
            LoadHandlesFromJson.printHelp();
            return;
        }
        privateKeyFileName = cl.getOptionArgument("privatekey");
        authPrivateKey = LoadHandlesFromJson.getLocalPrivateKey(privateKeyFileName, "Enter the passphrase to decrypt the private signing key: ");
        ValueReference authValueRef = ValueReference.fromString(authId);
        authInfo = new PublicKeyAuthenticationInfo(authValueRef.handle, authValueRef.index, authPrivateKey);
        File inputFile = new File(inputFileName);
        try (JsonReader reader = new JsonReader((Reader)new InputStreamReader((InputStream)new FileInputStream(inputFile), "UTF-8"));){
            reader.beginObject();
            while (reader.hasNext()) {
                String name = reader.nextName();
                if ("homedPrefixes".equals(name)) {
                    reader.beginArray();
                    while (reader.hasNext()) {
                    }
                    reader.endArray();
                    continue;
                }
                if (!"handleRecords".equals(name)) continue;
                reader.beginObject();
                while (reader.hasNext()) {
                    String handle = reader.nextName();
                    HandleRecord handleRecord = LoadHandlesFromJson.readNextHandleRecord(reader);
                    try {
                        LoadHandlesFromJson.createHandleRecordOnService(handleRecord);
                        System.out.println("Created: " + handle);
                    }
                    catch (HandleException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    public static void createHandleRecordOnService(HandleRecord handleRecord) throws HandleException {
        String handle = handleRecord.getHandle();
        byte[] handleBytes = Util.encodeString(handle);
        CreateHandleRequest request = new CreateHandleRequest(handleBytes, handleRecord.getValuesAsArray(), authInfo);
        resolver.sendHdlTcpRequest(request, addr, port);
    }

    public static HandleRecord readNextHandleRecord(JsonReader reader) {
        HandleRecord handleRecord = (HandleRecord)gson.fromJson(reader, HandleRecord.class);
        return handleRecord;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PrivateKey getLocalPrivateKey(String key, String prompt) throws Exception {
        File privateKeyFile = new File(key);
        byte[] encKeyBytes = new byte[(int)privateKeyFile.length()];
        try (FileInputStream in = new FileInputStream(privateKeyFile);){
            int r;
            for (int n = 0; n < encKeyBytes.length && (r = in.read(encKeyBytes, n, encKeyBytes.length - n)) >= 0; n += r) {
            }
        }
        byte[] keyBytes = null;
        byte[] secKey = null;
        if (Util.requiresSecretKey(encKeyBytes)) {
            secKey = Util.getPassphrase(prompt);
        }
        keyBytes = Util.decrypt(encKeyBytes, secKey);
        for (int i = 0; secKey != null && i < secKey.length; ++i) {
            secKey[i] = 0;
        }
        PrivateKey privateKey = Util.getPrivateKeyFromBytes(keyBytes, 0);
        return privateKey;
    }

    public static final String responseToPrompt(String prompt, BufferedReader in) throws IOException {
        System.out.print("\n" + prompt + ": ");
        System.out.flush();
        return in.readLine().trim();
    }
}

